<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Woo_Minicart_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-woo-mini-cart';
    }
    public function get_title() {
        return 'Woo Header Cart (N)';
    }
    public function get_icon() {
        return 'eicon-cart';
    }
    public function get_categories() {
        return [ 'naturally-woo' ];
    }

    // Registering Controls
    protected function register_controls() {

        /* HEADER MINICART SETTINGS */
        $this->start_controls_section( 'header_minicart_style_controls_section',
            [
                'label'        => esc_html__( 'Minicart Style', 'naturally' ),
                'tab'          => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_responsive_control( 'header_minicart_width',
            [
                'label'         => esc_html__( 'Width', 'naturally' ),
                'type'          => Controls_Manager::SLIDER,
                'range'         => [ 'px' => [ 'max' => 500 ] ],
                'selectors'     => [ '{{WRAPPER}} .header_cart' => 'width: {{SIZE}}px;max-width: {{SIZE}}px;' ],
            ]
        );
        $this->add_responsive_control( 'header_minicart_zindex',
            [
                'label'         => esc_html__( 'Z-Index', 'naturally' ),
                'type'          => Controls_Manager::NUMBER,
                'selectors'     => [ '{{WRAPPER}} .header_cart' => 'z-index: {{SIZE}};' ],
            ]
        );
        $this->add_responsive_control( 'header_minicart_alignment',
            [
                'label'          => esc_html__( 'Alignment', 'naturally' ),
                'type'           => Controls_Manager::CHOOSE,
                'selectors'      => ['{{WRAPPER}} .header_cart' => '{{VALUE}};'],
                'options'        => [
                    'margin-right:auto;margin-left:inherit' => [
                        'title'    => esc_html__( 'Left', 'naturally' ),
                        'icon'     => 'fa fa-align-left'
                    ],
                    'margin-right:auto;margin-left:auto' => [
                        'title'    => esc_html__( 'Center', 'naturally' ),
                        'icon'     => 'fa fa-align-center'
                    ],
                    'margin-left:auto' => [
                        'title'    => esc_html__( 'Right', 'naturally' ),
                        'icon'     => 'fa fa-align-right'
                    ]
                ],
                'toggle'         => true,
                'default'        => '',
                'separator'     => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'          => 'header_minicart_typo',
                'label'         => esc_html__( 'Typography', 'naturally' ),
                'selector'      => '{{WRAPPER}} .header_cart .header_cart_label'
            ]
        );
        $this->add_responsive_control( 'header_minicart_padding',
            [
                'label'         => esc_html__( 'Padding', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ],
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'header_minicart_margin',
            [
                'label'         => esc_html__( 'Margin', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ],
                'separator'     => 'before'
            ]
        );
        $this->start_controls_tabs('header_minicart_normal_tabs');
        $this->start_controls_tab( 'header_minicart_normal_tab',
            [ 'label'           => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'          => 'header_minicart_background',
                'label'         => esc_html__( 'Background', 'naturally' ),
                'types'         => [ 'classic', 'gradient' ],
                'selector'      => '{{WRAPPER}} .header_cart .header_cart_label, {{WRAPPER}} .header_cart .header_cart_label:after',
            ]
        );
        $this->add_control( 'header_minicart_normal_color',
            [
                'label'         => esc_html__( 'Button Text Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_label' => 'color: {{VALUE}};'],
                'separator'     => 'before'
            ]
        );
       $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'          => 'header_minicart_border',
                'label'         => esc_html__( 'Border', 'naturally' ),
                'selector'      => '{{WRAPPER}} .header_cart .header_cart_label',
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'header_minicart_border_radius',
            [
                'label'         => esc_html__( 'Border Radius', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px' ],
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_label' => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ]
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab('header_minicart_hover_tab',
            [ 'label'           => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'          => 'header_minicart_hover_background',
                'label'         => esc_html__( 'Background', 'naturally' ),
                'types'         => [ 'classic', 'gradient' ],
                'selector'      => '{{WRAPPER}} .header_cart:hover .header_cart_label, {{WRAPPER}} .header_cart:hover .header_cart_label:after, {{WRAPPER}} .header_cart.is-active .header_cart_label',
            ]
        );
        $this->add_control( 'header_minicart_hover_color',
            [
                'label'         => esc_html__( 'Button Text Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart:hover .header_cart_label, {{WRAPPER}} .header_cart.is-active .header_cart_label' => 'color: {{VALUE}};'],
                'separator'     => 'before'
            ]
        );
       $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'          => 'header_minicart_hover_border',
                'label'         => esc_html__( 'Border', 'naturally' ),
                'selector'      => '{{WRAPPER}} .header_cart:hover .header_cart_label',
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'header_minicart_hover_border_radius',
            [
                'label'         => esc_html__( 'Border Radius', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px' ],
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_label:hover, {{WRAPPER}} .header_cart.is-active .header_cart_label' => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ]
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        /* HEADER MINICART SETTINGS */
        $this->start_controls_section( 'header_minicart_content_style_controls_section',
            [
                'label'        => esc_html__( 'Minicart Content Style', 'naturally' ),
                'tab'          => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_responsive_control( 'header_minicart_content_width',
            [
                'label'         => esc_html__( 'Width', 'naturally' ),
                'type'          => Controls_Manager::SLIDER,
                'range'         => [ 'px' => [ 'max' => 2000 ] ],
                'selectors'     => [ '{{WRAPPER}} .header_cart .header_cart_detail' => 'width: {{SIZE}}px;max-width: {{SIZE}}px;' ],
            ]
        );
        $this->add_responsive_control( 'header_minicart_content_alignment',
            [
                'label'          => esc_html__( 'Alignment', 'naturally' ),
                'type'           => Controls_Manager::CHOOSE,
                'selectors'      => ['{{WRAPPER}} .header_cart .header_cart_detail' => '{{VALUE}};'],
                'options'        => [
                    'left:0;right:auto' => [
                        'title'    => esc_html__( 'Left', 'naturally' ),
                        'icon'     => 'fa fa-align-left'
                    ],
                    'left:50%;transform: translate(-50%);right:auto;text-align:center' => [
                        'title'    => esc_html__( 'Center', 'naturally' ),
                        'icon'     => 'fa fa-align-center'
                    ],
                    'right:0' => [
                        'title'    => esc_html__( 'Right', 'naturally' ),
                        'icon'     => 'fa fa-align-right'
                    ]
                ],
                'toggle'         => true,
                'default'        => 'right:0',
                'separator'     => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'          => 'header_minicart_content_background',
                'label'         => esc_html__( 'Background', 'naturally' ),
                'types'         => [ 'classic', 'gradient' ],
                'selector'      => '{{WRAPPER}} .header_cart .header_cart_detail',
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'header_minicart_content_padding',
            [
                'label'         => esc_html__( 'Padding', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ],
                'separator'     => 'before'
            ]
        );
       $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'          => 'header_minicart_content_border',
                'label'         => esc_html__( 'Border', 'naturally' ),
                'selector'      => '{{WRAPPER}} .header_cart .header_cart_detail',
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'header_border_content_radius',
            [
                'label'         => esc_html__( 'Border Radius', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px' ],
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail' => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ]
            ]
        );
        $this->end_controls_section();

        /* HEADER MINICART SETTINGS */
        $this->start_controls_section( 'header_minicart_content_table_style_controls_section',
            [
                'label'        => esc_html__( 'Minicart Table Style', 'naturally' ),
                'tab'          => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'          => 'header_minicart_content_table_image',
                'label'         => esc_html__( 'Thumbnail Border', 'naturally' ),
                'selector'      => '{{WRAPPER}} .header_cart .header_cart_detail .header_cart_products td.is-photo a',
            ]
        );
        $this->add_control( 'header_minicart_content_table_qty_color',
            [
                'label'         => esc_html__( 'Quantity Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_products td.is-qty' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'header_minicart_content_table_title_color',
            [
                'label'         => esc_html__( 'Title Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_products td.is-name' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'header_minicart_content_table_price_color',
            [
                'label'         => esc_html__( 'Price Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_products td.is-price' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'header_minicart_content_table_empty_color',
            [
                'label'         => esc_html__( 'Empty Text Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_products,{{WRAPPER}} .header_cart .header_cart_detail .header_cart_products h3' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'header_minicart_content_table_remove_heading',
            [
                'label'         => esc_html__( 'Remove Button Style', 'naturally' ),
                'type'          => Controls_Manager::HEADING
            ]
        );
        $this->start_controls_tabs('header_minicart_content_table_remove_normal_tabs');
        $this->start_controls_tab( 'header_minicart_content_table_remove_normal_tab',
            [ 'label'           => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'          => 'header_minicart_content_table_remove_background',
                'label'         => esc_html__( 'Background', 'naturally' ),
                'types'         => [ 'classic', 'gradient' ],
                'selector'      => '{{WRAPPER}} .header_cart .header_cart_detail .header_cart_products td.is-delete a',
                'separator'     => 'before'
            ]
        );
        $this->add_control( 'header_minicart_content_table_remove_normal_color',
            [
                'label'         => esc_html__( 'Button Text Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_products td.is-delete a' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'header_minicart_content_table_remove_normal_btn_brdcolor',
            [
                'label'         => esc_html__( 'Button Border Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_products td.is-delete a' => 'border-color: {{VALUE}};']
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab('header_minicart_content_hover_tab',
            [ 'label'           => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'          => 'header_minicart_content_table_remove_hover_background',
                'label'         => esc_html__( 'Background', 'naturally' ),
                'types'         => [ 'classic', 'gradient' ],
                'selector'      => '{{WRAPPER}} .header_cart .header_cart_detail .header_cart_products td.is-delete a:hover',
                'separator'     => 'before'
            ]
        );
        $this->add_control( 'header_minicart_content_table_remove_hover_color',
            [
                'label'         => esc_html__( 'Button Text Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_products td.is-delete a:hover' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'header_minicart_content_table_remove_hover_brdcolor',
            [
                'label'         => esc_html__( 'Button Border Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_products td.is-delete a:hover' => 'border-color: {{VALUE}};']
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /* HEADER MINICART SETTINGS */
        $this->start_controls_section( 'header_minicart_content_footer_style_controls_section',
            [
                'label'        => esc_html__( 'Minicart Table Footer Style', 'naturally' ),
                'tab'          => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'header_minicart_content_footer_total_title_color',
            [
                'label'         => esc_html__( 'Total Title Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_footer td.is-total' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'header_minicart_content_footer_total_color',
            [
                'label'         => esc_html__( 'Total Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_footer td.is-total-value' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'header_minicart_content_footer_btn_heading',
            [
                'label'         => esc_html__( 'Button Style', 'naturally' ),
                'type'          => Controls_Manager::HEADING
            ]
        );
        $this->start_controls_tabs('header_minicart_content_footer_normal_tabs');
        $this->start_controls_tab( 'header_minicart_content_footer_normal_tab',
            [ 'label'           => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'          => 'header_minicart_content_footer_btn_background',
                'label'         => esc_html__( 'Background', 'naturally' ),
                'types'         => [ 'classic', 'gradient' ],
                'selector'      => '{{WRAPPER}} .header_cart .header_cart_detail .header_cart_footer .button.is-grey',
                'separator'     => 'before'
            ]
        );
        $this->add_control( 'header_minicart_content_footer_normal_btn_color',
            [
                'label'         => esc_html__( 'Button Text Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_footer .button.is-grey' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'header_minicart_content_footer_normal_btn_brdcolor',
            [
                'label'         => esc_html__( 'Button Border Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_footer .button.is-grey' => 'border-color: {{VALUE}};']
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab('header_minicart_content_footer_hover_tab',
            [ 'label'           => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'          => 'header_minicart_content_footer_btn_hover_background',
                'label'         => esc_html__( 'Background', 'naturally' ),
                'types'         => [ 'classic', 'gradient' ],
                'selector'      => '{{WRAPPER}} .header_cart .header_cart_detail .header_cart_footer .button.is-grey:hover',
                'separator'     => 'before'
            ]
        );
        $this->add_control( 'header_minicart_content_footer_hover_btn_color',
            [
                'label'         => esc_html__( 'Button Text Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_footer .button.is-grey:hover' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'header_minicart_content_footer_hover_btn_brdcolor',
            [
                'label'         => esc_html__( 'Button Border Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .header_cart .header_cart_detail .header_cart_footer .button.is-grey:hover' => 'border-color: {{VALUE}};']
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }


    protected function render() {
        $settings = $this->get_settings_for_display();

        global $woocommerce;

		echo'<div class="naturally_mini_cart">';
		echo'<div class="header_cart">';
			echo'<div class="header_cart_label">';
				echo'<span class="header_cart_label_icon icon is-bag"></span>';
				if ( $woocommerce->cart->cart_contents_count != 0  ) {
				    echo'<span class="header_cart_label_text">';printf( '%s', $woocommerce->cart->subtotal ); echo'/'; echo sprintf(_n('%d item', '%d items', $woocommerce->cart->cart_contents_count, 'naturally'), $woocommerce->cart->cart_contents_count);echo'</span>';
				}
		    echo'</div>';

            do_action( 'woocommerce_before_mini_cart' );

            if ( $woocommerce->cart->cart_contents_count != 0  ) {

            	echo'<div class="header_cart_detail">';
            		echo'<div class="header_cart_products">';
            			echo'<table>';
            			    $listclass = !empty($args['list_class']) ? ' '.esc_attr( $args['list_class'] ) : '';
            				echo'<tbody class="woocommerce-mini-cart'.$listclass.'">';
            				    do_action( 'woocommerce_before_mini_cart_contents' );
            				    foreach ( $woocommerce->cart->get_cart() as $cart_item_key => $cart_item ) {

                					$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                					$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

                					if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {

                						$product_name      = apply_filters( 'woocommerce_cart_item_name2', $_product->get_name(), $cart_item, $cart_item_key );
                						$thumbnail         = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
                						$product_price     = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
                						$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );

                						echo'<tr class="woocommerce-mini-cart-item '.esc_attr( apply_filters( 'woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key ) ).'">';

                							echo'<td class="is-photo">';
                								echo'<a class="product-media" href="'.esc_url( get_permalink( $cart_item['product_id'] ) ).'">';
                									printf( '%s', $_product->get_image( array( 50, 50 ) ) );
                								echo'</a>';
                							echo'</td>';

                							echo'<td class="is-qty">';printf( esc_html__( 'x %1$s', 'naturally' ), $cart_item['quantity'] );echo'</td>';
                							echo'<td class="is-name">'.esc_html( $product_name ).'</td>';
                							echo'<td class="is-price">'.apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="product-cost">' . sprintf( '%s', $product_price ) . '</span>', $cart_item, $cart_item_key ).'</td>';
                							echo'<td class="is-delete">';

                								echo apply_filters( 'woocommerce_cart_item_remove_link',
                									sprintf(
                										'<a href="%s" class="remove remove_from_cart_button" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s"><span class="icon is-close"></span></a>',
                										esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
                										esc_attr__( 'Remove this item', 'naturally' ),
                										esc_attr( $product_id ),
                										esc_attr( $cart_item_key ),
                										esc_attr( $_product->get_sku() )
                									),
                									$cart_item_key
                								);

                							echo wc_get_formatted_cart_item_data( $cart_item );
                							echo'</td>';
                						echo'</tr>';
                					}
            				    }

            				    do_action( 'woocommerce_mini_cart_contents' );

            				echo'</tbody>';
            			echo'</table>';
            		echo'</div>';

            		echo'<div class="header_cart_footer">';
            			echo'<table>';
            				echo'<tbody>';
            					echo'<tr>';
            						echo'<td class="is-total">'.esc_html__( 'Total: ', 'naturally' ).'</td>';
            						echo'<td class="is-total-value">';printf( '%s', $woocommerce->cart->get_cart_subtotal() ); echo'</td>';
            					echo'</tr>';

            					do_action( 'woocommerce_widget_shopping_cart_before_buttons' );

            					echo'<tr>';
            						echo'<td class="is-view">';
            							echo'<a class="button is-block is-small is-grey" href="'.esc_url( wc_get_cart_url() ).'">';
            								echo'<span class="button_text">'.esc_html__( 'View Cart', 'naturally' ).'</span>';
            							echo'</a>';
            						echo'</td>';
            						echo'<td class="is-checkout">';
            							echo'<a class="button is-block is-small is-grey" href="'.esc_url( wc_get_checkout_url() ).'">';
            								echo'<span class="button_text">'.esc_html__( 'Checkout', 'naturally' ).'</span>';
            							echo'</a>';
            						echo'</td>';
            					echo'</tr>';

            					do_action( 'woocommerce_widget_shopping_cart_after_buttons' );

            				echo'</tbody>';
            			echo'</table>';
            		echo'</div>';
            	echo'</div>';

            } else {

            	echo '<div class="header_cart_detail shopcart-empty">
            		<div class="header_cart_products">
            			<h3 class="minicart-title">'.esc_html__( 'Your Cart', 'naturally' ).'</h3>
            			<div class="empty-title">'.esc_html__( 'No products in the cart.', 'naturally' ).'</div>
            			<div class="header_cart_footer">
            				<table>
            					<tbody>
            						<tr>
            							<td class="is-view">
            								<a class="button is-block is-small is-grey" href="'.esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ).'">
            									<span class="button_text">'.esc_html__( 'Start Shopping', 'naturally' ).'</span>
            								</a>
            							</td>
            							<td class="is-checkout">
            								<a class="button is-block is-small is-grey" href="'.esc_url( get_permalink( get_option( 'wp_page_for_privacy_policy' ) ) ).'">
            									<span class="button_text">'.esc_html__( 'Return Policy', 'naturally' ).'</span>
            								</a>
            							</td>
            						</tr>';

            						do_action( 'woocommerce_widget_shopping_cart_after_buttons' );

            					echo '</tbody>
            				</table>
            			</div>
            		</div>
            	</div>';
            }

            do_action( 'woocommerce_after_mini_cart' );

        echo'</div>';
        echo'</div>';

    }
}
