<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Woo_Page_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-woo-page';
    }
    public function get_title() {
        return 'Products Page (N)';
    }
    public function get_icon() {
        return 'eicon-columns';
    }
    public function get_categories() {
        return [ 'naturally-woo' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'post_query_section',
            [
                'label' => esc_html__( 'Query', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        // Order
        $this->add_control( 'scenario',
            [
                'label' => esc_html__( 'Select Scenario', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'featured' => esc_html__( 'Featured', 'naturally' ),
                    'on-sale' => esc_html__( 'On Sale', 'naturally' ),
                    'best' => esc_html__( 'Best Selling', 'naturally' ),
                    'custom' => esc_html__( 'Specific Categories', 'naturally' ),
                ],
                'default' => 'newest'
            ]
        );
        // Category Filter Heading
        $this->add_control( 'category_filter_heading',
            [
                'label' => esc_html__( 'Category Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        // Category Filter
        $this->add_control( 'category_filter',
            [
                'label' => esc_html__( 'Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s)',
                'condition' => [ 'scenario' => 'custom' ]
            ]
        );
        // Exclude Category
        $this->add_control( 'category_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Category(s)', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s) to Exclude',
            ]
        );
        $this->add_control( 'category_exclude_from_sidebar',
            [
                'label' => esc_html__( 'Exclude Selected Category(s) from Sidebar', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_block' => true,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        // Post Filter Heading
        $this->add_control( 'post_filter_heading',
            [
                'label' => esc_html__( 'Post Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        // Specific Post
        $this->add_control( 'post_filter',
            [
                'label' => esc_html__( 'Specific Post(s)', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_get_post_title('product'),
                'description' => 'Select Specific Post(s)',
                'condition' => [ 'scenario' => 'custom' ]
            ]
        );
        // Exclude Post
        $this->add_control( 'post_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Post', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_get_post_title('product'),
                'description' => 'Select Post(s) to Exclude',
                'separator' => 'after',
            ]
        );
        // Other Filter Heading
        $this->add_control( 'post_other_heading',
            [
                'label' => esc_html__( 'Other Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        // Posts Per Page
        $this->add_control( 'post_per_page',
            [
                'label' => esc_html__( 'Posts Per Page', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 1000,
                'default' => 20
            ]
        );
        // Order
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'naturally' ),
                    'DESC' => esc_html__( 'Descending', 'naturally' )
                ],
                'default' => 'ASC'
            ]
        );
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'naturally' ),
                    'menu_order' => esc_html__( 'Menu Order', 'naturally' ),
                    'rand' => esc_html__( 'Random', 'naturally' ),
                    'date' => esc_html__( 'Date', 'naturally' ),
                    'title' => esc_html__( 'Title', 'naturally' ),
                ],
                'default' => 'id',
            ]
        );
		$this->add_control( 'thumbnail2',
			[
				'label' => esc_html__( 'Image Dimension', 'naturally' ),
				'type' => Controls_Manager::IMAGE_DIMENSIONS,
				'description' => esc_html__( 'Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.', 'naturally' ),
				'default' => [
					'width' => '',
					'height' => '',
				],
			]
		);
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'products_on_off_settings',
            [
                'label' => esc_html__('General', 'naturally'),
            ]
        );
        $this->add_control( 'hidetitle',
            [
                'label' => esc_html__( 'Hide Title', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => get_the_title(),
                'label_block' => true,
                'condition' => [ 'hidetitle!' => 'yes' ],
            ]
        );
        $this->add_control( 'desc',
            [
                'label' => esc_html__( 'Description', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '',
                'label_block' => true,
                'condition' => [ 'hidetitle!' => 'yes' ],
            ]
        );
        $this->add_control( 'hidebread',
            [
                'label' => esc_html__( 'Hide Breadcrumbs', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'hidecat',
            [
                'label' => esc_html__( 'Hide Category Block', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'cat_singular',
            [
                'label' => esc_html__( 'Category Text Singular', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Product',
                'pleaceholder' => esc_html__( 'Enter title here', 'naturally' ),
                'condition' => ['hidecat!' => 'yes']
            ]
        );
        $this->add_control( 'cat_plural',
            [
                'label' => esc_html__( 'Category Text Plural', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Products',
                'pleaceholder' => esc_html__( 'Enter title here', 'naturally' ),
                'condition' => ['hidecat!' => 'yes']
            ]
        );
        $this->add_control( 'hide_catalog',
            [
                'label' => esc_html__( 'Hide Filters-Catalog', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'layout',
            [
                'label' => esc_html__( 'Layout', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'full-width',
                'options' => [
                    'left-sidebar' => esc_html__( 'Left Sidebar', 'naturally' ),
                    'right-sidebar' => esc_html__( 'Right Sidebar', 'naturally' ),
                    'full-width' => esc_html__( 'Full-width', 'naturally' ),
                ]
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Products Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid' => esc_html__( 'Grid', 'naturally' ),
                    'list' => esc_html__( 'List', 'naturally' ),
                ]
            ]
        );
        $this->add_control('column',
            [
                'label' => esc_html__( 'Column', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 4,
                'default' => 3,
                'condition' => ['type' => 'grid']
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /***** WOO TITLE ******/
        $this->start_controls_section( 'slider_category_filter_settings',
            [
                'label' => esc_html__( 'Slider Category Filter', 'naturally' ),
                'condition' => ['hidecat!' => 'yes']
            ]
        );
        $this->add_group_control(
        Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'thumbnail',
            ]
        );
        // Category Filter
        $this->add_control( 'scategory_filter',
            [
                'label' => esc_html__( 'Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s)',
            ]
        );
        // Order
        $this->add_control( 'sorder',
            [
                'label' => esc_html__( 'Select Order', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'naturally' ),
                    'DESC' => esc_html__( 'Descending', 'naturally' )
                ],
                'default' => 'ASC'
            ]
        );
        $this->add_control( 'sorderby',
            [
                'label' => esc_html__( 'Order By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'naturally' ),
                    'menu_order' => esc_html__( 'Menu Order', 'naturally' ),
                    'rand' => esc_html__( 'Random', 'naturally' ),
                    'date' => esc_html__( 'Date', 'naturally' ),
                    'title' => esc_html__( 'Title', 'naturally' ),
                ],
                'default' => 'id',
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /***** WOO TITLE ******/
        $this->start_controls_section( 'page_title_styling',
            [
                'label' => esc_html__( 'Page Title', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control( 'page_title_color',
            [
                'label' => esc_html__( 'Title Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .headline_title' => 'color: {{VALUE}};' ]
            ]
        );
        $this->naturally_style_typo( 'page_title_typo','{{WRAPPER}} .headline_title' );

        $this->add_control( 'page_desc_color',
            [
                'label' => esc_html__( 'Description Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .headline_summary' => 'color: {{VALUE}};' ]
            ]
        );
        $this->naturally_style_typo( 'page_desc_typo','{{WRAPPER}} .headline_summary' );

        $this->add_control( 'page_bread_color',
            [
                'label' => esc_html__( 'Breadcrumbs Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .breadcrumb, {{WRAPPER}} .breadcrumb_link_icon' => 'color: {{VALUE}};' ]
            ]
        );
        $this->add_control( 'page_bread_hvrcolor',
            [
                'label' => esc_html__( 'Current && Hover Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .breadcrumb .breadcrumb_link:hover, {{WRAPPER}} .breadcrumb_active' => 'color: {{VALUE}};' ]
            ]
        );
        $this->naturally_style_typo( 'page_bread_typo','{{WRAPPER}} .breadcrumb' );
        $this->end_controls_section();

        /***** WOO TITLE ******/
        $this->start_controls_section( 'grid_catslider_styling',
            [
                'label' => esc_html__( 'Category Slider', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control( 'cat_box_bg',
            [
                'label' => esc_html__( 'Box Background', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .slider-categories_item' => 'background-color: {{VALUE}};' ]
            ]
        );
        $this->add_control( 'cat_box_hvrbg',
            [
                'label' => esc_html__( 'Hover Box Background', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .slider-categories_item:hover' => 'background-color: {{VALUE}};' ]
            ]
        );
        $this->naturally_style_border( 'cat_box_brd','{{WRAPPER}} .shop-product' );

        $this->add_control( 'cat_box_hvrbrd',
            [
                'label' => esc_html__( 'Hover Border Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .slider-categories_item:hover' => 'border-color: {{VALUE}};' ]
            ]
        );
        $this->add_control( 'cat_color',
            [
                'label' => esc_html__( 'Category Name Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .slider-categories_item_name' => 'color: {{VALUE}};' ]
            ]
        );
        $this->add_control( 'cat_hvrcolor',
            [
                'label' => esc_html__( 'Hover Name Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .slider-categories_item:hover .slider-categories_item_name, {{WRAPPER}} .slider-categories_item_name:hover' => 'color: {{VALUE}};' ]
            ]
        );
        $this->add_control( 'cat_count_color',
            [
                'label' => esc_html__( 'Category Count Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .slider-categories_item_count' => 'color: {{VALUE}};' ]
            ]
        );
        $this->add_control( 'cat_count_hvrcolor',
            [
                'label' => esc_html__( 'Hover Count Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .slider-categories_item:hover .slider-categories_item_count, {{WRAPPER}} .slider-categories_item_count:hover' => 'color: {{VALUE}};' ]
            ]
        );
        $this->add_control( 'slider_nav_color',
            [
                'label' => esc_html__( 'Prev && Next Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-prev .icon, {{WRAPPER}} .slick-next .icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .slick-prev, {{WRAPPER}} .slick-next' => 'border-color: {{VALUE}};',
                ]
            ]
        );
        $this->add_control( 'slider_nav_hvrcolor',
            [
                'label' => esc_html__( 'Hover Prev && Next Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-prev:hover .icon, {{WRAPPER}} .slick-next:hover .icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .woocommerce .slick-prev:hover, {{WRAPPER}} .woocommerce .slick-next:hover' => 'border-color: {{VALUE}};',
                ]
            ]
        );
        $this->add_control( 'slider_nav_bg',
            [
                'label' => esc_html__( 'Prev && Next Background', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .slick-prev, {{WRAPPER}} .slick-next' => 'background-color: {{VALUE}};']
            ]
        );
        $this->add_control( 'slider_nav_hvrbgcolor',
            [
                'label' => esc_html__( 'Hover Prev && Next Background', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .slick-prev:hover, {{WRAPPER}} .slick-next:hover' => 'background-color: {{VALUE}};']
            ]
        );

        $this->end_controls_section();
        /***** END WOO TITLE ******/

        /***** WOO TITLE ******/
        $this->start_controls_section( 'grid_selection_styling',
            [
                'label' => esc_html__( 'Grid Buttons', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control( 'grid_selection_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shop-header_layout_item' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .woocommerce .shop-header_layout_item' => 'border-color: {{VALUE}};'
                ]
            ]
        );
        $this->add_control( 'grid_selection_hvrcolor',
            [
                'label' => esc_html__( 'Active Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shop-header_layout_item.is-active .icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .woocommerce .shop-header_layout_item.is-active' => 'border-color: {{VALUE}};'
                ]
            ]
        );
        $this->add_control( 'grid_result_color',
            [
                'label' => esc_html__( 'Result Count Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .woocommerce-result-count' => 'color: {{VALUE}};' ]
            ]
        );
        $this->add_control( 'grid_sorting_hvrcolor',
            [
                'label' => esc_html__( 'Sorting Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['
                    {{WRAPPER}} .woocommerce form select' => 'color: {{VALUE}};'
                ]
            ]
        );
        $this->add_control( 'grid_sorting_brdcolor',
            [
                'label' => esc_html__( 'Sorting Border Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['
                    {{WRAPPER}} .woocommerce form select' => 'border-color: {{VALUE}};'
                ]
            ]
        );
        $this->add_control( 'grid_sorting_bg',
            [
                'label' => esc_html__( 'Sorting Background', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['
                    {{WRAPPER}} .woocommerce form select' => 'background-color: {{VALUE}};'
                ]
            ]
        );
        $this->end_controls_section();
        /***** END WOO TITLE ******/

        /***** WOO TITLE ******/
        $this->start_controls_section( 'naturally_product_box_styling',
            [
                'label' => esc_html__( 'Product Box', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs( 'product_box_tabs' );
        $this->start_controls_tab( 'product_box_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_bgcolor( 'product_box_bg','{{WRAPPER}} .shop-product' );
        $this->naturally_style_border( 'product_box_border','{{WRAPPER}} .shop-product' );
        $this->end_controls_tab();
        $this->end_controls_tab();
        $this->start_controls_tab( 'product_box_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_bgcolor( 'product_box_hvrbg','{{WRAPPER}} .shop-product' );
        $this->naturally_style_border( 'product_box_hvrborder','{{WRAPPER}} .shop-product' );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /***** WOO TITLE ******/
        $this->start_controls_section( 'naturally_ititle_woo_styling',
            [
                'label' => esc_html__( 'Woo Item Title', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->naturally_style_typo( 'product_item_title_typo','{{WRAPPER}} .shop-product_title a' );
        $this->add_control( 'product_item_title_color',
            [
                'label' => esc_html__( 'Title Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .shop-product_title a' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'product_item_title_hvrcolor',
            [
                'label' => esc_html__( 'Hover Title Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .shop-product_title a:hover' => 'color: {{VALUE}};']
            ]
        );
        $this->end_controls_section();
        /***** END WOO TITLE ******/

        /***** WOO STAR ******/
        $this->start_controls_section('star_price_styling',
            [
                'label' => esc_html__( 'Woo Star && Price', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control( 'star_color',
            [
                'label' => esc_html__( 'Star Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .star-rating span::before' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'empty_star_color',
            [
                'label' => esc_html__( 'Empty Star Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .woocommerce .star-rating::before' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'regular_color',
            [
                'label' => esc_html__( 'Regular Price Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .woocommerce .price del,del .woocommerce-Price-amount' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'sale_color',
            [
                'label' => esc_html__( 'Sale Price Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .woocommerce div.product span.price ins' => 'color: {{VALUE}};']
            ]
        );
        $this->end_controls_section();

        /***** WOO STAR ******/
        $this->start_controls_section('buttons_styling',
            [
                'label' => esc_html__( 'Buttons', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control( 'btn_color',
            [
                'label' => esc_html__( 'Icon Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .button.yith-wcqv-button, {{WRAPPER}} .compare.button, {{WRAPPER}} .shop-product2_actions .yith-wcwl-add-to-wishlist, {{WRAPPER}} .shop-product_actions .yith-wcwl-add-to-wishlist, {{WRAPPER}} .woocommerce .shop-product2_actions a, {{WRAPPER}} .woocommerce .shop-product2_actions a.button, {{WRAPPER}} .woocommerce .shop-product_actions a, {{WRAPPER}} .woocommerce .shop-product_actions a.button, {{WRAPPER}} .yith-wcwl-add-button a' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'btn_hvrcolor',
            [
                'label' => esc_html__( 'Hover Icon Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .button.yith-wcqv-button:hover, {{WRAPPER}} .compare.button:hover, {{WRAPPER}} .shop-product2_actions .yith-wcwl-add-to-wishlist:hover, {{WRAPPER}} .shop-product_actions .yith-wcwl-add-to-wishlist:hover, {{WRAPPER}} .woocommerce .shop-product2_actions a:hover, {{WRAPPER}} .woocommerce .shop-product2_actions a.button:hover, {{WRAPPER}} .woocommerce .shop-product_actions a:hover, {{WRAPPER}} .woocommerce .shop-product_actions a.button:hover, {{WRAPPER}} .yith-wcwl-add-button a:hover' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'btn_bg',
            [
                'label' => esc_html__( 'Background', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .button.yith-wcqv-button, {{WRAPPER}} .compare.button, {{WRAPPER}} .shop-product2_actions .yith-wcwl-add-to-wishlist, {{WRAPPER}} .shop-product_actions .yith-wcwl-add-to-wishlist, {{WRAPPER}} .woocommerce .shop-product2_actions a, {{WRAPPER}} .woocommerce .shop-product2_actions a.button, {{WRAPPER}} .woocommerce .shop-product_actions a, {{WRAPPER}} .woocommerce .shop-product_actions a.button, {{WRAPPER}} .yith-wcwl-add-button a' => 'background-color: {{VALUE}};']
            ]
        );
        $this->add_control( 'btn_hvrbg',
            [
                'label' => esc_html__( 'Hover Background', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .button.yith-wcqv-button:hover, {{WRAPPER}} .compare.button:hover, {{WRAPPER}} .shop-product2_actions .yith-wcwl-add-to-wishlist:hover, {{WRAPPER}} .shop-product_actions .yith-wcwl-add-to-wishlist:hover, {{WRAPPER}} .woocommerce .shop-product2_actions a:hover, {{WRAPPER}} .woocommerce .shop-product2_actions a.button:hover, {{WRAPPER}} .woocommerce .shop-product_actions a:hover, {{WRAPPER}} .woocommerce .shop-product_actions a.button:hover, {{WRAPPER}} .yith-wcwl-add-button a:hover' => 'background-color: {{VALUE}};']
            ]
        );
        $this->add_control( 'btn_brd',
            [
                'label' => esc_html__( 'Border', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shop-product_actions' => 'border-color: {{VALUE}}!important;',
                    '{{WRAPPER}} .shop-product_actions .yith-wcwl-add-to-wishlist, {{WRAPPER}} .shop-product_actions a:not(:first-child)' => 'border-left-color: {{VALUE}}!important;'
                ]
            ]
        );
        $this->end_controls_section();
        /***** END WOO STAR ******/

        /***** WOO STAR ******/
        $this->start_controls_section('pagination_styling',
            [
                'label' => esc_html__( 'Pagination', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control( 'pag_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .pagination.woo-pagination ul li a, {{WRAPPER}} .pagination.woo-pagination ul li span' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'pag_hvrcolor',
            [
                'label' => esc_html__( 'Active && Hover Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .pagination.woo-pagination ul li a:focus, {{WRAPPER}} .pagination.woo-pagination ul li a:hover, {{WRAPPER}} .pagination.woo-pagination ul li span.current' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'pag_brd',
            [
                'label' => esc_html__( 'Border Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .pagination.woo-pagination ul li a, {{WRAPPER}} .pagination.woo-pagination ul li span' => 'border-color: {{VALUE}};']
            ]
        );
        $this->add_control( 'pag_hvrbrd',
            [
                'label' => esc_html__( 'Hover Border Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .pagination.woo-pagination ul li a:focus, {{WRAPPER}} .pagination.woo-pagination ul li a:hover, {{WRAPPER}} .pagination.woo-pagination ul li span.current' => 'border-color: {{VALUE}};']
            ]
        );
        $this->end_controls_section();
        /***** END WOO STAR ******/
        if ( defined( 'YITH_WCBR' ) ) {
            /*****   START CONTROLS SECTION   ******/
            $this->start_controls_section( 'product_item_brands_section',
                [
                    'label' => esc_html__( 'Brands', 'naturally' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                ]
            );
            $this->naturally_style_typo( 'product_item_brands_typo','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_color( 'product_item_brands_color','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_bgcolor( 'product_item_brands_background','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_margin( 'product_item_brands_margin','{{WRAPPER}} .naturally-brands .badge' );
            $this->end_controls_section();
            /*****   END CONTROLS SECTION   ******/

        }
        $this->start_controls_section( 'sidebar_style_section',
            [
                'label' => esc_html__( 'Sidebar', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control( 'sidebar_bg',
            [
                'label' => esc_html__( 'Sidebar Background', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .shop-sidebar' => 'background-color: {{VALUE}};']
            ]
        );
        $this->naturally_style_border( 'sidebar_brd','{{WRAPPER}} .shop-sidebar' );

        $this->add_control( 'sidebar_w_title',
            [
                'label' => esc_html__( 'Widget Title Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .shop-sidebar .nt-sidebar-widget-title' => 'color: {{VALUE}};']
            ]
        );
        $this->naturally_style_typo( 'sidebar_w_title_typo','{{WRAPPER}} .shop-sidebar .nt-sidebar-widget-title' );

        $this->add_control( 'sidebar_w_link',
            [
                'label' => esc_html__( 'Widget Link Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .nt-sidebar-inner-widget ol li a, {{WRAPPER}} .nt-sidebar-inner-widget ul li a, {{WRAPPER}} .woocommerce ul.cart_list li a, {{WRAPPER}} .woocommerce ul.product_list_widget li a, {{WRAPPER}} .nt-sidebar-inner-widget a, {{WRAPPER}}.nt-sidebar-inner-widget ul li a span' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'sidebar_w_hvrlink',
            [
                'label' => esc_html__( 'Hover Link Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .nt-sidebar-inner-widget ol li a:hover, {{WRAPPER}} .nt-sidebar-inner-widget ul li a:hover, {{WRAPPER}} .woocommerce ul.cart_list li a:hover, {{WRAPPER}} .woocommerce ul.product_list_widget li a:hover, {{WRAPPER}} .nt-sidebar-inner-widget a:hover, {{WRAPPER}}.nt-sidebar-inner-widget ul li a:hover span' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'sidebar_w_text',
            [
                'label' => esc_html__( 'General Text Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .nt-sidebar-inner-widget ol li span, {{WRAPPER}} .nt-sidebar-inner-widget ul li span, {{WRAPPER}} .widget-list-span, {{WRAPPER}} .nt-sidebar-inner-widget p' => 'color: {{VALUE}};']
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }
    public function set_column() {
        $settings = $this->get_settings_for_display();
        return $settings['column'];
    }

    public function add_product_thumbs() {
        echo '<div class="shop-product_photo">
            <a href="'.get_permalink().'">';
                woocommerce_template_loop_product_thumbnail();
            echo '</a>
        </div>';
    }
    public function exclude_wc_widget_categories( $cat_args ) {
        $settings = $this->get_settings_for_display();

        if ( 'yes' == $settings['category_exclude_from_sidebar'] && !empty( $settings['category_exclude_filter'] ) ) {
            $cat_args['exclude'] = $settings['category_exclude_filter'];
        }
        return $cat_args;
    }
    public function add_thumbnail_size( $size ) {
        $settings  = $this->get_settings_for_display();
        $size['width'] = $settings['thumbnail2']['width'];
        $size['height'] = $settings['thumbnail2']['height'];
        $size['crop']   = 1;
        return $size;
    }
    protected function render() {
        global $wp_query;
        $settings = $this->get_settings_for_display();

        add_filter('naturally_shop_column', array( $this, 'set_column' ));

        if ( 'yes' == $settings['category_exclude_from_sidebar'] && !empty( $settings['category_exclude_filter'] ) ) {

            add_filter('woocommerce_product_categories_widget_dropdown_args', array( $this, 'exclude_wc_widget_categories' ) );
            add_filter('woocommerce_product_categories_widget_args', array( $this, 'exclude_wc_widget_categories' ) );
        }

        $aos = '';
        if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
            $aos = ' aos-init aos-animate';
            remove_action( 'woocommerce_before_shop_loop_item_title', 'naturally_product_thumbs', 10 );
            add_action( 'woocommerce_before_shop_loop_item_title', array( $this, 'add_product_thumbs' ), 10 );
        }

        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        $args = array(
            'post_type'      => 'product',
            'posts_per_page' => $settings['post_per_page'],
            'post__in'       => $settings['post_filter'],
            'post__not_in'   => $settings['post_exclude_filter'],
            'order'          => $settings['order'],
            'paged'          => $paged,
        );

        if ( 'featured' == $settings['scenario'] ) {
           $args['tax_query'] = array(
                array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                )
            );

        } elseif('on-sale' == $settings['scenario']) {

            $args['meta_query'] = array(
                'relation' => 'AND',
                array(
                    'key' => '_stock_status',
                    'value' => 'instock'
                ),
                array(
                    'relation' => 'OR',
                    array( // Simple products type
                        'key'       => '_sale_price',
                        'value'     => 0,
                        'compare'   => '>',
                        'type'      => 'numeric'
                    ),
                    array( // Variable products type
                        'key'       => '_min_variation_sale_price',
                        'value'     => 0,
                        'compare'   => '>',
                        'type'      => 'numeric'
                    )
                )
            );
        } elseif('best' == $settings['scenario']) {

            $args['orderby'] = 'meta_value_num';
            $args['meta_key'] = 'total_sales';

        } else {

            $args['orderby'] = $settings['orderby'];

        }

        if ( $settings['category_filter'] ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy'  => 'product_cat',
                    'field'     => 'id',
                    'terms'     => $settings['category_filter'],
                    'operator'  => 'IN'
                )
            );
        }
        if ( $settings['category_exclude_filter'] ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy'  => 'product_cat',
                    'field'     => 'id',
                    'terms'     => $settings['category_exclude_filter'],
                    'operator'  => 'NOT IN'
                )
            );
        }
        $orderby = 'menu_order';
        if ( isset( $_GET['orderby'] ) ) {
            $orderby = $_GET['orderby'];
        }
        if ($orderby == 'date') {
            $args['orderby'] = 'date';
            $args['order'] = 'desc';
        } elseif ($orderby == 'price-desc') {
            $args['orderby'] = 'meta_value_num';
            $args['order'] = 'desc';
            $args['meta_key'] = '_price';
        } elseif ($orderby == 'price') {
            $args['orderby'] = 'meta_value_num';
            $args['order'] = 'asc';
            $args['meta_key'] = '_price';
        } elseif ($orderby == 'popularity') {
            $args['orderby'] = 'meta_value_num';
            $args['order'] = 'asc';
            $args['meta_key'] = 'total_sales';
        } elseif ($orderby == 'rating') {
            $args['orderby'] = 'meta_value_num';
            $args['order'] = 'desc';
            $args['meta_key'] = '_wc_average_rating';
        }

        $size = $settings['thumbnail_size'] ? $settings['thumbnail_size'] : 'thumbnail';
        if ( 'custom' == $size ) {
            $sizew = $settings['thumbnail_custom_dimension']['width'];
            $sizeh = $settings['thumbnail_custom_dimension']['height'];
            $size = [ $sizew, $sizeh ];
        }

        if ( !empty( $settings['thumbnail2']['width'] ) && !empty( $settings['thumbnail2']['height'] ) ) {
            add_filter( 'woocommerce_get_image_size_thumbnail', [$this, 'add_thumbnail_size'],1,10 );
        }
        $the_query = new \WP_Query( $args );

        $shop_display_mode = woocommerce_get_loop_display_mode();
        $shop_layout = $settings['layout'];
        $shop_column = 'full-width' != $shop_layout && is_active_sidebar( 'shop-page-sidebar' ) ? ' is-lg-8 is-xl-9' : '';

        if ( 'yes' != $settings['hidetitle'] ) {
            echo '<div class="section text-center">';
                echo '<div class="container">';

                    echo '<div class="headline">';

                    if ( $settings['title'] ) {
                        echo '<h1 class="headline_title">'.$settings['title'].'</h1>';
                    } else {

                        if ( apply_filters( 'woocommerce_show_page_title', true ) ) {
                            echo '<h1 class="headline_title">';
                            woocommerce_page_title();
                            echo '</h1>';
                        }
                    }
                    if ( $settings['desc'] ) {
                        echo '<p class="headline_summary">'.$settings['desc'].'</p>';
                    } else {
                        /**
                        * Hook: woocommerce_archive_description.
                        *
                        * @hooked woocommerce_taxonomy_archive_description - 10
                        * @hooked woocommerce_product_archive_description - 10
                        */
                        do_action( 'woocommerce_archive_description' );
                    }
                echo '</div>';

                if ( 'yes' != $settings['hidebread'] ) {
                    echo '<div class="breadcrumb">';
                    /**
                    * Hook: woocommerce_before_main_content.
                    *
                    * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
                    * @hooked woocommerce_breadcrumb - 20
                    * @hooked WC_Structured_Data::generate_website_data() - 30
                    */
                    do_action( 'woocommerce_before_main_content' );

                    echo '</div>';
                }

                echo '</div>';
            echo '</div>';
        }

        echo '<div class="section woocommerce">';
                echo '<div class="container">';
                    echo '<div class="grid">';
                        echo '<div class="grid_row is-40">';

                            echo '<div class="grid_col is-12 mt-0 woo-message">';
                                /**
                                * Hook: woocommerce_before_shop_loop.
                                *
                                * @hooked woocommerce_output_all_notices - 10
                                * @hooked woocommerce_result_count - 20
                                * @hooked woocommerce_catalog_ordering - 30
                                */
                                do_action( 'woocommerce_before_shop_loop' );
                            echo '</div>';

                            if ('yes' != $settings['hidecat']) {
                                echo '<div class="grid_col is-12 mb-0 '.esc_attr( $shop_display_mode ).'">';
                                    echo '<div class="section section-shop-categories mt-0" data-ntr-shop-categories2>';
                                        echo '<div class="slider-categories">';
                                            echo '<div class="slick-slider">';
                                                $cats = get_terms(
                                                    array(
                                                        'taxonomy' => 'product_cat',
                                                        'order' => $settings['sorder'],
                                                        'orderby' => $settings['sorderby'],
                                                        'include' => $settings['scategory_filter']
                                                    )
                                                );
                                                foreach ($cats as $cat) {
                                                    $imgid = get_term_meta($cat->term_id, 'thumbnail_id', true );
                                                    echo '<div class="slick-item-inner">';
                                                        echo '<a class="slider-categories_item" href="'.esc_url( get_term_link( $cat ) ).'">';
                                                            if ( $imgid ) {
                                                                echo wp_get_attachment_image($imgid, $size, '', array('class'=>'slider-categories_item_photo') );
                                                            }
                                                            if ($cat->name) {
                                                                echo '<span class="slider-categories_item_name">'.$cat->name.'</span>';
                                                            }
                                                            if ($cat->count > 0) {
                                                                echo '<span class="slider-categories_item_count">'.sprintf(_n('%d '.$settings['cat_singular'], '%d '.$settings['cat_plural'], $cat->count, 'naturally'),$cat->count) .'</span>';
                                                            }
                                                        echo '</a>';
                                                    echo '</div>';
                                                }
                                            echo '</div>';
                                        echo '</div>';
                                    echo '</div>';
                                echo '</div>';
                            }

                            if ( 'yes' != $settings['hide_catalog'] ) {
                                echo '<div class="grid_col is-12">';
                                    echo '<div class="shop-header" data-ntr-shop-header>';
                                        echo '<div class="shop-header_views">';
                                            echo '<div class="shop-header_layout">';
                                                $gridactive = $settings['type'] == 'grid' ? ' is-active' : '';
                                                $listactive = $settings['type'] == 'list' ? ' is-active' : '';
                                                $column = $settings['column'] ? $settings['column'] : '3';
                                                echo '<div class="shop-header_layout_item'.$gridactive.'" data-layout="grid-'.$column.'">';
                                                    echo '<span class="shop-header_layout_item_icon icon is-grid"></span>';
                                                    echo '<span class="shop-header_layout_item_text">'.esc_html__( 'Grid View', 'naturally' ).'</span>';
                                                echo '</div>';
                                                echo '<div class="shop-header_layout_item'.$listactive.'" data-layout="list">';
                                                    echo '<span class="shop-header_layout_item_icon icon is-list"></span>';
                                                    echo '<span class="shop-header_layout_item_text">'.esc_html__( 'List View', 'naturally' ).'</span>';
                                                echo '</div>';
                                            echo '</div>';
                                            echo '<div class="shop-header_result">';

                                                echo '<p class="woocommerce-result-count">';

                                                    $paged    = max( 1, get_query_var( 'paged' ) );
                                                    $per_page = $settings['post_per_page'];
                                                    $total    = $the_query->found_posts;
                                                    $first    = ( $per_page * $paged ) - $per_page + 1;
                                                    $last     = min( $total, $settings['post_per_page'] * $paged );

                                                    if ( 1 == $total ) {
                                                        _e( 'Showing the single result', 'naturally' );
                                                    } elseif ( $total <= $per_page || -1 == $per_page ) {
                                                        printf( __( 'Showing all %d results', 'naturally' ), $total );
                                                    } else {
                                                        printf( _x( 'Showing %1$d&ndash;%2$d of %3$d results', '%1$d = first, %2$d = last, %3$d = total', 'naturally' ), $first, $last, $total );
                                                    }
                                                echo '</p>';
                                            echo '</div>';
                                        echo '</div>';
                                        echo '<div class="shop-header_selects">';

                                            $show_default_orderby = 'menu_order' === apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', 'menu_order' ) );
                                            $catalog_orderby_options = apply_filters( 'woocommerce_catalog_orderby',
                                                array(
                                                    'menu_order' => __( 'Default sorting', 'woocommerce' ),
                                                    'popularity' => __( 'Sort by popularity', 'woocommerce' ),
                                                    'rating'     => __( 'Sort by average rating', 'woocommerce' ),
                                                    'date'       => __( 'Sort by latest', 'woocommerce' ),
                                                    'price'      => __( 'Sort by price: low to high', 'woocommerce' ),
                                                    'price-desc' => __( 'Sort by price: high to low', 'woocommerce' )
                                                )
                                            );
                                            $default_orderby = wc_get_loop_prop( 'is_search' ) ? 'relevance' : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', '' ) );
                                            $orderby         = isset( $_GET['orderby'] ) ? wc_clean( wp_unslash( $_GET['orderby'] ) ) : $default_orderby;
                                            echo '<form class="woocommerce-ordering" method="get">';
                                                echo '<select name="orderby" class="orderby" aria-label="'.esc_attr__( 'Shop order', 'woocommerce' ).'">';
                                                    foreach ( $catalog_orderby_options as $id => $name ) :
                                                        ob_start();
                                                        selected( $orderby, $id );
                                                        echo '<option value="'.esc_attr( $id ).'" '.ob_get_clean() .'>'.esc_html( $name ).'</option>';
                                                    endforeach;
                                                echo '</select>';
                                                echo '<input type="hidden" name="paged" value="1" />';
                                                    wc_query_string_form_fields( null, array( 'orderby', 'submit', 'paged', 'product-page' ) );
                                            echo '</form>';
                                        echo '</div>';
                                    echo '</div>';
                                echo '</div>';
                            }

                            if ( 'left-sidebar' == $shop_layout && is_active_sidebar( 'shop-page-sidebar' ) ) {
                                echo '<div class="grid_col is-12 is-lg-4 is-xl-3'.$aos.'" data-aos="ntr-fade-up" data-aos-once="true">';
                                    echo '<div class="shop-sidebar">';
                                        echo '<div class="shop-sidebar_inner">';
                                            dynamic_sidebar( 'shop-page-sidebar' );
                                        echo '</div>';
                                    echo '</div>';
                                echo '</div>';
                            }

                        $type = $settings['type'] == 'grid' ? ' is-grid-'.$settings['column'] : ' is-grid-'.$settings['column'];
                        $type = $settings['type'] == 'list' ? ' is-list' : $type;

                        echo '<div class="grid_col is-12'.$shop_column.$aos.'" data-aos="ntr-fade-up" data-aos-once="true">';
                            echo '<div class="shop-products'.$type.'">';
                                echo '<div class="grid">';
                                    echo '<div class="grid_row is-40">';

                                        if ( $the_query->have_posts() ) {
                                            while ($the_query->have_posts()) {
                                                $the_query->the_post();

                                                do_action( 'woocommerce_shop_loop' );

                                                wc_get_template_part( 'content', 'product' );
                                            }

                                        } else {

                                            do_action( 'woocommerce_no_products_found' );
                                        }
                                        wp_reset_postdata();

                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                            if($the_query->max_num_pages>1) {
                                echo '<div class="pagination woo-pagination">';
                                    echo '<div class="pagination_items">';
                                        echo paginate_links( apply_filters(
                                                'woocommerce_pagination_args', array(
                                                    'base'      => esc_url( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
                                                    'format'    => '',
                                                    'current'   => max( 1, get_query_var( 'paged' ) ),
                                                    'total'     => $the_query->max_num_pages,
                                                    'prev_text' => '<span class="icon is-prev"></span>',
                                                    'next_text' => '<span class="icon is-next"></span>',
                                                    'type'      => 'list',
                                                    'end_size'  => 3,
                                                    'mid_size'  => 3
                                                )
                                            )
                                        );
                                    echo '</div>';
                                echo '</div>';
                            }
                        echo '</div>';

                        if ( 'right-sidebar' == $shop_layout && is_active_sidebar( 'shop-page-sidebar' ) ) {
                            echo '<div class="grid_col is-12 is-lg-4 is-xl-3'.$aos.'" data-aos="ntr-fade-up" data-aos-once="true">';
                                echo '<div class="shop-sidebar">';
                                    echo '<div class="shop-sidebar_inner">';
                                        dynamic_sidebar( 'shop-page-sidebar' );
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        }

                    echo '</div>';
                echo '</div>';
                echo '</div>';
        echo '</div>';
        if ( !empty( $settings['thumbnail2']['width'] ) && !empty( $settings['thumbnail2']['height'] ) ) {
            remove_filter( 'woocommerce_get_image_size_thumbnail', [$this, 'add_thumbnail_size'],1,10 );
        }
        do_action( 'woocommerce_after_main_content' );

    }
}
