<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Woo_Product_Item_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-woo-product-item';
    }
    public function get_title() {
        return 'Woo Product Item (N)';
    }
    public function get_icon() {
        return 'eicon-image-box';
    }
    public function get_categories() {
        return [ 'naturally-woo' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'post_query_section',
            [
                'label' => esc_html__( 'Query', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'filter_by',
            [
                'label' => esc_html__( 'Show Product By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => 'title',
                'options' => [
                    'title' => esc_html__( 'Title', 'naturally' ),
                    'sku' => esc_html__( 'SKU', 'naturally' )
                ]
            ]
        );
        // Post Filter Heading
        $this->add_control( 'post_filter_heading',
            [
                'label' => esc_html__( 'Post Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        // Specific Post
        $this->add_control( 'post_filter',
            [
                'label' => esc_html__( 'Specific Post(s)', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => false,
                'options' => $this->naturally_cpt_get_post_title('product'),
                'description' => 'Select Specific Post(s)',
                'condition' => [ 'filter_by' => 'title' ]
            ]
        );
        // Specific Post
        $this->add_control( 'post_skus',
            [
                'label' => esc_html__( 'Specific SKU', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => false,
                'options' => $this->naturally_woo_get_skus(),
                'description' => 'Select Specific SKU',
                'condition' => [ 'filter_by' => 'sku' ]
            ]
        );
        // Specific Post Attr
        $this->add_control( 'post_attr',
            [
                'label' => esc_html__( 'Show Product Attribute', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => false,
                'options' => $this->naturally_woo_attributes_taxonomies(),
                'description' => 'Select Specific SKU',
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Product Box Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => '1',
                'options' => [
                    '1' => esc_html__( 'Default', 'naturally' ),
                    '2' => esc_html__( 'List Type', 'naturally' )
                ]
            ]
        );
        $this->add_group_control(
        Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium',
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        if ( defined( 'YITH_WCBR' ) ) {
            /*****   START CONTROLS SECTION   ******/
            $this->start_controls_section( 'product_item_brands_section',
                [
                    'label' => esc_html__( 'BRANDS', 'naturally' ),
                    'tab' => Controls_Manager::TAB_CONTENT,
                ]
            );
            $this->naturally_style_typo( 'product_item_brands_typo','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_color( 'product_item_brands_color','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_bgcolor( 'product_item_brands_background','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_margin( 'product_item_brands_margin','{{WRAPPER}} .naturally-brands .badge' );
            $this->end_controls_section();
            /*****   END CONTROLS SECTION   ******/
        }
    }

    protected function render() {
        global $wp_query;
        $settings  = $this->get_settings_for_display();
        $elementid = $this->get_id();

        $args = array(
            'post_type'      => 'product',
            'posts_per_page' => 1,
        );

        if ( 'sku' == $settings['filter_by'] ) {

            if ( $settings['post_skus'] ) {

                $args['meta_query'] = [
                    [
                        'key'     => '_sku',
                        'value'   => $settings['post_skus'],
                        'compare' => '='
                    ]
                ];
            }

        } else {

            if ( $settings['post_filter'] ) {
                $args['post__in'] = array($settings['post_filter']);
            }
        }
        $size = $settings['thumbnail_size'] ? $settings['thumbnail_size'] : 'full';
        if ( 'custom' == $size ) {
            $sizew = $settings['thumbnail_custom_dimension']['width'];
            $sizeh = $settings['thumbnail_custom_dimension']['height'];
            $size = [ $sizew, $sizeh ];
        }
        $the_query = new \WP_Query( $args );
        if( $the_query->have_posts() ) {
            echo '<div class="product-items woocommerce">';

                while ($the_query->have_posts()) {
                    $the_query->the_post();
                    global $product;

                    $badge = get_post_meta( $product->get_id(), 'naturally_badge', true );
                    $badge_custom = get_post_meta( $product->get_id(), 'naturally_custom_badge', true );
                    $attr = get_post_meta( $product->get_id(), 'naturally_product_single_attr', true );
                    $attr_custom = get_post_meta( $product->get_id(), 'naturally_product_custom_attr', true );
                    $show_discount = get_post_meta( $product->get_id(), 'naturally_product_discount', true );
                    $badge = $badge || $badge_custom ? 'yes' : '';
                    $attr = $attr || $attr_custom ? 'yes' : '';
                    $discount = $show_discount == 'yes' ? 'yes' : '';


                    if ( '2' == $settings['type'] ) {

                        remove_action( 'woocommerce_after_shop_loop_item', 'naturally_product_price', 5 );
                        remove_action( 'woocommerce_after_shop_loop_item', 'naturally_before_product_buttons', 9 );
                        remove_action( 'woocommerce_after_shop_loop_item', 'naturally_after_product_buttons', 25 );
                        ob_start();
                        wc_product_class( 'shop-product2 hover-shadow', $product );
                        echo '<div '.ob_get_clean().'>';

                            if ( function_exists( 'naturally_product_all_labels' ) ) {
                                naturally_product_all_labels();
                            }

                            echo '<div class="shop-product2_photo">';
                                echo '<a href="'.get_permalink().'">';
                                    if ( $size ) {
                                        echo wp_get_attachment_image($product->get_image_id(), $size );
                                    } else {
                                        woocommerce_template_loop_product_thumbnail();
                                    }
                                echo '</a>';
                            echo '</div>';

                            echo '<div class="shop-product2_body">';
                                echo '<div class="shop-product2_title">';
                                    echo '<a href="'.get_permalink().'">'.get_the_title().'</a>';
                                echo '</div>';
                                if( wc_review_ratings_enabled() && $product->get_average_rating() ){
                                    echo '<div class="shop-product2_rating">';
                                        echo '<div class="rating">';
                                            woocommerce_template_loop_rating();
                                        echo '</div>';
                                    echo '</div>';
                                }
                                if( $product->get_price_html() ){
                                    echo '<div class="shop-product2_prices">';
                                        woocommerce_template_loop_price();
                                    echo '</div>';
                                }

                                if ( defined( 'YITH_WCBR' ) && function_exists( 'naturally_product_brand' ) ) {
                                    naturally_product_brand();
                                }

                            echo '</div>';

                            echo '<div class="shop-product2_actions">';
                                do_action( 'woocommerce_after_shop_loop_item' );
                            echo '</div>';
                        echo '</div>';

                    } else {
                        ob_start();
                        wc_product_class( 'shop-product hover-shadow', $product );
                        echo '<div '.ob_get_clean().'>';

                            if ( function_exists( 'naturally_product_all_labels' ) ) {
                                naturally_product_all_labels();
                            }

                            echo '<div class="shop-product_photo">';
                                echo '<a href="'.get_permalink().'">';
                                    if ( $size ) {
                                        echo wp_get_attachment_image($product->get_image_id(), $size );
                                    } else {
                                        woocommerce_template_loop_product_thumbnail();
                                    }
                                echo '</a>';
                            echo '</div>';

                            echo '<div class="shop-product_content">';
                                echo '<div class="shop-product_body">';

                                    echo '<div class="shop-product_title">';
                                        echo '<a href="'.get_permalink().'">'.get_the_title().'</a>';
                                    echo '</div>';
                                    if( wc_review_ratings_enabled() && $product->get_average_rating() ){
                                        echo '<div class="shop-product_rating">';
                                            echo '<div class="rating">';
                                                woocommerce_template_loop_rating();
                                            echo '</div>';
                                        echo '</div>';
                                    }

                                    if ( defined( 'YITH_WCBR' ) && function_exists( 'naturally_product_brand' ) ) {
                                        naturally_product_brand();
                                    }
                                echo '</div>';

                                echo '<div class="shop-product_footer">';
                                    do_action( 'woocommerce_after_shop_loop_item' );
                                echo '</div>';

                            echo '</div>';
                        echo '</div>';
                    }
                }

            echo '</div>';
        }
        wp_reset_postdata();
    }
}
