<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Woo_Product_Slider_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-woo-product-slider';
    }
    public function get_title() {
        return 'Woo Slider 2 (N)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'naturally-woo' ];
    }
    // Registering Controls
    protected function register_controls() {

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'post_query_section',
            [
                'label' => esc_html__( 'Query', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        // Order
        $this->add_control( 'scenario',
            [
                'label' => esc_html__( 'Select Scenario', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'featured' => esc_html__( 'Featured', 'naturally' ),
                    'on-sale' => esc_html__( 'On Sale', 'naturally' ),
                    'best' => esc_html__( 'Best Selling', 'naturally' ),
                    'custom' => esc_html__( 'Specific Categories', 'naturally' ),
                ],
                'default' => 'newest'
            ]
        );
        // Category Filter Heading
        $this->add_control( 'category_filter_heading',
            [
                'label' => esc_html__( 'Category Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        // Category Filter
        $this->add_control( 'category_filter',
            [
                'label' => esc_html__( 'Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s)',
                'condition' => [ 'scenario' => 'custom' ]
            ]
        );
        // Exclude Category
        $this->add_control( 'category_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s) to Exclude',
            ]
        );
        // Post Filter Heading
        $this->add_control( 'post_filter_heading',
            [
                'label' => esc_html__( 'Post Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        // Specific Post
        $this->add_control( 'post_filter',
            [
                'label' => esc_html__( 'Specific Post(s)', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_get_post_title('product'),
                'description' => 'Select Specific Post(s)',
                'condition' => [ 'scenario' => 'custom' ]
            ]
        );
        // Exclude Post
        $this->add_control( 'post_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Post', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_get_post_title('product'),
                'description' => 'Select Post(s) to Exclude',
                'separator' => 'after',
            ]
        );
        // Other Filter Heading
        $this->add_control( 'post_other_heading',
            [
                'label' => esc_html__( 'Other Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        // Posts Per Page
        $this->add_control( 'post_per_page',
            [
                'label' => esc_html__( 'Posts Per Page', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 1000,
                'default' => 20
            ]
        );
        // Order
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'naturally' ),
                    'DESC' => esc_html__( 'Descending', 'naturally' )
                ],
                'default' => 'ASC'
            ]
        );
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'naturally' ),
                    'menu_order' => esc_html__( 'Menu Order', 'naturally' ),
                    'rand' => esc_html__( 'Random', 'naturally' ),
                    'date' => esc_html__( 'Date', 'naturally' ),
                    'title' => esc_html__( 'Title', 'naturally' ),
                ],
                'default' => 'id',
            ]
        );
		$this->add_control( 'thumbnail2',
			[
				'label' => esc_html__( 'Image Dimension', 'naturally' ),
				'type' => Controls_Manager::IMAGE_DIMENSIONS,
				'description' => esc_html__( 'Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.', 'naturally' ),
				'default' => [
					'width' => '',
					'height' => '',
				],
			]
		);
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_woo_product_slider_text_settings',
            [
                'label' => esc_html__('Section Text', 'naturally'),
            ]
        );
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Hot deals of the week',
                'label_block' => true,
            ]
        );
        $this->add_control( 'desc',
            [
                'label' => esc_html__( 'Description', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam sollicitudin elit et lectus scelerisque aliquet. Aenean vitaemi. Mauris at augue vel tortor suscipit cursus.',
                'label_block' => true,
            ]
        );
        $this->add_control( 'btn_title',
            [
                'label' => esc_html__( 'Button Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Discover',
                'label_block' => true,
            ]
        );
        $this->add_control( 'btn_link',
            [
                'label' => esc_html__( 'Button Link', 'naturally' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '#0',
                    'is_external' => ''
                ],
                'show_external' => true
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'bg_img',
                'label' => esc_html__( 'Background', 'naturally' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .section-custom-2',
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /***** Woo Slider Style ******/

        /***** TITLE ******/
        $this->start_controls_section('naturally_woo_title_styling',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_title_woo_tabs');
        $this->start_controls_tab( 'naturally_title_woo_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='title_woo',$selector='.slider-deals_title');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_title_woo_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='title_woo_hover',$selector='.slider-deals_title:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
        /***** END TITLE ******/

        /***** DESCRIPTION ******/
        $this->start_controls_section('naturally_desc_woo_styling',
            [
                'label' => esc_html__( 'Description', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_desc_woo_tabs');
        $this->start_controls_tab( 'naturally_desc_woo_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='desc_woo',$selector='.slider-deals_summary');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_desc_woo_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='desc_woo_hover',$selector='.slider-deals_summary:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
        /***** END DESCRIPTION ******/

        /***** WOO TITLE ******/
        $this->start_controls_section('naturally_ititle_woo_styling',
            [
                'label' => esc_html__( 'Woo Item Title', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_ititle_woo_tabs');
        $this->start_controls_tab( 'naturally_ititle_woo_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='ititle_woo',$selector='.shop-product_title');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_ititle_woo_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='ititle_woo_hover',$selector='.shop-product_title:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
        /***** END WOO TITLE ******/

        /***** WOO STAR ******/
        $this->start_controls_section('naturally_star_woo_styling',
            [
                'label' => esc_html__( 'Woo Star', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control( 'naturally_star_woo_color',
           [
               'label' => esc_html__( 'Star Color', 'naturally' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .star-rating span::before' => 'color: {{VALUE}};']
           ]
       );
       $this->add_control( 'naturally_empty_star_woo_color',
          [
              'label' => esc_html__( 'Empty Star Color', 'naturally' ),
              'type' => Controls_Manager::COLOR,
              'default' => '',
              'selectors' => ['{{WRAPPER}} .woocommerce .star-rating::before' => 'color: {{VALUE}};']
          ]
      );
      $this->end_controls_section();
        /***** END WOO STAR ******/

        /***** WOO PRICE AMOUNT ******/
        $this->start_controls_section('naturally_pamount_woo_styling',
            [
                'label' => esc_html__( 'Woo Price Amount', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->naturally_style_controls(array('shadow'),$id='pamount_woo',$selector='ins .woocommerce-Price-amount');
        $this->end_controls_section();

        /***** END WOO PRICE AMOUNT ******/

        /***** WOO REDUCED PRICE AMOUNT ******/
        $this->start_controls_section('naturally_rpamount_woo_styling',
            [
                'label' => esc_html__( 'Woo Reduced Price Amount', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->naturally_style_controls(array('shadow'),$id='rpamount_woo',$selector='.woocommerce .price del,del .woocommerce-Price-amount');
        $this->end_controls_section();

        /***** END WOO REDUCED PRICE AMOUNT ******/

        /***** End woo slider style ******/
    }
    public function add_thumbnail_size( $size ) {
        $settings  = $this->get_settings_for_display();
        $size['width'] = $settings['thumbnail2']['width'];
        $size['height'] = $settings['thumbnail2']['height'];
        $size['crop']   = 1;
        return $size;
    }
    protected function render() {
        global $wp_query;
        $settings = $this->get_settings_for_display();
        $target   = $settings['btn_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['btn_link']['nofollow'] ? ' rel="nofollow"' : '';

        $args = array(
            'post_type'      => 'product',
            'posts_per_page' => $settings['post_per_page'],
            'post__in'       => $settings['post_filter'],
            'post__not_in'   => $settings['post_exclude_filter'],
            'order'          => $settings['order']
        );

        if ( 'featured' == $settings['scenario'] ) {
           $args['tax_query'] = array(
                array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                )
            );

        } elseif('on-sale' == $settings['scenario']) {

            $args['meta_query'] = array(
                'relation' => 'OR',
                array( // Simple products type
                    'key'       => '_sale_price',
                    'value'     => 0,
                    'compare'   => '>',
                    'type'      => 'numeric'
                ),
                array( // Variable products type
                    'key'       => '_min_variation_sale_price',
                    'value'     => 0,
                    'compare'   => '>',
                    'type'      => 'numeric'
                )
            );

        } elseif('best' == $settings['scenario']) {

            $args['orderby'] = 'meta_value_num';
            $args['meta_key'] = 'total_sales';

        } else {

            $args['orderby'] = $settings['orderby'];

        }

        if ( $settings['category_filter'] ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy'  => 'product_cat',
                    'field'     => 'id',
                    'terms'     => $settings['category_filter'],
                    'operator'  => 'IN'
                )
            );
        }
        if ( $settings['category_exclude_filter'] ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy'  => 'product_cat',
                    'field'     => 'id',
                    'terms'     => $settings['category_exclude_filter'],
                    'operator'  => 'NOT IN'
                )
            );
        }
        if ( !empty( $settings['thumbnail2']['width'] ) && !empty( $settings['thumbnail2']['height'] ) ) {
            add_filter( 'woocommerce_get_image_size_thumbnail', [$this, 'add_thumbnail_size'],1,10 );
        }
        echo '<div class="section-custom-2">';
            echo '<div class="container">';
                echo '<div class="slider-deals" data-ntr-slider-deals>';
                    if ( $settings['title'] || $settings['desc'] || $settings['btn_title']) {
                        echo '<div class="slider-deals_heading" data-ntr-animation=\'{"name":"fadein-up"}\'>';
                            if ($settings['title']) {
                                echo '<h2 class="slider-deals_title">'.$settings['title'].'</h2>';
                            }
                            if ($settings['desc']) {
                                echo '<p class="slider-deals_summary">'.$settings['desc'].'</p>';
                            }
                            if ($settings['btn_title']) {
                                echo '<p>';
                                    echo '<a class="link is-color-secondary" href="'.$settings['btn_link']['url'].'"'.$target.$nofollow.'>';
                                        echo '<span class="link_text">'.$settings['btn_title'].'</span>';
                                        echo '<span class="link_icon icon is-next"></span>';
                                    echo '</a>';
                                echo '</p>';
                            }
                        echo '</div>';
                    }

                    $the_query = new \WP_Query( $args );
                    if( $the_query->have_posts() ) {
                        echo '<div class="slider-deals_products woocommerce">';
                            echo '<div class="slick-slider">';
                                while ($the_query->have_posts()) {
                                    $the_query->the_post();
                                    echo '<div class="slick-item-inner">';
                                        wc_get_template_part( 'content', 'product' );
                                    echo '</div>';
                                }
                            echo '</div>';
                        echo '</div>';
                    }
                    wp_reset_postdata();
                echo '</div>';
            echo '</div>';
        echo '</div>';
        if ( !empty( $settings['thumbnail2']['width'] ) && !empty( $settings['thumbnail2']['height'] ) ) {
            remove_filter( 'woocommerce_get_image_size_thumbnail', [$this, 'add_thumbnail_size'],1,10 );
        }
    }
}
