<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Woo_Products_Gallery_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-woo-products-gallery';
    }
    public function get_title() {
        return 'Woo Gallery (N)';
    }
    public function get_icon() {
        return 'eicon-gallery-grid';
    }
    public function get_categories() {
        return [ 'naturally-woo' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'post_query_section',
            [
                'label' => esc_html__( 'Query', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        // Order
        $this->add_control( 'scenario',
            [
                'label' => esc_html__( 'Select Scenario', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'featured' => esc_html__( 'Featured', 'naturally' ),
                    'on-sale' => esc_html__( 'On Sale', 'naturally' ),
                    'best' => esc_html__( 'Best Selling', 'naturally' ),
                    'custom' => esc_html__( 'Specific Categories', 'naturally' ),
                ],
                'default' => 'custom'
            ]
        );
        // Category Filter Heading
        $this->add_control( 'category_filter_heading',
            [
                'label' => esc_html__( 'Category Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        // Category Filter
        $this->add_control( 'category_filter',
            [
                'label' => esc_html__( 'Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s)',
                'condition' => [ 'scenario' => 'custom' ]
            ]
        );
        // Exclude Category
        $this->add_control( 'category_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s) to Exclude',
            ]
        );
        // Post Filter Heading
        $this->add_control( 'post_filter_heading',
            [
                'label' => esc_html__( 'Post Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        // Specific Post
        $this->add_control( 'post_filter',
            [
                'label' => esc_html__( 'Specific Post(s)', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_get_post_title('product'),
                'description' => 'Select Specific Post(s)',
                'condition' => [ 'scenario' => 'custom' ]
            ]
        );
        // Exclude Post
        $this->add_control( 'post_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Post', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_get_post_title('product'),
                'description' => 'Select Post(s) to Exclude',
            ]
        );
        // Other Filter Heading
        $this->add_control( 'post_other_heading',
            [
                'label' => esc_html__( 'Other Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        // Posts Per Page
        $this->add_control( 'post_per_page',
            [
                'label' => esc_html__( 'Posts Per Page', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 1000,
                'default' => 20
            ]
        );
        // Order
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'naturally' ),
                    'DESC' => esc_html__( 'Descending', 'naturally' )
                ],
                'default' => 'ASC'
            ]
        );
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'naturally' ),
                    'menu_order' => esc_html__( 'Menu Order', 'naturally' ),
                    'rand' => esc_html__( 'Random', 'naturally' ),
                    'date' => esc_html__( 'Date', 'naturally' ),
                    'title' => esc_html__( 'Title', 'naturally' ),
                ],
                'default' => 'id',
            ]
        );
        $this->add_group_control(
        Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium',
            ]
        );
        // Other Filter Heading
        $this->add_control( 'post_column_heading',
            [
                'label' => esc_html__( 'Column and Type', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Product Box Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => '1',
                'options' => [
                    '1' => esc_html__( 'Default', 'naturally' ),
                    '2' => esc_html__( 'List Type', 'naturally' )
                ]
            ]
        );
        $this->add_control( 'col_xl',
            [
                'label' => esc_html__( 'XL Device Column Width', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => '6',
                'options' => [
                    '4' => esc_html__( '3 Column', 'naturally' ),
                    '6' => esc_html__( '2 Column', 'naturally' )
                ],
                'condition' => [ 'type' => '2' ]
            ]
        );
        $this->add_control( 'col_lg',
            [
                'label' => esc_html__( 'LG Device Column Width', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => '4',
                'options' => [
                    '3' => esc_html__( 'Default 4 Column', 'naturally' ),
                    '4' => esc_html__( '3 Column', 'naturally' ),
                    '6' => esc_html__( '2 Column', 'naturally' )
                ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'post_filter_section',
            [
                'label' => esc_html__( 'Gallery Filters', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [ 'scenario' => 'custom' ]
            ]
        );
        $this->add_control( 'hide_filters',
            [
                'label' => esc_html__( 'Hide Filters', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'return_value' => 'yes'
            ]
        );
        // Exclude Category
        $this->add_control( 'category_exclude_filter2',
            [
                'label' => esc_html__( 'Exclude Category from Filter', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies(array ( 'taxonomy' => 'product_cat','hide_empty' => true,'parent' => 0) ),
                'description' => 'Select Category(s) to Exclude',
                'condition' => [ 'hide_filters!' => 'yes' ]
            ]
        );
        $this->add_responsive_control( 'filter_spacing',
            [
                'label' => esc_html__( 'Filter Bottom Spacing', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 500
                    ]
                ],
                'selectors' => ['{{WRAPPER}} .section-custom-6' => 'margin-bottom: {{SIZE}}px;'],
                'condition' => [ 'hide_filters!' => 'yes' ]
            ]
        );

        $this->add_control( 'all_text',
            [
                'label' => esc_html__( 'All Text', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'All Products',
                'label_block' => true,
                'condition' => [ 'hide_filters!' => 'yes' ]
            ]
        );
        $this->add_control( 'filter_text',
            [
                'label' => esc_html__( 'Mobile Filter Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Filter',
                'label_block' => true,
                'condition' => [ 'hide_filters!' => 'yes' ]
            ]
        );
        /*
        // tooltip Filter Heading
        $this->add_control( 'post_tooltip_heading',
            [
                'label' => esc_html__( 'Filter Tooltip', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control( 'hide_tooltip',
            [
                'label' => esc_html__( 'Hide Tooltip', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'return_value' => 'yes'
            ]
        );
        $this->add_control( 'tooltip_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.ui-tooltip.is-top:after' => 'border-color: {{VALUE}} transparent transparent transparent;',
                    '.ui-tooltip.is-right:after' => 'border-color: transparent {{VALUE}} transparent transparent;',
                    '.ui-tooltip.is-left:after' => 'border-color: transparent transparent transparent {{VALUE}};',
                    '.ui-tooltip.is-bottom:after' => 'border-color: transparent transparent {{VALUE}} transparent;',
                    '.ui-tooltip.ui-widget-content' => 'background-color: {{VALUE}};',
                ],
                'condition' => [ 'hide_filters!' => 'yes' ]
            ]
        );
        $this->add_control( 'tooltip_txtcolor',
            [
                'label' => esc_html__( 'Number Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['.ui-tooltip.ui-widget-content' => 'color: {{VALUE}};'],
                'condition' => [ 'hide_filters!' => 'yes' ]
            ]
        );
        $this->add_responsive_control( 'tooltip_padding',
            [
                'label' => esc_html__( 'Padding', 'naturally' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['.ui-tooltip' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                ],
                'condition' => [ 'hide_filters!' => 'yes' ]
            ]
        );
        $this->add_control( 'tooltip_fontsize',
            [
                'label' => esc_html__( 'Font Size', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 10,
                'max' => 36,
                'step' => 1,
                'default' => '',
                'selectors' => ['.ui-tooltip.ui-widget'  => 'font-size: {{VALUE}}px;']
            ]
        );
        */
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        if ( defined( 'YITH_WCBR' ) ) {
            /*****   START CONTROLS SECTION   ******/
            $this->start_controls_section( 'product_item_brands_section',
                [
                    'label' => esc_html__( 'BRANDS', 'naturally' ),
                    'tab' => Controls_Manager::TAB_CONTENT,
                ]
            );
            $this->naturally_style_typo( 'product_item_brands_typo','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_color( 'product_item_brands_color','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_bgcolor( 'product_item_brands_background','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_margin( 'product_item_brands_margin','{{WRAPPER}} .naturally-brands .badge' );
            $this->end_controls_section();
            /*****   END CONTROLS SECTION   ******/
        }
    }

    protected function render() {
        global $wp_query;
        $settings = $this->get_settings_for_display();

        $size = $settings['thumbnail_size'] ? $settings['thumbnail_size'] : 'full';
        if ( 'custom' == $size ) {
            $sizew = $settings['thumbnail_custom_dimension']['width'];
            $sizeh = $settings['thumbnail_custom_dimension']['height'];
            $size = [ $sizew, $sizeh ];
        }

        $args = array(
            'post_type'      => 'product',
            'posts_per_page' => $settings['post_per_page'],
            'post__in'       => $settings['post_filter'],
            'post__not_in'   => $settings['post_exclude_filter'],
            'order'          => $settings['order']
        );

        if ( 'featured' == $settings['scenario'] ) {
           $args['tax_query'] = array(
                array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                )
            );

        } elseif('on-sale' == $settings['scenario']) {

            $args['meta_query'] = array(
                'relation' => 'OR',
                array( // Simple products type
                    'key'       => '_sale_price',
                    'value'     => 0,
                    'compare'   => '>',
                    'type'      => 'numeric'
                ),
                array( // Variable products type
                    'key'       => '_min_variation_sale_price',
                    'value'     => 0,
                    'compare'   => '>',
                    'type'      => 'numeric'
                )
            );

        } elseif('best' == $settings['scenario']) {

            $args['orderby'] = 'meta_value_num';
            $args['meta_key'] = 'total_sales';

        } else {

            $args['orderby'] = $settings['orderby'];

        }

        if ( $settings['category_filter'] ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy'  => 'product_cat',
                    'field'     => 'id',
                    'terms'     => $settings['category_filter'],
                    'operator'  => 'IN'
                )
            );
        }
        if ( $settings['category_exclude_filter'] ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy'  => 'product_cat',
                    'field'     => 'id',
                    'terms'     => $settings['category_exclude_filter'],
                    'operator'  => 'NOT IN'
                )
            );
        }

        $settings  = $this->get_settings_for_display();
        $elementid = $this->get_id();
        $product_cat_args = array (
            'taxonomy' => 'product_cat', //empty string(''), false, 0 don't work, and return empty array
            'orderby' => 'name',
            'order' => 'ASC',
            'hide_empty' => true, //can be 1, '1' too
            'parent' => 0,
            'exclude' => $settings['category_exclude_filter2'] ? $settings['category_exclude_filter2'] : 'all',
        );

        $cats = get_terms($product_cat_args);
        if ( 'yes' != $settings['hide_filters'] && 'custom' == $settings['scenario'] && $cats > 1 ) {
            echo '<div class="section section-custom-6 gallery-products">';
                echo '<div class="container-off">';
                    echo '<div class="nav" data-ntr-nav>';
                        echo '<div class="nav_toggle">';
                            echo '<div class="nav_toggle_button">';
                                echo '<span class="nav_toggle_button_icon icon is-filter"></span>';
                                echo '<span class="nav_toggle_button_text">'.$settings['filter_text'].'</span>';
                            echo '</div>';
                            echo '<div class="nav_toggle_inner">';
                                echo '<nav class="nav_menu">';
                                    echo '<ul class="nav_menu_items">';
                                        $count_posts = wp_count_posts( 'product' )->publish;
                                        $tooltipone = '';
                                        //$tooltipone = 'yes' != $settings['hide_tooltip'] ? ' data-ntr-ui-tooltip=\'{"position":"top","content":"'.$count_posts.'"}\'' : '';
                                        echo '<li class="nav_menu_item is-active"><a class="nav_menu_link" href="#"'.$tooltipone.' data-ntr-isotope-filter=\'{"name":"gallery_'.$elementid.'", "selector":"*"}\'>'.$settings['all_text'].'</a></li>';
                                        foreach ($cats as $cat) {
                                            $tooltiptwo = '';
                                            //$tooltiptwo = 'yes' != $settings['hide_tooltip'] ? ' data-ntr-ui-tooltip=\'{"position":"top","content":"'.$cat->count.'"}\'' : '';
                                            $filter_item = strtolower(str_replace(' ', '-', $cat->name));
                                            echo '<li class="nav_menu_item"><a class="nav_menu_link" href="#"'.$tooltiptwo.' data-ntr-isotope-filter=\'{"name":"gallery_'.$elementid.'", "selector":".'.$filter_item.'"}\'>'.$cat->name.'</a></li>';
                                        }
                                    echo '</ul>';
                                echo '</nav>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }
        $the_query = new \WP_Query( $args );
        if( $the_query->have_posts() ) {
            echo '<div class="section-gallery woocommerce">';
                echo '<div class="container-off">';
                    echo '<div class="grid">';
                        echo '<div class="grid_row is-40" data-ntr-isotope=\'{"name":"gallery_'.$elementid.'", "itemSelector":".grid_col", "layoutMode":"fitRows"}\' data-ntr-lightbox=\'{"type":"gallery","selector":".gallery-photo"}\'>';
                            while ($the_query->have_posts()) {
                                $the_query->the_post();
                                global $product;
                                $terms = $product->get_category_ids();
                                $termname = array();
                                foreach ( $terms as $term ) {
                                    $term = get_term_by( 'id', $term, 'product_cat' );
                                    array_push($termname, strtolower(str_replace(' ', '-', $term->name)));
                                }

                            if ( '2' == $settings['type'] ) {
                                $colxl  = $settings['col_xl'] ? $settings['col_xl'] : '6';
                                $collg  = $settings['col_lg'] ? $settings['col_lg'] : '4';
                                remove_action( 'woocommerce_after_shop_loop_item', 'naturally_product_price', 5 );
                                remove_action( 'woocommerce_after_shop_loop_item', 'naturally_before_product_buttons', 9 );
                                remove_action( 'woocommerce_after_shop_loop_item', 'naturally_after_product_buttons', 25 );

                                $badge = get_post_meta( $product->get_id(), 'naturally_badge', true );
                                $badge_custom = get_post_meta( $product->get_id(), 'naturally_custom_badge', true );
                                $attr = get_post_meta( $product->get_id(), 'naturally_product_single_attr', true );
                                $attr_custom = get_post_meta( $product->get_id(), 'naturally_product_custom_attr', true );
                                $show_discount = get_post_meta( $product->get_id(), 'naturally_product_discount', true );

                                $badge = $badge || $badge_custom ? 'yes' : '';
                                $attr = $attr || $attr_custom ? 'yes' : '';
                                $discount = $show_discount == 'yes' ? 'yes' : '';

                                echo '<div class="grid_col is-12 is-sm-6 is-lg-'.$collg.' is-xl-'.$colxl.' '.implode(' ', $termname).' product-items">';
                                    ob_start();
                                    wc_product_class( 'shop-product2 hover-shadow', $product );
                                    echo '<div '.ob_get_clean().'>';

                                        if ( function_exists( 'naturally_product_all_labels' ) ) {
                                            naturally_product_all_labels();
                                        }

                                        echo '<div class="shop-product2_photo">';
                                            echo '<a href="'.get_permalink().'">';
                                                if ( $size ) {
                                                    echo wp_get_attachment_image($product->get_image_id(), $size );
                                                } else {
                                                    woocommerce_template_loop_product_thumbnail();
                                                }
                                            echo '</a>';
                                        echo '</div>';

                                        echo '<div class="shop-product2_body">';

                                            echo '<div class="shop-product2_title">';
                                                echo '<a href="'.get_permalink().'">'.get_the_title().'</a>';
                                            echo '</div>';
                                            if( wc_review_ratings_enabled() && $product->get_average_rating() ){
                                                echo '<div class="shop-product2_rating">';
                                                    echo '<div class="rating">';
                                                        woocommerce_template_loop_rating();
                                                    echo '</div>';
                                                echo '</div>';
                                            }
                                            if( $product->get_price_html() ){
                                                echo '<div class="shop-product2_prices">';
                                                    woocommerce_template_loop_price();
                                                echo '</div>';
                                            }
                                            if ( defined( 'YITH_WCBR' ) && function_exists( 'naturally_product_brand' ) ) {
                                                naturally_product_brand();
                                            }
                                        echo '</div>';

                                        echo '<div class="shop-product2_actions">';
                                            do_action( 'woocommerce_after_shop_loop_item' );
                                        echo '</div>';

                                    echo '</div>';
                                echo '</div>';

                            } else {
                                remove_action( 'woocommerce_after_shop_loop_item', 'naturally_product_price', 5 );
                                $collg  = $settings['col_lg'] ? $settings['col_lg'] : '4';
                                echo '<div class="grid_col is-12 is-sm-6 is-lg-'.$collg.' '.implode(' ', $termname).'">';
                                    ob_start();
                                    wc_product_class( 'shop-product hover-shadow', $product );
                                    echo '<div '.ob_get_clean().'>';

                                        if ( function_exists( 'naturally_product_all_labels' ) ) {
                                            naturally_product_all_labels();
                                        }

                                        echo '<div class="shop-product_photo">';
                                            echo '<a href="'.get_permalink().'">';
                                                if ( $size ) {
                                                    echo wp_get_attachment_image($product->get_image_id(), $size );
                                                } else {
                                                    woocommerce_template_loop_product_thumbnail();
                                                }
                                            echo '</a>';
                                        echo '</div>';

                                        if ( defined( 'YITH_WCBR' ) && function_exists( 'naturally_product_brand' ) ) {
                                            naturally_product_brand();
                                        }

                                        echo '<div class="shop-product_content">';
                                            echo '<div class="shop-product_body">';

                                                echo '<div class="shop-product_title">';
                                                    echo '<a href="'.get_permalink().'">'.get_the_title().'</a>';
                                                echo '</div>';
                                            if( $product->get_price_html() ){
                                                echo '<div class="shop-product2_prices">';
                                                    woocommerce_template_loop_price();
                                                echo '</div>';
                                            }
                                                if( wc_review_ratings_enabled() && $product->get_average_rating() ){
                                                    echo '<div class="shop-product_rating">';
                                                        echo '<div class="rating">';
                                                            woocommerce_template_loop_rating();
                                                        echo '</div>';
                                                    echo '</div>';
                                                }
                                            echo '</div>';

                                            echo '<div class="shop-product_footer">';
                                                do_action( 'woocommerce_after_shop_loop_item' );
                                            echo '</div>';

                                        echo '</div>';

                                    echo '</div>';
                                echo '</div>';
                            }
                        }
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }
        wp_reset_postdata();
        // Not in edit mode
        if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
            <script>jQuery(document).ready(function ($) {function ntrIsotope() {var myIsotopes = $('[data-ntr-isotope]');if (myIsotopes.length) {myIsotopes.each(function (i, el) {var myIsotope = $(el);var myData = myIsotope.data('ntrIsotope');if (!myData.itemSelector) {return true;}myIsotope.imagesLoaded(function() {myIsotope.isotope({percentPosition: true,itemSelector: myData.itemSelector,layoutMode: myData.layoutMode || 'fitRows',});if ($('[data-ntr-isotope-filter]').length) {var myFilters = $('[data-ntr-isotope-filter]').filter(function (i, el) {var myFilter = $(el);var myFilterData = myFilter.data('ntrIsotopeFilter');return myFilterData.name === myData.name && myFilterData.selector;});if (myFilters.length) {myFilters.on('click', function (e) {e.preventDefault();var myFilter = $(this);var myFilterData = myFilter.data('ntrIsotopeFilter');var myFilterSelector = myFilterData.selector;var myFilterParent = myFilter.parent();myFilterParent.siblings().removeClass('is-active');myFilterParent.addClass('is-active');myIsotope.isotope({filter: myFilterSelector});});}}});});}}ntrIsotope();});</script>
            <?php
        }
    }
}
