<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Woo_Products_Grid_Two_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-woo-products-grid-two';
    }
    public function get_title() {
        return 'Woo Grid 2 (N)';
    }
    public function get_icon() {
        return 'eicon-gallery-grid';
    }
    public function get_categories() {
        return [ 'naturally-woo' ];
    }
    // Registering Controls
    protected function register_controls() {

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'post_query_section',
            [
                'label' => esc_html__( 'Query', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        // Order
        $this->add_control( 'scenario',
            [
                'label' => esc_html__( 'Select Scenario', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'featured' => esc_html__( 'Featured', 'naturally' ),
                    'on-sale' => esc_html__( 'On Sale', 'naturally' ),
                    'best' => esc_html__( 'Best Selling', 'naturally' ),
                    'custom' => esc_html__( 'Specific Categories', 'naturally' ),
                ],
                'default' => 'newest'
            ]
        );
        // Category Filter Heading
        $this->add_control( 'category_filter_heading',
            [
                'label' => esc_html__( 'Category Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        // Category Filter
        $this->add_control( 'category_filter',
            [
                'label' => esc_html__( 'Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s)',
                'condition' => [ 'scenario' => 'custom' ]
            ]
        );
        // Exclude Category
        $this->add_control( 'category_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s) to Exclude',
            ]
        );
        // Post Filter Heading
        $this->add_control( 'post_filter_heading',
            [
                'label' => esc_html__( 'Post Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        // Specific Post
        $this->add_control( 'post_filter',
            [
                'label' => esc_html__( 'Specific Post(s)', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_get_post_title('product'),
                'description' => 'Select Specific Post(s)',
                'condition' => [ 'scenario' => 'custom' ]
            ]
        );
        // Exclude Post
        $this->add_control( 'post_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Post', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_get_post_title('product'),
                'description' => 'Select Post(s) to Exclude',
                'separator' => 'after',
            ]
        );
        // Other Filter Heading
        $this->add_control( 'post_other_heading',
            [
                'label' => esc_html__( 'Other Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        // Posts Per Page
        $this->add_control( 'post_per_page',
            [
                'label' => esc_html__( 'Posts Per Page', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 1000,
                'default' => 20
            ]
        );
        // Order
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'naturally' ),
                    'DESC' => esc_html__( 'Descending', 'naturally' )
                ],
                'default' => 'ASC'
            ]
        );
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'naturally' ),
                    'menu_order' => esc_html__( 'Menu Order', 'naturally' ),
                    'rand' => esc_html__( 'Random', 'naturally' ),
                    'date' => esc_html__( 'Date', 'naturally' ),
                    'title' => esc_html__( 'Title', 'naturally' ),
                ],
                'default' => 'id',
            ]
        );
        $this->add_control( 'colxl',
            [
                'label' => esc_html__( 'Column ( Large Device )', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '12' => esc_html__( '1 Column', 'naturally' ),
                    '6' => esc_html__( '2 Column', 'naturally' ),
                    '4' => esc_html__( '3 Column', 'naturally' ),
                ],
                'default' => '6',
                'separator' => 'before'
            ]
        );
        $this->add_control( 'collg',
            [
                'label' => esc_html__( 'Column ( Desktop )', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '12' => esc_html__( '1 Column', 'naturally' ),
                    '6' => esc_html__( '2 Column', 'naturally' ),
                    '4' => esc_html__( '3 Column', 'naturally' ),
                ],
                'default' => '4'
            ]
        );
        $this->add_control( 'colsm',
            [
                'label' => esc_html__( 'Column ( Tablet )', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '12' => esc_html__( '1 Column', 'naturally' ),
                    '6' => esc_html__( '2 Column', 'naturally' ),
                    '4' => esc_html__( '3 Column', 'naturally' ),
                ],
                'default' => '6'
            ]
        );
        $this->add_control( 'colxs',
            [
                'label' => esc_html__( 'Column ( Phone )', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '12' => esc_html__( '1 Column', 'naturally' ),
                    '6' => esc_html__( '2 Column', 'naturally' )
                ],
                'default' => '12'
            ]
        );
        $this->add_control( 'gap_col',
            [
                'label' => esc_html__( 'Column Gap', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 20,
                'default' => 20,
                'selectors' => [
                    '{{WRAPPER}} .grid_row .grid_col' =>'padding-left: {{SIZE}}px;padding-right: {{SIZE}}px;margin-bottom: calc( {{SIZE}}px * 2 );',
                    '{{WRAPPER}} .grid_row' =>'margin-left: -{{SIZE}}px;margin-right: -{{SIZE}}px;margin-bottom: calc(-{{SIZE}}px * 2 );',
                ],

            ]
        );
        $this->add_group_control(
        Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'large',
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        if ( defined( 'YITH_WCBR' ) ) {
            /*****   START CONTROLS SECTION   ******/
            $this->start_controls_section( 'product_item_brands_section',
                [
                    'label' => esc_html__( 'BRANDS', 'naturally' ),
                    'tab' => Controls_Manager::TAB_CONTENT,
                ]
            );
            $this->naturally_style_typo( 'product_item_brands_typo','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_color( 'product_item_brands_color','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_bgcolor( 'product_item_brands_background','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_margin( 'product_item_brands_margin','{{WRAPPER}} .naturally-brands .badge' );
            $this->end_controls_section();
            /*****   END CONTROLS SECTION   ******/
        }
    }
    protected function render() {
        global $wp_query;
        $settings = $this->get_settings_for_display();

        $args = array(
            'post_type'      => 'product',
            'posts_per_page' => $settings['post_per_page'],
            'post__in'       => $settings['post_filter'],
            'post__not_in'   => $settings['post_exclude_filter'],
            'order'          => $settings['order']
        );

        if ( 'featured' == $settings['scenario'] ) {
           $args['tax_query'] = array(
                array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                )
            );

        } elseif('on-sale' == $settings['scenario']) {

            $args['meta_query'] = array(
                'relation' => 'OR',
                array( // Simple products type
                    'key'       => '_sale_price',
                    'value'     => 0,
                    'compare'   => '>',
                    'type'      => 'numeric'
                ),
                array( // Variable products type
                    'key'       => '_min_variation_sale_price',
                    'value'     => 0,
                    'compare'   => '>',
                    'type'      => 'numeric'
                )
            );

        } elseif('best' == $settings['scenario']) {

            $args['orderby'] = 'meta_value_num';
            $args['meta_key'] = 'total_sales';

        } else {

            $args['orderby'] = $settings['orderby'];

        }

        if ( $settings['category_filter'] ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy'  => 'product_cat',
                    'field'     => 'id',
                    'terms'     => $settings['category_filter'],
                    'operator'  => 'IN'
                )
            );
        }
        if ( $settings['category_exclude_filter'] ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy'  => 'product_cat',
                    'field'     => 'id',
                    'terms'     => $settings['category_exclude_filter'],
                    'operator'  => 'NOT IN'
                )
            );
        }
        
        $size = $settings['thumbnail_size'] ? $settings['thumbnail_size'] : 'full';
        if ( 'custom' == $size ) {
            $sizew = $settings['thumbnail_custom_dimension']['width'];
            $sizeh = $settings['thumbnail_custom_dimension']['height'];
            $size = [ $sizew, $sizeh ];
        }
        
        $col  = $settings['colxs'] ? ' is-'.$settings['colxs'] : ' is-12';
        $col .= $settings['colsm'] ? ' is-sm-'.$settings['colsm'] : ' is-sm-6';
        $col .= $settings['collg'] ? ' is-lg-'.$settings['collg'] : ' is-lg-4';
        $col .= $settings['colxl'] ? ' is-xl-'.$settings['colxl'] : ' is-xl-6';

        $the_query = new \WP_Query( $args );
        if( $the_query->have_posts() ) {
            echo '<div class="container">';
                echo '<div class="grid grid-style-three woocommerce">';
                    echo '<div class="grid_row is-30 is-md-40">';
                        while ($the_query->have_posts()) {
                            $the_query->the_post();
                            global $product;
                            remove_action( 'woocommerce_after_shop_loop_item', 'naturally_product_price', 5 );
                            remove_action( 'woocommerce_after_shop_loop_item', 'naturally_before_product_buttons', 9 );
                            remove_action( 'woocommerce_after_shop_loop_item', 'naturally_after_product_buttons', 25 );

                            $badge = get_post_meta( $product->get_id(), 'naturally_badge', true );
                            $badge_custom = get_post_meta( $product->get_id(), 'naturally_custom_badge', true );
                            $attr = get_post_meta( $product->get_id(), 'naturally_product_single_attr', true );
                            $attr_custom = get_post_meta( $product->get_id(), 'naturally_product_custom_attr', true );
                            $show_discount = get_post_meta( $product->get_id(), 'naturally_product_discount', true );

                            $custom_classes = '';
                            $custom_classes .= $badge || $badge_custom ? ' has-custom-badge' : '';
                            $custom_classes .= $attr || $attr_custom ? ' has-custom-attr' : '';
                            $custom_classes .= $show_discount == 'yes' ? ' has-custom-discount' : '';

                            $badge = $badge || $badge_custom ? 'yes' : '';
                            $attr = $attr || $attr_custom ? 'yes' : '';
                            $discount = $show_discount == 'yes' ? 'yes' : '';

                            if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                                echo '<div class="grid_col '.$col.' product-items">';
                            } else {
                                echo '<div class="grid_col '.$col.' product-items" data-aos="ntr-fade-up" data-aos-once="true">';
                            }
                                ob_start();
                                wc_product_class( 'shop-product2 hover-shadow', $product );
                                echo '<div '.ob_get_clean().'>';

                                if ( function_exists( 'naturally_product_all_labels' ) ) {
                                    naturally_product_all_labels();
                                }

                                    echo '<div class="shop-product2_photo">';
                                        echo '<a href="'.get_permalink().'">';
                                            if ( $size ) {
                                                echo wp_get_attachment_image($product->get_image_id(), $size );
                                            } else {
                                                woocommerce_template_loop_product_thumbnail();
                                            }
                                        echo '</a>';
                                    echo '</div>';

                                    echo '<div class="shop-product2_body">';

                                        echo '<div class="shop-product2_title">';
                                            echo '<a href="'.get_permalink().'">'.get_the_title().'</a>';
                                        echo '</div>';
                                        if( wc_review_ratings_enabled() && $product->get_average_rating() ){
                                            echo '<div class="shop-product2_rating">';
                                                echo '<div class="rating">';
                                                    woocommerce_template_loop_rating();
                                                echo '</div>';
                                            echo '</div>';
                                        }
                                        if( $product->get_price_html() ){
                                            echo '<div class="shop-product2_prices">';
                                                woocommerce_template_loop_price();
                                            echo '</div>';
                                        }

                                        if ( defined( 'YITH_WCBR' ) && function_exists( 'naturally_product_brand' ) ) {
                                            naturally_product_brand();
                                        }

                                    echo '</div>';

                                    echo '<div class="shop-product2_actions">';
                                        do_action( 'woocommerce_after_shop_loop_item' );
                                    echo '</div>';

                                echo '</div>';
                            echo '</div>';
                        }
                        wp_reset_postdata();
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }
    }
}
