<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Woo_Products_Grid_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-woo-products-grid';
    }
    public function get_title() {
        return 'Products Grid (N)';
    }
    public function get_icon() {
        return 'eicon-gallery-grid';
    }
    public function get_categories() {
        return [ 'naturally-woo' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'post_query_scenario_section',
            [
                'label' => esc_html__( 'Query', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'thumbnail2',
            [
                'label' => esc_html__( 'Image Dimension', 'naturally' ),
                'type' => Controls_Manager::IMAGE_DIMENSIONS,
                'description' => esc_html__( 'Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.', 'naturally' ),
                'default' => [
                    'width' => '',
                    'height' => '',
                ],
            ]
        );
        $this->add_control( 'column',
            [
                'label' => esc_html__( 'Column', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'default' => 3
            ]
        );
        // Posts Per Page
        $this->add_control( 'limit',
            [
                'label' => esc_html__( 'Posts Per Page', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => count( get_posts( array('post_type' => 'product', 'post_status' => 'publish', 'fields' => 'ids', 'posts_per_page' => '-1') ) ),
                'default' => 12
            ]
        );
        // Order
        $this->add_control( 'scenario',
            [
                'label' => esc_html__( 'Select Scenerio', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'newest' => esc_html__( 'Newest', 'naturally' ),
                    'featured' => esc_html__( 'Featured', 'naturally' ),
                    'popularity' => esc_html__( 'Popularity', 'naturally' ),
                    'best' => esc_html__( 'Best Selling', 'naturally' ),
                    'attr' => esc_html__( 'Attribute Display', 'naturally' ),
                    'custom_cat' => esc_html__( 'Specific Categories', 'naturally' ),
                ],
                'default' => 'newest'
            ]
        );
        $this->add_control( 'paginate',
            [
                'label' => esc_html__( 'Pagination', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control( 'hide_catalog',
            [
                'label' => esc_html__( 'Hide Catalog', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [ 'paginate' => 'yes' ]
            ]
        );
        $this->add_control( 'hr0',
            [
                'type' => Controls_Manager::DIVIDER,
                'condition' => [ 'scenario' => 'attr' ]
            ]
        );
        $this->add_control( 'attribute',
            [
                'label' => esc_html__( 'Select Attribute', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_woo_attributes(),
                'description' => 'Select Attribute(s)',
                'condition' => [ 'scenario' => 'attr' ]
            ]
        );
        $this->add_control( 'attr_terms',
            [
                'label' => esc_html__( 'Select Attribute Terms', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_woo_attributes_taxonomies(),
                'description' => 'Select Attribute(s)',
                'condition' => [ 'scenario' => 'attr' ]
            ]
        );
        $this->add_control( 'hr1',['type' => Controls_Manager::DIVIDER]);

        $this->add_control( 'cat_filter',
            [
                'label' => esc_html__( 'Filter Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s)',
            ]
        );
        $this->add_control( 'cat_operator',
            [
                'label' => esc_html__( 'Category Operator', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'AND' => esc_html__( 'display all of the chosen categories', 'naturally' ),
                    'IN' => esc_html__( 'display products within the chosen category', 'naturally' ),
                    'NOT IN' => esc_html__( 'display products that are not in the chosen category.', 'naturally' ),
                ],
                'default' => 'AND',
                'condition' => [ 'scenario' => 'custom_cat' ]
            ]
        );

        $this->add_control( 'hr2',['type' => Controls_Manager::DIVIDER]);

        $this->add_control( 'tag_filter',
            [
                'label' => esc_html__( 'Filter Tag(s)', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_tag','name'),
                'description' => 'Select Tag(s)',
            ]
        );
        $this->add_control( 'tag_operator',
            [
                'label' => esc_html__( 'Tags Operator', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'AND' => esc_html__( 'display all of the chosen tags', 'naturally' ),
                    'IN' => esc_html__( 'display products within the chosen tags', 'naturally' ),
                    'NOT IN' => esc_html__( 'display products that are not in the chosen tags.', 'naturally' ),
                ],
                'default' => 'AND',
            ]
        );

        $this->add_control( 'hr3',['type' => Controls_Manager::DIVIDER]);

        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'naturally' ),
                    'DESC' => esc_html__( 'Descending', 'naturally' )
                ],
                'default' => 'ASC'
            ]
        );
        // Order By
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'naturally' ),
                    'menu_order' => esc_html__( 'Menu Order', 'naturally' ),
                    'popularity' => esc_html__( 'Popularity', 'naturally' ),
                    'rand' => esc_html__( 'Random', 'naturally' ),
                    'rating' => esc_html__( 'Rating', 'naturally' ),
                    'date' => esc_html__( 'Date', 'naturally' ),
                    'title' => esc_html__( 'Title', 'naturally' ),
                ],
                'default' => 'id',
                'condition' => [ 'scenario!' => 'custom_cat' ]
            ]
        );
        // Order By
        $this->add_control( 'cat_orderby',
            [
                'label' => esc_html__( 'Order By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'naturally' ),
                    'menu_order' => esc_html__( 'Menu Order', 'naturally' ),
                    'name' => esc_html__( 'Name', 'naturally' ),
                    'slug' => esc_html__( 'Slug', 'naturally' ),
                ],
                'default' => 'id',
                'condition' => [ 'scenario' => 'custom_cat' ]
            ]
        );
        $this->add_control( 'show_cat_empty',
            [
                'label' => esc_html__( 'Show Empty Categories', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [ 'scenario' => 'custom_cat' ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        if ( defined( 'YITH_WCBR' ) ) {
            /*****   START CONTROLS SECTION   ******/
            $this->start_controls_section( 'product_item_brands_section',
                [
                    'label' => esc_html__( 'BRANDS', 'naturally' ),
                    'tab' => Controls_Manager::TAB_CONTENT,
                ]
            );
            $this->naturally_style_typo( 'product_item_brands_typo','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_color( 'product_item_brands_color','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_bgcolor( 'product_item_brands_background','{{WRAPPER}} .naturally-brands .badge' );
            $this->naturally_style_margin( 'product_item_brands_margin','{{WRAPPER}} .naturally-brands .badge' );
            $this->end_controls_section();
            /*****   END CONTROLS SECTION   ******/
        }

        /***** WOO TITLE ******/
        $this->start_controls_section( 'naturally_ititle_woo_styling',
            [
                'label' => esc_html__( 'Woo Item Title', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs( 'naturally_ititle_woo_tabs' );
        $this->start_controls_tab( 'naturally_ititle_woo_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='ititle_woo',$selector='.shop-product_title a');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_ititle_woo_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='ititle_woo_hover',$selector='.shop-product_title a:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
        /***** END WOO TITLE ******/

        /***** WOO STAR ******/
        $this->start_controls_section('naturally_star_woo_styling',
            [
                'label' => esc_html__( 'Woo Star', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control( 'naturally_star_woo_color',
           [
               'label' => esc_html__( 'Star Color', 'naturally' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .star-rating span::before' => 'color: {{VALUE}};']
           ]
       );
       $this->add_control( 'naturally_empty_star_woo_color',
          [
              'label' => esc_html__( 'Empty Star Color', 'naturally' ),
              'type' => Controls_Manager::COLOR,
              'default' => '',
              'selectors' => ['{{WRAPPER}} .woocommerce .star-rating::before' => 'color: {{VALUE}};']
          ]
      );
      $this->end_controls_section();
        /***** END WOO STAR ******/

        /***** WOO PRICE AMOUNT ******/
        $this->start_controls_section('naturally_pamount_woo_styling',
            [
                'label' => esc_html__( 'Woo Price Amount', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->naturally_style_controls(array('shadow'),$id='pamount_woo',$selector='ins .woocommerce-Price-amount');
        $this->end_controls_section();

        /***** END WOO PRICE AMOUNT ******/

        /***** WOO REDUCED PRICE AMOUNT ******/
        $this->start_controls_section('naturally_rpamount_woo_styling',
            [
                'label' => esc_html__( 'Woo Reduced Price Amount', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->naturally_style_controls(array('shadow'),$id='rpamount_woo',$selector='.woocommerce .price del,del .woocommerce-Price-amount');
        $this->end_controls_section();

        /***** END WOO REDUCED PRICE AMOUNT ******/
        /*****  END STYLE GRID   ******/

    }

    public function set_column() {
        $settings = $this->get_settings_for_display();
        return $settings['column'];
    }

    public function add_product_thumbs() {
        echo '<div class="shop-product_photo">
            <a href="'.get_permalink().'">';
                woocommerce_template_loop_product_thumbnail();
            echo '</a>
        </div>';
    }
    public function add_thumbnail_size( $size ) {
        $settings  = $this->get_settings_for_display();
        $size['width'] = $settings['thumbnail2']['width'];
        $size['height'] = $settings['thumbnail2']['height'];
        $size['crop']   = 1;
        return $size;
    }
    protected function render() {
        $settings  = $this->get_settings_for_display();
        $elementid = $this->get_id();
        add_filter('naturally_shop_column', array( $this, 'set_column' ));
        if ('yes' == $settings['hide_catalog']) {
            remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
        }
        if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
            remove_action( 'woocommerce_before_shop_loop_item_title', 'naturally_product_thumbs', 10 );
            add_action( 'woocommerce_before_shop_loop_item_title', array( $this, 'add_product_thumbs' ), 10 );
        }

        if ( !empty( $settings['thumbnail2']['width'] ) && !empty( $settings['thumbnail2']['height'] ) ) {
            add_filter( 'woocommerce_get_image_size_thumbnail', [$this, 'add_thumbnail_size'],1,10 );
        }

        $limit = 'limit="'.$settings['limit'].'"';
        $order = ' order="'.$settings['order'].'"';
        $orderby = ' orderby="'.$settings['orderby'].'"';
        $paginate = 'yes'== $settings['paginate'] ? ' paginate="true"' : '';
        $hide_empty = 'yes'== $settings['show_cat_empty'] ? ' hide_empty="0"' : '';
        $operator = ' cat_operator="'.$settings['cat_operator'].'"';
        $tag_operator = ' tag_operator="'.$settings['tag_operator'].'"';
        $cat_orderby = ' orderby="'.$settings['cat_orderby'].'"';
        $cat_filter = is_array($settings['cat_filter']) ? ' category="'.implode(', ',$settings['cat_filter']).'"' : '';
        $hide_empty_cat = 'yes'== $settings['show_cat_empty'] ? ' hide_empty="0"' : '';
        $tag_filter = is_array($settings['tag_filter']) ? ' tag="'.implode(', ',$settings['tag_filter']).'"' : '';
        $attr_filter = is_array($settings['attribute']) ? ' attribute="'.implode(', ',$settings['attribute']).'"' : '';
        $attr_terms = is_array($settings['attr_terms']) ? ' terms="'.implode(', ',$settings['attr_terms']).'"' : '';
        echo '<div class="section-custom-categories woocommerce">';
            echo '<div class="container">';
                if ('newest' == $settings['scenario']) {
                    echo do_shortcode('[products '.$limit.$orderby.$order.$tag_filter.$paginate.' visibility="visible"]');
                } elseif ('featured' == $settings['scenario']) {
                    echo do_shortcode('[products '.$limit.$orderby.$order.$tag_filter.$paginate.' visibility="featured"]');
                } elseif ('popularity' == $settings['scenario']) {
                    echo do_shortcode('[products '.$limit.$order.$tag_filter.$paginate.' orderby="popularity" on_sale="true"]');
                } elseif ('best' == $settings['scenario']) {
                    echo do_shortcode('[products '.$limit.$orderby.$order.$tag_filter.$paginate.' best_selling="true"]');
                } elseif ('custom_cat' == $settings['scenario']) {
                    echo do_shortcode('[products '.$limit.$cat_orderby.$order.$cat_filter.$operator.$hide_empty_cat.$tag_filter.$paginate.']');
                } elseif ('attr' == $settings['scenario']) {
                    echo do_shortcode('[products '.$attr_filter.$attr_terms.$limit.$orderby.$order.$paginate.']');
                } else {
                    echo do_shortcode('[products '.$limit.$orderby.$order.$tag_filter.$operator.$paginate.' visibility="visible"]');
                }
            echo '</div>';
        echo '</div>';

        if ( !empty( $settings['thumbnail2']['width'] ) && !empty( $settings['thumbnail2']['height'] ) ) {
            remove_filter( 'woocommerce_get_image_size_thumbnail', [$this, 'add_thumbnail_size'],1,10 );
        }

    }
}
