<?php

Redux::setSection('energyland_opt', array(
    'title'     => esc_html__('404 Page Settings', 'energyland'),
    'id'        => '404_0pt',
    'icon'      => 'dashicons dashicons-megaphone',
    'fields'    => array(

        array(
            'title'    => esc_html__('404 Banner Image', 'energyland'),
            'id'       => 'error_img_banner',
            'type'     => 'media',
            'compiler' => true,
            'default'  => array(
                'url'  => ENERGYLAND_DIR_IMG.'/opt/404.gif'
            ),
        ),

        array(
            'title'     => esc_html__('Heading', 'energyland'),
            'id'        => 'error_title',
            'type'      => 'text',
            'default'   => esc_html__("Page Not Found", 'energyland'),
        ),

        array(
            'title'     => esc_html__('Sub Heading', 'energyland'),
            'id'        => 'error_subtitle',
            'type'      => 'textarea',
            'default'   => esc_html__('Sorry! The page you are looking doesn’t exist or broken. Go to Homepage from the below button', 'energyland'),
        ),

        array(
            'title'     => esc_html__('Button Text', 'energyland'),
            'id'        => 'error_btn_label',
            'type'      => 'text',
            'default'   => esc_html__('Back To Home', 'energyland'),
        ),

        array(
            'id'          => 'btn_font_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Button Text Color', 'energyland' ),
            'output'      => array(
                'color' => '.content-not-found .theme-btn',
            ),
        ),

        array(
            'id'          => 'btn_bg_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Button Background Color', 'energyland' ),
            'output'      => array(
                'background' => '.content-not-found .theme-btn',
            ),
        ),

        array(
            'id'          => 'btn_border_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Button Border Color', 'energyland' ),
            'output'      => array(
                'border-color' => '.content-not-found .theme-btn',
            ),
        ),

        array(
            'id'          => 'btn_font_color_hover',
            'type'        => 'color',
            'title'       => esc_html__( 'Button Text Hover Color', 'energyland' ),
            'output'      => array(
                'color' => '.content-not-found .theme-btn:hover',
            ),
        ),

        array(
            'id'          => 'btn_bg_hover',
            'type'        => 'color',
            'title'       => esc_html__( 'Button Background Hover Color', 'energyland' ),
            'output'      => array(
                'background' => '.content-not-found .theme-btn:hover',
            ),
        ),

        array(
            'id'          => 'btn_border_hover',
            'type'        => 'color',
            'title'       => esc_html__( 'Button Border Hover Color', 'energyland' ),
            'output'      => array(
                'border-color' => '.content-not-found .theme-btn:hover',
            ),
        ),
    )
));
