<?php

Redux::setSection('energyland_opt', array(
	'title'     => esc_html__('Blog Settings', 'energyland'),
	'id'        => 'blog_page',
	'icon'      => 'dashicons dashicons-admin-post',
));


Redux::setSection('energyland_opt', array(
	'title'     => esc_html__('Title-Bar', 'energyland'),
	'id'        => 'blog_titlebar_settings',
	'icon'      => 'dashicons dashicons-admin-post',
    'subsection' => true,
	'fields'    => array(
		array(
			'title'     => esc_html__('Blog Page Title', 'energyland'),
			'subtitle'  => esc_html__('Give here the blog page title', 'energyland'),
			'desc'      => esc_html__('This text will be show on blog page banner', 'energyland'),
			'id'        => 'blog_title',
			'type'      => 'text',
			'default'   => 'News'
		),
	)
));


Redux::setSection('energyland_opt', array(
    'title'     => esc_html__('Layout Style', 'energyland'),
    'id'        => 'blog_layout_settings',
    'icon'      => 'dashicons dashicons-align-left',
    'subsection' => true,
    'fields'    => array(
        array(
            'title'     => esc_html__('Select Blog Layout Style', 'energyland'),
            'id'        => 'blog_layout_style',
            'type'      => 'image_select',
            'default'   => '1',
            'options'   => array(
                '1' => array(
                    'alt' => esc_html__('Right Sidebar - Default', 'energyland'),
                    'img' => esc_url(ENERGYLAND_DIR_IMG.'/opt/right-sidebar.png')
                ),
                '2' => array(
                    'alt' => esc_html__('Left Sidebar', 'energyland'),
                    'img' => esc_url(ENERGYLAND_DIR_IMG.'/opt/left-sidebar.png')
                ),
            )
        ),

    )
));


Redux::setSection('energyland_opt', array(
	'title'     => esc_html__('Blog Single', 'energyland'),
	'id'        => 'blog_single_opt',
	'icon'      => 'dashicons dashicons-media-document',
	'subsection' => true,
	'fields'    => array(
        array(
			'title'     => esc_html__( 'Post Meta', 'energyland' ),
			'subtitle'  => esc_html__( 'Show/hide post meta on blog archive page', 'energyland' ),
			'id'        => 'is_post_meta',
			'type'      => 'switch',
            'on'        => esc_html__( 'Show', 'energyland' ),
            'off'       => esc_html__( 'Hide', 'energyland' ),
            'default'   => '1',
		),
	)
));

// blog Share Options
Redux::setSection('energyland_opt', array(
    'title'     => esc_html__('Blog Social Share', 'energyland'),
    'id'        => 'blog_share_opt',
    'subsection'=> true,
    'icon'      => 'dashicons dashicons-share',
    'fields'    => array(

        array(
            'title'     => esc_html__( 'Social Share', 'energyland' ),
            'id'        => 'is_social_share',
            'type'      => 'switch',
            'on'        => esc_html__( 'Enabled', 'energyland' ),
            'off'       => esc_html__( 'Disabled', 'energyland' ),
            'default'   => '0'
        ),

        array(
            'id' => 'blog_share_start',
            'type' => 'section',
            'title' => __('Share Options', 'energyland'),
            'subtitle' => __('Enable/Disable social media share options as you want.', 'energyland'),
            'required' => array('is_social_share','=','1'),
            'indent' => true,
        ),

        array(
            'title'    => esc_html__('Title', 'energyland'),
            'id'       => 'share_heading',
            'type'     => 'text',
            'compiler' => true,
            'default'  => esc_html__('Share on', 'energyland'),
        ),

        array(
            'id'       => 'is_post_fb',
            'type'     => 'switch',
            'title'    => esc_html__('Facebook', 'energyland'),
            'default'  => true,
            'on'       => esc_html__('Show', 'energyland'),
            'off'      => esc_html__('Hide', 'energyland'),
        ),

        array(
            'id'       => 'is_post_twitter',
            'type'     => 'switch',
            'title'    => esc_html__('Twitter', 'energyland'),
            'default'  => true,
            'on'       => esc_html__('Show', 'energyland'),
            'off'      => esc_html__('Hide', 'energyland'),
        ),

        array(
            'id'       => 'is_post_linkedin',
            'type'     => 'switch',
            'title'    => esc_html__('Linkedin', 'energyland'),
            'on'       => esc_html__('Show', 'energyland'),
            'off'      => esc_html__('Hide', 'energyland'),
            'default'  => true,
        ),

        array(
            'id'       => 'is_post_pinterest',
            'type'     => 'switch',
            'title'    => esc_html__('Pinterest', 'energyland'),
            'default'  => true,
            'on'       => esc_html__('Show', 'energyland'),
            'off'      => esc_html__('Hide', 'energyland'),
        ),

        array(
            'id'     => 'post_share_end',
            'type'   => 'section',
            'indent' => false,
        ),
    )
));


