<?php

// Footer settings
Redux::setSection('energyland_opt', array(
	'title'     => esc_html__('Footer', 'energyland'),
	'id'        => 'energyland_footer',
	'icon'      => 'dashicons dashicons-table-row-before',
));


// ScrollUp settings
Redux::setSection('energyland_opt', array(
	'title'     => esc_html__('Scroll Up', 'energyland'),
	'id'        => 'energyland_scrollup',
	'icon'      => 'el el-arrow-up',
	'subsection'=> true,
	'fields'    => array(   

        array(
            'title'     => esc_html__('Scroll Up Icon Color', 'energyland'),
            'id'        => 'scroll_icon_color',
            'type'      => 'color',
            'output'    => '.scroll-up',
        ),

        array(
            'title'     => esc_html__('Scroll Up Background Color', 'energyland'),
            'id'        => 'scroll_bg_color',
            'type'      => 'color',
        ),
        
        array(
            'title'     => esc_html__('Scroll Up Hover Icon Color', 'energyland'),
            'id'        => 'scroll_hover_icon_color',
            'type'      => 'color',
            'output'    => '.scroll-up:hover',
        ),

        array(
            'title'     => esc_html__('Scroll Up Hover Background Color', 'energyland'),
            'id'        => 'scroll_hover_bg_color',
            'type'      => 'color',
        ),

	)
));

// Footer settings
Redux::setSection('energyland_opt', array(
	'title'     => esc_html__('Footer Top Settings', 'energyland'),
	'id'        => 'energyland_footer_widgets_opt',
	'icon'      => 'dashicons dashicons-editor-kitchensink',
	'subsection'=> true,
	'fields'    => array(

        array(
            'title'     => esc_html__( 'Footer Column', 'energyland' ),
            'id'        => 'footer_column',
            'type'      => 'select',
            'default'   => '3',
            'options'   => array(
                '6' => esc_html__( 'Two Column', 'energyland' ),
                '4' => esc_html__( 'Three Column', 'energyland' ),
                '3' => esc_html__( 'Four Column', 'energyland' ),
            )
        ),

        array(
            'id'     => 'divider_three',
            'type'   => 'divide',
        ),

        array(
            'title'     => esc_html__('Widget Title Color', 'energyland'),
            'id'        => 'widget_title_color',
            'type'      => 'color',
        ),

        array(
            'title'     => esc_html__('Footer Text Color', 'energyland'),
            'id'        => 'footer_text_color',
            'type'      => 'color',
            'output'    => 'footer .single-footer-wid ul li a, .widget .textwidget p, footer span, footer p',
        ),

        array(
            'id'     => 'divider_six',
            'type'   => 'divide',
        ),

        array(
            'title'     => esc_html__('Footer Background Color', 'energyland'),
            'id'        => 'footer_bg_color',
            'type'      => 'color',
        ),
        
        array(
            'title'    => esc_html__('Footer Background Image', 'energyland'),
            'id'       => 'footer_bg_img',
            'type'     => 'media',
            'compiler' => true,
        ),

	)
));

// Footer settings
Redux::setSection('energyland_opt', array(
	'title'     => esc_html__('Footer Bottom', 'energyland'),
	'id'        => 'energyland_footer_style_opt',
	'icon'      => 'dashicons dashicons-editor-kitchensink',
	'subsection'=> true,
	'fields'    => array(

        array(
			'title'     => esc_html__('Footer Copyright', 'energyland'),
			'desc'      => esc_html__('write down your own copyright info.', 'energyland'),
			'id'        => 'footer_copyright_content',
			'type'      => 'editor',
			'default'   => '<p>&copy; <b>energyland</b> - 2022. All rights reserved.</p>'
		),

        array(
            'title'     => esc_html__('Footer Text Color', 'energyland'),
            'id'        => 'footer_text_color',
            'type'      => 'color',
            'output'    => 'footer .footer-bottom p',
        ),

        array(
            'title'     => esc_html__('Footer Link Color', 'energyland'),
            'id'        => 'footer_link_color',
            'type'      => 'color',
            'output'    => 'footer .footer-bottom a',
        ),

        array(
            'title'     => esc_html__('Footer Bottom Bar Background', 'energyland'),
            'id'        => 'footer_bottom_bg_color',
            'type'      => 'color',
        ),

	)
));
