<?php
// Header Section
Redux::setSection('energyland_opt', array(
    'title'            => esc_html__( 'Header Settings', 'energyland' ),
    'id'               => 'header_sec',
    'customizer_width' => '400px',
    'icon'             => 'el el-home',
    'fields'           => array(

        array (
            'title'     => esc_html__( 'Header Style', 'energyland' ),
            'subtitle'  => esc_html__( 'Select your header style from this three design.', 'energyland' ),
            'id'        => 'header_style',
            'type'      => 'image_select',
            'default'   => '1',
            'options'   => array (
                '1' => array (
                    'alt' => esc_html__( 'Header One', 'energyland' ),
                    'img' => esc_url( ENERGYLAND_DIR_IMG.'/opt/header1.png' ),
                ),
                '2' => array (
                    'alt' => esc_html__( 'Header Two', 'energyland' ),
                    'img' => esc_url( ENERGYLAND_DIR_IMG.'/opt/header2.png' ),
                ),
                '4' => array (
                    'alt' => esc_html__( 'Header Three', 'energyland' ),
                    'img' => esc_url( ENERGYLAND_DIR_IMG.'/opt/header3.png' ),
                ),
            )
        ),

        array(
            'title'     => esc_html__('Top Header Bar', 'energyland'),
            'subtitle'  => esc_html__( 'are you want show top bar ?', 'energyland' ),
            'id'        => 'top_header_opt',
            'type'      => 'switch',
            'default'  => false,
            'on'       => esc_html__('Show', 'energyland'),
            'off'      => esc_html__('Hide', 'energyland'),
        ),
        array(
            'id'      => 'top_divider_1',
            'type'    => 'divide',
            'required'    => array('top_header_opt', '!=', 'false' ),
        ),

        array(
            'title'     => esc_html__('Phone Number', 'energyland'),
            'subtitle'  => esc_html__( 'Type phone number.', 'energyland' ),
            'id'        => 'phone_number',
            'type'      => 'text',
            'required'    => array('top_header_opt', '!=', 'false' ),
            'default'   => '987-098-098-09',
        ),

        array(
            'title'     => esc_html__('Email Address', 'energyland'),
            'subtitle'  => esc_html__( 'Type email address.', 'energyland' ),
            'id'        => 'email_address',
            'type'      => 'text',
            'required'    => array('top_header_opt', '!=', 'false' ),
            'default'   => 'info@example.com',
        ),

        array(
            'title'     => esc_html__('Office Address - Location', 'energyland'),
            'subtitle'  => esc_html__( 'Type phone number.', 'energyland' ),
            'id'        => 'office_address',
            'type'      => 'text',
            'required'    => array('top_header_opt', '!=', 'false' ),
            'default'   => 'Solar Energy, LD 32614, UK',
        ),

        array(
            'title'     => esc_html__('Office Time Hours', 'energyland'),
            'subtitle'  => esc_html__( 'Enter Days & Time.', 'energyland' ),
            'id'        => 'office_hours',
            'type'      => 'text',
            'required'    => array('top_header_opt', '!=', 'false' ),
            'default'   => 'Mon-Fri 8am-5pm',
        ),

        array(
            'title'     => esc_html__('Welcome Text', 'energyland'),
            'subtitle'  => esc_html__( 'Type your top bar welcome heading.', 'energyland' ),
            'id'        => 'welcome_text',
            'type'      => 'textarea',
            'required'    => array('top_header_opt', '!=', 'false' ),
            'default'   => 'Welcome to Energyland Solar Energy & Wind Services Company',
            'args'   => array(
                'teeny'            => true,
                'textarea_rows'    => 10
            ),
        ),

        array(
            'id'      => 'top_divider_3',
            'type'    => 'divide',
        ),

    )
) );

// Logo
Redux::setSection('energyland_opt', array(
    'title'            => esc_html__( 'Logo', 'energyland' ),
    'id'               => 'logo_setting',
    'subsection'       => true,
    'icon'             => 'el el-upload',
    'fields'           => array(

        array(
            'title'     => esc_html__('Select Your Logo Type', 'energyland'),
            'subtitle'  => esc_html__( 'which type logo you want for your site ?', 'energyland' ),
            'id'        => 'logo_select',
            'type'      => 'select',
            'options'  => array(
                '1' => 'Text',
                '2' => 'Image',
            ),
            'default'  => '2',
        ),

        array(
            'title'     => esc_html__('Text Logo', 'energyland'),
            'subtitle'  => esc_html__( 'Type your logo text , it is a text logo.', 'energyland' ),
            'id'        => 'main_text_logo',
            'type'      => 'text',
            'default'   => 'energyland',
            'required'  => array( 
                array('logo_select','equals','1')
            ),
        ),

        array(
            'title'     => esc_html__('Logo Text Color', 'energyland'),
            'subtitle'  => esc_html__('Select Logo color', 'energyland'),
            'id'        => 'logo_text_color',
            'type'      => 'color',
            'required'  => array( 
                array('logo_select','equals','1')
            ),
        ),

        array(
            'title'     => esc_html__('Main Logo Upload', 'energyland'),
            'subtitle'  => esc_html__( 'Upload here a image file for your logo', 'energyland' ),
            'id'        => 'main_logo',
            'type'      => 'media',
            'compiler'  => true,
            'required'  => array( 
                array('logo_select','equals','2')
            ),
            'default'   => array(
                'url'   => ENERGYLAND_DIR_IMG.'/logo.svg'
            ),
        ),

        array(
            'title'     => esc_html__( 'Logo dimensions', 'energyland' ),
            'subtitle'  => esc_html__( 'Set a custom height width for your upload logo.', 'energyland' ),
            'id'        => 'logo_dimensions',
            'required'  => array( 
                array('logo_select','equals','2')
            ),            
            'type'      => 'dimensions',
            'units'     => array( 'em','px','%' ),
            'output'    => '.logo > img'
        ),

    )
) );

// banner Section
Redux::setSection('energyland_opt', array(
    'title'            => esc_html__( 'Banner', 'energyland' ),
    'id'               => 'banner_sec',
    'subsection'       => true,
    'icon'             => 'el el-picture',
    'fields'           => array(

        array(
            'id'      => 'is_breadcrumb',
            'type'    => 'switch',
            'title'   => esc_html__( 'Breadcrumb Option', 'energyland' ),
            'on'      => esc_html__('Show', 'energyland'),
            'off'     => esc_html__('Hide', 'energyland'),
            'default' => false,
        ),

        array(
            'title'     => esc_html__( 'Banner Image Type', 'energyland' ),
            'id'        => 'is_banner_img',
            'type'      => 'switch',
            'on'        => esc_html__( 'Show', 'energyland' ),
            'off'       => esc_html__( 'Hide', 'energyland' ),
            'default'   => '1'
        ),

        array(
            'id' => 'banner_opt_start',
            'type' => 'section',
            'title' => __('Banner Options', 'energyland'),
            'subtitle' => __('Enable/Disable Header Banner Options as you want.', 'energyland'),
            'required' => array('is_banner_img','=','1'),
            'indent' => true,
        ),

        array(
            'title'     => esc_html__('Header Banner Image Upload', 'energyland'),
            'subtitle'  => esc_html__( 'Upload here a jpg/png file for header background image.', 'energyland' ),
            'id'        => 'header_banner_img',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => ENERGYLAND_DIR_IMG.'/page-banner.jpg'
            ),
        ),

        array(
            'title'     => esc_html__('Banner Overlay Color', 'energyland'),
            'id'        => 'banner_overlay_color',
            'type'      => 'color',
        ),

        array(
            'id' => 'banner_overlay_color_opacity',
            'type' => 'slider',
            'title' => esc_html__('Banner Overlay Color Opacity', 'energyland'),
            "min" => 0,
            "step" => .1,
            "max" => 1,
            'resolution' => 0.1,
            'display_value' => 'label'
        ),

        array(
            'id'     => 'banner_opt_end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id' => 'banner_opt_color_start',
            'type' => 'section',
            'title' => __('Banner Color', 'energyland'),
            'required' => array('is_banner_img','=','0'),
            'indent' => true,
        ),

        array(
            'title'     => esc_html__('Banner Color', 'energyland'),
            'subtitle'  => esc_html__( 'Choice your solid banner color', 'energyland' ),
            'id'        => 'banner_color',
            'type'      => 'color'
        ),

        array(
            'id'     => 'banner_opt_color_end',
            'type'   => 'section',
            'indent' => false,
        ),

    )
) );

// Navbar styling
Redux::setSection('energyland_opt', array(
    'title'            => esc_html__( 'Navbar', 'energyland' ),
    'id'               => 'navbar_styling',
    'subsection'       => true,
    'icon'             => 'el el-lines',
    'fields'           => array(

        array(
            'title'     => esc_html__('Menu Item Color', 'energyland'),
            'subtitle'  => esc_html__('Menu item Text color', 'energyland'),
            'id'        => 'menu_text_color',
            'type'      => 'color',
        ),

        array(
            'title'     => esc_html__('Menu Item Hover Color', 'energyland'),
            'subtitle'  => esc_html__('Menu item Text color', 'energyland'),
            'id'        => 'menu_hover_text_color',
            'type'      => 'color',
        ),

        array(
            'title'     => esc_html__('Menu Active Color', 'energyland'),
            'subtitle'  => esc_html__('Menu item active and hover text color', 'energyland'),
            'id'        => 'menu_active_text_color',
            'type'      => 'color',
        ),

        array(
            'title'     => esc_html__('Sub Menu Background Color', 'energyland'),
            'id'        => 'sub_menu_bg_color',
            'type'      => 'color',
        ),

        array(
            'title'     => esc_html__('Menu Item Margin', 'energyland'),
            'subtitle'  => esc_html__('Margin around menu item (li).', 'energyland'),
            'id'        => 'menu_item_margin',
            'type'      => 'spacing',
            'mode'      => 'margin',
            'units'     => array( 'em', 'px' ),
        ),

    )
));

// Menu action button
Redux::setSection('energyland_opt', array(
    'title'            => esc_html__( 'Action Button', 'energyland' ),
    'id'               => 'cta_btn_opt',
    'subsection'       => true,
    'icon'             => 'el el-link',
    'fields'           => array(
        
        array(
            'title'     => esc_html__('Button Visibility', 'energyland'),
            'id'        => 'is_menu_btn',
            'type'      => 'switch',
            'on'        => esc_html__('Show', 'energyland'),
            'off'       => esc_html__('Hide', 'energyland'),
        ),

        array(
            'title'     => esc_html__('Button Label', 'energyland'),
            'subtitle'  => esc_html__('Leave the button label field empty to hide the button.', 'energyland'),
            'id'        => 'menu_btn_label',
            'type'      => 'text',
            'default'   => esc_html__('Get A Quote', 'energyland'),
            'required'  => array('is_menu_btn', '=', '1')
        ),

        array(
            'title'     => esc_html__('Button URL', 'energyland'),
            'id'        => 'menu_btn_url',
            'type'      => 'text',
            'default'   => '#',
            'required'  => array('is_menu_btn', '=', '1')
        ),

        array(
            'title'     => esc_html__('Font Size', 'energyland'),
            'id'        => 'menu_btn_size',
            'type'      => 'spinner',
            'default'   => '14',
            'min'       => '12',
            'step'      => '1',
            'max'       => '50',
            'required'  => array('is_menu_btn', '=', '1')
        ),

        array(
            'title'     => esc_html__('Button Colors', 'energyland'),
            'subtitle'  => esc_html__('Button style attributes on normal', 'energyland'),
            'id'        => 'button_colors',
            'type'      => 'section',
            'indent'    => true,
            'required'  => array('is_menu_btn', '=', '1')
        ),

        array(
            'title'     => esc_html__('Text color', 'energyland'),
            'id'        => 'menu_btn_font_color',
            'type'      => 'color',
            'output'    => array('header .header-promo-btn a, header.header-1 .top-bar .d-btn'),
            'required'  => array('is_menu_btn', '=', '1')
        ),
            
        array(
            'title'     => esc_html__('Background Color', 'energyland'),
            'id'        => 'menu_btn_bg_color',
            'type'      => 'color',
            'mode'      => 'background',
            'output'    => array('header .header-promo-btn a, header.header-1 .top-bar .d-btn'),
            'required'  => array('is_menu_btn', '=', '1')
        ),

        // Button color on hover stats
        array(
            'title'     => esc_html__('Hover Text Color', 'energyland'),
            'subtitle'  => esc_html__('Text color on hover stats.', 'energyland'),
            'id'        => 'menu_btn_hover_font_color',
            'type'      => 'color',
            'output'    => array('header .header-promo-btn a:hover, header.header-1 .top-bar .d-btn:hover'),
            'required'  => array('is_menu_btn', '=', '1')
        ),

        array(
            'title'     => esc_html__('Hover Background Color', 'energyland'),
            'subtitle'  => esc_html__('Background color on hover stats.', 'energyland'),
            'id'        => 'menu_btn_hover_bg_color',
            'type'      => 'color',
            'output'    => array(
                'background' => 'header.header-1 .top-bar .d-btn:hover, header .header-promo-btn a:hover',
            ),
            'required'  => array('is_menu_btn', '=', '1')
        ),

        array(
            'id'     => 'button_colors-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'title'     => esc_html__('Button Padding', 'energyland'),
            'subtitle'  => esc_html__('Padding around the menu donate button.', 'energyland'),
            'id'        => 'menu_btn_padding',
            'type'      => 'spacing',
            'output'    => array( 'header .header-promo-btn a, header.header-1 .top-bar .d-btn' ),
            'mode'      => 'padding',
            'units'     => array( 'em', 'px', '%' ), 
            'units_extended' => 'true',
            'required'  => array('is_menu_btn', '=', '1')
        ),
    )
));