(function($) {
    "use strict";

		
		
		/*--------------------------------------------
            Search Popup
        ---------------------------------------------*/
        var bodyOvrelay =  $('#body-overlay');
        var searchPopup = $('#search-popup');

        $(document).on('click','#body-overlay',function(e){
            e.preventDefault();
        bodyOvrelay.removeClass('active');
            searchPopup.removeClass('active');
        });
        $(document).on('click','.search-box-btn',function(e){
            e.preventDefault();
            searchPopup.addClass('active');
        bodyOvrelay.addClass('active');
        });	
		
		
		/* ----------------------------------------------------------- */
		/*  Back to top
		/* ----------------------------------------------------------- */

		$(window).scroll(function () {
			if ($(this).scrollTop() > 300) {
				 $('.backto').fadeIn();
			} else {
				 $('.backto').fadeOut();
			}
		});

		// scroll body to 0px on click
		$('.backto').on('click', function () {
			 $('.backto').tooltip('hide');
			 $('body,html').animate({
				  scrollTop: 0
			 }, 800);
			 return false;
		});
		
		
		jQuery('.mainmenu ul.menu').slicknav({
            allowParentLinks: true,
			prependTo: '.errin-responsive-menu',
			closedSymbol: "&#8594",
			openedSymbol: "&#8595",
        });
		
		jQuery(window).load(function() {
			jQuery("#preloader").fadeOut();
		});
		

	/* ----------------------------------------------------------- */
		/*  Sticky Header
	/* ----------------------------------------------------------- */

	$(window).on('scroll', function(event) {
        var scroll = $(window).scrollTop();
        if (scroll < 100) {
            $(".stick-top").removeClass("sticky");
        } else {
            $(".stick-top").addClass("sticky");
        }
    });
    document.addEventListener('DOMContentLoaded', function() {
        const toggleButtons = document.querySelectorAll('.theme-toggle');
        const currentTheme = localStorage.getItem('theme');

        toggleButtons.forEach(function(toggleButton) {
            const sunIcon = toggleButton.querySelector('.theme-toggle-sun');
            const moonIcon = toggleButton.querySelector('.theme-toggle-moon');

            if (currentTheme === 'errin_dark-mode') {
                document.body.classList.add('errin_dark-mode');
                sunIcon.style.display = 'none';
                moonIcon.style.display = 'inline';
            }

            toggleButton.addEventListener('click', function() {
                document.body.classList.toggle('errin_dark-mode');

                if (document.body.classList.contains('errin_dark-mode')) {
                    localStorage.setItem('theme', 'errin_dark-mode');
                    sunIcon.style.display = 'none';
                    moonIcon.style.display = 'inline';
                } else {
                    localStorage.setItem('theme', 'light-mode');
                    sunIcon.style.display = 'inline';
                    moonIcon.style.display = 'none';
                }
            });
        });
    });

    /* ----------------------------------------------------------- */
    /*  PLAYER MOUSE HOVER PLAY / PAUSE + CLICK TOGGLE
    /* ----------------------------------------------------------- */
function initPlyrVideos(scope) {

        function bindHoverClick(player, element, hoverEnabled){
            let wasPlaying = false;

            if(hoverEnabled){
                element.addEventListener('mouseenter', () => {
                    wasPlaying = player.playing;
                    player.play();
                });
                element.addEventListener('mouseleave', () => {
                    if(!wasPlaying) player.pause();
                });
            }

            element.addEventListener('click', (e) => {
                e.stopPropagation();
                player.togglePlay();
            });
        }

        $(scope).find('.youtube-player, .vimeo-player, .html5-player').each(function(){
            const hoverEnabled = this.dataset.hoverPlay === 'true';
            let player;

            if($(this).hasClass('html5-player')){
                player = new Plyr(this, { clickToPlay: false });
                bindHoverClick(player, player.elements.container, hoverEnabled);
            } else {
                player = new Plyr(this, { clickToPlay: false });
                bindHoverClick(player, this, hoverEnabled);
            }
        });
    }

    // Normal page load
    $(document).ready(() => initPlyrVideos(document));

    // Elementor widget load
    if(typeof elementorFrontend !== 'undefined'){
        elementorFrontend.hooks.addAction('frontend/element_ready/global', function(scope){
            initPlyrVideos(scope);
        });
    }


    // Audio

    document.addEventListener('DOMContentLoaded', function() {

        document.querySelectorAll('.player-container').forEach(wrapper => {
            const audioElement = wrapper.querySelector('audio');
            const coverArt = wrapper.querySelector('.cover-art');
            const trackTitle = wrapper.querySelector('.track-info h2'); // ID না, class/element path ব্যবহার
            const trackArtist = wrapper.querySelector('.track-info p'); // ID না
            const playlistItems = wrapper.querySelectorAll('.playlist-item');

            if (!audioElement) return;

            const player = new Plyr(audioElement, {
                controls: ['play','progress','current-time','mute','volume','settings','fullscreen'],
                hideControls: false
            });
            audioElement.controls = false;

            function playTrack(item) {
                const audioSrc = item.dataset.audio;
                const coverSrc = item.dataset.image;
                const titleEl = item.querySelector('.track-title') || item.childNodes[0]; // মূল title
                const artistEl = item.querySelector('.artist');
                const title = titleEl ? titleEl.textContent.trim() : 'Unknown Title';
                const artist = artistEl ? artistEl.textContent.trim() : 'Unknown Artist';

                // Update UI
                if(trackTitle) trackTitle.textContent = title;
                if(trackArtist) trackArtist.textContent = artist;
                if(coverArt) coverArt.src = coverSrc;

                // Update active state
                playlistItems.forEach(i => i.classList.remove('playing'));
                item.classList.add('playing');

                // Update Plyr source
                player.source = {
                    type: 'audio',
                    title: title,
                    sources: [{ src: audioSrc, type: 'audio/mpeg' }]
                };
            }

            // Playlist click
            playlistItems.forEach(item => {
                item.addEventListener('click', () => {
                    playTrack(item);
                    player.play().catch(err => console.log(err));
                });
            });

            // Track ended
            player.on('ended', () => {
                const currentItem = wrapper.querySelector('.playlist-item.playing');
                if (currentItem) {
                    const nextIndex = (parseInt(currentItem.dataset.id) + 1) % playlistItems.length;
                    playTrack(playlistItems[nextIndex]);
                    player.play().catch(err => console.log(err));
                }
            });

            // Initialize first track UI only (no autoplay)
            const firstItem = wrapper.querySelector('.playlist-item');
            if (firstItem) playTrack(firstItem);
        });


    });



        // Social share popup

        function initErrinShare(scope) {
        const $modal = $(scope).find('#errin-share-modal');
        const $shareBtn = $(scope).find('#errin-share-btn');
        const $closeBtn = $(scope).find('.errin-close');

        // Open modal
        $shareBtn.off('click').on('click', function (e) {
            e.preventDefault();
            $modal.fadeIn(200);
        });

        // Close modal on close button
        $closeBtn.off('click').on('click', function () {
            $modal.fadeOut(200);
        });

        // Close modal when clicking outside
        $(window).off('click.errinModal').on('click.errinModal', function (e) {
            if ($(e.target).is($modal)) {
                $modal.fadeOut(200);
            }
        });

        // Social share links
        $(scope).find('.errin-share-link').off('click').on('click', function (e) {
            e.preventDefault();

            const network = $(this).data('network');
            const pageUrl = encodeURIComponent(window.location.href);
            const pageTitle = encodeURIComponent(document.title);
            let shareUrl = '';

            switch (network) {
                case 'facebook':
                    shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${pageUrl}`;
                    break;
                case 'twitter':
                    shareUrl = `https://twitter.com/intent/tweet?url=${pageUrl}&text=${pageTitle}`;
                    break;
                case 'linkedin':
                    shareUrl = `https://www.linkedin.com/sharing/share-offsite/?url=${pageUrl}`;
                    break;
                case 'whatsapp':
                    shareUrl = `https://api.whatsapp.com/send?text=${pageTitle}%20${pageUrl}`;
                    break;
            }

            // Popup size
            const width = 600;
            const height = 500;
            const left = (window.innerWidth / 2) - (width / 2);
            const top = (window.innerHeight / 2) - (height / 2);

            const popup = window.open(
                shareUrl,
                'errinSharePopup',
                `width=${width},height=${height},top=${top},left=${left},` +
                'scrollbars=yes,resizable=yes,toolbar=no,location=no,status=no,menubar=no'
            );

            if (popup) popup.focus();

            $modal.fadeOut(200);
        });
    }

    // Normal page load
    $(document).ready(function () {
        initErrinShare(document);
    });

    // Elementor frontend init
    if (typeof elementorFrontend !== 'undefined') {
        elementorFrontend.hooks.addAction('frontend/element_ready/global', function (scope) {
            initErrinShare(scope);
        });
    }

})(jQuery);


jQuery(document).ready(function ($) {
   
});
