class VamtamButton extends elementorModules.frontend.handlers.Base {

	onInit( ...args ) {
		super.onInit( ...args );
		this.handleBtnHoverAnim();
	}

	handleBtnHoverAnim() {
		if ( ! this.$element.hasClass( 'vamtam-has-hover-anim' ) ) {
			return;
		}

		const $btnTxtEl = this.$element.find( '.elementor-button-text' );
		if ( $btnTxtEl.length ) {
			const $spanWrap = jQuery(' <span> ').addClass( 'vamtam-btn-text-wrap' );
			$spanWrap.appendTo( $btnTxtEl.parent() )
			$btnTxtEl.appendTo( $spanWrap );
			$btnTxtEl.clone().appendTo( $spanWrap ).addClass( 'vamtam-btn-text-abs' );
			$btnTxtEl.addClass( 'vamtam-btn-text' );
		}
	}
}


jQuery( window ).on( 'elementor/frontend/init', () => {
	if ( !elementorFrontend.elementsHandler || !elementorFrontend.elementsHandler.attachHandler ) {
		const addHandler = ( $element ) => {
			elementorFrontend.elementsHandler.addHandler( VamtamButton, {
				$element,
			} );
		};

		elementorFrontend.hooks.addAction( 'frontend/element_ready/button.default', addHandler, 100 );
	} else {
		elementorFrontend.elementsHandler.attachHandler( 'button', VamtamButton );
	}
} );
