class VamtamPostComments extends elementorModules.frontend.handlers.Base {

	onInit( ...args ) {
		super.onInit( ...args );
		this.handleBtnHoverAnim();
	}

	handleBtnHoverAnim() {
		if ( ! this.$element.is( '[data-widget_type="post-comments.theme_comments"]' ) ) {
			return;
		}

		// Reply btns.
		const $replyBtnsTxtEls = this.$element.find( 'a.comment-reply-link .btext' );
		if ( $replyBtnsTxtEls.length ) {
			$replyBtnsTxtEls.each( ( index, btnTxtEl ) => {
				const $btnTxtEl = jQuery( btnTxtEl );
				const $spanWrap = jQuery(' <span> ').addClass( 'vamtam-btn-text-wrap' );
				$spanWrap.appendTo( $btnTxtEl.parent() )
				$btnTxtEl.appendTo( $spanWrap );
				$btnTxtEl.clone().appendTo( $spanWrap ).addClass( 'vamtam-btn-text-abs' );
				$btnTxtEl.addClass( 'vamtam-btn-text' );
			} );
		}

		// Submit btn.
		const $submitInput = this.$element.find( '#submit' );

		// Submit btn.
		// We hide (from css) the submit input and create a submit button that can support the hover animation.
		if ( $submitInput.length ) {
			const submitText = $submitInput.val();

			const $submitBtn = jQuery( `
				<button class="elementor-button elementor-size-sm" type="submit">
					<span class="elementor-button-content-wrapper">
						<span class="vamtam-btn-text-wrap">
							<span class="elementor-button-text vamtam-btn-text">${submitText}</span>
							<span class="elementor-button-text vamtam-btn-text-abs">${submitText}</span>
						</span>
					</span>
				</button>
			` );

			$submitBtn.insertAfter( $submitInput );
		}
	}
}


jQuery( window ).on( 'elementor/frontend/init', () => {
	if ( !elementorFrontend.elementsHandler || !elementorFrontend.elementsHandler.attachHandler ) {
		const addHandler = ( $element ) => {
			elementorFrontend.elementsHandler.addHandler( VamtamPostComments, {
				$element,
			} );
		};

		elementorFrontend.hooks.addAction( 'frontend/element_ready/post-comments.theme_comments', addHandler, 100 );
	} else {
		elementorFrontend.elementsHandler.attachHandler( 'post-comments', VamtamPostComments, 'theme_comments' );
	}
} );
