<?php
namespace VamtamElementor\Widgets\Button;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Theme preferences.
if ( ! \Vamtam_Elementor_Utils::is_widget_mod_active( 'button' ) ) {
	return;
}

if ( vamtam_theme_supports( 'button--icon-vertical-pos' ) ) {
	function update_icon_align_control( $controls_manager, $widget ) {
		\Vamtam_Elementor_Utils::add_control_options( $controls_manager, $widget, 'icon_align', [
			'options' => [
				'column' => [
					'title' => esc_html__( 'Over', 'vamtam-elementor-integration' ),
					'icon' => "eicon-v-align-top",
				],
				'column-reverse' => [
					'title' => esc_html__( 'Under', 'vamtam-elementor-integration' ),
					'icon' => "eicon-v-align-bottom",
				],
			],
			'selectors_dictionary' => [
				'over' => 'column',
				'under' => 'column-reverse',
			],
			'prefix_class' => 'layout-',
		] );

		\Vamtam_Elementor_Utils::add_control_options( $controls_manager, $widget, 'content_align', [
			'selectors' => [
				'{{WRAPPER}} .elementor-button .elementor-button-content-wrapper' => '--vamtam-content-align: {{VALUE}};',
			]
		] );
	}
	function update_content_align_control( $controls_manager, $widget ) {
		\Vamtam_Elementor_Utils::add_control_options( $controls_manager, $widget, 'content_align', [
			'selectors' => [
				'{{WRAPPER}} .elementor-button .elementor-button-content-wrapper' => '--vamtam-content-align: {{VALUE}};',
			]
		] );
	}
	// Content - Button section
	function section_button_content_before_section_end( $widget, $args ) {
		$controls_manager = \Elementor\Plugin::instance()->controls_manager;
		update_icon_align_control( $controls_manager, $widget );
	}
	add_action( 'elementor/element/button/section_button/before_section_end', __NAMESPACE__ . '\section_button_content_before_section_end', 10, 2 );
}

if ( vamtam_theme_supports( 'button--hover-anim' ) ) {
	function add_button_style_section_controls( $controls_manager, $widget ) {
		// Use Theme Animation
		$widget->add_control(
			'vamtam_use_hover_anim',
			[
				'type'  => $controls_manager::SWITCHER,
				'label' => esc_html__('Use Theme Hover Animation', 'vamtam-elementor-integration'),
				'prefix_class' => 'vamtam-has-',
				'return_value' => 'hover-anim',
				'default' => '',
				'render_type' => 'template',
			]
		);
	}

	// Vamtam_Widget_Button.
	function widgets_registered() {
		class Vamtam_Widget_Button extends \Elementor\Widget_Button {
			public $extra_depended_scripts = [
				'vamtam-button',
			];

			// Extend constructor.
			public function __construct($data = [], $args = null) {
				parent::__construct($data, $args);

				$this->register_assets();

				$this->add_extra_script_depends();
			}

			// Register the assets the widget depends on.
			public function register_assets() {
				$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

				wp_register_script(
					'vamtam-button',
					VAMTAM_ELEMENTOR_INT_URL . '/assets/js/widgets/button/vamtam-button' . $suffix . '.js',
					[
						'elementor-frontend'
					],
					\VamtamElementorIntregration::PLUGIN_VERSION,
					true
				);
			}

			// Assets the widget depends upon.
			public function add_extra_script_depends() {
				// Scripts
				foreach ( $this->extra_depended_scripts as $script ) {
					$this->add_script_depends( $script );
				}
			}
		}

		// Replace current divider widget with our extended version.
		$widgets_manager = \Elementor\Plugin::instance()->widgets_manager;
		$widgets_manager->unregister( 'button' );
		$widgets_manager->register( new Vamtam_Widget_Button );
	}
	add_action( \Vamtam_Elementor_Utils::get_widgets_registration_hook(), __NAMESPACE__ . '\widgets_registered', 100 );
}

if ( vamtam_theme_supports( [ 'button--hover-anim', 'button--icon-vertical-pos' ] ) ) {
	// Style - Button section
	function section_style_before_section_end( $widget, $args ) {
		$controls_manager = \Elementor\Plugin::instance()->controls_manager;
		if ( vamtam_theme_supports( 'button--hover-anim' ) ) {
			add_button_style_section_controls( $controls_manager, $widget );
		}
		if ( vamtam_theme_supports( 'button--icon-vertical-pos' ) ) {
			update_content_align_control( $controls_manager, $widget );
		}
	}
	add_action( 'elementor/element/button/section_style/before_section_end', __NAMESPACE__ . '\section_style_before_section_end', 10, 2 );
}
