<?php
namespace VamtamElementor\Widgets\IconList;


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Theme preferences.
if ( ! \Vamtam_Elementor_Utils::is_widget_mod_active( 'icon-list' ) ) {
	return;
}

if ( vamtam_theme_supports( 'icon-list--use-icon-bg-controls' ) ) {
	function add_icon_background_controls( $controls_manager, $widget ) {
		// Initially it adds padding to the icon element which does not work well when the icon has a background color.
		\Vamtam_Elementor_Utils::replace_control_options( $controls_manager, $widget, 'text_indent', [
			'selectors' => [
				'{{WRAPPER}} .elementor-icon-list-items .elementor-icon-list-item' => 'gap: {{SIZE}}{{UNIT}};',
			],
		] );

		$widget->start_injection( [
			'of' => 'icon_color',
			'at' => 'after',
		] );

		// Icon Background Color.
		$widget->add_control(
			'vamtam_icon_bg_color',
			[
				'label' => __( 'Icon Bg Color', 'vamtam-elementor-integration' ),
				'type' => $controls_manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .elementor-icon-list-icon' => 'background-color: {{VALUE}};',
					// '{{WRAPPER}} .elementor-icon-list-icon i' => 'width: 1em;', // Applied from the LESS file cause of a bug in Elementor where the width prop gets the control {{VALUE}} instead of the set string.
				],
			]
		);

		$widget->end_injection();

		$widget->start_injection( [
			'of' => 'icon_color_hover',
			'at' => 'after',
		] );

		// Icon Bg Color Hover.
		$widget->add_control(
			'vamtam_icon_bg_color_hover',
			[
				'label' => __( 'Icon Bg Color', 'vamtam-elementor-integration' ),
				'type' => $controls_manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .elementor-icon-list-item:hover .elementor-icon-list-icon' => 'background-color: {{VALUE}};',
				],
				'conditions' => [
					'relation' => 'or',
					'terms' => [
						[
							'name' => 'vamtam_icon_bg_color',
							'operator' => '!==',
							'value' => '',
						],
						[
							'name' => '__globals__[vamtam_icon_bg_color]',
							'operator' => '!==',
							'value' => '',
						],
					],
				],
			]
		);

		$widget->end_injection();

		// Icon Padding.
		$widget->add_control(
			'vamtam_icon_padding',
			[
				'label' => __( 'Icon Padding', 'vamtam-elementor-integration' ),
				'type' => $controls_manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', '%' ],
				'default' => [
					'size' => 10,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-icon-list-icon' => 'padding: {{SIZE}}{{UNIT}};',
				],
				'conditions' => [
					'relation' => 'or',
					'terms' => [
						[
							'name' => 'vamtam_icon_bg_color',
							'operator' => '!==',
							'value' => '',
						],
						[
							'name' => '__globals__[vamtam_icon_bg_color]',
							'operator' => '!==',
							'value' => '',
						],
					],
				],
			]
		);

		// Icon Bg Border Radius.
		$widget->add_control(
			'vamtam_icon_border_radius',
			[
				'label' => __( 'Icon Border Radius', 'vamtam-elementor-integration' ),
				'type' => $controls_manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', '%' ],
				'default' => [
					'size' => 50,
					'unit' => '%',
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-icon-list-icon' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
				'conditions' => [
					'relation' => 'or',
					'terms' => [
						[
							'name' => 'vamtam_icon_bg_color',
							'operator' => '!==',
							'value' => '',
						],
						[
							'name' => '__globals__[vamtam_icon_bg_color]',
							'operator' => '!==',
							'value' => '',
						],
					],
				],
			]
		);
	}

	function section_icon_style_before_section_end( $widget ) {
		$controls_manager = \Elementor\Plugin::instance()->controls_manager;
		add_icon_background_controls( $controls_manager, $widget );
	}
	add_action( 'elementor/element/icon-list/section_icon_style/before_section_end', __NAMESPACE__ . '\section_icon_style_before_section_end' );
}
