<?php
namespace VamtamElementor\Widgets\Post_Comments;

use ElementorPro\Modules\ThemeElements\Widgets\Post_Comments as Elementor_Post_Comments;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Theme preferences.
if ( ! \Vamtam_Elementor_Utils::is_widget_mod_active( 'post-comments' ) ) {
	return;
}

if ( vamtam_theme_supports( 'post-comments--btn-hover-anim' ) ) {

	// Vamtam_Widget_PostComments.
	function widgets_registered() {
		class Vamtam_Widget_Post_Comments extends Elementor_Post_Comments {
			public $extra_depended_scripts = [
				'vamtam-post-comments',
			];

			// Extend constructor.
			public function __construct($data = [], $args = null) {
				parent::__construct($data, $args);

				$this->register_assets();

				$this->add_extra_script_depends();
			}

			// Register the assets the widget depends on.
			public function register_assets() {
				$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

				wp_register_script(
					'vamtam-post-comments',
					VAMTAM_ELEMENTOR_INT_URL . '/assets/js/widgets/post-comments/vamtam-post-comments' . $suffix . '.js',
					[
						'elementor-frontend'
					],
					\VamtamElementorIntregration::PLUGIN_VERSION,
					true
				);
			}

			// Assets the widget depends upon.
			public function add_extra_script_depends() {
				// Scripts
				foreach ( $this->extra_depended_scripts as $script ) {
					$this->add_script_depends( $script );
				}
			}
		}

		// Replace current widget with our extended version.
		$widgets_manager = \Elementor\Plugin::instance()->widgets_manager;
		$widgets_manager->unregister( 'post-comments' );
		$widgets_manager->register( new Vamtam_Widget_Post_Comments );
	}
	add_action( \Vamtam_Elementor_Utils::get_widgets_registration_hook(), __NAMESPACE__ . '\widgets_registered', 100 );
}
