<?php

/**
 * Setup Child Theme
 */
function expedition_setup_child_theme() {
	// Add Child Theme Text Domain.
	load_child_theme_textdomain( 'expedition', get_stylesheet_directory() . '/languages' );
}

add_action( 'after_setup_theme', 'expedition_setup_child_theme', 99 );

/**
 * Enqueue Child Theme Assets
 */
function expedition_child_assets() {
	if ( ! is_admin() ) {
		$version = wp_get_theme()->get( 'Version' );
		wp_enqueue_style( 'expedition-child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array(), $version, 'all' );
	}
}

add_action( 'wp_enqueue_scripts', 'expedition_child_assets', 99 );

/**
 * Add your custom code below this comment.
 */
