function initWaterDroplet(e,t,s,r,o,i,a){const n={uniforms:{iResolution:{type:"v2",value:[document.getElementById("effect-box").clientWidth,document.getElementById("effect-box").clientHeight]},vTextureSize:{type:"v2",value:[0,0]},uTextureForeground:{type:"sampler2D",value:null},uTextureBackground:{type:"sampler2D",value:null},uTextureDropShine:{type:"sampler2D",value:null}},fragment:'\n        precision mediump float;\n    \n        //Textures\n        uniform sampler2D uTextureForeground;\n        uniform sampler2D uTextureBackground;\n        uniform sampler2D uTextureDropShine;\n        \n        //Canvas image data\n        uniform sampler2D uSampler;\n    \n        //The resolution and coordinates of the current pixel\n        uniform vec2 iResolution;\n        uniform vec2 vTextureSize;\n        varying vec2 vTextureCoord;\n        \n        //Function to get the vec2 value of the current coordinate\n        vec2 texCoord(){\n            return vec2(gl_FragCoord.x, iResolution.y - gl_FragCoord.y) / iResolution;\n        }\n\n        //Scales the bg up and proportionally to fill the container\n        vec2 scaledTextureCoordinate(){\n            float ratioCanvas = iResolution.x / iResolution.y;\n            float ratioImage = vTextureSize.x / vTextureSize.y;\n            \n            vec2 scale = vec2(1, 1);\n            vec2 offset = vec2(0, 0);\n            float ratioDelta = ratioCanvas - ratioImage;\n\n            if(ratioDelta >= 0.0){\n                scale.y = (1.0 + ratioDelta);\n                offset.y = ratioDelta / 2.0;\n            }else{\n                scale.x = (1.0 - ratioDelta);\n                offset.x = -(ratioDelta / 2.0);\n            }\n\n            return (texCoord() + offset) / scale;\n        }\n        \n        //Alpha-blends two colors\n        vec4 blend(vec4 bg, vec4 fg){\n            vec3 bgm = bg.rgb * bg.a;\n            vec3 fgm = fg.rgb * fg.a;\n            float ia = 1.0 - fg.a;\n            float a = (fg.a + bg.a * ia);\n            \n            vec3 rgb;\n            \n            if(a != 0.0){\n                rgb = (fgm + bgm * ia) / a;\n            }else{\n                rgb = vec3(0.0,0.0,0.0);\n            }\n            \n            return vec4(rgb,a);\n        }\n        \n        vec2 pixel(){\n            return vec2(1.0, 1.0) / iResolution;\n        }\n        \n        //Get color from fg\n        vec4 fgColor(){\n            return texture2D(uSampler, vTextureCoord);\n        }\n                \n        void main(){\n            vec4 bg = texture2D(uTextureBackground, scaledTextureCoordinate());\n            vec4 cur = fgColor();\n\n            float d = cur.b; // "thickness"\n            float x = cur.g;\n            float y = cur.r;\n            float a = smoothstep(0.65, 0.7, cur.a);\n            \n            vec4 smoothstepped = vec4(y, x, d, a);\n\n            vec2 refraction = (vec2(x, y) - 0.5) * 2.0;\n            vec2 refractionPos = scaledTextureCoordinate() + (pixel() * refraction * (256.0 + (d * 512.0)));\n            vec4 tex = texture2D(uTextureForeground, refractionPos);\n            \n            float maxShine = 390.0;\n            float minShine = maxShine * 0.18;\n            vec2 shinePos = vec2(0.5, 0.5) + ((1.0 / 512.0) * refraction) * -(minShine + ((maxShine-minShine) * d));\n            vec4 shine = texture2D(uTextureDropShine, shinePos);\n            tex = blend(tex,shine);\n            \n            vec4 fg = vec4(tex.rgb, a);\n            gl_FragColor = blend(bg, fg);\n        }\n\t'};class l{constructor(e,r,o){this.renderer=new PIXI.autoDetectRenderer(e,r,{antialias:!1,transparent:!1,view:document.getElementById("water-droplet")}),this.renderer.autoResize=!0,this.stage=new PIXI.Container,this.background=new PIXI.Graphics,this.background.fillAlphanumber=0,this.background.beginFill("0xffffff"),this.background.drawRect(0,0,e,r),this.background.endFill(),this.background.alpha=0,this.stage.addChild(this.background),this.dropletManager=new h(this.stage,o),n.uniforms.uTextureDropShine.value=o.resources[t].texture,n.uniforms.uTextureBackground.value=o.resources[s].texture,n.uniforms.uTextureForeground.value=o.resources[s].texture,n.uniforms.vTextureSize.value=[o.resources[s].texture.width,o.resources[s].texture.height],this.dropletShader=new PIXI.Filter("",n.fragment,n.uniforms),this.stage.filters=[this.dropletShader]}resize(e,t){this.renderer.resize(e,t),this.background.clear(),this.background.beginFill("0xffffff"),this.background.drawRect(0,0,e,t),this.background.endFill()}update(e,t){this.updateShader(e,t),this.dropletManager.update(e,t)}updateShader(e,t){this.dropletShader.uniforms.iResolution=[e,t]}render(){this.renderer.render(this.stage)}}class h{constructor(t,s){let n=9e3,l=200;t.width<700&&(n=3e3,l=150),this.options={spawnRate:{small:.6,large:.05},spawnsPerFrame:{small:200,large:5},spawnMass:{small:{min:1,max:2},large:{min:7,max:10}},poolDroplets:{small:{min:n-500,max:n},large:{min:l-100,max:l}},maximumMassGravity:r,maximumMass:o,dropletGrowSpeed:i,dropletShrinkSpeed:a,dropletContainerSize:100},this.positionMatrix=[[-1,-1],[1,-1],[-1,1],[1,1]],this.smallDroplets=[],this.largeDroplets=[],this.dropletSmallTexture=s.resources[e].texture,this.dropletLargeTexture=s.resources[e].texture,this.smallDropletContainer=new p(d,this.dropletSmallTexture,this.options.poolDroplets.small.min,this.options.poolDroplets.small.max),this.largeDropletContainer=new p(m,this.dropletLargeTexture,this.options.poolDroplets.large.min,this.options.poolDroplets.large.max),t.addChild(this.largeDropletContainer),t.addChild(this.smallDropletContainer)}update(e,t){h.removeLargeOffscreenDroplets(e,t,this.largeDroplets,this.largeDropletContainer);for(let s=0;s<this.options.spawnsPerFrame.small;s++)this.spawnNewSmallDroplet(e,t);for(let s=0;s<this.options.spawnsPerFrame.large;s++)this.spawnNewLargeDroplet(e,t);this.checkLargeDropletLogic()}checkLargeDropletLogic(){for(let e=this.largeDroplets.length-1;e>=0;e--)this.updateLargeDropletSize(this.largeDroplets[e]),this.checkDropletMovement(this.largeDroplets[e]),this.checkLargeToSmallDropletCollision(this.largeDroplets[e]),this.checkLargeToLargeDropletCollision(this.largeDroplets[e]),this.removeLargeDroplets(e)}removeLargeDroplets(e){0===this.largeDroplets[e].mass&&!0===this.largeDroplets[e].toBeRemoved&&(this.largeDropletContainer.destroy(this.largeDroplets[e]),this.largeDroplets.splice(e,1))}updateLargeDropletSize(e){!0===e.toBeRemoved?this.shrinkDropletSize(e):this.growDropletSize(e),e.width=6*e.mass,e.height=7*e.mass}shrinkDropletSize(e){e.mass-this.options.dropletShrinkSpeed<=0?e.mass=0:e.mass-=this.options.dropletShrinkSpeed}growDropletSize(e){e.mass!==e.targetMass&&(e.mass+this.options.dropletGrowSpeed>=e.targetMass?e.mass=e.targetMass:e.mass+=this.options.dropletGrowSpeed)}checkDropletMovement(e){!0!==e.toBeRemoved&&(e.mass<this.options.maximumMassGravity&&0===e.dropletVelocity.y&&0===e.dropletVelocity.x?Math.random()<.01&&(e.dropletVelocity.y=u.getRandomInt(.5,3)):e.mass<this.options.maximumMassGravity&&0!==e.dropletVelocity.y?(Math.random()<.1&&(e.x+=u.getRandomInt(-10,10)/10),Math.random()<.1&&(e.dropletVelocity.y=0)):e.mass>=this.options.maximumMassGravity&&e.dropletVelocity.y<10&&(e.dropletVelocity.y=u.getRandomInt(10,20),e.dropletVelocity.x=u.getRandomInt(-10,10)/10),e.y+=e.dropletVelocity.y,e.x+=e.dropletVelocity.x)}getDropletPresenceArray(e){const t=[],s=this.positionMatrix.length;for(let r=0;r<s;r++){const s={x:Math.floor((e.x+e.width/7*this.positionMatrix[r][0])/this.options.dropletContainerSize),y:Math.floor((e.y+e.height/7*this.positionMatrix[r][1])/this.options.dropletContainerSize)};0!==r?t[0].x===s.x&&t[0].y===s.y||t.push(s):t.push(s)}return t}checkLargeToLargeDropletCollision(e){if(!0===e.toBeRemoved)return;for(let t=this.largeDroplets.length-1;t>=0;t--){if(e.x===this.largeDroplets[t].x&&e.y===this.largeDroplets[t].y)continue;const s=e.x-this.largeDroplets[t].x,r=e.y-this.largeDroplets[t].y;Math.sqrt(s*s+r*r)<=e.width/7+this.largeDroplets[t].width/7&&(e.mass+this.largeDroplets[t].mass<=this.options.maximumMass?e.targetMass=e.mass+this.largeDroplets[t].mass:e.targetMass=this.options.maximumMass,this.largeDroplets[t].toBeRemoved=!0)}}checkLargeToSmallDropletCollision(e){if(!0===e.toBeRemoved)return;const t=this.getDropletPresenceArray(e);for(let s=0;s<t.length;s++){if(void 0===this.smallDroplets[t[s].x]||void 0===this.smallDroplets[t[s].x][t[s].y])continue;for(let r=this.smallDroplets[t[s].x][t[s].y].length-1;r>=0;r--){const o=e.x-this.smallDroplets[t[s].x][t[s].y][r].x,i=e.y-this.smallDroplets[t[s].x][t[s].y][r].y;Math.sqrt(o*o+i*i)<=e.width/7+this.smallDroplets[t[s].x][t[s].y][r].width/7&&(e.mass+this.smallDroplets[t[s].x][t[s].y][r].mass/3<=this.options.maximumMass&&(e.targetMass=e.mass+this.smallDroplets[t[s].x][t[s].y][r].mass/3),this.smallDropletContainer.destroy(this.smallDroplets[t[s].x][t[s].y][r]),this.smallDroplets[t[s].x][t[s].y].splice(r,1))}}}spawnNewSmallDroplet(e,t){if(Math.random()>this.options.spawnRate.small)return;const s=this.smallDropletContainer.get();if(null===s)return;const r={x:u.getRandomInt(0,e),y:u.getRandomInt(0,t)},o=u.getRandomInt(this.options.spawnMass.small.min,this.options.spawnMass.small.max),i=Math.floor(r.x/this.options.dropletContainerSize),a=Math.floor(r.y/this.options.dropletContainerSize);s.x=r.x,s.y=r.y,s.mass=o,s.width=8*s.mass,s.height=8*s.mass,void 0===this.smallDroplets[i]&&(this.smallDroplets[i]=[]),void 0===this.smallDroplets[i][a]&&(this.smallDroplets[i][a]=[]),this.smallDroplets[i][a].push(s)}spawnNewLargeDroplet(e,t){if(Math.random()>this.options.spawnRate.large)return;const s=this.largeDropletContainer.get();if(null===s)return;const r=u.getRandomInt(this.options.spawnMass.large.min,this.options.spawnMass.large.max);s.x=u.getRandomInt(0,e),s.y=u.getRandomInt(-100,t/1.5),s.mass=r/2,s.targetMass=r,s.width=6*s.mass,s.height=7*s.mass,s.dropletVelocity.x=0,s.toBeRemoved=!1,this.largeDroplets.push(s)}static removeLargeOffscreenDroplets(e,t,s,r){for(let o=s.length-1;o>=0;o--)(s[o].x>e+10||s[o].x<-10||s[o].y>t+10||s[o].y<-100)&&(r.destroy(s[o]),s.splice(o,1))}}class p extends PIXI.particles.ParticleContainer{constructor(e,t,s,r){super(r,{scale:!0,position:!0,rotation:!1,uvs:!1,alpha:!1}),this.ObjectToCreate=e,this.objectTexture=t,this.pool=[],this.inUse=0,this.startingSize=s,this.maximumSize=r,this.initialize()}initialize(){for(let e=0;e<this.startingSize;e+=1){const e=new this.ObjectToCreate(this.objectTexture);e.x=-100,e.y=-100,e.anchor.set(.5),this.addChild(e),this.pool.push(e)}}get(){if(this.inUse>=this.maximumSize)return null;if(this.inUse++,this.pool.length>0)return this.pool.pop();const e=new this.ObjectToCreate(this.objectTexture);return e.x=-100,e.y=-100,e.anchor.set(.5,.5),this.addChild(e),e}destroy(e){this.inUse-1<0?console.error("Something went wrong, you cant remove more elements than there are in the total pool"):(e.x=-100,e.y=-100,this.inUse-=1,this.pool.push(e))}}class d extends PIXI.Sprite{constructor(e){super(e),this.mass=0}}class m extends d{constructor(e){super(e),this.dropletVelocity=new PIXI.Point(0,0),this.toBeRemoved=!1,this.targetMass=0}}class u{static getRandomInt(e,t){return Math.floor(Math.random()*(t-e+1))+e}}new class{constructor(){this.width=document.getElementById("effect-box").clientWidth,this.height=document.getElementById("effect-box").clientHeight,this.loader=PIXI.loader.add(e).add(t).add(s).load((()=>this.initialize()))}initialize(){this.effectCanvas=new l(this.width,this.height,this.loader),window.addEventListener("resize",(()=>this.resizeCanvas()),!1),this.loop(),this.loader.reset()}resizeCanvas(){this.width=document.getElementById("effect-box").clientWidth,this.height=document.getElementById("effect-box").clientHeight,this.effectCanvas.resize(this.width,this.height)}loop(){requestAnimationFrame((()=>this.loop())),this.effectCanvas.update(this.width,this.height),this.effectCanvas.render()}}}