(function ($) {
	"use strict";
	
	/* ---------------------------------------------
	 Services
	--------------------------------------------- */

	var WidgetServices = function( $scope, $ ) {

		var flatIcon = $scope.find('.flat-icon');

		flatIcon.flatshadow({
			angle: "SE", // Shadows direction. Available options: N, NE, E, SE, S, SW, W and NW. (Angle will be random if left unassigned)
			fade: true, // Gradient shadow effect
		});
	};


	/* ---------------------------------------------
	 Google Map
	--------------------------------------------- */

	var WidgetGoogleMap = function( $scope, $ ) {

		//set google maps parameters
		var googleMap = $scope.find('#google-container'),
			latitude = googleMap.data('latitude'),
			longitude = googleMap.data('longitude'),

			map_type = googleMap.data('type'),
			map_zoom_control = googleMap.data('zoom-control'),
			map_info_window = googleMap.data('info-window'),
			map_zoom = googleMap.data('zoom'),
			map_marker_title = googleMap.data('marker-title'),
			map_marker_icon = googleMap.data('marker-icon'),
			map_styles = googleMap.data('style') || '';

			//set google map options
			var map_options = {
			center: new google.maps.LatLng(latitude, longitude),
			zoom: map_zoom,
			panControl: false,
			zoomControl: false,
			mapTypeControl: false,
			streetViewControl: false,
			mapTypeId: map_type,
			scrollwheel: false,
			styles: map_styles,
			}
	 
			//inizialize the map
			var map = new google.maps.Map(document.getElementById('google-container'), map_options);
			

			//google map custom marker icon - .png fallback for IE11
			var is_internetExplorer11 = navigator.userAgent.toLowerCase().indexOf('trident') > -1;
			var marker_url = (is_internetExplorer11) ? map_marker_icon : map_marker_icon;
			

			//add a custom marker to the map      
			var marker = new google.maps.Marker({
			position: new google.maps.LatLng(latitude, longitude),
			map: map,
			title: map_marker_title,
			visible: true,
			icon: marker_url
			});
		
			if (map_info_window == 'yes') {
	  
				var infowindow = new google.maps.InfoWindow({
					content: contentString,
					maxWidth: 300,
			
				});

				infowindow.open(map,marker);

				google.maps.event.addListener(marker, 'click', function() {
					infowindow.open(map,marker);
				});
			
			}


			google.maps.event.addDomListener(window, "resize", function () {
				var center = map.getCenter();
				google.maps.event.trigger(map, "resize");
				map.setCenter(center);
			
			});

		 if (map_zoom_control == 'yes') {

			//add custom buttons for the zoom-in/zoom-out on the map
			function CustomZoomControl(controlDiv, map) {
			//grap the zoom elements from the DOM and insert them in the map 
			var controlUIzoomIn = document.getElementById('zoom-in'),
				controlUIzoomOut = document.getElementById('zoom-out');
			controlDiv.appendChild(controlUIzoomIn);
			controlDiv.appendChild(controlUIzoomOut);
		
			// Setup the click event listeners and zoom-in or out according to the clicked element
			google.maps.event.addDomListener(controlUIzoomIn, 'click', function () {
				map.setZoom(map.getZoom() + 1)
			});
			google.maps.event.addDomListener(controlUIzoomOut, 'click', function () {
				map.setZoom(map.getZoom() - 1)
			});
			}
		
			var zoomControlDiv = document.createElement('div');
			var zoomControl = new CustomZoomControl(zoomControlDiv, map);
		
			//insert the zoom div on the top left of the map
			map.controls[google.maps.ControlPosition.LEFT_TOP].push(zoomControlDiv);

		}

	};

	
	/* ---------------------------------------------
	 Blog
	--------------------------------------------- */

	var WidgetBlog = function( $scope, $ ) {

		var element = $scope.find('.blogContainer');
		element.imagesLoaded().done(function() {
		  element.isotope({
			itemSelector: 'article',
			masonry: {
			  columnWidth: 'article',
			  gutter: '.gutter-sizer'
			},
			percentPosition: true
		  });
		});
		$(window).on('resize', function() {
		  element.isotope();
		}).trigger('resize');


		if ($('video, audio').length) {
			$('video, audio').mediaelementplayer({ alwaysShowControls: true });
		}
								  
		Fancybox.bind('[data-fancybox="gallery"]', {
			Thumbs: {
			  Carousel: {
				fill: false,
				center: true,
			  },
			},
		  });
		
		  $('.flexslider').flexslider({
			controlNav: false,
			animation: "fade",  
			prevText: '<i class="fa fa-angle-left"></i>',
			nextText: '<i class="fa fa-angle-right"></i>',
			slideshowSpeed: '3000',
			pauseOnHover: true
		  });
	};

	/* ---------------------------------------------
	 Content Cover
	--------------------------------------------- */

	var WidgetСontentСover = function( $scope, $ ) {

		// General vars
		var element = $scope.find('.cover-section'),
			background_style = element.data('type'),
			animation_elements = element.data('animation'),
			countdown_element = element.data('countdown'),
			background_effects = element.data('effects'),
			destroy_effects = element.data('destroy');

		// Animation show elements
		if (animation_elements == true) {
			if ($('.cover-section').length) {
				setTimeout(function() {
				$(".cover-section .mouse-wrapper").delay(1500).css({display: 'none'}).fadeIn(1500);
				$(".cover-section h1, .cover-section h2, .cover-section h3, .cover-section h4, .cover-section h5, .cover-section h6").delay(1200).css({display: 'none'}).fadeIn(1200);
				$(".cover-section p").delay(1200).css({display: 'none'}).fadeIn(1200);
				$(".cover-section .logo-image-box img").delay(1200).css({display: 'none'}).fadeIn(1200);
				});
			}
		}


		// Single image
		if (background_style == 'image') {
			var singleImage = $scope.find('.image-box'),
				background_image = singleImage.data('image');
			singleImage.backstretch(background_image);
		}

		// Slideshow images
		if (background_style == 'slideshow') {
			var imgs = $scope.find('.image-box .dummy'),
				slideshowImage = $scope.find('.image-box'),
				slideshowDuration = slideshowImage.data('duration'),
				slideshowFade = slideshowImage.data('fade');

				var imgSrcs = [];
			
				for (var i = 0; i < imgs.length; i++) {
					imgSrcs.push(imgs[i].src);
				}

			slideshowImage.backstretch(imgSrcs, {duration: slideshowDuration, fade: slideshowFade});
		}
		
		// YouTube Video
		if (background_style == 'youtube_video') {
			var videoYoutube = $scope.find('.video-box'),
				youtubeMobileImage = videoYoutube.data('mobile-image'),
				youtubeCoverImage = videoYoutube.data('cover-image'),
				myPlayer = $scope.find('.video-box #video-youtube');

				var options = {
					mobileFallbackImage: youtubeMobileImage,
					coverImage: youtubeCoverImage,
					playOnlyIfVisible  : false
				};

				myPlayer.YTPlayer(options);

			
		}

		// Vimeo Video
		if (background_style == 'vimeo_video') {
			var videoVimeo = $scope.find('.video-box'),
				vimeoMobileImage = videoVimeo.data('mobile-image'),
				myPlayer = $scope.find('.video-box #video-vimeo');
				
			myPlayer.vimeo_player({
				mobileFallbackImage: vimeoMobileImage,
				showControls: false
			});
		}

		// HTML5 Video
		if (background_style == 'html5_video') {
			var videoHTML5 = $scope.find('.video-html5-box'),
				html5MobileImage = videoHTML5.data('poster'),
				html5Video = videoHTML5.data('video'),
				html5VideoMuted = videoHTML5.data('muted');
				
				var instance = new vidbg(
					'.video-html5-box',
						{
							'mp4': html5Video,
							'poster': html5MobileImage,
						}, {
							muted: html5VideoMuted,
							loop:true,
							overlay: false
						}
				);
		}

		// Effects
		let elem = document.querySelector('body');
		let contains = elem.classList.contains('elementor-editor-active');
		if (destroy_effects == true) {

		}
		if (destroy_effects == false || contains == false) {
		
			// Winter
			if (background_effects == 'winter' ) {
				var winter = $scope.find('#effect-box'),
					opacitySnow = winter.data('opacity'),
					sizeSnow = winter.data('size'),
					speedSnow = winter.data('speed'),
					colorSnow = winter.data("color");
				initLetItSnow(opacitySnow, sizeSnow, speedSnow, colorSnow);
			}

			// Low Poly
			if (background_effects == 'low_poly') {
				var lowPoly = $scope.find('#effect-box'),
					alpha = lowPoly.data('opacity'),
					size = lowPoly.data('size'),
					density = lowPoly.data('density'),
					circleColor = lowPoly.data('color');
				initLowPoly(alpha, size, density, circleColor);
			}

			// Constellation
			if (background_effects == 'constellation') {
				var constellation = $scope.find('#effect-box'),
					constellationColor = constellation.data('color');
				initConstellation(constellationColor);
			}

			// Particles
			if (background_effects == 'particles') {
				var particles = $scope.find('#effect-box'),
					particlesColors = new Array(particles.data('color')),			
					numberParticles = particles.data('particles'),
					particlesColor = particlesColors.toString().split(',');
				initParticles(particlesColor, numberParticles);
			}

			// Rainbow Squares
			if (background_effects == 'rainbow_squares') {
				var rainbowSquares = $scope.find('#effect-box'),	
					quantitySquares = rainbowSquares.data('quantity'),
					speedSquares = rainbowSquares.data('speed'),
					size1Squares = rainbowSquares.data('size1'),
					size2Squares = rainbowSquares.data('size2');
				initRainbowSquares(quantitySquares, speedSquares, size1Squares, size2Squares);
			}

			// Shooting Stars
			if (background_effects == 'shooting_stars') {
				var shootingStars = $scope.find('#effect-box'),	
					particleLifeStars = shootingStars.data('partical'),
					quantity = shootingStars.data('quantity'),
					probability = shootingStars.data('probability'),
					sizeone = shootingStars.data('size1'),
					sizetwo = shootingStars.data('size2'),
					borderColorStars = shootingStars.data('border-color'),
					backgroundColorStars = shootingStars.data('background-color');
				initShootingStars(particleLifeStars, probability, quantity, sizeone, sizetwo, borderColorStars, backgroundColorStars);
			}

			// Starfield
			if (background_effects == 'starfield') {
				var starfield = $scope.find('#effect-box'),	
					mouseMoveStar = starfield.data('mouse'),
					speed = starfield.data('speed'),
					quantity = starfield.data('quantity'),
					backgroundColor = starfield.data('background-color'),
					starColor = starfield.data('star-color');
				initStarfield(mouseMoveStar, speed, quantity, backgroundColor, starColor);
			}

			// Gravity
			if (background_effects == 'gravity') {
				var gravity = $scope.find('#effect-box'),
					particleSize = gravity.data('particle-size'),
					particleColor = gravity.data('particle-color'),
					pointSize = gravity.data('point-size'),
					backgroundColor = gravity.data('bg-color'),
					pointColor = gravity.data('point-color'),
					pointBackgroundColor = gravity.data('point-bg-color');
				initGravity(particleSize, particleColor, pointSize, backgroundColor, pointColor, pointBackgroundColor);
			}

			// Fireworks
			if (background_effects == 'fireworks') {
				var fireworks = $scope.find('#effect-box'),
					speed = fireworks.data('speed'),
					minimum = fireworks.data('minimum'),
					maximum = fireworks.data('maximum');
				initFireworks(speed, minimum, maximum);
			}

			// Geometric
			if (background_effects == 'geometric') {
				var geometric = $scope.find('#effect-box'),
					speed = geometric.data('speed'),
					quantity = geometric.data('quantity'),
					hover = geometric.data('hover'),
					click = geometric.data('click'),
					lineColor = geometric.data('line-color'),
					circleColor = geometric.data('circle-color');
				initGeometric(speed, quantity, hover, click, lineColor, circleColor);
			}

			// Bubbles
			if (background_effects == 'bubbles') {
				var bubbles = $scope.find('#effect-box'),
					quantity = bubbles.data('quantity'),
					color1 = bubbles.data('color1'),
					color2 = bubbles.data('color2'),
					color3 = bubbles.data('color3'),
					color4 = bubbles.data('color4'),
					color5 = bubbles.data('color5');
				initBubbles(quantity, color1, color2, color3, color4, color5);
			}

			// Mosaic
			if (background_effects == 'mosaic') {
				var mosaic = $scope.find('#effect-box'),
					sideMosaic = mosaic.data('side'),
					shineMosaic = mosaic.data('shine'),
					base = mosaic.data('base-time'),
					added = mosaic.data('added-time'),
					backgroundColor = mosaic.data('bg-color'),
					stroke = mosaic.data('stroke-color'),
					color1 = mosaic.data('color1'),
					color2 = mosaic.data('color2'),
					color3 = mosaic.data('color3');
				initMosaic(sideMosaic, shineMosaic, base, added, backgroundColor, stroke, color1, color2, color3);
			}

			// Rain
			if (background_effects == 'rain') {
				var rain = $scope.find('#effect-box'),
					dropAlpha = rain.data('drop-alpha'),
					dropColor = rain.data('drop-color'),
					rainStyle = rain.data('style');
				if (rainStyle == 'image_rain') {
					var imagebg = rain.data('rain-image'),
						imagefg = rain.data('rain-image');
					initRain(imagebg, imagefg, dropAlpha, dropColor);
				}
				if (rainStyle == 'video_rain') {
					initRainVideo(dropAlpha, dropColor);
				}
			}

			// Surface
			if (background_effects == 'surface') {
				var surface = $scope.find('#effect-box'),
					speed = surface.data('speed'),
					ambient_color = surface.data('ambient-color'),
					diffuse_color = surface.data('diffuse-color');
				initSurface(speed, ambient_color, diffuse_color);
			}

			// Magneto
			if (background_effects == 'magneto') {
				var magneto = $scope.find('#effect-box'),
					color_1_magneto = magneto.data('color1'),
					color_2_magneto = magneto.data('color2'),
					color_3_magneto = magneto.data('color3'),
					bg_color_magneto = magneto.data('bg-color');
				initMagneto(color_1_magneto, color_2_magneto, color_3_magneto, bg_color_magneto);
			}

			// Liquid
			if (background_effects == 'liquid') {
				var liquid = $scope.find('#effect-box'),
					color_1_liquid = liquid.data('color1'),
					color_2_liquid = liquid.data('color2');
				initLiquid(color_1_liquid, color_2_liquid);
			}

			// Сonfetti
			if (background_effects == 'confetti') {
				var confetti = $scope.find('#effect-box'),
					particlesColors = new Array(confetti.data('color')),			
					numberParticles = confetti.data('particles'),
					particlesColor = particlesColors.toString().split(',');
				initConfetti(numberParticles, particlesColor);
			}

			// Orbit
			if (background_effects == 'orbit') {
				var orbit = $scope.find('#effect-box'),
					count_orbit = orbit.data('count'),
					speed_orbit = orbit.data('speed'),
					radius_orbit = orbit.data('radius'),
					size_orbit = orbit.data('size'),
					maxdistance_orbit = orbit.data('maxdistance'),
					color_orbit_rgba = orbit.data('color'),
					background_orbit_rgba = orbit.data('bg-color'),
					background_orbit_2_rgba = orbit.data('bg2-color');
				initOrbit(count_orbit, speed_orbit, radius_orbit, size_orbit, maxdistance_orbit, color_orbit_rgba, background_orbit_rgba, background_orbit_2_rgba);
			}

			// Swirl
			if (background_effects == 'swirl') {
				var swirl = $scope.find('#effect-box'),		
					speed_swirl = swirl.data('speed'),
					particles_swirl = swirl.data('particles'),
					background_swirl = swirl.data('bg-color');
				initSwirl(speed_swirl, particles_swirl, background_swirl);
			}

			// Shift
			if (background_effects == 'shift') {
				var shift = $scope.find('#effect-box'),		
					speed_shift = shift.data('speed'),
					circle_count_shift = shift.data('count'),
					color_shift = shift.data('color');
				initShift(speed_shift, circle_count_shift, color_shift);
			}

			// Coalesce
			if (background_effects == 'coalesce') {
				var coalesce = $scope.find('#effect-box'),		
					speed_coalesce = coalesce.data('speed'),
					particles_count_coalesce = coalesce.data('count'),
					color_coalesce = coalesce.data('color');
				initCoalesce(speed_coalesce, particles_count_coalesce, color_coalesce);
			}

			// Pipeline
			if (background_effects == 'pipeline') {
				var pipeline = $scope.find('#effect-box'),		
					speed_pipeline = pipeline.data('speed'),
					pipeline_count_pipeline = pipeline.data('count'),
					color_pipeline = pipeline.data('color');
				initPipeline(speed_pipeline, pipeline_count_pipeline, color_pipeline);
			}

			// Aurora
			if (background_effects == 'aurora') {
				var aurora = $scope.find('#effect-box'),		
					speed_aurora = aurora.data('speed'),
					count_aurora = aurora.data('count'),
					color_aurora = aurora.data('color');
				initAurora(speed_aurora, count_aurora, color_aurora);
			}

			// Stardust
			if (background_effects == 'stardust') {
				var stardust = $scope.find('#effect-box'),		
					particle_stardust = stardust.data('particle'),
					micro_stardust = stardust.data('micro'),
					gradient_stardust = stardust.data('gradient'),
					gradient_stardust_2 = stardust.data('gradient2');
				initStardust(particle_stardust, micro_stardust, gradient_stardust, gradient_stardust_2);
			}

			// Abstractart
			if (background_effects == 'abstractart') {
				var abstractart = $scope.find('#effect-box'),		
					color_abstractart = abstractart.data('color'),
					color_abstractart_2 = abstractart.data('color2'),
					frequency_abstractart = abstractart.data('frequency'),
					background_abstractart = abstractart.data('background');
				initAbstractart(frequency_abstractart, color_abstractart, color_abstractart_2, background_abstractart);
			}

			// Wave
			if (background_effects == 'wave') {
				var wave = $scope.find('#effect-box'),
				speed_wave = wave.data('speed'),
				images_wave = new Array(wave.data('images')),			
				list_images_wave = images_wave.toString().split(',');
				initWave(speed_wave, list_images_wave);
			}

			// Connections
			if (background_effects == 'connections') {
				var connections = $scope.find('#effect-box'),
					connectionsColors = new Array(connections.data('color')),			
					numberParticles = connections.data('particles'),
					background_connections = connections.data('bg-color'),
					strokestyle_connections = connections.data('stroke-color'),
					linewidth_connections = connections.data('linewidth'),
					frequency_connections = connections.data('frequency'),
					connectionsColor = connectionsColors.toString().split(',');
				initConnections(connectionsColor, numberParticles, background_connections, strokestyle_connections, linewidth_connections, frequency_connections);
			}

			// Alien
			if (background_effects == 'alien') {
				var alien = $scope.find('#effect-box'),		
					numberParticles = alien.data('particles'),
					background_alien = alien.data('bg-color'),
					background_alien_2 = alien.data('bg2-color'),
					color_alien = alien.data('color'),
					color_alien_2 = alien.data('color2'),
					color_alien_3 = alien.data('color3');
				initAlien(numberParticles, background_alien, background_alien_2, color_alien, color_alien_2, color_alien_3);
			}
			
			// Balls
			if (background_effects == 'balls') {
				var balls = $scope.find('#effect-box'),
					ballsColors = new Array(balls.data('color')),	
					number_balls = balls.data('balls'),		
					ballsColor = ballsColors.toString().split(',');
				initBalls(ballsColor, number_balls);
			}

			// Landscape
			if (background_effects == 'landscape') {
				var landscape = $scope.find('#effect-box'),	
					landscapeStyle = landscape.data('style');
					if (landscapeStyle == 'style1_landscape') {
						var landscape_style = landscape.data('landscape'),
							speed_landscape = landscape.data('speed');
						initLandscape(landscape_style, speed_landscape);
					}
					if (landscapeStyle == 'style2_landscape') {
						var landscape_style2 = landscape.data('landscape2'),
							speed_landscape2 = landscape.data('speed2');
						initLandscape2(landscape_style2, speed_landscape2);
					}
			}

			// Boreal Sky
			if (background_effects == 'boreal_sky') {
				var boreal_sky = $scope.find('#effect-box'),
					borealColors = new Array(boreal_sky.data('color')),	
					borealColor = borealColors.toString().split(','),
					background1_boreal = boreal_sky.data('bg1-color'),
					background2_boreal = boreal_sky.data('bg2-color'),
					background3_boreal = boreal_sky.data('bg3-color');
				initBorealSky(borealColor, background1_boreal, background2_boreal, background3_boreal);
			}
			
			// Colors
			if (background_effects == 'colors') {
				var colors = $scope.find('#effect-box'),
					colorsColors = new Array(colors.data('color')),	
					colorsColor = colorsColors.toString().split(','),
					background1_colors = colors.data('bg1-color'),
					background2_colors = colors.data('bg2-color');
				initColors(colorsColor, background1_colors, background2_colors);
			}

			// Confetti Lines
			if (background_effects == 'confetti_lines') {
				var confetti_lines = $scope.find('#effect-box'),
					confetti_linesColors = new Array(confetti_lines.data('color')),	
					confetti_linesColor = confetti_linesColors.toString().split(','),
					background1_confetti_lines = confetti_lines.data('bg1-color'),
					background2_confetti_lines = confetti_lines.data('bg2-color');
				initConfettiLines(confetti_linesColor, background1_confetti_lines, background2_confetti_lines);
			}

			// Stars Lines
			if (background_effects == 'stars_lines') {
				var stars_lines = $scope.find('#effect-box'),
					stars_linesColor = stars_lines.data('color'),
					background1_stars_lines = stars_lines.data('bg1-color');
				initStarsLines(stars_linesColor, background1_stars_lines);
			}

			// Quantum
			if (background_effects == 'quantum') {
				var quantum = $scope.find('#effect-box'),
					background_quantum = quantum.data('color'),
					gemisphere_light = quantum.data('light-color'),
					gemisphere_light_2 = quantum.data('light2-color'),
					directional_light = quantum.data('light3-color'),
					mesh_phong_material = quantum.data('material-color');
				initQuantum(background_quantum, gemisphere_light, gemisphere_light_2, directional_light, mesh_phong_material);
			}

			// Information
			if (background_effects == 'information') {
				var information = $scope.find('#effect-box'),
					background_information = information.data('bg-color'),
					color_1_information = information.data('color'),
					color_2_information = information.data('color2'),
					color_3_information = information.data('color3'),
					dotTexture = information.data('texture');
				initInformation(background_information, color_1_information, color_2_information, color_3_information, dotTexture);
			}

			// Space Time
			if (background_effects == 'spacetime') {
				var spacetime = $scope.find('#effect-box'),
					background_spacetime = spacetime.data('bg-color'),
					dotTexture = spacetime.data('texture');
				initSpacetime(background_spacetime, dotTexture);
			}

			// Physics
			if (background_effects == 'physics') {
				var physics = $scope.find('#effect-box'),
					color_physics = physics.data('color'),
					lines_physics = physics.data('lines'),
					radius_physics = physics.data('radius'),
					vertices_physics = physics.data('vertices');
				initPhysics(color_physics, lines_physics, radius_physics, vertices_physics);
			}

			// Heuristics
			if (background_effects == 'heuristics') {
				var heuristics = $scope.find('#effect-box'),
					color_heuristics = heuristics.data('color'),
					background_heuristics = heuristics.data('bg-color');
				initHeuristics(color_heuristics, background_heuristics);
			}

			// Hawking
			if (background_effects == 'hawking') {
				var hawking = $scope.find('#effect-box'),
					color_hawking = hawking.data('color'),
					color2_hawking = hawking.data('color2'),
					background_hawking = hawking.data('background'),
					lines_hawking = hawking.data('lines'),
					radius_hawking = hawking.data('radius'),
					dots_hawking = hawking.data('dots');
				initHawking(color_hawking, color2_hawking, background_hawking, lines_hawking, radius_hawking, dots_hawking);
			}

			// Star Wars
			if (background_effects == 'star_wars') {
				var star_wars = $scope.find('#effect-box'),
					texture_bg_star_wars = star_wars.data('texture');
				initStarWars(texture_bg_star_wars);
			}

			// Brick Tunnel
			if (background_effects == 'brick_tunnel') {
				var brick_tunnel = $scope.find('#effect-box'),
					texture_bg_brick_tunnel = brick_tunnel.data('texture');
				initBrickTunnel(texture_bg_brick_tunnel);
			}

			// Triangle
			if (background_effects == 'triangle') {
				var triangle = $scope.find('#effect-box');
				initTriangle();
			}

			// Birds
			if (background_effects == 'birds') {
				var birds = $scope.find('#effect-box'),
					mouse_birds = birds.data('mouse'),
					color_birds = birds.data('color'),
					color2_birds = birds.data('color2'),
					background_birds = birds.data('bg-color'),
					size_birds = birds.data('size'),
					wing_birds = birds.data('wing'),
					speed_birds = birds.data('speed'),
					separation_birds = birds.data('separation'),
					alignment_birds = birds.data('alignment'),
					cohesion_birds = birds.data('cohesion'),
					quantity_birds = birds.data('quantity');
				initBirds(mouse_birds, quantity_birds, cohesion_birds, alignment_birds, separation_birds, speed_birds, wing_birds, size_birds, color_birds, color2_birds, background_birds);
			}

			// Fog
			if (background_effects == 'fog') {
				var fog = $scope.find('#effect-box'),
					base_color_fog = fog.data('base-color'),
					highlight_color_fog = fog.data('highlight-color'),
					midtone_color_fog = fog.data('midtone-color'),
					lowlight_color_fog = fog.data('lowlight-color'),
					blur_fog = fog.data('blur'),
					zoom_fog = fog.data('zoom'),
					speed_fog = fog.data('speed');
				initFog(base_color_fog, highlight_color_fog, midtone_color_fog, lowlight_color_fog, blur_fog, zoom_fog, speed_fog);
			}

			// Waves
			if (background_effects == 'waves') {
				var waves = $scope.find('#effect-box'),
					mouse_waves = waves.data('mouse'),
					color_waves = waves.data('color'),
					shininess_waves = waves.data('shininess'),
					height_waves = waves.data('height'),
					zoom_waves = waves.data('zoom'),
					speed_waves = waves.data('speed');
				initWaves(mouse_waves, color_waves, shininess_waves, height_waves, zoom_waves, speed_waves);
			}

			// Clouds
			if (background_effects == 'clouds') {
				var clouds = $scope.find('#effect-box'),	
					cloudsStyle = clouds.data('style');
					if (cloudsStyle == 'style1_clouds') {
						var mouse_clouds = clouds.data('mouse'),
							skycolor_clouds = clouds.data('sky-color'),
							cloudcolor_clouds = clouds.data('cloud-color'),
							cloudshadowcolor_clouds = clouds.data('shadow-color'),
							suncolor_clouds = clouds.data('sun-color'),
							sunlightcolor_clouds = clouds.data('light-color'),
							speed_clouds = clouds.data('speed'),
							sunglarecolor_clouds = clouds.data('glare-color');
						initClouds(mouse_clouds, skycolor_clouds, cloudcolor_clouds, cloudshadowcolor_clouds, suncolor_clouds, sunlightcolor_clouds, speed_clouds, sunglarecolor_clouds);
					}
					if (cloudsStyle == 'style2_clouds') {
						var texture_clouds = clouds.data('texture'),
							skycolor2_clouds = clouds.data('sky-color'),
							cloudcolor2_clouds = clouds.data('cloud-color'),
							lightcolor2_clouds = clouds.data('light-color'),
							speed2_clouds = clouds.data('speed');
						initClouds2(texture_clouds, speed2_clouds, skycolor2_clouds, cloudcolor2_clouds, lightcolor2_clouds);
					}
			}

			// Globe
			if (background_effects == 'globe') {
				var globe = $scope.find('#effect-box'),
					mouse_globe = globe.data('mouse'),
					color_globe = globe.data('color'),
					color2_globe = globe.data('color2'),
					bg_color_globe = globe.data('bg-color'),
					size_globe = globe.data('size');
				initGlobe(mouse_globe, color_globe, color2_globe, bg_color_globe, size_globe);
			}

			// Net
			if (background_effects == 'net') {
				var net = $scope.find('#effect-box'),
					mouse_net = net.data('mouse'),
					dots_net = net.data('dots'),
					color_net = net.data('color'),
					bg_color_net = net.data('bg-color'),
					points_net = net.data('points'),
					distance_net = net.data('distance'),
					spacing_net = net.data('spacing');
				initNet(mouse_net, dots_net, color_net, points_net, bg_color_net, distance_net, spacing_net);
			}

			// Cells
			if (background_effects == 'cells') {
				var cells = $scope.find('#effect-box'),
					color_cells = cells.data('color'),
					color2_cells = cells.data('color2'),
					size_cells = cells.data('size'),
					speed_cells = cells.data('speed');
				initCells(color_cells, color2_cells, size_cells, speed_cells);
			}

			// Trunk
			if (background_effects == 'trunk') {
				var trunk = $scope.find('#effect-box'),
					color_trunk = trunk.data('color'),
					bg_color_trunk = trunk.data('bg-color'),
					spacing_trunk = trunk.data('spacing'),
					chaos_trunk = trunk.data('chaos');
				initTrunk(color_trunk, bg_color_trunk, spacing_trunk, chaos_trunk);
			}

			// Topology
			if (background_effects == 'topology') {
				var topology = $scope.find('#effect-box'),
					color_topology = topology.data('color'),
					bg_color_topology = topology.data('bg-color');
				initTopology(color_topology, bg_color_topology);
			}

			// Dots
			if (background_effects == 'dots') {
				var dots = $scope.find('#effect-box'),
					mouse_dots = dots.data('mouse'),
					lines_dots = dots.data('lines'),
					color_dots = dots.data('color'),
					color2_dots = dots.data('color2'),
					bg_color_dots = dots.data('bg-color'),
					spacing_dots = dots.data('spacing'),
					size_dots = dots.data('size');
				initDots(mouse_dots, lines_dots, color_dots, color2_dots, bg_color_dots, spacing_dots, size_dots);
			}

			// Rings
			if (background_effects == 'rings') {
				var rings = $scope.find('#effect-box'),
					mouse_rings = rings.data('mouse'),
					color_rings = rings.data('color'),
					bg_color_rings = rings.data('bg-color'),
					alpha_rings = rings.data('alpha');
				initRings(mouse_rings, color_rings, bg_color_rings, alpha_rings);
			}

			// Halo
			if (background_effects == 'halo') {
				var halo = $scope.find('#effect-box'),
					mouse_halo = halo.data('mouse'),
					bg_color_halo = halo.data('bg-color'),
					base_halo = halo.data('base'),
					size_halo = halo.data('size'),
					xoffset_halo = halo.data('xoffset'),
					yoffset_halo = halo.data('yoffset'),
					amplitude_halo = halo.data('amplitude');
				initHalo(mouse_halo, bg_color_halo, base_halo, size_halo, amplitude_halo, xoffset_halo, yoffset_halo);
			}

			// Glitch
			if (background_effects == 'glitch') {
				var glitch = $scope.find('#effect-box'),
					imageGlitch = glitch.data('image');
				initGlitch(imageGlitch);
			}

			// Sand Particles
			if (background_effects == 'sand_particles') {
				var sand_particles = $scope.find('#effect-box'),
					color_sand_particles = sand_particles.data('bg-color');
				initSandParticles(color_sand_particles);
			}

			// Hills
			if (background_effects == 'hills') {
				var hills = $scope.find('#effect-box'),
					color_hills = hills.data('bg-color');
				initHills(color_hills);
			}

			// Plasmatic
			if (background_effects == 'plasmatic') {
				var plasmatic = $scope.find('#effect-box'),
					particles_plasmatic = plasmatic.data('particles'),
					energy_plasmatic = plasmatic.data('energy'),
					blobiness_plasmatic = plasmatic.data('blobiness'),
					brightness_plasmatic = plasmatic.data('brightness');
				initPlasmatic(particles_plasmatic, energy_plasmatic, blobiness_plasmatic, brightness_plasmatic);
			}

			// Coronavirus
			if (background_effects == 'coronavirus') {
				var coronavirus = $scope.find('#effect-box'),
					object_coronavirus = coronavirus.data('object'),
					max_coronavirus = coronavirus.data('max'),
					blur_coronavirus = coronavirus.data('blur'),
					bg_coronavirus = coronavirus.data('bg-color'),
					color_coronavirus = coronavirus.data('color');
				initCoronavirus(object_coronavirus, max_coronavirus, blur_coronavirus, bg_coronavirus, color_coronavirus);
			}

			// Audio Visualizers
			if (background_effects == 'audio_visualizers') {
				var audio_visualizers = $scope.find('#effect-box'),	
						audioStyleMix = '',
						audioStyleBox = '',
						audioStyleCylinder = '',
						audioUrl = audio_visualizers.data('audio'),
						audioStartColor = audio_visualizers.data('start-color'),
						audioEndColor = audio_visualizers.data('end-color'),
						audioLoop = audio_visualizers.data('loop'),
						audioDistance = audio_visualizers.data('distance'),
						audioStyle = audio_visualizers.data('style'),
						audioVolume = audio_visualizers.data('volume');
						if (audioStyle == 'mix_audio_visualizers') {
							audioStyleMix = true;
						} else if (audioStyle == 'box_audio_visualizers') {
							audioStyleBox = true;
						} else if (audioStyle == 'cylinder_audio_visualizers') {
							audioStyleCylinder = true;
						};
					initAudioVisualizers(audioStyleMix, audioStyleBox, audioStyleCylinder, audioUrl, audioStartColor, audioEndColor, audioLoop, audioVolume, audioDistance);
			}

			// Water Droplet
			if (background_effects == 'water_droplet') {
				var water_droplet = $scope.find('#effect-box'),
					waterAlpha = water_droplet.data('alpha'),
					waterShine = water_droplet.data('shine'),
					waterImage = water_droplet.data('image'),
					maximumMassGravity_water = water_droplet.data('gravity'),
					maximumMass_water = water_droplet.data('mass'),
					dropletGrowSpeed_water = water_droplet.data('grow'),
					dropletShrinkSpeed_water = water_droplet.data('shrink');
				initWaterDroplet(waterAlpha, waterShine, waterImage, maximumMassGravity_water, maximumMass_water, dropletGrowSpeed_water, dropletShrinkSpeed_water);
			}

			// Noisy Blobs
			if (background_effects == 'noisy_blobs') {
				var noisy_blobs = $scope.find('#effect-box'),
					speed_noisy_blobs = noisy_blobs.data('speed'),
					scale_noisy_blobs = noisy_blobs.data('scale'),
					dot_size_noisy_blobs = noisy_blobs.data('dot'),
					gap_noisy_blobs = noisy_blobs.data('gap'),
					hue_base_noisy_blobs = noisy_blobs.data('hue-base'),
					hue_range_noisy_blobs = noisy_blobs.data('hue-range'),
					shape_noisy_blobs = noisy_blobs.data('shape');
				initNoisyBlobs(speed_noisy_blobs, scale_noisy_blobs, dot_size_noisy_blobs, gap_noisy_blobs, hue_base_noisy_blobs, hue_range_noisy_blobs, shape_noisy_blobs);
			}

			// Nucleus
			if (background_effects == 'nucleus') {
				var nucleus = $scope.find('#effect-box'),
					darker_nucleus = nucleus.data('darker'),
					particle_nucleus = nucleus.data('particle'),
					points_nucleus = nucleus.data('points'),
					space_nucleus = nucleus.data('space'),
					speed_nucleus = nucleus.data('speed');
				initNucleus(darker_nucleus, particle_nucleus, points_nucleus, space_nucleus, speed_nucleus);
			}

			// TV
			if (background_effects == 'tv') {
				var tv = $scope.find('#effect-box'),
					noise_tv = tv.data('noise'),
					fps_tv = tv.data('fps'),
					scan_tv = tv.data('scan'),
					sample_tv = tv.data('sample');
				initTV(noise_tv, fps_tv, scan_tv, sample_tv);
			}

			// Floor is Lava
			if (background_effects == 'floor_lava') {
				var floor_lava = $scope.find('#effect-box'),
					amplitudex_floor_lava = floor_lava.data('amplitudex'),
					amplitudey_floor_lava = floor_lava.data('amplitudey'),
					lines_floor_lava = floor_lava.data('lines'),
					start_floor_lava = floor_lava.data('start'),
					end_floor_lava = floor_lava.data('end');
				initFloorLava(amplitudex_floor_lava, amplitudey_floor_lava, lines_floor_lava, start_floor_lava, end_floor_lava);
			}

			// Circuits
			if (background_effects == 'circuits') {
				var circuits = $scope.find('#effect-box'),
					bg_color_circuits = circuits.data('bg-color'),
					stroke_color_circuits = circuits.data('stroke-color'),
					circle_color_circuits = circuits.data('circle-color'),
					move_circle_color_circuits = circuits.data('move-circle-color'),
					light_size_width_circuits = circuits.data('light-size-width'),
					light_size_height_circuits = circuits.data('light-size-height'),
					max_length_circuits = circuits.data('max-length'),
					min_length_circuits = circuits.data('min-length'),
					light_circle_color_circuits = circuits.data('light-color'),
					light2_circle_color_circuits = circuits.data('light2-color'),
					superlight_circle_color_circuits = circuits.data('superlight-color'),
					superlight2_circle_color_circuits = circuits.data('superlight2-color'),
					cell_size_circuits = circuits.data('cell-size');
				initCircuits(bg_color_circuits, stroke_color_circuits, circle_color_circuits, move_circle_color_circuits, light_size_width_circuits, light_size_height_circuits, max_length_circuits, min_length_circuits, cell_size_circuits, light_circle_color_circuits, light2_circle_color_circuits, superlight_circle_color_circuits, superlight2_circle_color_circuits);
			}

			// Turbulent Noise
			if (background_effects == 'turbulent_noise') {
				var turbulent_noise = $scope.find('#effect-box'),
					time_turbulent_noise = turbulent_noise.data('time'),
					red_turbulent_noise = turbulent_noise.data('red'),
					green_turbulent_noise = turbulent_noise.data('green'),
					blue_turbulent_noise = turbulent_noise.data('blue');
				initTurbulentNoise(time_turbulent_noise, red_turbulent_noise, green_turbulent_noise, blue_turbulent_noise);
			}

			// Ribbons
			if (background_effects == 'ribbons') {
				var ribbons = $scope.find('#effect-box'),
					waves_ribbons = ribbons.data('waves'),
					width_ribbons = ribbons.data('width'),
					amplitude_ribbons = ribbons.data('amplitude'),
					rotation_ribbons = ribbons.data('rotation'),
					hue_ribbons = ribbons.data('hue'),
					hue2_ribbons = ribbons.data('hue2'),
					speed_ribbons = ribbons.data('speed'),
					speed2_ribbons = ribbons.data('speed2');
				initRibbons(waves_ribbons, width_ribbons, amplitude_ribbons, rotation_ribbons, hue_ribbons, hue2_ribbons, speed_ribbons, speed2_ribbons);
			}

			// Dotted Ocean
			if (background_effects == 'dotted_ocean') {
				var dotted_ocean = $scope.find('#effect-box'),
					count_dotted_ocean = dotted_ocean.data('count'),
					size_dotted_ocean = dotted_ocean.data('size'),
					width_dotted_ocean = dotted_ocean.data('width'),
					height_dotted_ocean = dotted_ocean.data('height'),
					grid_size_dotted_ocean = dotted_ocean.data('grid-size'),
					wave_size_dotted_ocean = dotted_ocean.data('wave-size'),
					perspective_dotted_ocean = dotted_ocean.data('perspective'),
					bg_color_dotted_ocean = dotted_ocean.data('bg-color'),
					hsl_dotted_ocean = dotted_ocean.data('hsl'),
					hsl2_dotted_ocean = dotted_ocean.data('hsl2');
				initDottedOcean(count_dotted_ocean, size_dotted_ocean, width_dotted_ocean, height_dotted_ocean, grid_size_dotted_ocean, wave_size_dotted_ocean, perspective_dotted_ocean, bg_color_dotted_ocean, hsl_dotted_ocean, hsl2_dotted_ocean);
			}

			// Discoid
			if (background_effects == 'discoid') {
				var discoid = $scope.find('#effect-box'),
					discoidColors = new Array(discoid.data('color')),	
					discoidColor = discoidColors.toString().split(','),
					scale_discoid = discoid.data('scale'),
					speed_discoid = discoid.data('speed'),
					spirals_discoid = discoid.data('spirals'),
					spirals2_discoid = discoid.data('spirals2');
				initDiscoid(discoidColor, scale_discoid, speed_discoid, spirals_discoid, spirals2_discoid);
			}

			// Mechanical Grass
			if (background_effects == 'mechanical_grass') {
				var mechanical_grass = $scope.find('#effect-box'),
					background_color_mechanical_grass = mechanical_grass.data('bg-color'),
					background2_color_mechanical_grass = mechanical_grass.data('bg2-color'),
					stroke_color_mechanical_grass = mechanical_grass.data('stroke-color');
				initMechanicalGrass(background_color_mechanical_grass, background2_color_mechanical_grass, stroke_color_mechanical_grass);
			}

			// Gradient Animation
			if (background_effects == 'gradient_animation') {
				var gradient_animation = $scope.find('#effect-box'),
					speed_gradient_animation = gradient_animation.data('speed'),
					gradient_animation_start_color1 = new Array(gradient_animation.data('start-color1')),	
					gradient_animation_start_color1ofString = gradient_animation_start_color1.toString().split(','),
					start_color1_gradient_animation = gradient_animation_start_color1ofString.map(Number),

					gradient_animation_stop_color1 = new Array(gradient_animation.data('stop-color1')),	
					gradient_animation_stop_color1ofString = gradient_animation_stop_color1.toString().split(','),
					stop_color1_gradient_animation = gradient_animation_stop_color1ofString.map(Number),

					gradient_animation_start_color2 = new Array(gradient_animation.data('start-color2')),	
					gradient_animation_start_color2ofString = gradient_animation_start_color2.toString().split(','),
					start_color2_gradient_animation = gradient_animation_start_color2ofString.map(Number),

					gradient_animation_stop_color2 = new Array(gradient_animation.data('stop-color2')),	
					gradient_animation_stop_color2ofString = gradient_animation_stop_color2.toString().split(','),
					stop_color2_gradient_animation = gradient_animation_stop_color2ofString.map(Number),

					gradient_animation_start_color3 = new Array(gradient_animation.data('start-color3')),	
					gradient_animation_start_color3ofString = gradient_animation_start_color3.toString().split(','),
					start_color3_gradient_animation = gradient_animation_start_color3ofString.map(Number),

					gradient_animation_stop_color3 = new Array(gradient_animation.data('stop-color3')),	
					gradient_animation_stop_color3ofString = gradient_animation_stop_color3.toString().split(','),
					stop_color3_gradient_animation = gradient_animation_stop_color3ofString.map(Number);

				initGradientAnimation(speed_gradient_animation, start_color1_gradient_animation, stop_color1_gradient_animation, start_color2_gradient_animation, stop_color2_gradient_animation, start_color3_gradient_animation, stop_color3_gradient_animation);
			}

			// Funky Perlin
			if (background_effects == 'funky_perlin') {
				var funky_perlin = $scope.find('#effect-box'),
					color1_funky_perlin = funky_perlin.data('color'),
					color2_funky_perlin = funky_perlin.data('color2'),
					color3_funky_perlin = funky_perlin.data('color3'),
					speed_funky_perlin = funky_perlin.data('speed'),
					scale_funky_perlin = funky_perlin.data('scale');
				initFunkyPerlin(color1_funky_perlin, color2_funky_perlin, color3_funky_perlin, speed_funky_perlin, scale_funky_perlin);
			}

			// Snowfall
			if (background_effects == 'snowfall') {
				var snowfall = $scope.find('#effect-box'),
					count_snowfall = snowfall.data('count'),
					size_snowfall = snowfall.data('size'),
					speed_snowfall = snowfall.data('speed');
				initSnowfall(count_snowfall, size_snowfall, speed_snowfall);
			}

			// Trails
			if (background_effects == 'trails') {
				var trails = $scope.find('#effect-box'),
					color_trails = trails.data('color'),
					particles_trails = trails.data('particles'),
					speed_trails = trails.data('speed'),
					circle_trails = trails.data('circle');
				initTrails(color_trails, particles_trails, speed_trails, circle_trails);
			}

			// Blood Flow
			if (background_effects == 'blood_flow') {
				var blood = $scope.find('#effect-box'),
					object_blood = blood.data('object'),
					particles_blood = blood.data('particles'),
					speed_blood = blood.data('speed');
				initBloodFlow(object_blood, particles_blood, speed_blood);
			}

			// Night Sky
			if (background_effects == 'night_sky') {
				var night_sky = $scope.find('#effect-box'),
					sky_color_night_sky = night_sky.data('sky-color'),
					star_color_night_sky = night_sky.data('star-color'),
					falling_star_color_night_sky = night_sky.data('falling-star-color'),
					mountain_color1_night_sky = night_sky.data('mountain-color1'),
					mountain_color2_night_sky = night_sky.data('mountain-color2'),
					mountain_color3_night_sky = night_sky.data('mountain-color3'),
					displacement_night_sky = night_sky.data('displacement'),
					scroll_delay_night_sky = night_sky.data('scroll');
				initNightSky(sky_color_night_sky, star_color_night_sky, falling_star_color_night_sky, mountain_color1_night_sky, mountain_color2_night_sky, mountain_color3_night_sky, displacement_night_sky, scroll_delay_night_sky);
			}

			// Text Particles
			if (background_effects == 'text_particles') {
				var text_particles = $scope.find('#effect-box'),
					text_particlesColors = new Array(text_particles.data('color')),	
					text_particlesColor = text_particlesColors.toString().split(','),
					text_text_particles = text_particles.data('text'),
					text_size_text_particles = text_particles.data('text-size'),
					font_text_particles = text_particles.data('font'),
					width_text_particles = text_particles.data('width'),
					height_text_particles = text_particles.data('height'),
					distance_text_particles = text_particles.data('distance'),
					particles_text_particles = text_particles.data('particles');
				initTextParticles(text_particlesColor, distance_text_particles, text_size_text_particles, text_text_particles, font_text_particles, width_text_particles, height_text_particles, particles_text_particles);
			}

			// Pixel Grid
			if (background_effects == 'pixel_grid') {
				var pixel_grid = $scope.find('#effect-box'),
					pixel_gridColors = new Array(pixel_grid.data('color')),	
					pixel_gridColor = pixel_gridColors.toString().split(','),
					bg_color_pixel_grid = pixel_grid.data('bg-color');
				initPixelGrid(pixel_gridColor, bg_color_pixel_grid);
			}

			// Swarming Bugs
			if (background_effects == 'swarming_bugs') {
				var swarming_bugs = $scope.find('#effect-box'),
					circle_color_swarming_bugs = swarming_bugs.data('circle-color'),
					circle_border_color_swarming_bugs = swarming_bugs.data('circle-border-color'),
					bugs_color_swarming_bugs = swarming_bugs.data('bugs-color'),
					spurt_swarming_bugs = swarming_bugs.data('spurt'),
					radius1_swarming_bugs = swarming_bugs.data('radius1'),
					radius2_swarming_bugs = swarming_bugs.data('radius2')
				initSwarmingBugs(circle_color_swarming_bugs, circle_border_color_swarming_bugs, bugs_color_swarming_bugs, spurt_swarming_bugs, radius1_swarming_bugs, radius2_swarming_bugs);
			}

			// Blobs
			if (background_effects == 'blobs') {
				var blobs = $scope.find('#effect-box'),
					size_blobs1 = blobs.data('size-blobs1'),
					speed_blobs1 = blobs.data('speed-blobs1'),
					color_blobs1 = blobs.data('color-blobs1'),
					frequency_blobs1 = blobs.data('frequency-blobs1'),
					density_blobs1 = blobs.data('density-blobs1'),
					size_blobs2 = blobs.data('size-blobs2'),
					speed_blobs2 = blobs.data('speed-blobs2'),
					color_blobs2 = blobs.data('color-blobs2'),
					frequency_blobs2 = blobs.data('frequency-blobs2'),
					density_blobs2 = blobs.data('density-blobs2'),
					size_blobs3 = blobs.data('size-blobs3'),
					speed_blobs3 = blobs.data('speed-blobs3'),
					color_blobs3 = blobs.data('color-blobs3'),
					frequency_blobs3 = blobs.data('frequency-blobs3'),
					density_blobs3 = blobs.data('density-blobs3');
				initBlobs(size_blobs1, speed_blobs1, color_blobs1, frequency_blobs1, density_blobs1, size_blobs2, speed_blobs2, color_blobs2, frequency_blobs2, density_blobs2, size_blobs3, speed_blobs3, color_blobs3, frequency_blobs3, density_blobs3);
			}
			

		}

	};

	/* ---------------------------------------------
	 Countdown
	--------------------------------------------- */

	var WidgetCountdown = function( $scope, $ ) {

		var countdown = $scope.find('.countdown-box'),
			countdown_date = countdown.data('date'),
			countdown_text_days = countdown.data('textdays'),
			countdown_text_hours = countdown.data('texthours'),
			countdown_text_minutes = countdown.data('textminutes'),
			countdown_text_seconds = countdown.data('textseconds');

			// Create and Options
			function createСountdown() {
				var endDate = countdown_date;
				countdown.countdown({
					date: endDate,
					render: function(data) {
						$(this.el).html("<div>" + this.leadingZeros(data.days, 3) + " <span>"+ countdown_text_days +"</span></div><div>" + this.leadingZeros(data.hours, 2) + " <span>" + countdown_text_hours + "</span></div><div>" + this.leadingZeros(data.min, 2) + " <span>" + countdown_text_minutes + "</span></div><div>" + this.leadingZeros(data.sec, 2) + " <span>" + countdown_text_seconds + "</span></div>");
					}
				});
			}

			createСountdown();
	
	};

	/* ---------------------------------------------
	 Initialize Elementor Front Script
	--------------------------------------------- */
	$(window).on('elementor/frontend/init', function () {

		// Services
		elementorFrontend.hooks.addAction('frontend/element_ready/expedition-services.default', WidgetServices);
		// Google Map
		elementorFrontend.hooks.addAction('frontend/element_ready/expedition-google-map.default', WidgetGoogleMap);
		// Content Cover
		elementorFrontend.hooks.addAction('frontend/element_ready/expedition-content-cover.default', WidgetСontentСover);
		// Blog
		elementorFrontend.hooks.addAction('frontend/element_ready/expedition-blog.default', WidgetBlog);
		// Countdown
		elementorFrontend.hooks.addAction('frontend/element_ready/expedition-countdown.default', WidgetCountdown);
	});

})(jQuery);
