<?php

/**
 * AOS Animation
 *
 * @author: expedition-Themes
 * @version: 2.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( ! class_exists( 'AOS_Animation' ) ) {

	class AOS_Animation {

		public function __construct() {     
            add_action( 'elementor/element/common/_section_style/after_section_end', [ $this, 'register_controls' ], 10 );
			add_action( 'elementor/widget/before_render_content', [ $this, 'before_render' ] );
		}

		public function get_script_depends() {
			return [ 'expedition-aos-scripts' ];
		}
	
		public function get_style_depends() {
			return [ 'expedition-aos-style' ];
		}

		public function get_name() {
			return 'aos-animation';
		}

		public function register_controls( $element ) {

			$element->start_controls_section(
				'section_aos_animation', [
					'label' => esc_html__( 'AOS Animation', 'expedition-plugin' ),
					'tab' => Controls_Manager::TAB_ADVANCED,
				]
			);

			$element->add_control(
				'aos_animation_name', [
					'label' => esc_html__( 'Animation Name', 'expedition-plugin' ),
					'type' => Controls_Manager::SELECT,
					'options' => [
						'none' => 'NONE',
						'custom-fade-up' => 'CUSTOM FADE UP',
						'custom-fade-right' => 'CUSTOM FADE RIGHT',
						'fade' => 'FADE',
						'fade-up' => 'FADE-UP',
						'fade-down' => 'FADE-DOWN',
						'fade-left' => 'FADE-LEFT',
						'fade-right' => 'FADE-RIGHT',
						'fade-up-right' => 'FADE-UP-RIGHT',
						'fade-up-left' => 'FADE-UP-LEFT',
						'fade-down-right' => 'FADE-DOWN-RIGHT',
						'fade-down-left' => 'FADE-DOWN-LEFT',
						'flip-up' => 'FLIP-UP',
						'flip-down' => 'FLIP-DOWN',
						'flip-left' => 'FLIP-LEFT',
						'flip-right' => 'FLIP-RIGHT',
						'slide-up' => 'SLIDE-UP',
						'slide-down' => 'SLIDE-DOWN',
						'slide-left' => 'SLIDE-LEFT',
						'slide-right' => 'SLIDE-RIGHT',
						'zoom-in' => 'ZOOM-IN',
						'zoom-in-up' => 'ZOOM-IN-UP',
						'zoom-in-down' => 'ZOOM-IN-DOWN',
						'zoom-in-left' => 'ZOOM-IN-LEFT',
						'zoom-in-right' => 'ZOOM-IN-RIGHT',
						'zoom-out' => 'ZOOM-OUT',
						'zoom-out-up' => 'ZOOM-OUT-UP',
						'zoom-out-down' => 'ZOOM-OUT-DOWN',
						'zoom-out-left' => 'ZOOM-OUT-LEFT',
						'zoom-out-right' => 'ZOOM-OUT-RIGHT',
					],
					'default' => 'none',
					'frontend_available' => true,
					'render_type' => 'none',
				]
			);

			$element->add_control(
				'aos_animation_delay', [
					'label' => esc_html__( 'Animation Delay', 'expedition-plugin' ),
					'description' => esc_html__( 'Delay before the animation starts', 'expedition-plugin' ),
					'type' => Controls_Manager::NUMBER,
					'default' => '',
					'min' => 0,
					'step' => 50,
					'condition' => [
						'aos_animation_name!' => 'none',
					],
				]
			);

			$element->add_control(
				'aos_animation_duration', [
					'label' => esc_html__( 'Animation Duration', 'expedition-plugin' ),
					'description' => esc_html__( 'Change the animation duration', 'expedition-plugin' ),
					'type' => Controls_Manager::NUMBER,
					'default' => '',
					'min' => 0,
					'step' => 50,
					'condition' => [
						'aos_animation_name!' => 'none',
					],
					'frontend_available' => true,
					'render_type' => 'none',
				]
			);

			$element->add_control(
				'aos_animation_offset', [
					'label' => esc_html__( 'Animation Offset', 'expedition-plugin' ),
					'description' => esc_html__( 'Distance to start the animation (related to the browser bottom)', 'expedition-plugin' ),
					'type' => Controls_Manager::NUMBER,
					'default' => '',
					'min' => -500,
					'max' => 500,
					'step' => 10,
					'condition' => [
						'aos_animation_name!' => 'none',
					],
				]
			);

			$element->add_control(
				'aos_animation_once', [
					'label' => esc_html__( 'Animation Once', 'expedition-plugin' ),
					'description' => esc_html__( 'Animate only once while scrolling down', 'expedition-plugin' ),
					'type' => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default' => 'yes',
					'condition' => [
						'aos_animation_name!' => 'none',
					],
				]
			);

			$element->end_controls_section();

		}

		public function before_render( $element ) {

			$settings = $element->get_settings_for_display();

			if ( $settings[ 'aos_animation_name' ] != 'none' ) {

				if ( ! empty( $settings[ 'aos_animation_name' ] ) ) {
					$element->add_render_attribute( '_wrapper', 'data-aos', $settings[ 'aos_animation_name' ] );
				}

				if ( ! empty( $settings[ 'aos_animation_offset' ] ) ) {
					$element->add_render_attribute( '_wrapper', 'data-aos-offset', $settings[ 'aos_animation_offset' ] );
				}

				if ( ! empty( $settings[ 'aos_animation_delay' ] ) ) {
					$element->add_render_attribute( '_wrapper', 'data-aos-delay', $settings[ 'aos_animation_delay' ] );
				}

				if ( ! empty( $settings[ 'aos_animation_duration' ] ) ) {
					$element->add_render_attribute( '_wrapper', 'data-aos-duration', $settings[ 'aos_animation_duration' ] );
				}

				if ( ! empty( $settings[ 'aos_animation_once' ] ) ) {
					$element->add_render_attribute( '_wrapper', 'data-aos-once', $settings[ 'aos_animation_once' ] == 'yes' ? 'true' : 'false' );
				}

			}

		}

	}

}