<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Font Awesome 6 PRO Icons Integration
 *
 * @author: Mountain-Themes
 * @version: 2.0.0
 */

class Icons_Integration {

    public function __construct() { 
        add_filter( 'elementor/icons_manager/additional_tabs', array( $this, 'add_material_icons_tabs' ) );
    }

public function add_material_icons_tabs( $tabs = array() ) {
 
        $tabs['faprosolid'] = array(
            'name'          => 'faprosolid',
            'label'         => esc_html__( 'Font Awesome Pro 6 Solid', 'expedition-plugin' ),
            'labelIcon'     => 'fa-solid fa-fill-drip',
            'prefix'        => 'fa-solid ',
            'displayPrefix' => 'solid',
            'url'           => plugin_dir_url( __FILE__ ) . '../assets/fonts/faprosolid/faprosolid.css',
            'fetchJson'     => plugin_dir_url( __FILE__ ) . '../assets/fonts/faprosolid/faprosolid.json',
            'ver'           => '6.4.2',
        );

        $tabs['faproregular'] = array(
            'name'          => 'faproregular',
            'label'         => esc_html__( 'Font Awesome Pro 6 Regular', 'expedition-plugin' ),
            'labelIcon'     => 'fa-regular fa-fill-drip',
            'prefix'        => 'fa-regular ',
            'displayPrefix' => 'regular',
            'url'           => plugin_dir_url( __FILE__ ) . '../assets/fonts/faproregular/faproregular.css',
            'fetchJson'     => plugin_dir_url( __FILE__ ) . '../assets/fonts/faproregular/faproregular.json',
            'ver'           => '6.4.2',
        );

        $tabs['faprolight'] = array(
            'name'          => 'faprolight',
            'label'         => esc_html__( 'Font Awesome Pro 6 Light', 'expedition-plugin' ),
            'labelIcon'     => 'fa-light fa-fill-drip',
            'prefix'        => 'fa-light ',
            'displayPrefix' => 'light',
            'url'           => plugin_dir_url( __FILE__ ) . '../assets/fonts/faprolight/faprolight.css',
            'fetchJson'     => plugin_dir_url( __FILE__ ) . '../assets/fonts/faprolight/faprolight.json',
            'ver'           => '6.4.2',
        );

        $tabs['faprothin'] = array(
            'name'          => 'faprothin',
            'label'         => esc_html__( 'Font Awesome Pro 6 Thin', 'expedition-plugin' ),
            'labelIcon'     => 'fa-thin fa-fill-drip',
            'prefix'        => 'fa-thin ',
            'displayPrefix' => 'thin',
            'url'           => plugin_dir_url( __FILE__ ) . '../assets/fonts/faprothin/faprothin.css',
            'fetchJson'     => plugin_dir_url( __FILE__ ) . '../assets/fonts/faprothin/faprothin.json',
            'ver'           => '6.4.2',
        );

        $tabs['faproduotone'] = array(
            'name'          => 'faproduotone',
            'label'         => esc_html__( 'Font Awesome Pro 6 Duotone', 'expedition-plugin' ),
            'labelIcon'     => 'fa-duotone fa-fill-drip',
            'prefix'        => 'fa-duotone ',
            'displayPrefix' => 'duotone',
            'url'           => plugin_dir_url( __FILE__ ) . '../assets/fonts/faproduotone/faproduotone.css',
            'fetchJson'     => plugin_dir_url( __FILE__ ) . '../assets/fonts/faproduotone/faproduotone.json',
            'ver'           => '6.4.2',
        );

        $tabs['faprobrands'] = array(
            'name'          => 'faprobrands',
            'label'         => esc_html__( 'Font Awesome Pro 6 Brands', 'expedition-plugin' ),
            'labelIcon'     => 'fa-brands fa-instagram',
            'prefix'        => 'fa-brands ',
            'displayPrefix' => 'brands',
            'url'           => plugin_dir_url( __FILE__ ) . '../assets/fonts/faprobrands/faprobrands.css',
            'fetchJson'     => plugin_dir_url( __FILE__ ) . '../assets/fonts/faprobrands/faprobrands.json',
            'ver'           => '6.4.2',
        );

    return $tabs;
}

}
