<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Expedition Blog Widget
 *
 * @author: Mountain-Themes
 * @version: 2.0
 */

class Expedition_Blog_Widget extends Widget_Base {

	public function get_name() {
		return 'expedition-blog';
	}

	public function get_title() {
		return esc_html__( 'Blog', 'expedition-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax expedition-badge';
	}

	public function get_categories() {
		return [ 'expedition-category' ];
	}

	public function get_keywords() {
		return [ 'blog', 'posts' ];
	}

	/**
	 * Register widget controls.
	 */

	protected function register_controls() {
		

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'expedition-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'variants_styles',
			[
				'label' => esc_html__( 'Variants styles', 'expedition-plugin' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'classic',
				'options' => [
					'classic'  => esc_html__( 'Classic', 'expedition-plugin' ),
					'minimal' => esc_html__( 'Minimal', 'expedition-plugin' ),
                    'creative' => esc_html__( 'Creative', 'expedition-plugin' ),
				],
			]
		);

		$this->add_control(
			'total_post',
			[
				'label' => esc_html__( 'Total Post', 'expedition-plugin' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 4,
			]
		);	

        $this->add_control(
			'number_grids',
			[
				'label' => esc_html__( 'Number Of Grids', 'expedition-plugin' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'blog-column-one',
				'options' => [
					'blog-column-one'  => esc_html__( 'One Grid', 'expedition-plugin' ),
					'blog-column-two' => esc_html__( 'Two Grid', 'expedition-plugin' ),
					'blog-column-three' => esc_html__( 'Three Grid', 'expedition-plugin' ),
				],
			]
		);

		$this->add_control(
			'animation_post', [
				'label' => esc_html__( 'Animation effect', 'expedition-plugin' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
                    'none' => esc_html__( 'None', 'expedition-plugin' ),
                    'wow bounce' => esc_html__( 'Bounce', 'expedition-plugin' ),
                    'wow flash' => esc_html__( 'Flash', 'expedition-plugin' ),
                    'wow pulse' => esc_html__( 'Pulse', 'expedition-plugin' ),
                    'wow rubberBand' => esc_html__( 'RubberBand', 'expedition-plugin' ),
                    'wow shake' => esc_html__( 'Shake', 'expedition-plugin' ),
                    'wow swing' => esc_html__( 'Swing', 'expedition-plugin' ),
                    'wow tada' => esc_html__( 'Tada', 'expedition-plugin' ),
                    'wow wobble' => esc_html__( 'Wobble', 'expedition-plugin' ),
                    'wow jello' => esc_html__( 'Jello', 'expedition-plugin' ),
                    'wow bounceIn' => esc_html__( 'BounceIn', 'expedition-plugin' ),
                    'wow bounceInDown' => esc_html__( 'BounceInDown', 'expedition-plugin' ),
                    'wow bounceInLeft' => esc_html__( 'BounceInLeft', 'expedition-plugin' ),
                    'wow bounceInRight' => esc_html__( 'BounceInRight', 'expedition-plugin' ),
                    'wow bounceInUp' => esc_html__( 'BounceInUp', 'expedition-plugin' ),
                    'wow fadeIn' => esc_html__( 'FadeIn', 'expedition-plugin' ),
                    'wow fadeInDown' => esc_html__( 'FadeInDown', 'expedition-plugin' ),
                    'wow fadeInDownBig' => esc_html__( 'FadeInDownBig', 'expedition-plugin' ),
                    'wow fadeInLeft' => esc_html__( 'FadeInLeft', 'expedition-plugin' ),
                    'wow fadeInLeftBig' => esc_html__( 'FadeInLeftBig', 'expedition-plugin' ),
                    'wow fadeInRight' => esc_html__( 'FadeInRight', 'expedition-plugin' ),
                    'wow fadeInRightBig' => esc_html__( 'FadeInRightBig', 'expedition-plugin' ),
                    'wow fadeInUp' => esc_html__( 'FadeInUp', 'expedition-plugin' ),
                    'wow fadeInUpBig' => esc_html__( 'FadeInUpBig', 'expedition-plugin' ),
                    'wow flip' => esc_html__( 'Flip', 'expedition-plugin' ),
                    'wow flipInX' => esc_html__( 'FlipInX', 'expedition-plugin' ),
                    'wow flipInY' => esc_html__( 'FlipInY', 'expedition-plugin' ),
                    'wow lightSpeedIn' => esc_html__( 'LightSpeedIn', 'expedition-plugin' ),
                    'wow rotateIn' => esc_html__( 'RotateIn', 'expedition-plugin' ),
                    'wow rotateInDownLeft' => esc_html__( 'RotateInDownLeft', 'expedition-plugin' ),
                    'wow rotateInDownRight' => esc_html__( 'RotateInDownRight', 'expedition-plugin' ),
                    'wow rotateInUpLeft' => esc_html__( 'RotateInUpLeft', 'expedition-plugin' ),
                    'wow rotateInUpRight' => esc_html__( 'RotateInUpRight', 'expedition-plugin' ),
                    'wow slideInUp' => esc_html__( 'SlideInUp', 'expedition-plugin' ),
                    'wow slideInDown' => esc_html__( 'SlideInDown', 'expedition-plugin' ),
                    'wow slideInLeft' => esc_html__( 'SlideInLeft', 'expedition-plugin' ),
                    'wow slideInRight' => esc_html__( 'SlideInRight', 'expedition-plugin' ),
                    'wow zoomIn' => esc_html__( 'ZoomIn', 'expedition-plugin' ),
                    'wow zoomInDown' => esc_html__( 'ZoomInDown', 'expedition-plugin' ),
                    'wow zoomInLeft' => esc_html__( 'ZoomInLeft', 'expedition-plugin' ),
                    'wow zoomInRight' => esc_html__( 'ZoomInRight', 'expedition-plugin' ),
                    'wow zoomInUp' => esc_html__( 'ZoomInUp', 'expedition-plugin' ),
                    'wow zoomOut' => esc_html__( 'ZoomOut', 'expedition-plugin' ),
                    'wow hinge' => esc_html__( 'Hinge', 'expedition-plugin' ),
                    'wow rollIn' => esc_html__( 'RollIn', 'expedition-plugin' ),
				],
				'default' => 'none',
				'separator' => 'before',
			]
		);

        $this->add_control(
			'pagination',
			[
				'label' => esc_html__( 'Pagination', 'expedition-plugin' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'classic',
				'options' => [
					'classic'  => esc_html__( 'Classic', 'expedition-plugin' ),
					'ajax' => esc_html__( 'Ajax', 'expedition-plugin' ),
                    'hide' => esc_html__( 'Hide', 'expedition-plugin' ),
				],
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {

		$settings = $this->get_settings_for_display();

        echo '<div class="blogContainer ajaxContainer isotope">';

        echo '<div class="gutter-sizer"></div>';
        

                $get_variants_styles = $settings['variants_styles'];
                $number_grids = $settings['number_grids'];
				$animation_post = $settings['animation_post'];
                $pagination = $settings['pagination'];
                $total_posts = $settings['total_post'];

                

                $paged = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);

                $args = array( 
                    'post_status' => 'publish',
                    'paged' => $paged, 
                    'post_type' => 'post', 
                    'posts_per_page' => ($pagination == 'hide' ? -1 : $total_posts)
                );
                
                global $loop;

                $loop = new \WP_Query( $args );

                if ( $loop->have_posts() ) : 

                    while ( $loop->have_posts() ) : $loop->the_post();  

                        if ( $get_variants_styles == 'classic' ) {

                            get_template_part( 'template-parts/blog/classic/content', get_post_format(), $args = array(
                                'grids'	=>	$number_grids,
								'animation' => $animation_post
                            ) );

                        }

                        if ( $get_variants_styles == 'minimal' ) {

                            get_template_part( 'template-parts/blog/minimal', '', $args = array(
                                'grids'	=>	$number_grids,
								'animation' => $animation_post
                            ) );

                        }

                        if ( $get_variants_styles == 'creative' ) {

                            get_template_part( 'template-parts/blog/creative', '', $args = array(
                                'grids'	=>	$number_grids,
								'animation' => $animation_post
                            ) );

                        }

                    endwhile;


        echo '</div>'; 
        
        ?>

                <?php if ( $pagination == 'ajax' ) : ?>

                    <?php expedition_ajax_load(); ?>

                    <!-- AJAX LOAD BUTTON -->
                    <div class="text-center load-more">
                    <a class="ajax-button"><i class="fa-duotone fa-spinner-third fa-spin"></i><span><?php esc_html_e('Load More', 'expedition-plugin' ); ?></span></a>
                    </div>
                    <!-- END AJAX LOAD BUTTON -->

                <?php endif; ?>


                <?php if ( $pagination == 'classic' ) : ?>

                <!-- CLASSIC PAGINATION -->
                <div class="pagination">
                <div class="nav-links">  
                            
                    <?php

                    $big = 999999999; // need an unlikely integer
                    echo paginate_links( array(
                    'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
                    'format' => '?paged=%#%',
                    'current' => max( 1, $paged ),
                    'total' => $loop->max_num_pages,
                    'show_all'     => false,
                    'prev_text'    => ('<i class="fa fa-angle-left"></i>'),
                    'next_text'    => ('<i class="fa fa-angle-right"></i>'),
                    'add_args' => false
                    ) );

                    ?>

                </div>
                </div>
                <!-- END CLASSIC PAGINATION -->

            <?php endif; ?>

        <?php 

            else :

                get_template_part( 'template-parts/content/content', 'none' );

            endif;

            wp_reset_postdata();

			?>

			<?php	

	}

}

Plugin::instance()->widgets_manager->register( new Expedition_Blog_Widget() );
