<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Expedition Contact Form Widget
 *
 * @author: Mountain-Themes
 * @version: 2.0.0
 */

class Expedition_Contact_Form_Widget extends Widget_Base {

	public function get_name() {
		return 'expedition-contact-form';
	}

	public function get_title() {
		return esc_html__( 'Contact Form', 'expedition-plugin' );
	}

	public function get_icon() {
		return 'eicon-mail expedition-badge';
	}

	public function get_categories() {
		return [ 'expedition-category' ];
	}

	public function get_keywords() {
		return [ 'contact', 'form', 'shortcode', 'email', 'letter' ];
	}

	/**
	 * Register widget controls.
	 */

	protected function register_controls() {
		

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Shortcode', 'expedition-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'shortcode',
			[
				'label' => esc_html__( 'Enter your shortcode contact form', 'expedition-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => '[contact-form-7 id="d1d73bc" title="Coming Soon form"]',
				'default' => '',
			]
		);


		$this->end_controls_section();


		$this->start_controls_section(
			'contact_form_styling',
			[
				'label' => esc_html__( 'Contact Form Style', 'expedition-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'button_typography',
				'label' => esc_html__( 'Typography button', 'expedition-plugin' ),
				'selector' => '{{WRAPPER}} .contact-form input[type=\'submit\']',
				'fields_options' => [
					'typography' => [
						'default' => 'yes'
					],
					// Inner control name
					'font_weight' => [
						// Inner control settings
						'default' => '600',
					],
					'font_family' => [
						'default' => 'Exo',
					],
					'text_transform' => [
						'default' => 'none',
					],
					'font_size'   => [
						'default' => [ 'unit' => 'px', 'size' => 14 ]
					],
				],
			]
		);

        $this->add_control(
			'contact_form_color_text',
			[
				'label' => esc_html__( 'Contact form text color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
                'selectors' => [
					'{{WRAPPER}} .contact-form input[type="email"]' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form input[type="text"]' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form textarea' => 'color: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'contact_form_border_color',
			[
				'label' => esc_html__( 'Contact form border color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
                'selectors' => [
					'{{WRAPPER}} .contact-form input[type="email"]' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form input[type="text"]' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form textarea' => 'border-color: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'contact_form_button_color',
			[
				'label' => esc_html__( 'Contact form button border color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
                'selectors' => [
					'{{WRAPPER}} .contact-form input[type=\'submit\']' => 'border-color: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'contact_form_button_bg_color',
			[
				'label' => esc_html__( 'Contact form button:hover background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'transparent',
                'selectors' => [
					'{{WRAPPER}} .contact-form input[type=\'submit\']:hover' => 'background: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'contact_form_button_text_color',
			[
				'label' => esc_html__( 'Contact form button text color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#fff',
                'selectors' => [
					'{{WRAPPER}} .contact-form input[type=\'submit\']' => 'color: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'contact_form_button_text_hover_color',
			[
				'label' => esc_html__( 'Contact form button hover text color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
                'selectors' => [
					'{{WRAPPER}} .contact-form input[type=\'submit\']:hover' => 'color: {{VALUE}};',
				],
			]
		);
    

        $this->add_control(
			'contact_form_placeholder_color',
			[
				'label' => esc_html__( 'Contact form placeholder color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
                'selectors' => [
					'{{WRAPPER}} .contact-form input[type="email"]::-webkit-input-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form input[type="email"]:-moz-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form input[type="email"]::-moz-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form input[type="email"]:-ms-input-placeholder' => 'color: {{VALUE}};',

                    '{{WRAPPER}} .contact-form input[type="text"]::-webkit-input-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form input[type="text"]:-moz-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form input[type="text"]::-moz-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form input[type="text"]:-ms-input-placeholder' => 'color: {{VALUE}};',

                    '{{WRAPPER}} .contact-form textarea::-webkit-input-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form textarea:-moz-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form textarea::-moz-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .contact-form textarea:-ms-input-placeholder' => 'color: {{VALUE}};',
                ],
			]
		);

		$this->add_control(
			'contact_form_color_response',
			[
				'label' => esc_html__( 'Contact form color text response', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
                'selectors' => [
					'{{WRAPPER}} .wpcf7-response-output' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {

		$shortcode = $this->get_settings_for_display( 'shortcode' );

		$shortcode = do_shortcode( shortcode_unautop( $shortcode ) );

        echo $shortcode;
	}

}

Plugin::instance()->widgets_manager->register( new Expedition_Contact_Form_Widget() );