<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Expedition Content Cover
 *
 * @author: Mountain-Themes
 * @version: 2.0.0
 */

class Expedition_Content_Cover_Widget extends Widget_Base {

	public function get_name() {
		return 'expedition-content-cover';
	}

	public function get_title() {
		return esc_html__( 'Content Cover', 'expedition-plugin' );
	}

	public function get_icon() {
		return 'eicon-custom expedition-badge';
	}

	public function get_categories() {
		return array( 'expedition-category' );
	}

    public function get_keywords() {
		return [ 'cover', 'animation', 'effects', 'background', 'logo' ];
	}

	public function get_script_depends() {

		if (\Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode()) {
			return [ 'backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'gsap-lib', 'matter-lib', 'pixi-lib', 'raf-lib', 'sketch-lib', 'lo-dash-lib', 'noise-lib', 'perlin-lib', 'filter-polyfill-lib', 'chroma-lib', 'doyle-spirals-lib', 'matrix-lib', 'gradientify-lib', 'shader-program-lib',
			'winter-effect', 'low-poly-effect', 'constellation-effect', 'particles-effect', 'rainbow-squares-effect', 'shooting-stars-effect', 
			'starfield-effect', 'gravity-effect', 'fireworks-effect', 'geometric-effect', 'bubbles-effect', 'mosaic-effect', 'rain-effect', 'surface-effect', 
			'magneto-effect', 'liquid-effect', 'confetti-effect', 'orbit-effect', 'swirl-effect', 'shift-effect', 'coalesce-effect', 'pipeline-effect', 
			'aurora-effect', 'stardust-effect', 'abstractart-effect', 'wave-effect', 'connections-effect', 'alien-effect', 'balls-effect', 'landscape-effect', 
			'boreal-sky-effect', 'colors-effect', 'confetti-lines-effect', 'stars-lines-effect', 'quantum-effect', 'information-effect', 'spacetime-effect', 'physics-effect', 
			'heuristics-effect', 'star-wars-effect', 'brick-tunnel-effect', 'triangle-effect', 'birds-effect', 'fog-effect', 'waves-effect', 'clouds-effect', 
			'globe-effect', 'net-effect', 'cells-effect', 'trunk-effect', 'topology-effect', 'dots-effect', 'rings-effect', 'halo-effect', 'glitch-effect', 'sand-particles-effect', 
			'hills-effect', 'plasmatic-effect', 'coronavirus-effect', 'water-droplet-effect', 'noisy-blobs-effect', 'nucleus-effect', 'tv-effect', 'floor-lava-effect', 'circuits-effect', 
			'turbulent-noise-effect', 'ribbons-effect', 'dotted-ocean-effect', 'discoid-effect', 'mechanical-grass-effect', 'gradient-animation-effect', 'funky-perlin-effect', 'snowfall-effect', 
			'trails-effect', 'blood-flow-effect', 'night-sky-effect', 'text-particles-effect', 'pixel-grid-effect', 'swarming-bugs-effect', 'audio-visualizers-effect', 'blobs-effect' ];
		}

		if ( $this->get_settings_for_display( 'background_style' ) === 'image' && $this->get_settings_for_display( 'background_effects' ) === 'none' ) {
			return ['backstretch-lib' ];
		} else if ( $this->get_settings_for_display( 'background_style' ) === 'slideshow' && $this->get_settings_for_display( 'background_effects' ) === 'none' ) {
			return ['backstretch-lib' ];
		} else if ( $this->get_settings_for_display( 'background_style' ) === 'youtube_video' && $this->get_settings_for_display( 'background_effects' ) === 'none') {
			return ['ytplayer-lib' ];
		} else if ( $this->get_settings_for_display( 'background_style' ) === 'vimeo_video' && $this->get_settings_for_display( 'background_effects' ) === 'none') {
			return ['vimeo-player-lib' ];
		} else if ( $this->get_settings_for_display( 'background_style' ) === 'html5_video' && $this->get_settings_for_display( 'background_effects' ) === 'none') {
			return ['html5-videobg-lib' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'winter' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'raf-lib', 'winter-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'low_poly' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'raf-lib', 'low-poly-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'constellation' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'raf-lib', 'constellation-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'particles' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'sketch-lib', 'particles-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'rainbow_squares' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'raf-lib', 'rainbow-squares-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'shooting_stars' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'raf-lib', 'shooting-stars-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'starfield' ) {
			return ['raf-lib', 'starfield-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'gravity' ) {
			return ['raf-lib', 'gravity-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'fireworks' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'raf-lib', 'fireworks-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'geometric' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'raf-lib', 'geometric-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'bubbles' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'raf-lib', 'bubbles-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'mosaic' ) {
			return ['raf-lib', 'mosaic-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'rain' ) {
			return ['rain-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'surface' ) {
			return ['raf-lib', 'surface-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'magneto' ) {
			return ['raf-lib', 'magneto-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'liquid' ) {
			return ['raf-lib', 'liquid-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'confetti' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'raf-lib', 'confetti-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'orbit' ) {
			return ['raf-lib', 'lo-dash-lib', 'orbit-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'swirl' ) {
			return ['raf-lib', 'noise-lib', 'swirl-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'shift' ) {
			return ['raf-lib', 'noise-lib', 'filter-polyfill-lib', 'shift-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'coalesce' ) {
			return ['raf-lib', 'noise-lib', 'coalesce-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'pipeline' ) {
			return ['raf-lib', 'noise-lib', 'pipeline-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'aurora' ) {
			return ['raf-lib', 'noise-lib', 'aurora-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'stardust' ) {
			return ['raf-lib', 'stardust-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'abstractart' ) {
			return ['raf-lib', 'abstractart-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'wave' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'pixi-lib', 'raf-lib', 'wave-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'connections' ) {
			return ['raf-lib', 'connections-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'alien' ) {
			return ['raf-lib', 'alien-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'balls' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'raf-lib', 'matter-lib', 'balls-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'landscape' ) {
			return ['raf-lib', 'landscape-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'boreal_sky' ) {
			return ['gsap-lib', 'boreal-sky-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'colors' ) {
			return ['gsap-lib', 'colors-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'confetti_lines' ) {
		 	return ['gsap-lib', 'confetti-lines-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'stars_lines' ) {
			return ['gsap-lib', 'stars-lines-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'quantum' ) {
			return ['perlin-lib', 'quantum-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'information' ) {
			return ['gsap-lib', 'information-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'spacetime' ) {
			return ['gsap-lib', 'spacetime-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'physics' ) {
			return ['gsap-lib', 'perlin-lib', 'physics-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'heuristics' ) {
			return ['perlin-lib', 'heuristics-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'star_wars' ) {
			return ['gsap-lib', 'star-wars-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'brick_tunnel' ) {
			return ['gsap-lib', 'brick-tunnel-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'triangle' ) {
			return ['gsap-lib', 'perlin-lib', 'triangle-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'birds' ) {
			return ['birds-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'fog' ) {
			return ['fog-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'waves' ) {
			return ['waves-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'clouds' ) {
			return ['clouds-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'globe' ) {
			return ['globe-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'net' ) {
			return ['net-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'cells' ) {
			return ['cells-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'trunk' ) {
			return ['trunk-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'topology' ) {
			return ['topology-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'dots' ) {
			return ['dots-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'rings' ) {
			return ['rings-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'halo' ) {
			return ['halo-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'glitch' ) {
			return ['glitch-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'sand_particles' ) {
			return ['sand-particles-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'hills' ) {
			return ['hills-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'plasmatic' ) {
			return ['raf-lib', 'plasmatic-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'coronavirus' ) {
			return ['raf-lib', 'coronavirus-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'audio_visualizers' ) {
			return ['gsap-lib', 'audio-visualizers-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'water_droplet' ) {
			return ['raf-lib', 'pixi-lib', 'water-droplet-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'noisy_blobs' ) {
			return ['raf-lib', 'noisy-blobs-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'nucleus' ) {
			return ['nucleus-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'tv' ) {
			return ['raf-lib', 'tv-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'floor_lava' ) {
			return ['chroma-lib', 'raf-lib', 'floor-lava-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'circuits' ) {
			return ['raf-lib', 'circuits-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'turbulent_noise' ) {
			return ['raf-lib', 'turbulent-noise-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'ribbons' ) {
			return ['raf-lib', 'ribbons-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'dotted_ocean' ) {
			return ['raf-lib', 'dotted-ocean-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'discoid' ) {
			return ['raf-lib', 'doyle-spirals-lib', 'discoid-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'mechanical_grass' ) {
			return ['matrix-lib', 'mechanical-grass-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'gradient_animation' ) {
			return ['gradientify-lib', 'gradient-animation-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'funky_perlin' ) {
			return ['funky-perlin-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'snowfall' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'raf-lib', 'shader-program-lib', 'snowfall-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'trails' ) {
			return ['raf-lib', 'trails-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'blood_flow' ) {
			return ['raf-lib', 'blood-flow-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'night_sky' ) {
			return ['raf-lib', 'night-sky-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'text_particles' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'raf-lib', 'text-particles-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'pixel_grid' ) {
			return ['raf-lib', 'pixel-grid-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'swarming_bugs' ) {
			return ['backstretch-lib', 'ytplayer-lib', 'vimeo-player-lib', 'html5-videobg-lib', 'sketch-lib', 'swarming-bugs-effect' ];
		} else if ( $this->get_settings_for_display( 'background_effects' ) === 'blobs' ) {
			return ['gsap-lib', 'blobs-effect' ];
		}

	}

	/**
	 * Register widget controls.
	 */

	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Content', 'expedition-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'logo_enabled',
			array(
				'type'      => Controls_Manager::SWITCHER,
				'label'     => esc_html__( 'Show Logo', 'expedition-plugin' ),
				'default'   => 'yes',
			)
		);

		$this->add_responsive_control(
			'alignment_logo', [
				'label' => esc_html__( 'Alignment', 'expedition-plugin' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'expedition-plugin' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'expedition-plugin' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'expedition-plugin' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'condition'  => array(
					'logo_enabled' => 'yes',
				),
				'default' => 'center',
			]
		);

		$this->add_control(
			'logo_image', [
				'label' => esc_html__( 'Image', 'expedition-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'condition'  => array(
					'logo_enabled' => 'yes',
				),
			]
		);

        $this->add_group_control(
			Group_Control_Image_Size::get_type(), [
				'name' => 'logo_image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'condition'  => array(
					'logo_enabled' => 'yes',
				),
			]
		);

		$this->add_control(
			'content_enabled',
			array(
				'type'      => Controls_Manager::SWITCHER,
				'label'     => esc_html__( 'Show Content', 'expedition-plugin' ),
				'default'   => 'yes',
				'separator' => 'before',
			)
		);

		$this->add_responsive_control(
			'alignment_content', [
				'label' => esc_html__( 'Alignment', 'expedition-plugin' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'expedition-plugin' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'expedition-plugin' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'expedition-plugin' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'condition'  => array(
					'content_enabled' => 'yes',
				),
				'default' => 'center',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'cover_title_typography',
				'label' => esc_html__( 'Typography title', 'expedition-plugin' ),
				'selector' => '{{WRAPPER}} .inner-content-box h1.custom-title',
				'condition'  => array(
					'content_enabled' => 'yes',
				),
				'fields_options' => [
					'typography' => [
						'default' => 'yes'
					],
					// Inner control name
					'font_weight' => [
						// Inner control settings
						'default' => '600',
					],
					'font_family' => [
						'default' => 'Aldrich',
					],
					'font_size'   => [
						'default' => [ 'unit' => 'em', 'size' => 1.8 ]
					],
					'text_transform' => [
						'default' => 'uppercase',
					],
	
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'cover_text_typography',
				'label' => esc_html__( 'Typography text', 'expedition-plugin' ),
				'selector' => '{{WRAPPER}} .inner-content-box p.custom-text',
				'condition'  => array(
					'content_enabled' => 'yes',
				),
				'fields_options' => [
					'typography' => [
						'default' => 'yes'
					],
					// Inner control name
					'font_weight' => [
						// Inner control settings
						'default' => '600',
					],
					'font_family' => [
						'default' => 'Exo',
					],
					'font_size'   => [
						'default' => [ 'unit' => 'px', 'size' => 13 ]
					],
					'text_transform' => [
						'default' => 'none',
					],
	
				],
			]
		);

		$this->add_control(
			'title_border_color',
			[
				'label' => esc_html__( 'Title border color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'selectors' => [
					'{{WRAPPER}} .inner-content-box h1.custom-title' => 'border-color: {{VALUE}};',
				],
				'condition'  => array(
					'content_enabled' => 'yes',
				),
			]
		);

		$this->add_control(
			'content_cover',
			array(
				'type'        => Controls_Manager::WYSIWYG,
				'description' => sprintf(
					'%1s <strong>%2s</strong> %3s',
					esc_html__( 'Use class', 'expedition-plugin' ),
					'has-drop-cap',
					esc_html__( 'on an HTML element to set a dropcap.', 'expedition-plugin' )
				),
				'condition'  => array(
					'content_enabled' => 'yes',
				),
				'default' => '<h1 class="custom-title">Our website is under construction</h1>
				<p class="custom-text">YOU WILL LOVE EXPEDITION AS MUCH AS WE DO. IT WILL MORPH PERFECTLY ON YOUR NEEDS!</p>',
			)
		);
		

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_section',
			array(
				'label' => esc_html__( 'Layout', 'expedition-plugin' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);

		$this->add_control(
			'animation_elements',
			array(
				'type'      => Controls_Manager::SWITCHER,
				'label'     => esc_html__( 'Show elements with animation', 'expedition-plugin' ),
				'default'   => 'yes',
			)
		);

		$this->add_control(
			'border_bottom_enabled',
			array(
				'type'      => Controls_Manager::SWITCHER,
				'label'     => esc_html__( 'Border Bottom', 'expedition-plugin' ),
				'default'   => 'yes',
			)
		);

		
        $this->add_control(
			'image_border_bottom',
			array(
				'label'     => esc_html__( 'Image Border Bottom', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
                'selectors' => [
                '{{WRAPPER}} .cover-section .border-bottom-box' => 'background-image: url( {{URL}} );background-position:bottom center, top left, center center;background-repeat:repeat-x, repeat, no-repeat;',
                ],
                'condition'  => array(
					'border_bottom_enabled' => 'yes',
				),
			)
		);


		$this->add_control(
			'mouse_scroll_enabled',
			array(
				'type'      => Controls_Manager::SWITCHER,
				'label'     => esc_html__( 'Show Mouse Scroll', 'expedition-plugin' ),
				'default'   => 'yes',
			)
		);

        $this->add_control(
			'mouse_link_id', [
				'label' => esc_html__( 'CSS ID', 'expedition-plugin' ),
				'type' => Controls_Manager::TEXT,
				'default' => ( '#services'),
				'label_block' => true,
                'ai' => [
                    'active' => false,
                ],
                'condition'  => array(
					'mouse_scroll_enabled' => 'yes',
				),
			]
		);

        $this->add_control(
			'mouse_border_color',
			[
				'label' => esc_html__( 'Mouse border color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'selectors' => [
					'{{WRAPPER}} .cover-section .mouse-wrapper .mouse a' => 'border-color: {{VALUE}};',
				],
                'condition'  => array(
					'mouse_scroll_enabled' => 'yes',
				),
			]
		);

        $this->add_control(
			'mouse_icon_color',
			[
				'label' => esc_html__( 'Mouse icon color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'selectors' => [
					'{{WRAPPER}} .cover-section .mouse-wrapper .mouse a' => 'color: {{VALUE}};',
				],
                'condition'  => array(
					'mouse_scroll_enabled' => 'yes',
				),
			]
		);

		$this->add_control(
			'mouse_bg_color',
			[
				'label' => esc_html__( 'Mouse background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'transparent',
				'selectors' => [
					'{{WRAPPER}} .cover-section .mouse-wrapper .mouse a' => 'background-color: {{VALUE}};',
				],
                'condition'  => array(
					'mouse_scroll_enabled' => 'yes',
				),
			]
		);

		$this->add_control(
			'mouse_bg_color_hover',
			[
				'label' => esc_html__( 'Mouse background color (hover)', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'selectors' => [
					'{{WRAPPER}} .cover-section .mouse-wrapper .mouse a:hover' => 'background-color: {{VALUE}};',
				],
                'condition'  => array(
					'mouse_scroll_enabled' => 'yes',
				),
			]
		);

		$this->add_control(
			'mouse_icon_color_hover',
			[
				'label' => esc_html__( 'Mouse icon color (hover)', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .cover-section .mouse-wrapper .mouse a:hover' => 'color: {{VALUE}};',
				],
                'condition'  => array(
					'mouse_scroll_enabled' => 'yes',
				),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'color_header_section',
			array(
				'label' => esc_html__( 'Color for header', 'expedition-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'menu_color',
			[
				'label' => esc_html__( 'Menu color on coming soon page', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000000',
				'description' => esc_html__( 'Other general settings color in "Customizer"', 'expedition-plugin' ),
			]
		);

		if ( class_exists( 'WooCommerce' ) ) :

			$this->add_control(
				'cart_color',
				[
					'label' => esc_html__( 'Cart color on coming soon page', 'expedition-plugin' ),
					'type' => Controls_Manager::COLOR,
					'default'   => '#000000',
					'description' => esc_html__( 'Other general settings color in "Customizer"', 'expedition-plugin' ),
				]
			);

			$this->add_control(
				'cart_text_color',
				[
					'label' => esc_html__( 'Color text count cart on coming soon page', 'expedition-plugin' ),
					'type' => Controls_Manager::COLOR,
					'default'   => '#fff',
					'description' => esc_html__( 'Other general settings color in "Customizer"', 'expedition-plugin' ),
				]
			);

			$this->add_control(
				'cart_bg_color',
				[
					'label' => esc_html__( 'Color background count on coming soon page', 'expedition-plugin' ),
					'type' => Controls_Manager::COLOR,
					'default'   => '#000000',
					'description' => esc_html__( 'Other general settings color in "Customizer"', 'expedition-plugin' ),
				]
			);

		endif;

		$this->end_controls_section();

        $this->start_controls_section(
			'background_section',
			array(
				'label' => esc_html__( 'Background', 'expedition-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'background_style',
			array(
				'label'   => esc_html__( 'Background Style', 'expedition-plugin' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'color' => array(
						'title' => esc_html__( 'Background Color', 'expedition-plugin' ),
						'icon'  => 'eicon-paint-brush',
					),
					'image' => array(
						'title' => esc_html__( 'Single Image', 'expedition-plugin' ),
						'icon'  => 'eicon-image-bold',
					),
                    'slideshow' => array(
						'title' => esc_html__( 'Image Slideshow', 'expedition-plugin' ),
						'icon'  => 'eicon-slideshow',
					),
					'youtube_video' => array(
						'title' => esc_html__( 'YouTube Background', 'expedition-plugin' ),
						'icon'  => 'eicon-video-camera',
					),
                    'vimeo_video' => array(
						'title' => esc_html__( 'Vimeo Background', 'expedition-plugin' ),
						'icon'  => 'eicon-video-camera',
					),
                    'html5_video' => array(
						'title' => esc_html__( 'HTML5 Video', 'expedition-plugin' ),
						'icon'  => 'eicon-video-camera',
					),
				),
				'condition' => [
                    'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
                ],
				'default' => 'color',
				'toggle'  => false,
			)
		);

        $this->add_control(
			'background_color',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000000',
				'selectors' => [
					'{{WRAPPER}} .cover-box' => 'background-color: {{VALUE}};',
				],
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'color',
				),
			]
		);

		$this->add_control(
			'background_image',
			array(
				'label'     => esc_html__( 'Choose Image', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
				'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'image',
				),
			)
		);

        $this->add_control(
			'background_slideshow',
			array(
				'label'     => esc_html__( 'Choose Images', 'expedition-plugin' ),
				'type'      => Controls_Manager::GALLERY,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
				'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'slideshow',
				),
			)
		);

        $this->add_control(
			'background_slideshow_duration',
			[
				'label' => esc_html__( 'Duration', 'expedition-plugin' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 3000,
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'slideshow',
				),
			]
		);	

        $this->add_control(
			'background_slideshow_fade',
			[
				'label' => esc_html__( 'Fade', 'expedition-plugin' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 750,
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'slideshow',
				),
			]
		);	

        // YouTube Video
        $this->add_control(
			'background_youtube_link', [
				'label' => esc_html__( 'Link', 'expedition-plugin' ),
                'description' => esc_html__( 'Example: https://www.youtube.com/watch?v=xEBC4Tn1v8A You need a The video ID: xEBC4Tn1v8A', 'expedition-plugin' ),
				'type' => Controls_Manager::TEXT,
                'ai' => [
                    'active' => false,
                ],
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'youtube_video',
				),
				'placeholder' => 'your short link',
			]
		);

        $this->add_control(
			'background_youtube_audio',
			array(
				'label'   => esc_html__( 'Mute the audio', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
                'condition' => [
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
                    'background_style' => 'youtube_video',
                ],
            ),
		);

		$this->add_control(
			'startat_youtube_audio',
			[
				'label' => esc_html__( 'StartAt', 'expedition-plugin' ),
				'type' => Controls_Manager::NUMBER,
				'description' => esc_html__( 'Set the seconds the video should start at.', 'expedition-plugin' ),
				'min' => 0,
				'step' => 1,
				'default' => 0,
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'youtube_video',
				),
			]
		);	

		$this->add_control(
			'stopat_youtube_audio',
			[
				'label' => esc_html__( 'StopAt', 'expedition-plugin' ),
				'type' => Controls_Manager::NUMBER,
				'description' => esc_html__( 'Set the seconds the video should stop at. If 0 is ignored.', 'expedition-plugin' ),
				'min' => 0,
				'step' => 1,
				'default' => 0,
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'youtube_video',
				),
			]
		);	

        $this->add_control(
			'background_youtube_cover_image',
			array(
				'label'     => esc_html__( 'YouTube Cover Image', 'expedition-plugin' ),
                'description' => esc_html__( 'The path to the image used as background for the player', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'youtube_video',
				),
			)
		);

		$this->add_control(
			'background_youtube_mobile_image',
			array(
				'label'     => esc_html__( 'YouTube Mobile Image', 'expedition-plugin' ),
                'description' => esc_html__( 'The path to the fallback image in case of background video on mobile devices', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'youtube_video',
				),
			)
		);

        // Vimeo Video
        $this->add_control(
			'background_vimeo_link', [
				'label' => esc_html__( 'Link', 'expedition-plugin' ),
                'description' => esc_html__( 'Example: https://vimeo.com/50522981 You need a The video ID: 50522981', 'expedition-plugin' ),
				'type' => Controls_Manager::TEXT,
                'ai' => [
                    'active' => false,
                ],
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'vimeo_video',
				),
				'placeholder' => 'your short link',
			]
		);

		$this->add_control(
			'startat_vimeo_audio',
			[
				'label' => esc_html__( 'StartAt', 'expedition-plugin' ),
				'type' => Controls_Manager::NUMBER,
				'description' => esc_html__( 'Set the seconds the video should start at.', 'expedition-plugin' ),
				'min' => 0,
				'step' => 1,
				'default' => 0,
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'vimeo_video',
				),
			]
		);	

		$this->add_control(
			'stopat_vimeo_audio',
			[
				'label' => esc_html__( 'StopAt', 'expedition-plugin' ),
				'type' => Controls_Manager::NUMBER,
				'description' => esc_html__( 'Set the seconds the video should stop at. If 0 is ignored.', 'expedition-plugin' ),
				'min' => 0,
				'step' => 1,
				'default' => 0,
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'vimeo_video',
				),
			]
		);	

        $this->add_control(
			'background_vimeo_mobile_image',
			array(
				'label'     => esc_html__( 'Vimeo Mobile Image', 'expedition-plugin' ),
                'description' => esc_html__( 'The path to the fallback image in case of background video on mobile devices', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'vimeo_video',
				),
			)
		);

		// HTML5 Video
		$this->add_control(
			'background_html5_video',
			array(
				'label'      => esc_html__( 'Choose Video', 'expedition-plugin' ),
				'type'       => Controls_Manager::MEDIA,
				'media_types' => [ 'video' ],
				'condition'  => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'html5_video',
				),
			)
		);

		$this->add_control(
			'background_poster_html5_video',
			array(
				'label'     => esc_html__( 'HTML5 Mobile Image', 'expedition-plugin' ),
                'description' => esc_html__( 'The path to the fallback image in case of background video on mobile devices', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
                'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'html5_video',
				),
			)
		);

		
        $this->add_control(
			'background_html5_audio',
			array(
				'label'   => esc_html__( 'Mute the audio', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
                'condition' => [
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
					'background_style' => 'html5_video',
                ],
            ),
		);
        
		// Overlay cover box
		$this->add_control(
			'background_color_overlay',
			array(
				'label'     => esc_html__( 'Overlay', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgba(255, 255, 255, 0.9)',
				'selectors' => [
					'{{WRAPPER}} .cover-section .image-box:after' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .cover-section .video-box:after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .cover-section .video-html5-box:after' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
                    'background_style' => [ 'image', 'slideshow', 'youtube_video', 'vimeo_video', 'html5_video' ],
                ],
			)
		);

        $this->add_control(
			'background_image_overlay',
			array(
				'label'     => esc_html__( 'Image Overlay', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
                'selectors' => [
                '{{WRAPPER}} .cover-section .image-box:after' => 'background-image: url( {{URL}} );',
                '{{WRAPPER}} .cover-section .video-box:after' => 'background-image: url( {{URL}} );',
				'{{WRAPPER}} .cover-section .video-html5-box:after' => 'background-image: url( {{URL}} );',
                ],
				'condition' => array(
					'background_effects' => [ 'none', 'winter', 'low_poly', 'constellation', 'particles', 'rainbow_squares', 'shooting_stars', 'fireworks', 'geometric', 'bubbles', 'confetti', 'wave', 'balls', 'snowfall', 'text_particles', 'swarming_bugs' ],
                    'background_style' => [ 'image', 'slideshow', 'youtube_video', 'vimeo_video', 'html5_video' ],
				),
			)
		);

		// List Effects
		$this->add_control(
			'destroy_effects',
			array(
				'label'   => esc_html__( 'Disable', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'description' => esc_html__( 'Disable all the effects in the Frontend Editor. Some WebGL effects are slow on older computers. WebGL effects use at least 5-10 times more memory.' , 'expedition-plugin' ),
				'default' => 'no',
				'separator' => 'before',
				'condition' => array(
					'background_effects!' => 'none',
				),
			),
		);

        $this->add_control(
			'background_effects', [
				'label' => esc_html__( 'Background Effects', 'expedition-plugin' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None', 'expedition-plugin' ),
					'winter' => esc_html__( 'Winter', 'expedition-plugin' ),
					'low_poly' => esc_html__( 'Low-Poly', 'expedition-plugin' ),
					'constellation' => esc_html__( 'Constellation', 'expedition-plugin' ),
                    'particles' => esc_html__( 'Particles', 'expedition-plugin' ),
					'rainbow_squares' => esc_html__( 'Rainbow Squares', 'expedition-plugin' ),
					'shooting_stars' => esc_html__( 'Shooting Stars', 'expedition-plugin' ),
					'starfield' => esc_html__( 'Starfield', 'expedition-plugin' ),
                    'gravity' => esc_html__( 'Gravity', 'expedition-plugin' ),
                    'fireworks' => esc_html__( 'Fireworks', 'expedition-plugin' ),
					'geometric' => esc_html__( 'Geometric', 'expedition-plugin' ),
					'bubbles' => esc_html__( 'Bubbles', 'expedition-plugin' ),
					'mosaic' => esc_html__( 'Mosaic', 'expedition-plugin' ),
                    'rain' => esc_html__( 'Rain', 'expedition-plugin' ),
					'surface' => esc_html__( 'Surface Shader', 'expedition-plugin' ),
					'magneto' => esc_html__( 'Magneto', 'expedition-plugin' ),
					'liquid' => esc_html__( 'Liquid', 'expedition-plugin' ),
                    'confetti' => esc_html__( 'Confetti', 'expedition-plugin' ),
					'orbit' => esc_html__( 'Orbit', 'expedition-plugin' ),
					'swirl' => esc_html__( 'Swirl', 'expedition-plugin' ),
					'shift' => esc_html__( 'Shift', 'expedition-plugin' ),
                    'coalesce' => esc_html__( 'Coalesce', 'expedition-plugin' ),
					'pipeline' => esc_html__( 'Pipeline', 'expedition-plugin' ),
					'aurora' => esc_html__( 'Aurora', 'expedition-plugin' ),
					'stardust' => esc_html__( 'Stardust', 'expedition-plugin' ),
                    'abstractart' => esc_html__( 'Abstract Art', 'expedition-plugin' ),
					'wave' => esc_html__( 'Wave Elements', 'expedition-plugin' ),
					'connections' => esc_html__( 'Connections', 'expedition-plugin' ),
					'alien' => esc_html__( 'Alien', 'expedition-plugin' ),
                    'balls' => esc_html__( 'Balls', 'expedition-plugin' ),
					'landscape' => esc_html__( 'Landscape', 'expedition-plugin' ),
					'boreal_sky' => esc_html__( 'Boreal Sky', 'expedition-plugin' ),
                    'colors' => esc_html__( 'Colors', 'expedition-plugin' ),
					'confetti_lines' => esc_html__( 'Confetti Lines', 'expedition-plugin' ),
					'stars_lines' => esc_html__( 'Stars Lines', 'expedition-plugin' ),
                    'quantum' => esc_html__( 'Quantum', 'expedition-plugin' ),
					'information' => esc_html__( 'Information', 'expedition-plugin' ),
					'spacetime' => esc_html__( 'Space Time', 'expedition-plugin' ),
					'physics' => esc_html__( 'Physics', 'expedition-plugin' ),
                    'heuristics' => esc_html__( 'Heuristics', 'expedition-plugin' ),
					'star_wars' => esc_html__( 'Star Wars', 'expedition-plugin' ),
					'brick_tunnel' => esc_html__( 'Brick Tunnel', 'expedition-plugin' ),
                    'triangle' => esc_html__( 'Triangle', 'expedition-plugin' ),
					'birds' => esc_html__( 'Birds', 'expedition-plugin' ),
					'fog' => esc_html__( 'Fog', 'expedition-plugin' ),
					'waves' => esc_html__( 'Waves', 'expedition-plugin' ),
					'clouds' => esc_html__( 'Clouds', 'expedition-plugin' ),
					'globe' => esc_html__( 'Globe', 'expedition-plugin' ),
					'net' => esc_html__( 'Net', 'expedition-plugin' ),
					'cells' => esc_html__( 'Cells', 'expedition-plugin' ),
					'trunk' => esc_html__( 'Trunk', 'expedition-plugin' ),
                    'topology' => esc_html__( 'Topology', 'expedition-plugin' ),
					'dots' => esc_html__( 'Dots', 'expedition-plugin' ),
					'rings' => esc_html__( 'Rings', 'expedition-plugin' ),
					'halo' => esc_html__( 'Halo', 'expedition-plugin' ),
					'coronavirus' => esc_html__( 'Coronavirus (COVID-19)', 'expedition-plugin' ),
                    'glitch' => esc_html__( 'Glitch', 'expedition-plugin' ),
					'sand_particles' => esc_html__( 'Sand Particles', 'expedition-plugin' ),
					'hills' => esc_html__( 'Hills', 'expedition-plugin' ),
                    'audio_visualizers' => esc_html__( 'Audio Visualizers', 'expedition-plugin' ),
					'blobs' => esc_html__( 'Blobs', 'expedition-plugin' ),
					'water_droplet' => esc_html__( 'Water Droplet', 'expedition-plugin' ),
					'plasmatic' => esc_html__( 'Plasmatic', 'expedition-plugin' ),
					'noisy_blobs' => esc_html__( 'Noisy Blobs', 'expedition-plugin' ),
					'nucleus' => esc_html__( 'Nucleus', 'expedition-plugin' ),
					'tv' => esc_html__( 'TV Static Noise', 'expedition-plugin' ),
					'floor_lava' => esc_html__( 'Floor is Lava', 'expedition-plugin' ),
					'circuits' => esc_html__( 'Circuits', 'expedition-plugin' ),
					'turbulent_noise' => esc_html__( 'Turbulent Noise', 'expedition-plugin' ),
					'ribbons' => esc_html__( 'Ribbons', 'expedition-plugin' ),
					'dotted_ocean' => esc_html__( 'Dotted Ocean', 'expedition-plugin' ),
					'discoid' => esc_html__( 'Discoid', 'expedition-plugin' ),
					'mechanical_grass' => esc_html__( 'Mechanical Grass', 'expedition-plugin' ),
					'gradient_animation' => esc_html__( 'Gradient Animation', 'expedition-plugin' ),
					'funky_perlin' => esc_html__( 'Funky Perlin', 'expedition-plugin' ),
					'snowfall' => esc_html__( 'Snowfall', 'expedition-plugin' ),
					'trails' => esc_html__( 'Trails', 'expedition-plugin' ),
					'blood_flow' => esc_html__( 'Blood Flow', 'expedition-plugin' ),
					'night_sky' => esc_html__( 'Night Sky', 'expedition-plugin' ),
					'text_particles' => esc_html__( 'Text Particles', 'expedition-plugin' ),
					'pixel_grid' => esc_html__( 'Pixel Grid', 'expedition-plugin' ),
					'swarming_bugs' => esc_html__( 'Swarming Bugs', 'expedition-plugin' ),
				],
				'default' => 'none',
			]
		);

		// Winter
		$this->add_control(
			'color_winter',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#FFFFFF',
				'alpha' => false,
                'condition' => array(
					'background_effects' => 'winter',
				),
			]
		);

		$this->add_control(
			'opacity_winter',
			[
				'label' => esc_html__( 'Opacity', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'max' => 1.0,
				'default' => 0.3,
				'condition' => array(
					'background_effects' => 'winter',
				),
			]
		);

		$this->add_control(
			'speed_winter',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.5,
				'condition' => array(
					'background_effects' => 'winter',
				),
			]
		);

		$this->add_control(
			'size_winter',
			[
				'label' => esc_html__( 'Size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 2,
	
				'condition' => array(
					'background_effects' => 'winter',
				),
			]
		);

		// Low Poly
		$this->add_control(
			'color_low_poly',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3D4A6E',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'low_poly',
				),
			]
		);

		$this->add_control(
			'opacity_low_poly',
			[
				'label' => esc_html__( 'Opacity', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'max' => 1.0,
				'default' => 0.4,
				'condition' => array(
					'background_effects' => 'low_poly',
				),
			]
		);

		$this->add_control(
			'density_low_poly',
			[
				'label' => esc_html__( 'Density', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 100,
				'condition' => array(
					'background_effects' => 'low_poly',
				),
			]
		);

		$this->add_control(
			'size_low_poly',
			[
				'label' => esc_html__( 'Size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.3,
	
				'condition' => array(
					'background_effects' => 'low_poly',
				),
			]
		);

		// Constellation
		$this->add_control(
			'color_constellation',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'constellation',
				),
			]
		);

		// Particles
		$repeaterParticles = new \Elementor\Repeater();

		$repeaterParticles->add_control(
			'list_color_particles',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'alpha' => false,
			]
		);

		$this->add_control(
			'list_particles',
			[
				'label' => esc_html__( 'List colors for Particles', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeaterParticles->get_controls(),
				'default' => [
					[
						'list_color_particles' => "#69D2E7",
					],
					[
						'list_color_particles' => "#A7DBD8",
					],
					[
						'list_color_particles' => "#E0E4CC",
					],
					[
						'list_color_particles' => "#F38630",
					],
					[
						'list_color_particles' => "#FA6900",
					],
					[
						'list_color_particles' => "#FF4E50",
					],
					[
						'list_color_particles' => "#F9D423",
					],
						
				],
				'condition' => array(
					'background_effects' => 'particles',
				),
				'title_field' => '{{{ list_color_particles }}}',
			]
		);


		$this->add_control(
			'number_particles',
			[
				'label' => esc_html__( 'Particles', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 280,
				'condition' => array(
					'background_effects' => 'particles',
				),
			]
		);

		// Rainbow Squares
		$this->add_control(
			'quantity_squares',
			[
				'label' => esc_html__( 'Quantity', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 164,
				'condition' => array(
					'background_effects' => 'rainbow_squares',
				),
			]
		);

		$this->add_control(
			'speed_squares',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 3,
				'condition' => array(
					'background_effects' => 'rainbow_squares',
				),
			]
		);

		$this->add_control(
			'size1_squares',
			[
				'label' => esc_html__( 'Size 1', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 16,
				'condition' => array(
					'background_effects' => 'rainbow_squares',
				),
			]
		);

		$this->add_control(
			'size2_squares',
			[
				'label' => esc_html__( 'Size 2', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 8,
				'condition' => array(
					'background_effects' => 'rainbow_squares',
				),
			]
		);

		// Shooting Stars
		$this->add_control(
			'partical_shooting_stars',
			[
				'label' => esc_html__( 'Particle life', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 300,
				'condition' => array(
					'background_effects' => 'shooting_stars',
				),
			]
		);

		$this->add_control(
			'probability_shooting_stars',
			[
				'label' => esc_html__( 'Particle render probability', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'max' => 0.99,
				'default' => 0.95,
				'condition' => array(
					'background_effects' => 'shooting_stars',
				),
			]
		);

		$this->add_control(
			'quantity_shooting_stars',
			[
				'label' => esc_html__( 'Quantity', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 50,
				'condition' => array(
					'background_effects' => 'shooting_stars',
				),
			]
		);

		$this->add_control(
			'size1_shooting_stars',
			[
				'label' => esc_html__( 'Size 1', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 50,
				'condition' => array(
					'background_effects' => 'shooting_stars',
				),
			]
		);

		$this->add_control(
			'size2_shooting_stars',
			[
				'label' => esc_html__( 'Size 2', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 25,
				'condition' => array(
					'background_effects' => 'shooting_stars',
				),
			]
		);

		$this->add_control(
			'border_color_shooting_stars',
			[
				'label' => esc_html__( 'Border Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'shooting_stars',
				),
			]
		);

		$this->add_control(
			'background_color_shooting_stars',
			[
				'label' => esc_html__( 'Background Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'shooting_stars',
				),
			]
		);

		// Starfield
		$this->add_control(
			'mouse_starfield',
			array(
				'label'   => esc_html__( 'Mouse move', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
                'condition' => [
					'background_effects' => 'starfield',
                ],
            ),
		);

		$this->add_control(
			'speed_starfield',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.10,
				'default' => 2,
				'condition' => array(
					'background_effects' => 'starfield',
				),
			]
		);

		$this->add_control(
			'quantity_starfield',
			[
				'label' => esc_html__( 'Density', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 512,
				'condition' => array(
					'background_effects' => 'starfield',
				),
			]
		);

		$this->add_control(
			'bg_color_starfield',
			[
				'label' => esc_html__( 'Background Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#0a0a0a',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'starfield',
				),
			]
		);

		$this->add_control(
			'star_color_starfield',
			[
				'label' => esc_html__( 'Star Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#dddddd',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'starfield',
				),
			]
		);

		// Gravity
		$this->add_control(
			'particle_size_gravity',
			[
				'label' => esc_html__( 'Particle size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.10,
				'step' => 0.10,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'gravity',
				),
			]
		);

		$this->add_control(
			'particle_color_gravity',
			[
				'label' => esc_html__( 'Particle color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'gravity',
				),
			]
		);

		$this->add_control(
			'point_size_gravity',
			[
				'label' => esc_html__( 'Point size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 10,
				'condition' => array(
					'background_effects' => 'gravity',
				),
			]
		);

		$this->add_control(
			'bg_color_gravity',
			[
				'label' => esc_html__( 'Background Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#0b3238',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'gravity',
				),
			]
		);

		$this->add_control(
			'point_border_color_gravity',
			[
				'label' => esc_html__( 'Point border color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#67B5BF',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'gravity',
				),
			]
		);

		$this->add_control(
			'bg_point_color_gravity',
			[
				'label' => esc_html__( 'Point background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000000',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'gravity',
				),
			]
		);

		// Fireworks
		$this->add_control(
			'speed_fireworks',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.10,
				'step' => 0.10,
				'default' => 2,
				'condition' => array(
					'background_effects' => 'fireworks',
				),
			]
		);

		$this->add_control(
			'minimum_fireworks',
			[
				'label' => esc_html__( 'Minimum amount of rocket', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 35,
				'condition' => array(
					'background_effects' => 'fireworks',
				),
			]
		);

		$this->add_control(
			'maximum_fireworks',
			[
				'label' => esc_html__( 'Maximum amount of rocket', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 50,
				'condition' => array(
					'background_effects' => 'fireworks',
				),
			]
		);

		// Geometric
		$this->add_control(
			'speed_geometric',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 6,
				'condition' => array(
					'background_effects' => 'geometric',
				),
			]
		);

		$this->add_control(
			'quantity_geometric',
			[
				'label' => esc_html__( 'Quantity', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 180,
				'condition' => array(
					'background_effects' => 'geometric',
				),
			]
		);

		$this->add_control(
			'hover_geometric',
			array(
				'label'   => esc_html__( 'Hover', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
                'condition' => [
					'background_effects' => 'geometric',
                ],
            ),
		);

		$this->add_control(
			'click_geometric',
			array(
				'label'   => esc_html__( 'Click', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'no',
                'condition' => [
					'background_effects' => 'geometric',
                ],
            ),
		);

		$this->add_control(
			'line_color_geometric',
			[
				'label' => esc_html__( 'Line color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3D4A6E',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'geometric',
				),
			]
		);

		$this->add_control(
			'circle_color_geometric',
			[
				'label' => esc_html__( 'Circle color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3D4A6E',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'geometric',
				),
			]
		);

		// Bubbles
		$this->add_control(
			'quantity_bubbles',
			[
				'label' => esc_html__( 'Quantity', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 25,
				'condition' => array(
					'background_effects' => 'bubbles',
				),
			]
		);

		$this->add_control(
			'color1_bubbles',
			[
				'label' => esc_html__( 'Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#0000d8',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'bubbles',
				),
			]
		);

		$this->add_control(
			'color2_bubbles',
			[
				'label' => esc_html__( 'Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#800080',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'bubbles',
				),
			]
		);

		$this->add_control(
			'color3_bubbles',
			[
				'label' => esc_html__( 'Color #3', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#FFA500',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'bubbles',
				),
			]
		);
		
		$this->add_control(
			'color4_bubbles',
			[
				'label' => esc_html__( 'Color #4', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#FF0000',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'bubbles',
				),
			]
		);

		$this->add_control(
			'color5_bubbles',
			[
				'label' => esc_html__( 'Color #5', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000000',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'bubbles',
				),
			]
		);

		// Mosaic
		$this->add_control(
			'side_mosaic',
			[
				'label' => esc_html__( 'Side', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 17,
				'condition' => array(
					'background_effects' => 'mosaic',
				),
			]
		);

		$this->add_control(
			'shine_mosaic',
			[
				'label' => esc_html__( 'Shine', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.10,
				'step' => 0.10,
				'default' => 2,
				'condition' => array(
					'background_effects' => 'mosaic',
				),
			]
		);

		$this->add_control(
			'base_time_mosaic',
			[
				'label' => esc_html__( 'Base time', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 40,
				'condition' => array(
					'background_effects' => 'mosaic',
				),
			]
		);

		$this->add_control(
			'added_time_mosaic',
			[
				'label' => esc_html__( 'Added time', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 10,
				'condition' => array(
					'background_effects' => 'mosaic',
				),
			]
		);

		$this->add_control(
			'bg_color_mosaic',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#1D3C3F',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'mosaic',
				),
			]
		);

		$this->add_control(
			'stroke_color_mosaic',
			[
				'label' => esc_html__( 'Stroke Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#1C1D23',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'mosaic',
				),
			]
		);

		$this->add_control(
			'color1_mosaic',
			[
				'label' => esc_html__( 'Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#79BDE0',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'mosaic',
				),
			]
		);

		$this->add_control(
			'color2_mosaic',
			[
				'label' => esc_html__( 'Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#E1EBF5',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'mosaic',
				),
			]
		);

		$this->add_control(
			'color3_mosaic',
			[
				'label' => esc_html__( 'Color #3', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#FFFFFF',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'mosaic',
				),
			]
		);

		// Rain
		$this->add_control(
			'style_rain',
			array(
				'label'   => esc_html__( 'Style Rain', 'expedition-plugin' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'image_rain' => array(
						'title' => esc_html__( 'Single Image', 'expedition-plugin' ),
						'icon'  => 'eicon-image-bold'
					),
					'video_rain' => array(
						'title' => esc_html__( 'Video', 'expedition-plugin' ),
						'icon'  => 'eicon-video-camera',
					),
				),
				'condition' => [
					'background_effects' => 'rain',
                ],
				'default' => 'image_rain',
				'toggle'  => false,
			)
		);

		$this->add_control(
			'background_image_rain',
			array(
				'label'     => esc_html__( 'Choose Image', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
				'condition' => array(
					'background_effects' => 'rain',
					'style_rain' => 'image_rain',
				),
			)
		);

		// Rain Video
		$this->add_control(
			'poster_rain',
			array(
				'label'     => esc_html__( 'Choose Poster for video', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
				'condition' => array(
					'background_effects' => 'rain',
					'style_rain' => 'video_rain',
				),
			)
		);

		$this->add_control(
			'video_rain',
			array(
				'label'      => esc_html__( 'Choose Video', 'expedition-plugin' ),
				'type'       => Controls_Manager::MEDIA,
				'media_types' => [ 'video' ],
				'condition'  => array(
					'background_effects' => 'rain',
					'style_rain' => 'video_rain',
				),
			)
		);

		// Surface
		$this->add_control(
			'speed_surface',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.0001,
				'max' => 0.0100,
				'step' => 0.0001,
				'default' => 0.0002,
				'condition' => array(
					'background_effects' => 'surface',
				),
			]
		);

		$this->add_control(
			'ambient_surface',
			[
				'label' => esc_html__( 'Ambient', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#880066',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'surface',
				),
			]
		);

		$this->add_control(
			'diffuse_surface',
			[
				'label' => esc_html__( 'Diffuse', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#168724',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'surface',
				),
			]
		);

		// Magneto
		$this->add_control(
			'bg_color_magneto',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#110031',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'magneto',
				),
			]
		);

		$this->add_control(
			'color1_magneto',
			[
				'label' => esc_html__( 'Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#694FB9',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'magneto',
				),
			]
		);

		$this->add_control(
			'color2_magneto',
			[
				'label' => esc_html__( 'Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#9B0127',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'magneto',
				),
			]
		);

		$this->add_control(
			'color3_magneto',
			[
				'label' => esc_html__( 'Color #3', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3CFBFF',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'magneto',
				),
			]
		);

		// Liquid
		$this->add_control(
			'background_color_liquid',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#17181B',
				'alpha'		=> false,
				'selectors' => [
					'{{WRAPPER}} #effect-box' => 'background-color: {{VALUE}};',
				],
                'condition' => array(
					'background_effects' => 'liquid',
				),
			]
		);

		$this->add_control(
			'color1_liquid',
			[
				'label' => esc_html__( 'Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'liquid',
				),
			]
		);

		$this->add_control(
			'color2_liquid',
			[
				'label' => esc_html__( 'Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#042179',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'liquid',
				),
			]
		);

		// Confetti
		$repeaterConfetti = new \Elementor\Repeater();

		$repeaterConfetti->add_control(
			'list_color_confetti',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'alpha' => false,
			]
		);

		$this->add_control(
			'list_confetti',
			[
				'label' => esc_html__( 'List colors for Confetti', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeaterConfetti->get_controls(),
				'default' => [
					[
						'list_color_confetti' => "#1e90ff",
					],
					[
						'list_color_confetti' => "#6b8e23",
					],
					[
						'list_color_confetti' => "#ffd700",
					],
					[
						'list_color_confetti' => "#ffc0cb",
					],
					[
						'list_color_confetti' => "#6a5acd",
					],
					[
						'list_color_confetti' => "#add8e6",
					],
					[
						'list_color_confetti' => "#ee82ee",
					],
					[
						'list_color_confetti' => "#98fb98",
					],
					[
						'list_color_confetti' => "#4682b4",
					],
					[
						'list_color_confetti' => "#f4a460",
					],
					[
						'list_color_confetti' => "#d2691e",
					],
					[
						'list_color_confetti' => "#dc143c",
					],
						
				],
				'condition' => array(
					'background_effects' => 'confetti',
				),
				'title_field' => '{{{ list_color_confetti }}}',
			]
		);


		$this->add_control(
			'particles_confetti',
			[
				'label' => esc_html__( 'Particles', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 150,
				'condition' => array(
					'background_effects' => 'confetti',
				),
			]
		);

		// Orbit
		$this->add_control(
			'count_orbit',
			[
				'label' => esc_html__( 'Count', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 25,
				'condition' => array(
					'background_effects' => 'orbit',
				),
			]
		);

		$this->add_control(
			'speed_orbit',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.3,
				'condition' => array(
					'background_effects' => 'orbit',
				),
			]
		);

		$this->add_control(
			'radius_orbit',
			[
				'label' => esc_html__( 'Radius', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 6,
				'condition' => array(
					'background_effects' => 'orbit',
				),
			]
		);

		$this->add_control(
			'size_orbit',
			[
				'label' => esc_html__( 'Size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 15,
				'condition' => array(
					'background_effects' => 'orbit',
				),
			]
		);

		$this->add_control(
			'maxdistance_orbit',
			[
				'label' => esc_html__( 'Max Distance', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 100,
				'condition' => array(
					'background_effects' => 'orbit',
				),
			]
		);

		$this->add_control(
			'color_orbit',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#08003d',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'orbit',
				),
			]
		);

		$this->add_control(
			'bg_color_orbit',
			[
				'label' => esc_html__( 'Background', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#0e003d',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'orbit',
				),
			]
		);

		$this->add_control(
			'bg2_color_orbit',
			[
				'label' => esc_html__( 'Background #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#0e003d',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'orbit',
				),
			]
		);

		// Swirl
		$this->add_control(
			'particles_swirl',
			[
				'label' => esc_html__( 'Particles', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 700,
				'condition' => array(
					'background_effects' => 'swirl',
				),
			]
		);

		$this->add_control(
			'speed_swirl',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.1,
				'condition' => array(
					'background_effects' => 'swirl',
				),
			]
		);

		$this->add_control(
			'bg_color_swirl',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#131119',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'swirl',
				),
			]
		);

		// Shift
		$this->add_control(
			'speed_shift',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.1,
				'condition' => array(
					'background_effects' => 'shift',
				),
			]
		);

		$this->add_control(
			'circle_count_shift',
			[
				'label' => esc_html__( 'Circle count', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 150,
				'condition' => array(
					'background_effects' => 'shift',
				),
			]
		);

		$this->add_control(
			'color_shift',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000000',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'shift',
				),
			]
		);

		// Coalesce
		$this->add_control(
			'speed_coalesce',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.1,
				'condition' => array(
					'background_effects' => 'coalesce',
				),
			]
		);

		$this->add_control(
			'particles_count_coalesce',
			[
				'label' => esc_html__( 'Particles count', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 700,
				'condition' => array(
					'background_effects' => 'coalesce',
				),
			]
		);

		$this->add_control(
			'color_coalesce',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#1E1C1C',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'coalesce',
				),
			]
		);

		// Pipeline
		$this->add_control(
			'speed_pipeline',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.5,
				'condition' => array(
					'background_effects' => 'pipeline',
				),
			]
		);

		$this->add_control(
			'pipeline_count_pipeline',
			[
				'label' => esc_html__( 'Pipeline count', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 30,
				'condition' => array(
					'background_effects' => 'pipeline',
				),
			]
		);

		$this->add_control(
			'color_pipeline',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#1E1E1E',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'pipeline',
				),
			]
		);

		
		// Aurora
		$this->add_control(
			'speed_aurora',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.001,
				'step' => 0.001,
				'default' => 0.05,
				'condition' => array(
					'background_effects' => 'aurora',
				),
			]
		);

		$this->add_control(
			'count_aurora',
			[
				'label' => esc_html__( 'Ray count', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 300,
				'condition' => array(
					'background_effects' => 'aurora',
				),
			]
		);

		$this->add_control(
			'color_aurora',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#24131F',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'aurora',
				),
			]
		);

		// Stardust
		$this->add_control(
			'particle_stardust',
			[
				'label' => esc_html__( 'Particle color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#ff417d',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'stardust',
				),
			]
		);

		$this->add_control(
			'micro_stardust',
			[
				'label' => esc_html__( 'Micro color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#4EFCFE',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'stardust',
				),
			]
		);
		
		$this->add_control(
			'gradient_stardust',
			[
				'label' => esc_html__( 'Gradient color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#522A72',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'stardust',
				),
			]
		);

		$this->add_control(
			'gradient2_stardust',
			[
				'label' => esc_html__( 'Gradient #2 color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#1A0E04',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'stardust',
				),
			]
		);

		// Abstract Art
		$this->add_control(
			'frequency_abstractart',
			[
				'label' => esc_html__( 'Frequency', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 200,
				'condition' => array(
					'background_effects' => 'abstractart',
				),
			]
		);

		$this->add_control(
			'color_abstractart',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#36fcfa',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'abstractart',
				),
			]
		);

		$this->add_control(
			'color2_abstractart',
			[
				'label' => esc_html__( 'Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#E5483F',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'abstractart',
				),
			]
		);

		$this->add_control(
			'background_abstractart',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000042',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'abstractart',
				),
			]
		);
		
		// Wave
		$this->add_control(
			'speed_wave',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 5,
				'condition' => array(
					'background_effects' => 'wave',
				),
			]
		);

		$repeaterWave = new \Elementor\Repeater();

		$repeaterWave->add_control(
			'list_images_wave',
			[
				'label'     => esc_html__( 'Choose Image', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
			]
		);

		$this->add_control(
			'list_wave',
			[
				'label' => esc_html__( 'List images for Wave', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeaterWave->get_controls(),
				'default' => [
					[
						'list_images_wave' => [ 'url' => Utils::get_placeholder_image_src() ],
					],
						
				],
				'condition' => array(
					'background_effects' => 'wave',
				),
				
			]
		);

		// Connections
		$repeaterConnections = new \Elementor\Repeater();

		$repeaterConnections->add_control(
			'list_color_connections',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'alpha' => false,
			]
		);

		$this->add_control(
			'list_connections',
			[
				'label' => esc_html__( 'List colors for Connections', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeaterConnections->get_controls(),
				'default' => [
					[
						'list_color_connections' => "#feea00",
					],
					[
						'list_color_connections' => "#a9df85",
					],
					[
						'list_color_connections' => "#5dc0ad",
					],
					[
						'list_color_connections' => "#ff9a00",
					],
					[
						'list_color_connections' => "#fa3f20",
					],
						
				],
				'condition' => array(
					'background_effects' => 'connections',
				),
				'title_field' => '{{{ list_color_connections }}}',
			]
		);

		$this->add_control(
			'background_connections',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#111111',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'connections',
				),
			]
		);

		$this->add_control(
			'strokestyle_connections',
			[
				'label' => esc_html__( 'Stroke Style', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3f47ff',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'connections',
				),
			]
		);

		$this->add_control(
			'linewidth_connections',
			[
				'label' => esc_html__( 'Line Width', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.45,
				'condition' => array(
					'background_effects' => 'connections',
				),
			]
		);

		$this->add_control(
			'frequency_connections',
			[
				'label' => esc_html__( 'Frequency', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 100,
				'condition' => array(
					'background_effects' => 'connections',
				),
			]
		);

		$this->add_control(
			'particles_connections',
			[
				'label' => esc_html__( 'Particles', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 300,
				'condition' => array(
					'background_effects' => 'connections',
				),
			]
		);

		// Alien
		$this->add_control(
			'color_alien',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#2E4765',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'alien',
				),
			]
		);

		$this->add_control(
			'color2_alien',
			[
				'label' => esc_html__( 'Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#b5ff00',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'alien',
				),
			]
		);

		
		$this->add_control(
			'color3_alien',
			[
				'label' => esc_html__( 'Color #3', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#2E4765',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'alien',
				),
			]
		);

		$this->add_control(
			'background_alien',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000155',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'alien',
				),
			]
		);

		$this->add_control(
			'background2_alien',
			[
				'label' => esc_html__( 'Background color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000021',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'alien',
				),
			]
		);

		$this->add_control(
			'particles_alien',
			[
				'label' => esc_html__( 'Particles', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 1000,
				'condition' => array(
					'background_effects' => 'alien',
				),
			]
		);

		// Balls
		$repeaterBalls = new \Elementor\Repeater();

		$repeaterBalls->add_control(
			'list_color_balls',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'alpha' => false,
			]
		);

		$this->add_control(
			'list_balls',
			[
				'label' => esc_html__( 'List colors for Balls', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeaterBalls->get_controls(),
				'default' => [
					[
						'list_color_balls' => "#4285F4",
					],
					[
						'list_color_balls' => "#EA4335",
					],
					[
						'list_color_balls' => "#FBBC05",
					],
					[
						'list_color_balls' => "#34A853",
					],
						
				],
				'condition' => array(
					'background_effects' => 'balls',
				),
				'title_field' => '{{{ list_color_balls }}}',
			]
		);

		$this->add_control(
			'number_balls',
			[
				'label' => esc_html__( 'Balls', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 230,
				'condition' => array(
					'background_effects' => 'balls',
				),
			]
		);

		// Landscape
		$this->add_control(
			'style_landscape',
			array(
				'label'   => esc_html__( 'Style Landscape', 'expedition-plugin' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'style1_landscape' => array(
						'title' => esc_html__( 'Style #1', 'expedition-plugin' ),
						'icon'  => 'eicon-paint-brush',
					),
					'style2_landscape' => array(
						'title' => esc_html__( 'Style #2', 'expedition-plugin' ),
						'icon'  => 'eicon-paint-brush',
					),
				),
				'condition' => [
                    'background_effects' => 'landscape',
                ],
				'default' => 'style1_landscape',
				'toggle'  => false,
			)
		);

		$this->add_control(
			'speed_landscape',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 3,
				'condition' => array(
                    'background_effects' => 'landscape',
					'style_landscape' => 'style1_landscape',
				),
			]
		);

		$this->add_control(
			'speed2_landscape',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 1,
				'condition' => array(
                    'background_effects' => 'landscape',
					'style_landscape' => 'style2_landscape',
				),
			]
		);

		// Boreal Sky
		$repeaterBorealSky = new \Elementor\Repeater();

		$repeaterBorealSky->add_control(
			'list_color_boreal',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'alpha' => false,
			]
		);

		$this->add_control(
			'list_boreal',
			[
				'label' => esc_html__( 'List colors for Boreal Sky', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeaterBorealSky->get_controls(),
				'default' => [
					[
						'list_color_boreal' => "#FFFAFF",
					],
					[
						'list_color_boreal' => "#0A2463",
					],
					[
						'list_color_boreal' => "#3E92CC",
					],
					[
						'list_color_boreal' => "#723bb7",
					],
					[
						'list_color_boreal' => "#efd28e",
					],
					[
						'list_color_boreal' => "#3f9d8c",
					],
						
				],
				'condition' => array(
					'background_effects' => 'boreal_sky',
				),
				'title_field' => '{{{ list_color_boreal }}}',
			]
		);

		$this->add_control(
			'background1_boreal',
			[
				'label' => esc_html__( 'Background color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#1f174e',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'boreal_sky',
				),
			]
		);

		$this->add_control(
			'background2_boreal',
			[
				'label' => esc_html__( 'Background color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#151436',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'boreal_sky',
				),
			]
		);

		$this->add_control(
			'background3_boreal',
			[
				'label' => esc_html__( 'Background color #3', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'boreal_sky',
				),
			]
		);

		// Сolors
		$repeaterСolors = new \Elementor\Repeater();

		$repeaterСolors->add_control(
			'list_color_colors',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'alpha' => false,
			]
		);

		$this->add_control(
			'list_colors',
			[
				'label' => esc_html__( 'List colors for Сolors', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeaterСolors->get_controls(),
				'default' => [
					[
						'list_color_colors' => "#dc202e",
					],
					[
						'list_color_colors' => "#f7ed99",
					],
					[
						'list_color_colors' => "#2d338b",
					],
					[
						'list_color_colors' => "#76306b",
					],
					[
						'list_color_colors' => "#ea8c2d",
					],
						
				],
				'condition' => array(
					'background_effects' => 'colors',
				),
				'title_field' => '{{{ list_color_colors }}}',
			]
		);

		$this->add_control(
			'background1_colors',
			[
				'label' => esc_html__( 'Background color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#143261',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'colors',
				),
			]
		);

		$this->add_control(
			'background2_colors',
			[
				'label' => esc_html__( 'Background color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#010915',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'colors',
				),
			]
		);

		// Confetti Lines
		$repeaterConfettiLines = new \Elementor\Repeater();

		$repeaterConfettiLines->add_control(
			'list_color_confetti_lines',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'alpha' => false,
			]
		);

		$this->add_control(
			'list_confetti_lines',
			[
				'label' => esc_html__( 'List colors for Confetti Lines', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeaterConfettiLines->get_controls(),
				'default' => [
					[
						'list_color_confetti_lines' => "#69D2E7",
					],
					[
						'list_color_confetti_lines' => "#A7DBD8",
					],
					[
						'list_color_confetti_lines' => "#E0E4CC",
					],
					[
						'list_color_confetti_lines' => "#F38630",
					],
					[
						'list_color_confetti_lines' => "#FA6900",
					],
					[
						'list_color_confetti_lines' => "#FF4E50",
					],
					[
						'list_color_confetti_lines' => "#F9D423",
					],
						
				],
				'condition' => array(
					'background_effects' => 'confetti_lines',
				),
				'title_field' => '{{{ list_color_confetti_lines }}}',
			]
		);

		$this->add_control(
			'background1_confetti_lines',
			[
				'label' => esc_html__( 'Background color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#0959b5',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'confetti_lines',
				),
			]
		);

		$this->add_control(
			'background2_confetti_lines',
			[
				'label' => esc_html__( 'Background color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#0959B5',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'confetti_lines',
				),
			]
		);

		// Stars Lines
		$this->add_control(
			'color_stars_lines',
			[
				'label' => esc_html__( 'Color stars', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#FFFFFF',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'stars_lines',
				),
			]
		);

		$this->add_control(
			'background1_stars_lines',
			[
				'label' => esc_html__( 'Background color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000000',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'stars_lines',
				),
			]
		);

		// Quantum
		$this->add_control(
			'color_quantum',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#31917C',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'quantum',
				),
			]
		);

		$this->add_control(
			'light_quantum',
			[
				'label' => esc_html__( 'Hemisphere Light #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#FFFFFF',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'quantum',
				),
			]
		);

		$this->add_control(
			'light2_quantum',
			[
				'label' => esc_html__( 'Hemisphere Light #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#0d0056',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'quantum',
				),
			]
		);

		$this->add_control(
			'light3_quantum',
			[
				'label' => esc_html__( 'Directional Light', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#0d5982',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'quantum',
				),
			]
		);

		$this->add_control(
			'material_quantum',
			[
				'label' => esc_html__( 'Mesh Phong Material', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#6C82BE',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'quantum',
				),
			]
		);

		// Information
		$this->add_control(
			'bg_information',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000000',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'information',
				),
			]
		);

		$this->add_control(
			'color_information',
			[
				'label' => esc_html__( 'Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#AC0700',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'information',
				),
			]
		);

		$this->add_control(
			'color2_information',
			[
				'label' => esc_html__( 'Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#04FF00',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'information',
				),
			]
		);

		$this->add_control(
			'color3_information',
			[
				'label' => esc_html__( 'Color #3', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#535353',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'information',
				),
			]
		);

		// Space Time
		$this->add_control(
			'bg_spacetime',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#59C384',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'spacetime',
				),
			]
		);

		// Physics
		$this->add_control(
			'color_physics',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#fe0e55',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'physics',
				),
			]
		);

		$this->add_control(
			'background_color_physics',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#17181B',
				'alpha'		=> false,
				'selectors' => [
					'{{WRAPPER}} #effect-box' => 'background-color: {{VALUE}};',
				],
                'condition' => array(
					'background_effects' => 'physics',
				),
			]
		);

		$this->add_control(
			'lines_physics',
			[
				'label' => esc_html__( 'Lines Amount', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 18,
				'condition' => array(
					'background_effects' => 'physics',
				),
			]
		);

		$this->add_control(
			'radius_physics',
			[
				'label' => esc_html__( 'Radius', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 100,
				'condition' => array(
					'background_effects' => 'physics',
				),
			]
		);

		$this->add_control(
			'vertices_physics',
			[
				'label' => esc_html__( 'Vertices Amount', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 50,
				'condition' => array(
					'background_effects' => 'physics',
				),
			]
		);

		// Heuristics
		$this->add_control(
			'color_heuristics',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#13756A',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'heuristics',
				),
			]
		);

		$this->add_control(
			'background_heuristics',
			[
				'label' => esc_html__( 'Background Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#0F1617',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'heuristics',
				),
			]
		);

		// Star Wars 
		$this->add_control(
			'texture_star_wars',
			array(
				'label'     => esc_html__( 'Texture', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
				'condition' => array(
					'background_effects' => 'star_wars',
				),
			)
		);

		// Brick Tunnel
		$this->add_control(
			'texture_brick_tunnel',
			array(
				'label'     => esc_html__( 'Texture', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
				'condition' => array(
					'background_effects' => 'brick_tunnel',
				),
			)
		);

		// Birds
		$this->add_control(
			'mouse_birds',
			array(
				'label'   => esc_html__( 'Mouse move', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => array(
                    'background_effects' => 'birds',
				),
            ),
		);

		$this->add_control(
			'bg_color_birds',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#061930',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'birds',
				),
			]
		);

		$this->add_control(
			'color_birds',
			[
				'label' => esc_html__( 'Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#FC7171',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'birds',
				),
			]
		);

		$this->add_control(
			'color2_birds',
			[
				'label' => esc_html__( 'Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#173D88',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'birds',
				),
			]
		);

		$this->add_control(
			'size_birds',
			[
				'label' => esc_html__( 'Bird Size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'birds',
				),
			]
		);

		$this->add_control(
			'wing_birds',
			[
				'label' => esc_html__( 'Wing Span', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 30,
				'condition' => array(
					'background_effects' => 'birds',
				),
			]
		);

		$this->add_control(
			'speed_birds',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 5,
				'condition' => array(
					'background_effects' => 'birds',
				),
			]
		);

		$this->add_control(
			'separation_birds',
			[
				'label' => esc_html__( 'Separation', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 20,
				'condition' => array(
					'background_effects' => 'birds',
				),
			]
		);

		$this->add_control(
			'alignment_birds',
			[
				'label' => esc_html__( 'Alignment', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 20,
				'condition' => array(
					'background_effects' => 'birds',
				),
			]
		);

		$this->add_control(
			'cohesion_birds',
			[
				'label' => esc_html__( 'Cohesion', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 20,
				'condition' => array(
					'background_effects' => 'birds',
				),
			]
		);

		$this->add_control(
			'quantity_birds',
			[
				'label' => esc_html__( 'Quantity', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 5,
				'condition' => array(
					'background_effects' => 'birds',
				),
			]
		);

		// Fog
		$this->add_control(
			'base_color_fog',
			[
				'label' => esc_html__( 'Base color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000000',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'fog',
				),
			]
		);

		$this->add_control(
			'highlight_color_fog',
			[
				'label' => esc_html__( 'Highlight color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#757575',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'fog',
				),
			]
		);

		$this->add_control(
			'midtone_color_fog',
			[
				'label' => esc_html__( 'Midtone color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'fog',
				),
			]
		);

		$this->add_control(
			'lowlight_color_fog',
			[
				'label' => esc_html__( 'Lowlight color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000000',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'fog',
				),
			]
		);

		$this->add_control(
			'blur_fog',
			[
				'label' => esc_html__( 'Blur Factor', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'max' => 1,
				'step' => 0.01,
				'default' => 0.6,
				'condition' => array(
					'background_effects' => 'fog',
				),
			]
		);

		$this->add_control(
			'zoom_fog',
			[
				'label' => esc_html__( 'Zoom', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'max' => 10,
				'step' => 0.01,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'fog',
				),
			]
		);
		
		$this->add_control(
			'speed_fog',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'fog',
				),
			]
		);

		// Waves
		$this->add_control(
			'mouse_waves',
			array(
				'label'   => esc_html__( 'Mouse move', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => array(
                    'background_effects' => 'waves',
				),
            ),
		);

		$this->add_control(
			'color_waves',
			[
				'label' => esc_html__( 'Base color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3D4A6E',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'waves',
				),
			]
		);

		$this->add_control(
			'shininess_waves',
			[
				'label' => esc_html__( 'Shininess', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'step' => 1,
				'default' => 30,
				'condition' => array(
					'background_effects' => 'waves',
				),
			]
		);

		$this->add_control(
			'height_waves',
			[
				'label' => esc_html__( 'Wave Height', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'step' => 1,
				'default' => 15,
				'condition' => array(
					'background_effects' => 'waves',
				),
			]
		);

		$this->add_control(
			'speed_waves',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'waves',
				),
			]
		);

		$this->add_control(
			'zoom_waves',
			[
				'label' => esc_html__( 'Zoom', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'waves',
				),
			]
		);

		// Clouds
		$this->add_control(
			'style_clouds',
			array(
				'label'   => esc_html__( 'Style Clouds', 'expedition-plugin' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'style1_clouds' => array(
						'title' => esc_html__( 'Style #1', 'expedition-plugin' ),
						'icon'  => 'eicon-paint-brush',
					),
					'style2_clouds' => array(
						'title' => esc_html__( 'Style #2', 'expedition-plugin' ),
						'icon'  => 'eicon-paint-brush',
					),
				),
				'condition' => [
					'background_effects' => 'clouds',
				],
				'default' => 'style1_clouds',
				'toggle'  => false,
			)
		);

		$this->add_control(
			'mouse_clouds',
			array(
				'label'   => esc_html__( 'Mouse move', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => array(
                    'background_effects' => 'clouds',
					'style_clouds' => 'style1_clouds'
				),
            ),
		);

		$this->add_control(
			'skycolor_clouds',
			[
				'label' => esc_html__( 'Sky color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#68b8d7',
				'alpha' => false,
				'condition' => array(
                    'background_effects' => 'clouds',
					'style_clouds' => 'style1_clouds'
				),
			]
		);

		$this->add_control(
			'cloudcolor_clouds',
			[
				'label' => esc_html__( 'Cloud color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#ADC1DE',
				'alpha' => false,
				'condition' => array(
                    'background_effects' => 'clouds',
					'style_clouds' => 'style1_clouds'
				),
			]
		);

		$this->add_control(
			'cloudshadowcolor_clouds',
			[
				'label' => esc_html__( 'Cloud Shadow color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#183550',
				'alpha' => false,
				'condition' => array(
                    'background_effects' => 'clouds',
					'style_clouds' => 'style1_clouds'
				),
			]
		);

		$this->add_control(
			'suncolor_clouds',
			[
				'label' => esc_html__( 'Sun color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#ff9919',
				'alpha' => false,
				'condition' => array(
                    'background_effects' => 'clouds',
					'style_clouds' => 'style1_clouds'
				),
			]
		);

		$this->add_control(
			'sunglarecolor_clouds',
			[
				'label' => esc_html__( 'Sun Glare color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#ff6633',
				'alpha' => false,
				'condition' => array(
                    'background_effects' => 'clouds',
					'style_clouds' => 'style1_clouds'
				),
			]
		);

		$this->add_control(
			'sunlightcolor_clouds',
			[
				'label' => esc_html__( 'Sun Light color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#ff9933',
				'alpha' => false,
				'condition' => array(
                    'background_effects' => 'clouds',
					'style_clouds' => 'style1_clouds'
				),
			]
		);

		$this->add_control(
			'speed_clouds',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'waves',
				),
			]
		);

		$this->add_control(
			'skycolor2_clouds',
			[
				'label' => esc_html__( 'Sky color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#5ca6ca',
				'alpha' => false,
				'condition' => array(
                    'background_effects' => 'clouds',
					'style_clouds' => 'style2_clouds'
				),
			]
		);

		$this->add_control(
			'cloudcolor2_clouds',
			[
				'label' => esc_html__( 'Cloud color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#334d80',
				'alpha' => false,
				'condition' => array(
                    'background_effects' => 'clouds',
					'style_clouds' => 'style2_clouds'
				),
			]
		);

		$this->add_control(
			'lightcolor2_clouds',
			[
				'label' => esc_html__( 'Cloud color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'alpha' => false,
				'condition' => array(
                    'background_effects' => 'clouds',
					'style_clouds' => 'style2_clouds'
				),
			]
		);

		$this->add_control(
			'speed2_clouds',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 1,
				'condition' => array(
                    'background_effects' => 'clouds',
					'style_clouds' => 'style2_clouds'
				),
			]
		);

		// Globe
		$this->add_control(
			'mouse_globe',
			array(
				'label'   => esc_html__( 'Mouse move', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => array(
                    'background_effects' => 'globe',
				),
            ),
		);

		$this->add_control(
			'size_globe',
			[
				'label' => esc_html__( 'Size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 1,
				'condition' => array(
                    'background_effects' => 'globe',
				),
			]
		);

		$this->add_control(
			'bg_globe',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#23153c',
				'alpha' => false,
				'condition' => array(
                    'background_effects' => 'globe',
				),
			]
		);

		$this->add_control(
			'color_globe',
			[
				'label' => esc_html__( 'Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#FF3F81',
				'alpha' => false,
				'condition' => array(
                    'background_effects' => 'globe',
				),
			]
		);

		$this->add_control(
			'color2_globe',
			[
				'label' => esc_html__( 'Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'alpha' => false,
				'condition' => array(
                    'background_effects' => 'globe',
				),
			]
		);

		// Net
		$this->add_control(
			'mouse_net',
			array(
				'label'   => esc_html__( 'Mouse move', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => array(
					'background_effects' => 'net',
				),
			),
		);

		$this->add_control(
			'dots_net',
			array(
				'label'   => esc_html__( 'Show Dots', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => array(
					'background_effects' => 'net',
				),
			),
		);

		$this->add_control(
			'points_net',
			[
				'label' => esc_html__( 'Points', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 10,
				'condition' => array(
					'background_effects' => 'net',
				),
			]
		);

		$this->add_control(
			'distance_net',
			[
				'label' => esc_html__( 'Max Distance', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 20,
				'condition' => array(
					'background_effects' => 'net',
				),
			]
		);

		$this->add_control(
			'spacing_net',
			[
				'label' => esc_html__( 'Spacing', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 15,
				'condition' => array(
					'background_effects' => 'net',
				),
			]
		);

		$this->add_control(
			'bg_net',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#23153c',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'net',
				),
			]
		);

		$this->add_control(
			'color_net',
			[
				'label' => esc_html__( 'Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#FF3F81',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'net',
				),
			]
		);

		// Cells
		$this->add_control(
			'size_cells',
			[
				'label' => esc_html__( 'Points', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 1.5,
				'condition' => array(
					'background_effects' => 'cells',
				),
			]
		);

		$this->add_control(
			'speed_cells',
			[
				'label' => esc_html__( 'Max Distance', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'cells',
				),
			]
		);

		$this->add_control(
			'color_cells',
			[
				'label' => esc_html__( 'Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#0c8c8c',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'cells',
				),
			]
		);

		$this->add_control(
			'color2_cells',
			[
				'label' => esc_html__( 'Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#f2e735',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'cells',
				),
			]
		);

		// Trunk
		$this->add_control(
			'spacing_trunk',
			[
				'label' => esc_html__( 'Spacing', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 4,
				'condition' => array(
					'background_effects' => 'trunk',
				),
			]
		);

		$this->add_control(
			'chaos_trunk',
			[
				'label' => esc_html__( 'Chaos', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'trunk',
				),
			]
		);

		$this->add_control(
			'bg_trunk',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#222426',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'trunk',
				),
			]
		);

		$this->add_control(
			'color_trunk',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#98465f',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'trunk',
				),
			]
		);

		// Topology
		$this->add_control(
			'bg_topology',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#0e2222',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'topology',
				),
			]
		);

		$this->add_control(
			'color_topology',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#a9964e',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'topology',
				),
			]
		);

		// Dots
		$this->add_control(
			'mouse_dots',
			array(
				'label'   => esc_html__( 'Mouse move', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => array(
					'background_effects' => 'dots',
				),
			),
		);

		$this->add_control(
			'lines_dots',
			array(
				'label'   => esc_html__( 'Show Lines', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => array(
					'background_effects' => 'dots',
				),
			),
		);

		$this->add_control(
			'size_dots',
			[
				'label' => esc_html__( 'Size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 3,
				'condition' => array(
					'background_effects' => 'dots',
				),
			]
		);

		$this->add_control(
			'spacing_dots',
			[
				'label' => esc_html__( 'Spacing', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00,
				'step' => 0.01,
				'default' => 35,
				'condition' => array(
					'background_effects' => 'dots',
				),
			]
		);

		$this->add_control(
			'bg_dots',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#222222',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'dots',
				),
			]
		);

		$this->add_control(
			'color_dots',
			[
				'label' => esc_html__( 'Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#ff8820',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'dots',
				),
			]
		);

		$this->add_control(
			'color2_dots',
			[
				'label' => esc_html__( 'Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#ff8820',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'dots',
				),
			]
		);

		// Rings
		$this->add_control(
			'mouse_rings',
			array(
				'label'   => esc_html__( 'Mouse move', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => array(
					'background_effects' => 'rings',
				),
			),
		);

		$this->add_control(
			'bg_rings',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#202428',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'rings',
				),
			]
		);
		
		$this->add_control(
			'color_rings',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#88ff00',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'rings',
				),
			]
		);

		$this->add_control(
			'alpha_rings',
			[
				'label' => esc_html__( 'Background alpha', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 1,
				'step' => 0.1,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'rings',
				),
			]
		);

		// Halo
		$this->add_control(
			'mouse_halo',
			array(
				'label'   => esc_html__( 'Mouse move', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => array(
					'background_effects' => 'halo',
				),
			),
		);

		$this->add_control(
			'bg_halo',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#131a43',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'halo',
				),
			]
		);

		$this->add_control(
			'base_halo',
			[
				'label' => esc_html__( 'Base color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#001a59',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'halo',
				),
			]
		);

		$this->add_control(
			'size_halo',
			[
				'label' => esc_html__( 'Size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'step' => 0.1,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'halo',
				),
			]
		);

		$this->add_control(
			'amplitude_halo',
			[
				'label' => esc_html__( 'Amplitude Factor', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'step' => 0.1,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'halo',
				),
			]
		);

		$this->add_control(
			'xoffset_halo',
			[
				'label' => esc_html__( 'xOffset', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => -0.5,
				'max' => 0.5,
				'step' => 0.01,
				'default' => 0,
				'condition' => array(
					'background_effects' => 'halo',
				),
			]
		);

		$this->add_control(
			'yoffset_halo',
			[
				'label' => esc_html__( 'yOffset', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => -0.5,
				'max' => 0.5,
				'step' => 0.01,
				'default' => 0,
				'condition' => array(
					'background_effects' => 'halo',
				),
			]
		);

		// Glitch
		$this->add_control(
			'image_glitch',
			array(
				'label'     => esc_html__( 'Image', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
				'condition' => array(
					'background_effects' => 'glitch',
				),
			)
		);

		// Sand Particles
		$this->add_control(
			'bg_sand_particles',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#111111',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'sand_particles',
				),
			]
		);

		// Hills
		$this->add_control(
			'bg_hills',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#d5d5d5',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'hills',
				),
			]
		);

		// Plasmatic
		$this->add_control(
			'particles_plasmatic',
			[
				'label' => esc_html__( 'Particles', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 25,
				'condition' => array(
					'background_effects' => 'plasmatic',
				),
			]
		);

		$this->add_control(
			'energy_plasmatic',
			[
				'label' => esc_html__( 'Energy', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.1,
				'step' => 0.1,
				'default' => 0.2,
				'condition' => array(
					'background_effects' => 'plasmatic',
				),
			]
		);

		$this->add_control(
			'blobiness_plasmatic',
			[
				'label' => esc_html__( 'Blobiness', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.1,
				'step' => 0.1,
				'default' => 1.6,
				'condition' => array(
					'background_effects' => 'plasmatic',
				),
			]
		);

		$this->add_control(
			'brightness_plasmatic',
			[
				'label' => esc_html__( 'Brightness', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.1,
				'step' => 0.1,
				'default' => 1.2,
				'condition' => array(
					'background_effects' => 'plasmatic',
				),
			]
		);

		// Coronavirus
		$this->add_control(
			'max_coronavirus',
			[
				'label' => esc_html__( 'Max', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 400,
				'condition' => array(
					'background_effects' => 'coronavirus',
				),
			]
		);

		$this->add_control(
			'blur_coronavirus',
			[
				'label' => esc_html__( 'Blur', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.1,
				'step' => 0.1,
				'default' => 3.0,
				'condition' => array(
					'background_effects' => 'coronavirus',
				),
			]
		);

		$this->add_control(
			'bg_coronavirus',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#102905',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'coronavirus',
				),
			]
		);

		$this->add_control(
			'color_coronavirus',
			[
				'label' => esc_html__( 'Color virus', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#54fc3f',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'coronavirus',
				),
			]
		);

		// Audio Visualizers
		$this->add_control(
			'style_audio_visualizers',
			array(
				'label'   => esc_html__( 'Style Visualizers', 'expedition-plugin' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'mix_audio_visualizers' => array(
						'title' => esc_html__( 'Auto Mix', 'expedition-plugin' ),
						'icon'  => 'eicon-paint-brush',
					),
					'box_audio_visualizers' => array(
						'title' => esc_html__( 'Box', 'expedition-plugin' ),
						'icon'  => 'eicon-paint-brush',
					),
					'cylinder_audio_visualizers' => array(
						'title' => esc_html__( 'Cylinder', 'expedition-plugin' ),
						'icon'  => 'eicon-paint-brush',
					),
				),
				'condition' => [
                    'background_effects' => 'audio_visualizers',
                ],
				'default' => 'mix_audio_visualizers',
				'toggle'  => false,
			)
		);
		$this->add_control(
			'background_audio_visualizers',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#080808',
				'alpha'		=> false,
				'selectors' => [
					'{{WRAPPER}} .cover-section' => 'background-color: {{VALUE}};',
				],
				'condition' => array(
					'background_effects' => 'audio_visualizers',
				),
			]
		);

		$this->add_control(
			'start_color_audio_visualizers',
			[
				'label' => esc_html__( 'Start color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#FF00FF',
				'alpha'		=> false,
				'condition' => array(
					'background_effects' => 'audio_visualizers',
				),
			]
		);

		$this->add_control(
			'end_color_audio_visualizers',
			[
				'label' => esc_html__( 'End color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#00ffff',
				'alpha'		=> false,
				'condition' => array(
					'background_effects' => 'audio_visualizers',
				),
			]
		);

		$this->add_control(
			'volume_audio_visualizers',
			[
				'label' => esc_html__( 'Volume', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.0,
				'max' => 1,
				'step' => 0.1,
				'default' => 0.5,
				'condition' => array(
					'background_effects' => 'audio_visualizers',
				),
			]
		);

		$this->add_control(
			'distance_audio_visualizers',
			[
				'label' => esc_html__( 'Distance', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.1,
				'step' => 0.1,
				'default' => 1.8,
				'condition' => array(
					'background_effects' => 'audio_visualizers',
				),
			]
		);

		$this->add_control(
			'loop_audio_visualizers',
			array(
				'label'   => esc_html__( 'Loop', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => array(
					'background_effects' => 'audio_visualizers',
				),
			),
		);

		$this->add_control(
			'file_link_audio_visualizers',
			[
				'label' => esc_html__( 'Upload your track', 'expedition-plugin' ),
				'type'  => 'file-select',
				'description' => esc_html__( 'Select file from media library or upload. Recommended upload music with beats. Analyzing audio data
				with beats.', 'expedition-plugin' ),
				'condition' => array(
					'background_effects' => 'audio_visualizers',
				),
			]
		);

		$this->add_control(
			'text_play_audio_visualizers',
			[
				'label' => esc_html__( 'Text play button', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Click to Play', 'expedition-plugin' ),
				'condition' => array(
					'background_effects' => 'audio_visualizers',
				),
			]
		);

		$this->add_control(
			'text_pause_audio_visualizers',
			[
				'label' => esc_html__( 'Text pause button', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Click to Pause', 'expedition-plugin' ),
				'condition' => array(
					'background_effects' => 'audio_visualizers',
				),
			]
		);

		// Water Droplet
		$this->add_control(
			'image_water_droplet',
			array(
				'label'     => esc_html__( 'Choose Images', 'expedition-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'description' => esc_html__( 'If effect not work, enabling hardware acceleration. Browser Chrome -> Settings (⌘,) -> Advanced -> System -> enable 1st', 'expedition-plugin' ),
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
				'condition' => array(
					'background_effects' => 'water_droplet',
				),
			)
		);

		$this->add_control(
			'gravity_water_droplet',
			[
				'label' => esc_html__( 'Maximum Mass Gravity', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 17,
				'condition' => array(
					'background_effects' => 'water_droplet',
				),
			]
		);

		$this->add_control(
			'mass_water_droplet',
			[
				'label' => esc_html__( 'Maximum Mass', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 21,
				'condition' => array(
					'background_effects' => 'water_droplet',
				),
			]
		);

		$this->add_control(
			'grow_water_droplet',
			[
				'label' => esc_html__( 'Droplet Grow Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'water_droplet',
				),
			]
		);

		$this->add_control(
			'shrink_water_droplet',
			[
				'label' => esc_html__( 'Droplet Shrink Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 2,
				'condition' => array(
					'background_effects' => 'water_droplet',
				),
			]
		);
		

		// Noisy Blobs
		$this->add_control(
			'speed_noisy_blobs',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.001,
				'step' => 0.001,
				'default' => 0.005,
				'condition' => array(
					'background_effects' => 'noisy_blobs',
				),
			]
		);

		$this->add_control(
			'scale_noisy_blobs',
			[
				'label' => esc_html__( 'Scale', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 50,
				'max' => 300,
				'step' => 1,
				'default' => 200,
				'condition' => array(
					'background_effects' => 'noisy_blobs',
				),
			]
		);

		$this->add_control(
			'dot_size_noisy_blobs',
			[
				'label' => esc_html__( 'Dot size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 15,
				'step' => 1,
				'default' => 8,
				'condition' => array(
					'background_effects' => 'noisy_blobs',
				),
			]
		);

		$this->add_control(
			'gap_noisy_blobs',
			[
				'label' => esc_html__( 'Gap', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 10,
				'step' => 1,
				'default' => 2,
				'condition' => array(
					'background_effects' => 'noisy_blobs',
				),
			]
		);

		$this->add_control(
			'hue_base_noisy_blobs',
			[
				'label' => esc_html__( 'Hue Base', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 360,
				'step' => 1,
				'default' => 200,
				'condition' => array(
					'background_effects' => 'noisy_blobs',
				),
			]
		);

		$this->add_control(
			'hue_range_noisy_blobs',
			[
				'label' => esc_html__( 'Hue Range', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 200,
				'step' => 1,
				'default' => 60,
				'condition' => array(
					'background_effects' => 'noisy_blobs',
				),
			]
		);

		$this->add_control(
			'shape_noisy_blobs',
			[
				'label' => esc_html__( 'Shape', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 3,
				'step' => 1,
				'default' => 0,
				'condition' => array(
					'background_effects' => 'noisy_blobs',
				),
			]
		);

		// Nucleus
		$this->add_control(
			'darker_nucleus',
			[
				'label' => esc_html__( 'Darker', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 3,
				'condition' => array(
					'background_effects' => 'nucleus',
				),
			]
		);

		$this->add_control(
			'particle_nucleus',
			[
				'label' => esc_html__( 'Particle', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 500,
				'condition' => array(
					'background_effects' => 'nucleus',
				),
			]
		);

		$this->add_control(
			'points_size_nucleus',
			[
				'label' => esc_html__( 'Points size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 10,
				'condition' => array(
					'background_effects' => 'nucleus',
				),
			]
		);
		
		$this->add_control(
			'space_nucleus',
			[
				'label' => esc_html__( 'Ladder space', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 4,
				'condition' => array(
					'background_effects' => 'nucleus',
				),
			]
		);

		$this->add_control(
			'speed_nucleus',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.1,
				'step' => 0.1,
				'default' => 0.7,
				'condition' => array(
					'background_effects' => 'nucleus',
				),
			]
		);

		// TV static noise
		$this->add_control(
			'noise_tv',
			[
				'label' => esc_html__( 'Noise size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.5,
				'step' => 0.1,
				'default' => 2.5,
				'condition' => array(
					'background_effects' => 'tv',
				),
			]
		);

		$this->add_control(
			'fps_tv',
			[
				'label' => esc_html__( 'FPS', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 50,
				'condition' => array(
					'background_effects' => 'tv',
				),
			]
		);

		$this->add_control(
			'scan_tv',
			[
				'label' => esc_html__( 'Scan Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 15,
				'condition' => array(
					'background_effects' => 'tv',
				),
			]
		);

		$this->add_control(
			'sample_tv',
			[
				'label' => esc_html__( 'Sample count', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 10,
				'condition' => array(
					'background_effects' => 'tv',
				),
			]
		);

		// Floor is Lava
		$this->add_control(
			'amplitudex_floor_lava',
			[
				'label' => esc_html__( 'amplitudeX', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 150,
				'condition' => array(
					'background_effects' => 'floor_lava',
				),
			]
		);

		$this->add_control(
			'amplitudey_floor_lava',
			[
				'label' => esc_html__( 'amplitudeY', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 20,
				'condition' => array(
					'background_effects' => 'floor_lava',
				),
			]
		);

		$this->add_control(
			'lines_floor_lava',
			[
				'label' => esc_html__( 'Lines', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 30,
				'condition' => array(
					'background_effects' => 'floor_lava',
				),
			]
		);

		$this->add_control(
			'start_color_floor_lava',
			[
				'label' => esc_html__( 'Start Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#500c44',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'floor_lava',
				),
			]
		);

		$this->add_control(
			'end_color_floor_lava',
			[
				'label' => esc_html__( 'End Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#b4d455',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'floor_lava',
				),
			]
		);

		// Circuits
		$this->add_control(
			'bg_color_circuits',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000000',
				'alpha' => true,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		$this->add_control(
			'stroke_color_circuits',
			[
				'label' => esc_html__( 'Stroke color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgba(59, 177, 188, 1)',
				'alpha' => true,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		$this->add_control(
			'circle_color_circuits',
			[
				'label' => esc_html__( 'Circle color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgba(59, 177, 188, .6)',
				'alpha' => true,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		$this->add_control(
			'move_circle_color_circuits',
			[
				'label' => esc_html__( 'Move circle color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#afe3e9',
				'alpha' => true,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		$this->add_control(
			'light_size_width_circuits',
			[
				'label' => esc_html__( 'Light size width', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 15,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		$this->add_control(
			'light_size_height_circuits',
			[
				'label' => esc_html__( 'Light size height', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 20,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		$this->add_control(
			'light_circle_color_circuits',
			[
				'label' => esc_html__( 'Light small circle color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgba(24, 129, 141, 0)',
				'alpha' => true,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		
		$this->add_control(
			'light2_circle_color_circuits',
			[
				'label' => esc_html__( 'Light small circle color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgba(24, 129, 141, .6)',
				'alpha' => true,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		$this->add_control(
			'superlight_circle_color_circuits',
			[
				'label' => esc_html__( 'Super light circle color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgba(37, 203, 223, 0)',
				'alpha' => true,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		$this->add_control(
			'superlight2_circle_color_circuits',
			[
				'label' => esc_html__( 'Super light circle color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgba(37, 203, 223, .4)',
				'alpha' => true,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		$this->add_control(
			'max_length_circuits',
			[
				'label' => esc_html__( 'Max Length', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 16,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		$this->add_control(
			'min_length_circuits',
			[
				'label' => esc_html__( 'Min Length', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 3,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		$this->add_control(
			'cell_size_circuits',
			[
				'label' => esc_html__( 'Cell Size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 10,
				'condition' => array(
					'background_effects' => 'circuits',
				),
			]
		);

		// Turbulent Noise
		$this->add_control(
			'time_turbulent_noise',
			[
				'label' => esc_html__( 'Time', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.00001,
				'step' => 0.00001,
				'default' => 0.00035,
				'condition' => array(
					'background_effects' => 'turbulent_noise',
				),
			]
		);

		$this->add_control(
			'red_turbulent_noise',
			[
				'label' => esc_html__( 'Red color for vector', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.15,
				'condition' => array(
					'background_effects' => 'turbulent_noise',
				),
			]
		);

		$this->add_control(
			'green_turbulent_noise',
			[
				'label' => esc_html__( 'Green color for vector', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.65,
				'condition' => array(
					'background_effects' => 'turbulent_noise',
				),
			]
		);

		$this->add_control(
			'blue_turbulent_noise',
			[
				'label' => esc_html__( 'Blue color for vector', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.95,
				'condition' => array(
					'background_effects' => 'turbulent_noise',
				),
			]
		);

		// Ribbons
		$this->add_control(
			'waves_ribbons',
			[
				'label' => esc_html__( 'Waves', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 3,
				'condition' => array(
					'background_effects' => 'ribbons',
				),
			]
		);

		$this->add_control(
			'width_ribbons',
			[
				'label' => esc_html__( 'Width', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 200,
				'condition' => array(
					'background_effects' => 'ribbons',
				),
			]
		);

		$this->add_control(
			'amplitude_ribbons',
			[
				'label' => esc_html__( 'Amplitude', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.1,
				'step' => 0.1,
				'default' => 0.5,
				'condition' => array(
					'background_effects' => 'ribbons',
				),
			]
		);

		$this->add_control(
			'rotation_ribbons',
			[
				'label' => esc_html__( 'Rotation', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 45,
				'condition' => array(
					'background_effects' => 'ribbons',
				),
			]
		);

		$this->add_control(
			'hue_ribbons',
			[
				'label' => esc_html__( 'Hue Color', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 11,
				'condition' => array(
					'background_effects' => 'ribbons',
				),
			]
		);

		$this->add_control(
			'hue2_ribbons',
			[
				'label' => esc_html__( 'Hue Color #2', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 14,
				'condition' => array(
					'background_effects' => 'ribbons',
				),
			]
		);

		$this->add_control(
			'speed_ribbons',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.001,
				'step' => 0.001,
				'default' => 0.004,
				'condition' => array(
					'background_effects' => 'ribbons',
				),
			]
		);

		$this->add_control(
			'speed2_ribbons',
			[
				'label' => esc_html__( 'Speed #2', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.001,
				'step' => 0.001,
				'default' => 0.008,
				'condition' => array(
					'background_effects' => 'ribbons',
				),
			]
		);

		// Dotted Ocean
		$this->add_control(
			'count_dotted_ocean',
			[
				'label' => esc_html__( 'Vertex Count', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1000,
				'step' => 1,
				'default' => 7000,
				'condition' => array(
					'background_effects' => 'dotted_ocean',
				),
			]
		);

		$this->add_control(
			'size_dotted_ocean',
			[
				'label' => esc_html__( 'Vertex Size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 3,
				'condition' => array(
					'background_effects' => 'dotted_ocean',
				),
			]
		);

		$this->add_control(
			'width_dotted_ocean',
			[
				'label' => esc_html__( 'Width', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 204,
				'condition' => array(
					'background_effects' => 'dotted_ocean',
				),
			]
		);

		$this->add_control(
			'height_dotted_ocean',
			[
				'label' => esc_html__( 'Height', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => -100,
				'step' => 1,
				'default' => -80,
				'condition' => array(
					'background_effects' => 'dotted_ocean',
				),
			]
		);

		$this->add_control(
			'grid_size_dotted_ocean',
			[
				'label' => esc_html__( 'Grid size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 32,
				'condition' => array(
					'background_effects' => 'dotted_ocean',
				),
			]
		);

		$this->add_control(
			'wave_size_dotted_ocean',
			[
				'label' => esc_html__( 'Wave size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 16,
				'condition' => array(
					'background_effects' => 'dotted_ocean',
				),
			]
		);

		$this->add_control(
			'perspective_dotted_ocean',
			[
				'label' => esc_html__( 'Perspective', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 100,
				'condition' => array(
					'background_effects' => 'dotted_ocean',
				),
			]
		);

		$this->add_control(
			'bg_color_dotted_ocean',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#00070A',
				'alpha' => false,
				'condition' => array(
					'background_effects' => 'dotted_ocean',
				),
			]
		);

		$this->add_control(
			'hsl_dotted_ocean',
			[
				'label' => esc_html__( 'HSL Color', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 180,
				'condition' => array(
					'background_effects' => 'dotted_ocean',
				),
			]
		);

		$this->add_control(
			'hsl2_dotted_ocean',
			[
				'label' => esc_html__( 'HSL Color #2', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 20,
				'condition' => array(
					'background_effects' => 'dotted_ocean',
				),
			]
		);

		// Discoid
		$this->add_control(
			'background_color_discoid',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#000815',
				'alpha'		=> false,
				'selectors' => [
					'{{WRAPPER}} .cover-section' => 'background-color: {{VALUE}};',
				],
				'condition' => array(
					'background_effects' => 'discoid',
				),
			]
		);

		$this->add_control(
			'background_color_overlay_discoid',
			array(
				'label'     => esc_html__( 'Overlay', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgba(0, 0, 0, 0.4)',
				'selectors' => [
					'{{WRAPPER}} #effect-box:after' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'background_effects' => 'discoid',
                ],
			)
		);

		$this->add_control(
			'background_image_overlay_discoid',
			array(
				'label'     => esc_html__( 'Image Overlay', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
                'selectors' => [
                '{{WRAPPER}} #effect-box:after' => 'background-image: url( {{URL}} );',
                ],
				'condition' => array(
					'background_effects' => 'discoid',
				),
			)
		);

		$repeaterDiscoid = new \Elementor\Repeater();

		$repeaterDiscoid->add_control(
			'list_color_discoid',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'alpha' => false,
			]
		);

		$this->add_control(
			'list_discoid',
			[
				'label' => esc_html__( 'List colors', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeaterDiscoid->get_controls(),
				'default' => [
					[
						'list_color_discoid' => "#EB1E23",
					],
					[
						'list_color_discoid' => "#D9DFD1",
					],
					[
						'list_color_discoid' => "#008F86",
					],
						
				],
				'condition' => array(
					'background_effects' => 'discoid',
				),
				'title_field' => '{{{ list_color_discoid }}}',
			]
		);

		$this->add_control(
			'scale_discoid',
			[
				'label' => esc_html__( 'Scale', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 250,
				'condition' => array(
					'background_effects' => 'discoid',
				),
			]
		);

		$this->add_control(
			'speed_discoid',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 20000,
				'condition' => array(
					'background_effects' => 'discoid',
				),
			]
		);

		$this->add_control(
			'spirals_discoid',
			[
				'label' => esc_html__( 'Spirals', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 9,
				'condition' => array(
					'background_effects' => 'discoid',
				),
			]
		);

		$this->add_control(
			'spirals2_discoid',
			[
				'label' => esc_html__( 'Spirals #2', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 36,
				'condition' => array(
					'background_effects' => 'discoid',
				),
			]
		);

		// Mechanical Grass
		$this->add_control(
			'background_color_mechanical_grass',
			array(
				'label'     => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgba(255, 197, 120, 1)',
				'alpha' => true,
				'condition' => [
					'background_effects' => 'mechanical_grass',
                ],
			)
		);

		$this->add_control(
			'background2_color_mechanical_grass',
			array(
				'label'     => esc_html__( 'Background color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgba(251, 157, 35, 1)',
				'alpha' => true,
				'condition' => [
					'background_effects' => 'mechanical_grass',
                ],
			)
		);

		$this->add_control(
			'stroke_color_mechanical_grass',
			array(
				'label'     => esc_html__( 'Stroke Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3D4A6E',
				'alpha' => true,
				'condition' => [
					'background_effects' => 'mechanical_grass',
                ],
			)
		);

		// Gradient Animation
		$this->add_control(
			'speed_gradient_animation',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 8,
				'condition' => array(
					'background_effects' => 'gradient_animation',
				),
			]
		);

		$this->add_control(
			'start_color1_gradient_animation',
			array(
				'label'     => esc_html__( 'Start Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#314CAC',
				'alpha' => false,
				'condition' => [
					'background_effects' => 'gradient_animation',
                ],
			)
		);

		$this->add_control(
			'stop_color1_gradient_animation',
			array(
				'label'     => esc_html__( 'Stop Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#F29FBF',
				'alpha' => false,
				'condition' => [
					'background_effects' => 'gradient_animation',
                ],
			)
		);

		$this->add_control(
			'start_color2_gradient_animation',
			array(
				'label'     => esc_html__( 'Start Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#FF6745',
				'alpha' => false,
				'condition' => [
					'background_effects' => 'gradient_animation',
                ],
			)
		);

		$this->add_control(
			'stop_color2_gradient_animation',
			array(
				'label'     => esc_html__( 'Stop Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#F09AF1',
				'alpha' => false,
				'condition' => [
					'background_effects' => 'gradient_animation',
                ],
			)
		);

		$this->add_control(
			'start_color3_gradient_animation',
			array(
				'label'     => esc_html__( 'Start Color #3', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#21E5F1',
				'alpha' => false,
				'condition' => [
					'background_effects' => 'gradient_animation',
                ],
			)
		);

		$this->add_control(
			'stop_color3_gradient_animation',
			array(
				'label'     => esc_html__( 'Stop Color #3', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#EBEC75',
				'alpha' => false,
				'condition' => [
					'background_effects' => 'gradient_animation',
                ],
			)
		);

		// Funky Perlin
		$this->add_control(
			'color1_funky_perlin',
			array(
				'label'     => esc_html__( 'Gradient Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#fcb045',
				'alpha' => false,
				'condition' => [
					'background_effects' => 'funky_perlin',
                ],
			)
		);

		$this->add_control(
			'color2_funky_perlin',
			array(
				'label'     => esc_html__( 'Gradient Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#fd1d1d',
				'alpha' => false,
				'condition' => [
					'background_effects' => 'funky_perlin',
                ],
			)
		);

		$this->add_control(
			'color3_funky_perlin',
			array(
				'label'     => esc_html__( 'Gradient Color #3', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#833ab4',
				'alpha' => false,
				'condition' => [
					'background_effects' => 'funky_perlin',
                ],
			)
		);

		$this->add_control(
			'speed_funky_perlin',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 8,
				'condition' => array(
					'background_effects' => 'funky_perlin',
				),
			]
		);

		$this->add_control(
			'scale_funky_perlin',
			[
				'label' => esc_html__( 'Scale', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 6,
				'condition' => array(
					'background_effects' => 'funky_perlin',
				),
			]
		);

		// Snowfall
		$this->add_control(
			'count_snowfall',
			[
				'label' => esc_html__( 'Count', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 7000,
				'condition' => array(
					'background_effects' => 'snowfall',
				),
			]
		);

		$this->add_control(
			'size_snowfall',
			[
				'label' => esc_html__( 'Count', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 5,
				'condition' => array(
					'background_effects' => 'snowfall',
				),
			]
		);

		$this->add_control(
			'speed_snowfall',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'snowfall',
				),
			]
		);

		// Trails
		$this->add_control(
			'background_color_trails',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#070715',
				'alpha'		=> false,
				'selectors' => [
					'{{WRAPPER}} .cover-section' => 'background-color: {{VALUE}};',
				],
				'condition' => array(
					'background_effects' => 'trails',
				),
			]
		);

		$this->add_control(
			'color_trails',
			array(
				'label'     => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgba(255, 255, 255, 0.05)',
				'alpha' => true,
				'condition' => [
					'background_effects' => 'trails',
                ],
			)
		);

		$this->add_control(
			'particles_trails',
			[
				'label' => esc_html__( 'Particles', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 1000,
				'condition' => array(
					'background_effects' => 'trails',
				),
			]
		);

		$this->add_control(
			'speed_trails',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.3,
				'condition' => array(
					'background_effects' => 'trails',
				),
			]
		);

		$this->add_control(
			'circle_trails',
			[
				'label' => esc_html__( 'Circle Width', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 50,
				'condition' => array(
					'background_effects' => 'trails',
				),
			]
		);

		// Blood Flow
		$this->add_control(
			'particles_blood',
			[
				'label' => esc_html__( 'Particles', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 150,
				'condition' => array(
					'background_effects' => 'blood_flow',
				),
			]
		);

		$this->add_control(
			'speed_blood',
			[
				'label' => esc_html__( 'Speed', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 1,
				'condition' => array(
					'background_effects' => 'blood_flow',
				),
			]
		);

		// Night Sky
		$this->add_control(
			'sky_color_night_sky',
			array(
				'label'     => esc_html__( 'Sky Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#110E19',
				'alpha' => true,
				'condition' => [
					'background_effects' => 'night_sky',
                ],
			)
		);

		$this->add_control(
			'star_color_night_sky',
			array(
				'label'     => esc_html__( 'Star Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'alpha' => true,
				'condition' => [
					'background_effects' => 'night_sky',
                ],
			)
		);

		$this->add_control(
			'falling_star_color_night_sky',
			array(
				'label'     => esc_html__( 'Falling Star Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'alpha' => true,
				'condition' => [
					'background_effects' => 'night_sky',
                ],
			)
		);

		$this->add_control(
			'mountain_color1_night_sky',
			array(
				'label'     => esc_html__( 'Mountain Color #1', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#191D4C',
				'alpha' => true,
				'condition' => [
					'background_effects' => 'night_sky',
                ],
			)
		);

		$this->add_control(
			'mountain_color2_night_sky',
			array(
				'label'     => esc_html__( 'Mountain Color #2', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgb(17,20,40)',
				'alpha' => true,
				'condition' => [
					'background_effects' => 'night_sky',
                ],
			)
		);

		$this->add_control(
			'mountain_color3_night_sky',
			array(
				'label'     => esc_html__( 'Mountain Color #3', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'rgb(10,10,5)',
				'alpha' => true,
				'condition' => [
					'background_effects' => 'night_sky',
                ],
			)
		);

		$this->add_control(
			'displacement_night_sky',
			[
				'label' => esc_html__( 'Displacement', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.1,
				'max' => 0.9,
				'step' => 0.1,
				'default' => 0.6,
				'condition' => array(
					'background_effects' => 'night_sky',
				),
			]
		);

		$this->add_control(
			'scroll_delay_night_sky',
			[
				'label' => esc_html__( 'Scroll Delay', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 90,
				'condition' => array(
					'background_effects' => 'night_sky',
				),
			]
		);
		
		// Text Particles
		$repeaterTextParticles = new \Elementor\Repeater();

		$repeaterTextParticles->add_control(
			'list_color_text_particles',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'alpha' => false,
			]
		);

		$this->add_control(
			'list_text_particles',
			[
				'label' => esc_html__( 'List colors', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeaterTextParticles->get_controls(),
				'default' => [
					[
						'list_color_text_particles' => "#468966",
					],
					[
						'list_color_text_particles' => "#FFF0A5",
					],
					[
						'list_color_text_particles' => "#FFB03B",
					],
					[
						'list_color_text_particles' => "#B64926",
					],
					[
						'list_color_text_particles' => "#8E2800",
					],
						
				],
				'condition' => array(
					'background_effects' => 'text_particles',
				),
				'title_field' => '{{{ list_color_text_particles }}}',
			]
		);

		$this->add_control(
			'text_text_particles', [
				'label' => esc_html__( 'Text', 'expedition-plugin' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'envato', 'expedition-plugin' ),
				'label_block' => true,
                'ai' => [
                    'active' => true,
                ],
				'condition' => array(
					'background_effects' => 'text_particles',
				),
			]
		);

		$this->add_control(
			'font_load_text_particles',
			[
				'label' => esc_html__( 'Typography load', 'expedition-plugin' ),
				'description' => esc_html__( 'First select font for load on page' , 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::FONT,
				'default' => "'Exo', sans-serif",
				'selectors' => [
					'{{WRAPPER}} #effect-box' => 'font-family: {{VALUE}}',
				],
				'condition' => array(
					'background_effects' => 'text_particles',
				),
			]
		);

		$this->add_control(
			'font_text_particles',
			[
				'label' => esc_html__( 'Typography text', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::FONT,
				'default' => "'Exo', sans-serif",
				'condition' => array(
					'background_effects' => 'text_particles',
				),
			]
		);

		$this->add_control(
			'text_size_text_particles',
			[
				'label' => esc_html__( 'Text Size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 5,
				'condition' => array(
					'background_effects' => 'text_particles',
				),
			]
		);

		$this->add_control(
			'width_text_particles',
			[
				'label' => esc_html__( 'Position Width', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 2,
				'condition' => array(
					'background_effects' => 'text_particles',
				),
			]
		);

		$this->add_control(
			'height_text_particles',
			[
				'label' => esc_html__( 'Position Height', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 1.70,
				'condition' => array(
					'background_effects' => 'text_particles',
				),
			]
		);

		$this->add_control(
			'particles_text_particles',
			[
				'label' => esc_html__( 'Particles', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 50,
				'step' => 1,
				'default' => 150,
				'condition' => array(
					'background_effects' => 'text_particles',
				),
			]
		);

		$this->add_control(
			'distance_text_particles',
			[
				'label' => esc_html__( 'Distance mouse', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 50,
				'condition' => array(
					'background_effects' => 'text_particles',
				),
			]
		);

		// Pixel Grid
		$this->add_control(
			'background_pixel_grid',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#101010',
				'alpha'		=> false,
				'selectors' => [
					'{{WRAPPER}} .cover-section' => 'background-color: {{VALUE}};',
				],
				'condition' => array(
					'background_effects' => 'pixel_grid',
				),
			]
		);

		$this->add_control(
			'background_grid_pixel_grid',
			[
				'label' => esc_html__( 'Background grid color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#222',
				'alpha'		=> false,
				'condition' => array(
					'background_effects' => 'pixel_grid',
				),
			]
		);

		$repeaterPixelGrid = new \Elementor\Repeater();

		$repeaterPixelGrid->add_control(
			'list_color_pixel_grid',
			[
				'label' => esc_html__( 'Color', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'alpha' => false,
			]
		);

		$this->add_control(
			'list_pixel_grid',
			[
				'label' => esc_html__( 'List colors', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeaterPixelGrid->get_controls(),
				'default' => [
					[
						'list_color_pixel_grid' => "#540045",
					],
					[
						'list_color_pixel_grid' => "#C60052",
					],
					[
						'list_color_pixel_grid' => "#FF714B",
					],
					[
						'list_color_pixel_grid' => "#EAFF87",
					],
					[
						'list_color_pixel_grid' => "#ACFFE9",
					],
						
				],
				'condition' => array(
					'background_effects' => 'pixel_grid',
				),
				'title_field' => '{{{ list_color_pixel_grid }}}',
			]
		);

		// Swarming Bugs
		$this->add_control(
			'circle_color_swarming_bugs',
			array(
				'label'     => esc_html__( 'Circle Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3D4A6E',
				'alpha' => false,
				'condition' => [
					'background_effects' => 'swarming_bugs',
                ],
			)
		);
		
		$this->add_control(
			'circle_border_color_swarming_bugs',
			array(
				'label'     => esc_html__( 'Circle border Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3D4A6E',
				'alpha' => false,
				'condition' => [
					'background_effects' => 'swarming_bugs',
                ],
			)
		);

		$this->add_control(
			'bugs_color_swarming_bugs',
			array(
				'label'     => esc_html__( 'Bugs Color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3D4A6E',
				'alpha' => false,
				'condition' => [
					'background_effects' => 'swarming_bugs',
                ],
			)
		);

		$this->add_control(
			'spurt_swarming_bugs',
			[
				'label' => esc_html__( 'Spurt', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.5,
				'condition' => array(
					'background_effects' => 'swarming_bugs',
				),
			]
		);

		$this->add_control(
			'radius1_swarming_bugs',
			[
				'label' => esc_html__( 'Radius circle #1', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 20,
				'condition' => array(
					'background_effects' => 'swarming_bugs',
				),
			]
		);

		$this->add_control(
			'radius2_swarming_bugs',
			[
				'label' => esc_html__( 'Radius circle #2', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 50,
				'condition' => array(
					'background_effects' => 'swarming_bugs',
				),
			]
		);

		// Blobs
		$this->add_control(
			'background_blobs',
			[
				'label' => esc_html__( 'Background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#080808',
				'alpha'		=> false,
				'selectors' => [
					'{{WRAPPER}} .cover-section' => 'background-color: {{VALUE}};',
				],
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		// Blobs 1
		$this->add_control(
			'size_blobs1',
			[
				'label' => esc_html__( 'Size Blobs #1', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 1.75,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'speed_blobs1',
			[
				'label' => esc_html__( 'Speed Blobs #1', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.3,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'color_blobs1',
			[
				'label' => esc_html__( 'Color Blobs #1', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.1,
				'step' => 0.1,
				'default' => 0.5,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'frequency_blobs1',
			[
				'label' => esc_html__( 'Frequency Blobs #1', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 1.5,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'density_blobs1',
			[
				'label' => esc_html__( 'Density Blobs #1', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.12,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		// Blobs 2
		$this->add_control(
			'size_blobs2',
			[
				'label' => esc_html__( 'Size Blobs #2', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 6.0,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'speed_blobs2',
			[
				'label' => esc_html__( 'Speed Blobs #2', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.15,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'color_blobs2',
			[
				'label' => esc_html__( 'Color Blobs #2', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.1,
				'step' => 0.1,
				'default' => 0.4,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'frequency_blobs2',
			[
				'label' => esc_html__( 'Frequency Blobs #2', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 2.0,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'density_blobs2',
			[
				'label' => esc_html__( 'Density Blobs #2', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.3,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		// Blobs 3
		$this->add_control(
			'size_blobs3',
			[
				'label' => esc_html__( 'Size Blobs #3', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.8,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'speed_blobs3',
			[
				'label' => esc_html__( 'Speed Blobs #3', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.5,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'color_blobs3',
			[
				'label' => esc_html__( 'Color Blobs #3', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.1,
				'step' => 0.1,
				'default' => 0.1,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'frequency_blobs3',
			[
				'label' => esc_html__( 'Frequency Blobs #3', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 2.0,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'density_blobs3',
			[
				'label' => esc_html__( 'Density Blobs #3', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.01,
				'step' => 0.01,
				'default' => 0.05,
				'condition' => array(
					'background_effects' => 'blobs',
				),
			]
		);

		$this->add_control(
			'noise_blobs',
			array(
				'label'   => esc_html__( 'Noise background', 'expedition-plugin' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => array(
					'background_effects' => 'blobs',
				),
			),
		);
		

		$this->end_controls_section();

	}

	private function get_hex2rgba( $color ) {

		list($r, $g, $b) = sscanf($color, "#%02x%02x%02x");
		$output = "rgba($r, $g, $b,";
	
		return $output;
	
	}

	private function get_hex2rgba2( $color ) {

		list($r, $g, $b) = sscanf($color, "#%02x%02x%02x");
		$output = "$r, $g, $b";
	
		return $output;
	
	}
	

	protected function render() {

		$settings = $this->get_settings_for_display();
		$animationElements = ( $settings[ 'animation_elements' ] == 'yes' ? 'true' : 'false' );
		
        $this->add_render_attribute( 'section', [
            'class' => 'cover-section',
			'data-animation' => $animationElements,
			'data-effects' => $settings[ 'background_effects' ],
        ] );

        if ( $settings['background_style'] === 'color' ) {
			$this->add_render_attribute( 'section', 'class', 'cover-box' );
		}

		if ( $settings['background_style'] === 'color' || $settings['background_style'] === 'image' || $settings['background_style'] === 'slideshow' || $settings['background_style'] === 'youtube_video' || $settings['background_style'] === 'vimeo_video' || $settings['background_style'] === 'html5_video') {
			$this->add_render_attribute( 'section', [
				'data-type' => $settings[ 'background_style' ], 
			]);
		}

		if (\Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode()) {
			$destroy = ( $settings[ 'destroy_effects' ] == 'yes' ? 'true' : 'false' );
			$this->add_render_attribute( 'section', [
				'data-destroy' => $destroy,
			] );
		}

		$this->add_render_attribute( 'content', [
            'class' => 'cover-content-box',
        ] );


		?>

		<style type='text/css'>
			.custom-header #expedition_menu>ul>li>a {
				color: <?php echo $settings['menu_color']; ?>!important;
			}
		</style>

		<?php if ( class_exists( 'WooCommerce' ) ) : ?>

			<style type='text/css'>
				header.custom-header .icon-cart i {
					color: <?php echo $settings['cart_color']; ?>!important;
				}
				header.custom-header .icon-cart span {
					color: <?php echo $settings['cart_text_color']; ?>!important;
				}
				header.custom-header .icon-cart span {
					background-color: <?php echo $settings['cart_bg_color']; ?>!important;
				}
			</style>

		<?php endif; ?>

		<div <?php $this->print_render_attribute_string( 'section' ); ?>>

			<div <?php $this->print_render_attribute_string( 'content' ); ?>>

				
				<?php

				 // Logo
				 if ( $settings['logo_enabled'] === 'yes') : ?>

					<div class="container">
					   <div class="row">
						   <div class="col-md-12">
				
						   <?php if ( ! empty( $settings[ 'logo_image' ][ 'url' ] ) ) : 

								echo '<div class="logo-image-box" data-alignment="'. $settings['alignment_logo'] .'">';
									echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'logo_image' );
								echo '</div>';

							endif; ?>

						  </div>
						</div>
					</div>

				<?php endif; ?>

                <?php 

				// Content Box
				if ( $settings['content_enabled'] === 'yes') : ?>

					<div class="container">
						<div class="row">
							<div class="col-md-12">

						<?php  if ( $settings['content_cover'] ) : 
							echo '<div class="inner-content-box" data-alignment="'. $settings['alignment_content'] .'">'; 
								echo $settings['content_cover']; 
							echo '</div>'; 
						endif; ?>

							</div>
						</div>
					</div>

				
				<?php endif; ?>

				<?php 
				
				// Mouse Scroll
				if ( $settings['mouse_scroll_enabled'] === 'yes') : ?>

					<div class="mouse-wrapper">
						<div class="mouse">
						<?php echo  '<a href="' . esc_html($settings['mouse_link_id']) . '">'; ?>
							<i class="fa fa-chevron-down"></i>
						</a>
						</div>
					</div>

                <?php endif; ?>
                
			</div>	
				

                <?php

				// Background Styles

				// Single Image
                if ( $settings['background_style'] === 'image' ) {
                    echo '<div class="image-box" data-image="'. $settings[ 'background_image' ]['url'] . '"></div>';
                }

				// Slideshow images
                if ( $settings['background_style'] === 'slideshow' ) {
                    echo '<div class="image-box" data-duration="'. $settings[ 'background_slideshow_duration' ] . '" data-fade="'. $settings[ 'background_slideshow_fade' ] . '">';
                    foreach ( $settings['background_slideshow'] as $image ) {
                        echo '<img class="dummy" src="' . esc_attr( $image['url'] ) . '">';
                    }
                    echo '</div>';
                }

				// YouTube Video
                if ( $settings['background_style'] === 'youtube_video' ) {
                    $mute_audio = ( $settings[ 'background_youtube_audio' ] == 'yes' ? 'true' : 'false' );
				
                    echo '<div class="video-box" data-mobile-image="'. $settings[ 'background_youtube_mobile_image' ]['url'] . '" data-cover-image="'. $settings[ 'background_youtube_cover_image' ]['url'] . '">';
                    echo '<div id="video-youtube" data-property="{videoURL:\'' . $settings[ 'background_youtube_link' ] . '\',containment:\'.video-box\', showControls:false, autoPlay:true, startAt:'. $settings[ 'startat_youtube_audio' ] . ', stopAt:'. $settings[ 'stopat_youtube_audio' ] . ', loop:true, mute:'. $mute_audio .'}"></div>';
                    echo '</div>';
                }

				// Vimeo Video
                if ( $settings['background_style'] === 'vimeo_video' ) {
                    echo '<div class="video-box" data-mobile-image="'. $settings[ 'background_vimeo_mobile_image' ]['url'] . '">';
                    echo '<div id="video-vimeo" class="player" data-property="{videoURL:\'' . $settings[ 'background_vimeo_link' ] . '\',containment:\'.video-box\', showControls:false, autoPlay:true, startAt:'. $settings[ 'startat_vimeo_audio' ] . ', stopAt:'. $settings[ 'stopat_vimeo_audio' ] . ', loop:true, mute:true}"></div>';
                    echo '</div>';
                }

				// HTML5 Video
				if ( $settings['background_style'] === 'html5_video' ) {
                    $mute_audio = ( $settings[ 'background_html5_audio' ] == 'yes' ? 'true' : 'false' );
					echo '<div class="video-html5-box" data-video="'. $settings[ 'background_html5_video' ]['url'] . '" data-poster="'. $settings[ 'background_poster_html5_video' ]['url'] . '" data-muted="'. $mute_audio .'"></div>';
                }

				// Border
				if ( $settings['border_bottom_enabled'] === 'yes' ) {
					echo '<div class="border-bottom-box"></div>';
				}

				// Background Effects

				// Winter
				if ( $settings['background_effects'] === 'winter' ) {
					$rgb = $this->get_hex2rgba($settings[ 'color_winter' ]); 
					echo '<div id="effect-box" data-color="'. $rgb .'" data-speed="'. $settings[ 'speed_winter' ] .'" data-opacity="'. $settings[ 'opacity_winter' ] .'" data-size="'. $settings[ 'size_winter' ] .'"><canvas id="snow"></canvas></div>';
                }

				// Low Poly
				if ( $settings['background_effects'] === 'low_poly' ) {
					$rgb = $this->get_hex2rgba($settings[ 'color_low_poly' ]); 
					echo '<div id="effect-box" data-color="'. $rgb .'" data-opacity="'. $settings[ 'opacity_low_poly' ] .'" data-size="'. $settings[ 'size_low_poly' ] .'" data-density="'. $settings[ 'density_low_poly' ] .'"><canvas id="low-poly"></canvas></div>';
                }

				// Constellation
				if ( $settings['background_effects'] === 'constellation' ) {
					$rgb = $this->get_hex2rgba($settings[ 'color_constellation' ]); 
					echo '<div id="effect-box" data-color="'. $rgb .'"><canvas id="constellation"></canvas></div>';
                }

				// Particles
				if ( $settings['background_effects'] === 'particles' ) {
					$particles_colors = array();
					if ( $settings['list_particles'] ) {
						foreach (  $settings['list_particles'] as $item ) {
							$particles_colors[] = $item['list_color_particles'];
						}
					}
					$particles_list_colors = implode(", ", $particles_colors);
					echo '<div id="effect-box" data-color="'. $particles_list_colors .'" data-particles="'. $settings[ 'number_particles' ] .'"><div id="particles"></div></div>';
                }

				// Rainbow Squares
				if ( $settings['background_effects'] === 'rainbow_squares' ) {
					echo '<div id="effect-box" data-quantity="'. $settings[ 'quantity_squares' ] .'" data-speed="'. $settings[ 'speed_squares' ] .'" data-size1="'. $settings[ 'size1_squares' ] .'" data-size2="'. $settings[ 'size2_squares' ] .'"> <canvas id="rainbow_squares"></canvas></div>';
				}

				// Shooting Stars
				if ( $settings['background_effects'] === 'shooting_stars' ) {
					echo '<div id="effect-box" data-partical="'. $settings[ 'partical_shooting_stars' ] .'" data-quantity="'. $settings[ 'quantity_shooting_stars' ] .'" data-probability="'. $settings[ 'probability_shooting_stars' ] .'" data-size1="'. $settings[ 'size1_shooting_stars' ] .'" data-size2="'. $settings[ 'size2_shooting_stars' ] .'" data-border-color="'. $settings[ 'border_color_shooting_stars' ] .'" data-background-color="'. $settings[ 'background_color_shooting_stars' ] .'"> <canvas id="shooting_stars"></canvas></div>';
				}

				// Starfield
				if ( $settings['background_effects'] === 'starfield' ) {
					$mouseMove = ( $settings[ 'mouse_starfield' ] == 'yes' ? 'true' : 'false' );
					echo '<div id="effect-box" data-mouse="'. $mouseMove .'" data-speed="'. $settings[ 'speed_starfield' ] .'" data-quantity="'. $settings[ 'quantity_starfield' ] .'" data-background-color="'. $settings[ 'bg_color_starfield' ] .'" data-star-color="'. $settings[ 'star_color_starfield' ] .'"><div class="starfield"></div></div>';
				}

				// Gravity
				if ( $settings['background_effects'] === 'gravity' ) {
					echo '<div id="effect-box" data-particle-size="'. $settings[ 'particle_size_gravity' ] .'" data-particle-color="'. $settings[ 'particle_color_gravity' ] .'" data-point-size="'. $settings[ 'point_size_gravity' ] .'" data-bg-color="'. $settings[ 'bg_color_gravity' ] .'" data-point-color="'. $settings[ 'point_border_color_gravity' ] .'" data-point-bg-color="'. $settings[ 'bg_point_color_gravity' ] .'"><canvas id="gravity"></canvas></div>';
				}
				
				// Fireworks
				if ( $settings['background_effects'] === 'fireworks' ) {
					echo '<div id="effect-box" data-speed="'. $settings[ 'speed_fireworks' ] .'" data-minimum="'. $settings[ 'minimum_fireworks' ] .'" data-maximum="'. $settings[ 'maximum_fireworks' ] .'"><canvas id="fireworks"></canvas></div>';
				}

				// Geometric
				if ( $settings['background_effects'] === 'geometric' ) {
					$hover = ( $settings[ 'hover_geometric' ] == 'yes' ? 'true' : 'false' );
					$click = ( $settings[ 'click_geometric' ] == 'yes' ? 'true' : 'false' );
					echo '<div id="effect-box" data-speed="'. $settings[ 'speed_geometric' ] .'" data-quantity="'. $settings[ 'quantity_geometric' ] .'" data-hover="'. $hover .'" data-click="'. $click .'" data-line-color="'. $settings[ 'line_color_geometric' ] .'" data-circle-color="'. $settings[ 'circle_color_geometric' ] .'"><div id="geometric"></div></div>';
				}

				// Bubbles
				if ( $settings['background_effects'] === 'bubbles' ) {
					echo '<div id="effect-box" data-quantity="'. $settings[ 'quantity_bubbles' ] .'" data-color1="'. $settings[ 'color1_bubbles' ] .'" data-color2="'. $settings[ 'color2_bubbles' ] .'" data-color3="'. $settings[ 'color3_bubbles' ] .'" data-color4="'. $settings[ 'color4_bubbles' ] .'" data-color5="'. $settings[ 'color5_bubbles' ] .'"><canvas id="bubble"></canvas></div>';
				}

				// Mosaic
				if ( $settings['background_effects'] === 'mosaic' ) {
					$rgbBackgroundColor = $this->get_hex2rgba($settings[ 'bg_color_mosaic' ]); 
					$rgbColor1 = $this->get_hex2rgba($settings[ 'color1_mosaic' ]); 
					$rgbColor2 = $this->get_hex2rgba($settings[ 'color2_mosaic' ]); 
					$rgbColor3 = $this->get_hex2rgba($settings[ 'color3_mosaic' ]); 
					echo '<div id="effect-box" data-side="'. $settings[ 'side_mosaic' ] .'" data-shine="'. $settings[ 'shine_mosaic' ] .'" data-base-time="'. $settings[ 'base_time_mosaic' ] .'" data-added-time="'. $settings[ 'added_time_mosaic' ] .'" data-bg-color="'. $rgbBackgroundColor .'" data-stroke-color="'. $settings[ 'stroke_color_mosaic' ] .'" data-color1="'. $rgbColor1 .'" data-color2="'. $rgbColor2 .'" data-color3="'. $rgbColor3 .'"><canvas id="mosaic"></canvas></div>';
				}
				
				// Rain
				if ( $settings['background_effects'] === 'rain' ) {
					$dropColor = plugin_dir_url(__DIR__) . 'assets/img/rain/drop-color.png'; 
					$dropAlpha = plugin_dir_url(__DIR__) . 'assets/img/rain/drop-alpha.png'; 

					if ( $settings['style_rain'] === 'image_rain') {
						echo '<div id="effect-box" data-style="'. $settings['style_rain'] .'" data-rain-image="'. $settings[ 'background_image_rain' ]['url'] .'" data-drop-color="'. esc_url($dropColor) .'" data-drop-alpha="'. esc_url($dropAlpha) .'"><canvas id="rain"></canvas></div>';
					}

					if ( $settings['style_rain'] === 'video_rain') {
						echo '<div id="effect-box" data-style="'. $settings['style_rain'] .'" data-drop-color="'. esc_url($dropColor) .'" data-drop-alpha="'. esc_url($dropAlpha) .'"><canvas id="rain"></canvas></div>';
						echo '<video class="rain-video" poster="'. $settings[ 'poster_rain' ]['url'] .'" autoplay loop muted>';
						echo '<source src="'. $settings[ 'video_rain' ]['url'] .'" type="video/mp4">';
						echo '</video>';
					}
					
				}

				// Rain Video
				if ( $settings['background_effects'] === 'rain_video' ) {
					$dropColor = plugin_dir_url(__DIR__) . 'assets/img/rain/drop-color.png'; 
					$dropAlpha = plugin_dir_url(__DIR__) . 'assets/img/rain/drop-alpha.png'; 
					echo '<div id="effect-box" data-drop-color="'. esc_url($dropColor) .'" data-drop-alpha="'. esc_url($dropAlpha) .'"><canvas id="rain"></canvas></div>';
					echo '<video class="rain-video" poster="'. $settings[ 'poster_rain' ]['url'] .'" autoplay loop muted>';
					echo '<source src="'. $settings[ 'video_rain' ]['url'] .'" type="video/mp4">';
					echo '</video>';
				}

				// Surface
				if ( $settings['background_effects'] === 'surface' ) {
					echo '<div id="effect-box" data-speed="'. $settings[ 'speed_surface' ] .'" data-ambient-color="'. $settings[ 'ambient_surface' ] .'" data-diffuse-color="'. $settings[ 'diffuse_surface' ] .'"><div id="surface"></div></div>';
				}

				// Magneto
				if ( $settings['background_effects'] === 'magneto' ) {
					echo '<div id="effect-box" data-color1="'. $settings[ 'color1_magneto' ] .'" data-color2="'. $settings[ 'color2_magneto' ] .'" data-color3="'. $settings[ 'color3_magneto' ] .'" data-bg-color="'. $settings[ 'bg_color_magneto' ] .'"><div id="magneto"></div></div>';
				}

				// Liquid
				if ( $settings['background_effects'] === 'liquid' ) {
					echo '<div id="effect-box" data-color1="'. $settings[ 'color1_liquid' ] .'" data-color2="'. $settings[ 'color2_liquid' ] .'"><canvas id="liquid"></canvas></div>';
				}

				// Confetti
				if ( $settings['background_effects'] === 'confetti' ) {
					$particles_colors = array();
					if ( $settings['list_confetti'] ) {
						foreach (  $settings['list_confetti'] as $item ) {
							$particles_colors[] = $item['list_color_confetti'];
						}
					}
					$particles_list_colors = implode(", ", $particles_colors);
					echo '<div id="effect-box" data-particles="'. $settings[ 'particles_confetti' ] .'" data-color="'. $particles_list_colors .'"><div id="confetti"></div></div>';
				}

				// Orbit
				if ( $settings['background_effects'] === 'orbit' ) {
					$color_orbit = $this->get_hex2rgba2($settings[ 'color_orbit' ]); 
					$background_orbit = $this->get_hex2rgba2($settings[ 'bg_color_orbit' ]); 
					$background_orbit_2 = $this->get_hex2rgba2($settings[ 'bg2_color_orbit' ]); 
					echo '<div id="effect-box" data-count="'. $settings[ 'count_orbit' ] .'" data-speed="'. $settings[ 'speed_orbit' ] .'" data-radius="'. $settings[ 'radius_orbit' ] .'" data-size="'. $settings[ 'size_orbit' ] .'" data-maxdistance="'. $settings[ 'maxdistance_orbit' ] .'" data-color="'. $color_orbit .'"  data-bg-color="'. $background_orbit .'" data-bg2-color="'. $background_orbit_2 .'"><canvas id="orbit"></canvas></div>';
				}

				// Swirl
				if ( $settings['background_effects'] === 'swirl' ) {
					echo '<div id="effect-box" data-speed="'. $settings[ 'speed_swirl' ] .'" data-particles="'. $settings[ 'particles_swirl' ] .'" data-bg-color="'. $settings[ 'bg_color_swirl' ] .'"><div id="swirl"></div></div>';
				}
				
				// Shift
				if ( $settings['background_effects'] === 'shift' ) {
					echo '<div id="effect-box" data-speed="'. $settings[ 'speed_shift' ] .'" data-count="'. $settings[ 'circle_count_shift' ] .'" data-color="'. $settings[ 'color_shift' ] .'"><div id="shift"></div></div>';
				}

				// Coalesce
				if ( $settings['background_effects'] === 'coalesce' ) {
					echo '<div id="effect-box" data-speed="'. $settings[ 'speed_coalesce' ] .'" data-count="'. $settings[ 'particles_count_coalesce' ] .'" data-color="'. $settings[ 'color_coalesce' ] .'"><div id="coalesce"></div></div>';
				}

				// Pipeline
				if ( $settings['background_effects'] === 'pipeline' ) {
					echo '<div id="effect-box" data-speed="'. $settings[ 'speed_pipeline' ] .'" data-count="'. $settings[ 'pipeline_count_pipeline' ] .'" data-color="'. $settings[ 'color_pipeline' ] .'"><div id="pipeline"></div></div>';
				}

				// Aurora
				if ( $settings['background_effects'] === 'aurora' ) {
					echo '<div id="effect-box" data-speed="'. $settings[ 'speed_aurora' ] .'" data-count="'. $settings[ 'count_aurora' ] .'" data-color="'. $settings[ 'color_aurora' ] .'"><div id="aurora"></div></div>';
				}

				// Stardust
				if ( $settings['background_effects'] === 'stardust' ) {
					echo '<div id="effect-box" data-particle="'. $settings[ 'particle_stardust' ] .'" data-micro="'. $settings[ 'micro_stardust' ] .'" data-gradient="'. $settings[ 'gradient_stardust' ] .'" data-gradient2="'. $settings[ 'gradient2_stardust' ] .'"><div id="stardust"></div></div>';
				}

				// Abstractart
				if ( $settings['background_effects'] === 'abstractart' ) {
					echo '<div id="effect-box" data-frequency="'. $settings[ 'frequency_abstractart' ] .'" data-color="'. $settings[ 'color_abstractart' ] .'" data-color2="'. $settings[ 'color2_abstractart' ] .'" data-background="'. $settings[ 'background_abstractart' ] .'"><div id="abstractart"></div></div>';
				}

				// Wave
				if ( $settings['background_effects'] === 'wave' ) {
					$images_wave = array();
					if ( $settings['list_wave'] ) {
						foreach ( $settings['list_wave'] as $item ) {
							$images_wave[] = $item['list_images_wave'][ 'url' ];
						}
					}
					$list_images_wave = implode(", ", $images_wave);
					echo '<div id="effect-box" data-speed="'. $settings[ 'speed_wave' ] .'" data-images="'. $list_images_wave .'"><div id="wave"></div></div>';
				}

				// Connections
				if ( $settings['background_effects'] === 'connections' ) {
					$connections_colors = array();
					if ( $settings['list_connections'] ) {
						foreach (  $settings['list_connections'] as $item ) {
							$connections_colors[] = $item['list_color_connections'];
						}
					}
					$connections_list_colors = implode(", ", $connections_colors);
					echo '<div id="effect-box" data-color="'. $connections_list_colors .'" data-bg-color="'. $settings[ 'background_connections' ] .'" data-stroke-color="'. $settings[ 'strokestyle_connections' ] .'" data-linewidth="'. $settings[ 'linewidth_connections' ] .'" data-frequency="'. $settings[ 'frequency_connections' ] .'" data-particles="'. $settings[ 'particles_connections' ] .'"><div id="connections"></div></div>';
                }

				// Alien
				if ( $settings['background_effects'] === 'alien' ) {
					echo '<div id="effect-box" data-color="'. $settings[ 'color_alien' ] .'" data-color2="'. $settings[ 'color2_alien' ] .'" data-color3="'. $settings[ 'color3_alien' ] .'" data-bg-color="'. $settings[ 'background_alien' ] .'" data-bg2-color="'. $settings[ 'background2_alien' ] .'" data-particles="'. $settings[ 'particles_alien' ] .'"><div id="alien"></div></div>';
				}

				// Balls
				if ( $settings['background_effects'] === 'balls' ) {
					$balls_colors = array();
					if ( $settings['list_balls'] ) {
						foreach (  $settings['list_balls'] as $item ) {
							$balls_colors[] = $item['list_color_balls'];
						}
					}
					$balls_list_colors = implode(", ", $balls_colors);
					echo '<div id="effect-box" data-color="'. $balls_list_colors .'" data-balls="'. $settings[ 'number_balls' ] .'"><div id="balls"></div></div>';
				}

				// Landscape
				if ( $settings['background_effects'] === 'landscape' ) {
					if ( $settings['style_landscape'] === 'style1_landscape') {
						$landscape_style = plugin_dir_url(__DIR__) . 'assets/img/landscape/pallete.png'; 
						echo '<div id="effect-box" data-landscape="'. esc_url($landscape_style) .'" data-style="'. $settings['style_landscape'] .'" data-speed="'. $settings['speed_landscape'] .'"><canvas id="landscape"></canvas></div>';
					}

					if ( $settings['style_landscape'] === 'style2_landscape') {
						$landscape2_style = plugin_dir_url(__DIR__) . 'assets/img/landscape/pallete2.png'; 
						echo '<div id="effect-box" data-landscape2="'. esc_url($landscape2_style) .'" data-style="'. $settings['style_landscape'] .'" data-speed2="'. $settings['speed2_landscape'] .'"><canvas id="landscape"></canvas></div>';
					}
				}

				// Boreal Sky
				if ( $settings['background_effects'] === 'boreal_sky' ) {
					$boreal_colors = array();
					if ( $settings['list_boreal'] ) {
						foreach (  $settings['list_boreal'] as $item ) {
							$boreal_colors[] = $item['list_color_boreal'];
						}
					}
					$boreal_list_colors = implode(",", $boreal_colors);
					echo '<div id="effect-box" data-color="'. $boreal_list_colors .'" data-bg1-color="'. $settings['background1_boreal'] .'" data-bg2-color="'. $settings['background2_boreal'] .'" data-bg3-color="'. $settings['background3_boreal'] .'"><div id="vendors-lines"></div></div>';
				}

				// Сolors
				if ( $settings['background_effects'] === 'colors' ) {
					$colors_colors = array();
					if ( $settings['list_colors'] ) {
						foreach (  $settings['list_colors'] as $item ) {
							$colors_colors[] = $item['list_color_colors'];
						}
					}
					$colors_list_colors = implode(",", $colors_colors);
					echo '<div id="effect-box" data-color="'. $colors_list_colors .'" data-bg1-color="'. $settings['background1_colors'] .'" data-bg2-color="'. $settings['background2_colors'] .'"><div id="vendors-lines"></div></div>';
				}

				// Confetti Lines
				if ( $settings['background_effects'] === 'confetti_lines' ) {
					$confetti_lines_colors = array();
					if ( $settings['list_confetti_lines'] ) {
						foreach (  $settings['list_confetti_lines'] as $item ) {
							$confetti_lines_colors[] = $item['list_color_confetti_lines'];
						}
					}
					$colors_list_confetti_lines = implode(",", $confetti_lines_colors);
					echo '<div id="effect-box" data-color="'. $colors_list_confetti_lines .'" data-bg1-color="'. $settings['background1_confetti_lines'] .'" data-bg2-color="'. $settings['background2_confetti_lines'] .'"><div id="vendors-lines"></div></div>';
				}

				// Stars Lines
				if ( $settings['background_effects'] === 'stars_lines' ) {
					echo '<div id="effect-box" data-color="'. $settings['color_stars_lines'] .'" data-bg1-color="'. $settings['background1_stars_lines'] .'"><div id="vendors-lines"></div></div>';
				}

				// Quantum
				if ( $settings['background_effects'] === 'quantum' ) {
					echo '<div id="effect-box" data-color="'. $settings['color_quantum'] .'" data-light-color="'. $settings['light_quantum'] .'" data-light2-color="'. $settings['light2_quantum'] .'" data-light3-color="'. $settings['light3_quantum'] .'" data-material-color="'. $settings['material_quantum'] .'"><canvas class="quantum"></canvas></div>';
				}

				// Information
				if ( $settings['background_effects'] === 'information' ) {
					$dotTexture = plugin_dir_url(__DIR__) . 'assets/img/information/dotTexture.png'; 
					echo '<div id="effect-box" data-texture="'. esc_url($dotTexture) .'" data-bg-color="'. $settings['bg_information'] .'" data-color="'. $settings['color_information'] .'" data-color2="'. $settings['color2_information'] .'" data-color3="'. $settings['color3_information'] .'"><canvas class="information"></canvas></div>';
				}

				// Space Time
				if ( $settings['background_effects'] === 'spacetime' ) {
					$dotTexture = plugin_dir_url(__DIR__) . 'assets/img/information/dotTexture.png'; 
					echo '<div id="effect-box" data-texture="'. esc_url($dotTexture) .'" data-bg-color="'. $settings['bg_spacetime'] .'"><canvas class="spacetime"></canvas></div>';
				}

				// Physics
				if ( $settings['background_effects'] === 'physics' ) {
					echo '<div id="effect-box" data-color="'. $settings['color_physics'] .'" data-lines="'. $settings['lines_physics'] .'" data-radius="'. $settings['radius_physics'] .'" data-vertices="'. $settings['vertices_physics'] .'"><canvas class="physics"></canvas></div>';
				}

				// Heuristics
				if ( $settings['background_effects'] === 'heuristics' ) {
					echo '<div id="effect-box" data-color="'. $settings['color_heuristics'] .'" data-bg-color="'. $settings['background_heuristics'] .'"><canvas class="heuristics"></canvas></div>';
				}

				// Star Wars
				if ( $settings['background_effects'] === 'star_wars' ) {
					echo '<div id="effect-box" data-texture="'. $settings[ 'texture_star_wars' ]['url'] .'"><canvas class="star_wars"></canvas></div>';
				}

				// Brick Tunnel
				if ( $settings['background_effects'] === 'brick_tunnel' ) {
					echo '<div id="effect-box" data-texture="'. $settings[ 'texture_brick_tunnel' ]['url'] .'"><canvas class="brick_tunnel"></canvas></div>';
				}

				// Triangle
				if ( $settings['background_effects'] === 'triangle' ) {
					echo '<div id="effect-box"><canvas class="triangle"></canvas></div>';
				}

				// Birds
				if ( $settings['background_effects'] === 'birds' ) {
					$mouseMove = ( $settings[ 'mouse_birds' ] == 'yes' ? 'true' : 'false' );
					echo '<div id="effect-box" data-mouse="'. $mouseMove .'" data-bg-color="'. $settings['bg_color_birds'] .'" data-color="'. $settings['color_birds'] .'" data-color2="'. $settings['color2_birds'] .'" data-size="'. $settings['size_birds'] .'" data-wing="'. $settings['wing_birds'] .'" data-speed="'. $settings['speed_birds'] .'" data-separation="'. $settings['separation_birds'] .'" data-alignment="'. $settings['alignment_birds'] .'" data-cohesion="'. $settings['cohesion_birds'] .'" data-quantity="'. $settings['quantity_birds'] .'"></div>';
				}

				// Fog
				if ( $settings['background_effects'] === 'fog' ) {
					echo '<div id="effect-box" data-base-color="'. $settings['base_color_fog'] .'" data-highlight-color="'. $settings['highlight_color_fog'] .'" data-midtone-color="'. $settings['midtone_color_fog'] .'" data-lowlight-color="'. $settings['lowlight_color_fog'] .'" data-blur="'. $settings['blur_fog'] .'" data-zoom="'. $settings['zoom_fog'] .'" data-speed="'. $settings['speed_fog'] .'"></div>';
				}

				// Waves
				if ( $settings['background_effects'] === 'waves' ) {
					$mouseMove = ( $settings[ 'mouse_waves' ] == 'yes' ? 'true' : 'false' );
					echo '<div id="effect-box" data-mouse="'. $mouseMove .'" data-color="'. $settings['color_waves'] .'" data-shininess="'. $settings['shininess_waves'] .'" data-height="'. $settings['height_waves'] .'" data-speed="'. $settings['speed_waves'] .'" data-zoom="'. $settings['zoom_waves'] .'"></div>';
				}

				// Clouds
				if ( $settings['background_effects'] === 'clouds' ) {
					if ( $settings['style_clouds'] === 'style1_clouds') {
						$mouseMove = ( $settings[ 'mouse_clouds' ] == 'yes' ? 'true' : 'false' );
						echo '<div id="effect-box" data-style="'. $settings['style_clouds'] .'" data-mouse="'. $mouseMove .'" data-sky-color="'. $settings['skycolor_clouds'] .'" data-cloud-color="'. $settings['cloudcolor_clouds'] .'" data-shadow-color="'. $settings['cloudshadowcolor_clouds'] .'" data-sun-color="'. $settings['suncolor_clouds'] .'" data-glare-color="'. $settings['sunglarecolor_clouds'] .'" data-light-color="'. $settings['sunlightcolor_clouds'] .'" data-speed="'. $settings['speed_clouds'] .'"></div>';
					}

					if ( $settings['style_clouds'] === 'style2_clouds') {
						$clouds_texture = plugin_dir_url(__DIR__) . 'assets/img/clouds/noise.png'; 
						echo '<div id="effect-box" data-style="'. $settings['style_clouds'] .'" data-texture="'. esc_url($clouds_texture) .'" data-speed="'. $settings['speed2_clouds'] .'" data-sky-color="'. $settings['skycolor2_clouds'] .'" data-cloud-color="'. $settings['cloudcolor2_clouds'] .'" data-light-color="'. $settings['lightcolor2_clouds'] .'"></div>';
					}
				}

				// Globe
				if ( $settings['background_effects'] === 'globe' ) {
					$mouseMove = ( $settings[ 'mouse_globe' ] == 'yes' ? 'true' : 'false' );
					echo '<div id="effect-box" data-mouse="'. $mouseMove .'" data-color="'. $settings['color_globe'] .'" data-color2="'. $settings['color2_globe'] .'" data-bg-color="'. $settings['bg_globe'] .'" data-size="'. $settings['size_globe'] .'"></div>';
				}

				// Net
				if ( $settings['background_effects'] === 'net' ) {
					$mouseMove = ( $settings[ 'mouse_net' ] == 'yes' ? 'true' : 'false' );
					$dotsShow = ( $settings[ 'dots_net' ] == 'yes' ? 'true' : 'false' );
					echo '<div id="effect-box" data-mouse="'. $mouseMove .'" data-dots="'. $dotsShow .'" data-points="'. $settings['points_net'] .'" data-distance="'. $settings['distance_net'] .'" data-spacing="'. $settings['spacing_net'] .'" data-bg-color="'. $settings['bg_net'] .'" data-color="'. $settings['color_net'] .'"></div>';
				}

				// Cells
				if ( $settings['background_effects'] === 'cells' ) {
					echo '<div id="effect-box" data-size="'. $settings['size_cells'] .'" data-speed="'. $settings['speed_cells'] .'" data-color="'. $settings['color_cells'] .'" data-color2="'. $settings['color2_cells'] .'"></div>';
				}

				// Trunk
				if ( $settings['background_effects'] === 'trunk' ) {
					echo '<div id="effect-box" data-spacing="'. $settings['spacing_trunk'] .'" data-chaos="'. $settings['chaos_trunk'] .'" data-bg-color="'. $settings['bg_trunk'] .'" data-color="'. $settings['color_trunk'] .'"></div>';
				}

				// Topology
				if ( $settings['background_effects'] === 'topology' ) {
					echo '<div id="effect-box" data-color="'. $settings['color_topology'] .'" data-bg-color="'. $settings['bg_topology'] .'"></div>';
				}

				// Dots
				if ( $settings['background_effects'] === 'dots' ) {
					$mouseMove = ( $settings[ 'mouse_dots' ] == 'yes' ? 'true' : 'false' );
					$linesShow = ( $settings[ 'lines_dots' ] == 'yes' ? 'true' : 'false' );
					echo '<div id="effect-box" data-mouse="'. $mouseMove .'" data-lines="'. $linesShow .'" data-size="'. $settings['size_dots'] .'" data-spacing="'. $settings['spacing_dots'] .'" data-bg-color="'. $settings['bg_dots'] .'" data-color="'. $settings['color_dots'] .'" data-color2="'. $settings['color2_dots'] .'"></div>';
				}

				// Rings
				if ( $settings['background_effects'] === 'rings' ) {
					$mouseMove = ( $settings[ 'mouse_rings' ] == 'yes' ? 'true' : 'false' );
					echo '<div id="effect-box" data-mouse="'. $mouseMove .'" data-alpha="'. $settings['alpha_rings'] .'" data-bg-color="'. $settings['bg_rings'] .'" data-color="'. $settings['color_rings'] .'"></div>';
				}

				// Halo
				if ( $settings['background_effects'] === 'halo' ) {
					$mouseMove = ( $settings[ 'mouse_halo' ] == 'yes' ? 'true' : 'false' );
					echo '<div id="effect-box" data-mouse="'. $mouseMove .'" data-bg-color="'. $settings['bg_halo'] .'" data-base="'. $settings['base_halo'] .'" data-size="'. $settings['size_halo'] .'" data-amplitude="'. $settings['amplitude_halo'] .'" data-xoffset="'. $settings['xoffset_halo'] .'" data-yoffset="'. $settings['yoffset_halo'] .'"></div>';
				}

				// Glitch
				if ( $settings['background_effects'] === 'glitch' ) {
					echo '<div id="effect-box" data-image="'. $settings[ 'image_glitch' ]['url'] .'"><canvas id="glitch"></canvas></div>';
				}

				// Sand Particles
				if ( $settings['background_effects'] === 'sand_particles' ) {
					echo '<div id="effect-box" data-bg-color="'. $settings[ 'bg_sand_particles' ] .'"><canvas class="p-canvas-webgl" id="sand-particles"></canvas></div>';
				}

				// Hills
				if ( $settings['background_effects'] === 'hills' ) {
					echo '<div id="effect-box" data-bg-color="'. $settings[ 'bg_hills' ] .'"><canvas class="p-canvas-webgl" id="hills"></canvas></div>';
				}

				// Plasmatic
				if ( $settings['background_effects'] === 'plasmatic' ) {
					echo '<div id="effect-box" data-particles="'. $settings[ 'particles_plasmatic' ] .'" data-energy="'. $settings[ 'energy_plasmatic' ] .'" data-blobiness="'. $settings[ 'blobiness_plasmatic' ] .'" data-brightness="'. $settings[ 'brightness_plasmatic' ] .'"><canvas id="plasmatic"></canvas></div>';
				}

				// Coronavirus
				if ( $settings['background_effects'] === 'coronavirus' ) {
					$object = plugin_dir_url(__DIR__) . 'assets/js/effects/coronavirus/object.stl'; 
					echo '<div id="effect-box" data-object="'. esc_url($object) .'" data-max="'. $settings[ 'max_coronavirus' ] .'" data-blur="'. $settings[ 'blur_coronavirus' ] .'" data-bg-color="'. $settings[ 'bg_coronavirus' ] .'" data-color="'. $settings[ 'color_coronavirus' ] .'"><div class="coronavirus"></div></div>';
				}

				// Audio Visualizers
				if ( $settings['background_effects'] === 'audio_visualizers' ) {
						$audioLoop = ( $settings[ 'loop_audio_visualizers' ] == 'yes' ? 'true' : 'false' );
						echo '<div id="effect-box" data-style="'. $settings[ 'style_audio_visualizers' ] .'" data-loop="'. $audioLoop .'" data-distance="'. $settings['distance_audio_visualizers'] .'" data-volume="'. $settings['volume_audio_visualizers'] .'" data-start-color="'. $settings['start_color_audio_visualizers'] .'" data-end-color="'. $settings[ 'end_color_audio_visualizers' ] .'" data-audio="'. $settings[ 'file_link_audio_visualizers' ] .'"><div id="audio_visualizers"><button class="toggle-btn"><span class="button-vs-play"><i class="fa-light fa-circle-play"></i>'. $settings[ 'text_play_audio_visualizers' ] .'</span><span class="button-vs-pause"><i class="fa-light fa-circle-pause"></i>'. $settings[ 'text_pause_audio_visualizers' ] .'</span></button></div></div>';
				}

				// Water Droplet
				if ( $settings['background_effects'] === 'water_droplet' ) {
					$waterAlpha = plugin_dir_url(__DIR__) . 'assets/img/water/alpha.png'; 
					$waterShine = plugin_dir_url(__DIR__) . 'assets/img/water/shine.png'; 
					echo '<div id="effect-box" data-alpha="'. esc_url($waterAlpha) .'" data-shine="'. esc_url($waterShine) .'" data-image="'. $settings[ 'image_water_droplet' ]['url'] . '" data-gravity="'. $settings[ 'gravity_water_droplet' ] .'" data-mass="'. $settings[ 'mass_water_droplet' ] .'" data-grow="'. $settings[ 'grow_water_droplet' ] .'" data-shrink="'. $settings[ 'shrink_water_droplet' ] .'"><canvas id="water-droplet"></canvas></div>';
				}

				// Noisy Blobs
				if ( $settings['background_effects'] === 'noisy_blobs' ) {
					echo '<div id="effect-box" data-speed="'. $settings[ 'speed_noisy_blobs' ] .'" data-scale="'. $settings[ 'scale_noisy_blobs' ] .'" data-dot="'. $settings[ 'dot_size_noisy_blobs' ] .'" data-gap="'. $settings[ 'gap_noisy_blobs' ] .'" data-hue-base="'. $settings[ 'hue_base_noisy_blobs' ] .'" data-hue-range="'. $settings[ 'hue_range_noisy_blobs' ] .'" data-shape="'. $settings[ 'shape_noisy_blobs' ] .'"><canvas id="noisy-blobs"></canvas></div>';
				}

				// Nucleus
				if ( $settings['background_effects'] === 'nucleus' ) {
					echo '<div id="effect-box" data-darker="'. $settings[ 'darker_nucleus' ] .'" data-particle="'. $settings[ 'particle_nucleus' ] .'"  data-points="'. $settings[ 'points_size_nucleus' ] .'" data-space="'. $settings[ 'space_nucleus' ] .'" data-speed="'. $settings[ 'speed_nucleus' ] .'"></div>';
				}

				// TV static noise
				if ( $settings['background_effects'] === 'tv' ) {
					echo '<div id="effect-box" data-noise="'. $settings[ 'noise_tv' ] .'" data-fps="'. $settings[ 'fps_tv' ] .'" data-scan="'. $settings[ 'scan_tv' ] .'" data-sample="'. $settings[ 'sample_tv' ] .'"><canvas id="tv"></canvas></div>';
				}
				
				// Floor is Lava
				if ( $settings['background_effects'] === 'floor_lava' ) {
					echo '<div id="effect-box" data-amplitudex="'. $settings[ 'amplitudex_floor_lava' ] .'" data-amplitudey="'. $settings[ 'amplitudey_floor_lava' ] .'" data-lines="'. $settings[ 'lines_floor_lava' ] .'" data-start="'. $settings[ 'start_color_floor_lava' ] .'" data-end="'. $settings[ 'end_color_floor_lava' ] .'"><canvas id="floor-lava"></canvas></div>';
				}

				// Circuits
				if ( $settings['background_effects'] === 'circuits' ) {
					echo '<div id="effect-box" data-bg-color="'. $settings[ 'bg_color_circuits' ] .'" data-stroke-color="'. $settings[ 'stroke_color_circuits' ] .'" data-circle-color="'. $settings[ 'circle_color_circuits' ] .'"  data-move-circle-color="'. $settings[ 'move_circle_color_circuits' ] .'" data-light-size-width="'. $settings[ 'light_size_width_circuits' ] .'" data-light-size-height="'. $settings[ 'light_size_height_circuits' ] .'" data-light-color="'. $settings[ 'light_circle_color_circuits' ] .'" data-light2-color="'. $settings[ 'light2_circle_color_circuits' ] .'" data-superlight-color="'. $settings[ 'superlight_circle_color_circuits' ] .'" data-superlight2-color="'. $settings[ 'superlight2_circle_color_circuits' ] .'" data-max-length="'. $settings[ 'max_length_circuits' ] .'" data-min-length="'. $settings[ 'min_length_circuits' ] .'" data-cell-size="'. $settings[ 'cell_size_circuits' ] .'"><canvas id="circuits"></canvas></div>';
				}

				// Turbulent Noise
				if ( $settings['background_effects'] === 'turbulent_noise' ) {
					echo '<div id="effect-box" data-time="'. $settings[ 'time_turbulent_noise' ] .'" data-red="'. $settings[ 'red_turbulent_noise' ] .'" data-green="'. $settings[ 'green_turbulent_noise' ] .'" data-blue="'. $settings[ 'blue_turbulent_noise' ] .'"><canvas id="turbulent-noise"></canvas></div>';
				}

				// Ribbons
				if ( $settings['background_effects'] === 'ribbons' ) {
					echo '<div id="effect-box" data-waves="'. $settings[ 'waves_ribbons' ] .'" data-width="'. $settings[ 'width_ribbons' ] .'" data-amplitude="'. $settings[ 'amplitude_ribbons' ] .'" data-rotation="'. $settings[ 'rotation_ribbons' ] .'" data-hue="'. $settings[ 'hue_ribbons' ] .'" data-hue2="'. $settings[ 'hue2_ribbons' ] .'" data-speed="'. $settings[ 'speed_ribbons' ] .'" data-speed2="'. $settings[ 'speed2_ribbons' ] .'"></div>';
				}

				// Dotted Ocean
				if ( $settings['background_effects'] === 'dotted_ocean' ) {
					echo '<div id="effect-box" data-count="'. $settings[ 'count_dotted_ocean' ] .'" data-size="'. $settings[ 'size_dotted_ocean' ] .'" data-width="'. $settings[ 'width_dotted_ocean' ] .'" data-height="'. $settings[ 'height_dotted_ocean' ] .'" data-grid-size="'. $settings[ 'grid_size_dotted_ocean' ] .'" data-wave-size="'. $settings[ 'wave_size_dotted_ocean' ] .'" data-perspective="'. $settings[ 'perspective_dotted_ocean' ] .'" data-bg-color="'. $settings[ 'bg_color_dotted_ocean' ] .'" data-hsl="'. $settings[ 'hsl_dotted_ocean' ] .'" data-hsl2="'. $settings[ 'hsl2_dotted_ocean' ] .'"></div>';
				}

				// Discoid
				if ( $settings['background_effects'] === 'discoid' ) {
					$discoid_colors = array();
					if ( $settings['list_discoid'] ) {
						foreach (  $settings['list_discoid'] as $item ) {
							$discoid_colors[] = $item['list_color_discoid'];
						}
					}
					$colors_list_discoid = implode(",", $discoid_colors);
					echo '<div id="effect-box" data-color="'. $colors_list_discoid .'" data-scale="'. $settings[ 'scale_discoid' ] .'" data-speed="'. $settings[ 'speed_discoid' ] .'" data-spirals="'. $settings[ 'spirals_discoid' ] .'" data-spirals2="'. $settings[ 'spirals2_discoid' ] .'"><canvas id="discoid"></canvas></div>';
				}

				// Mechanical Grass
				if ( $settings['background_effects'] === 'mechanical_grass' ) {
					echo '<div id="effect-box" data-bg-color="'. $settings[ 'background_color_mechanical_grass' ] .'" data-bg2-color="'. $settings[ 'background2_color_mechanical_grass' ] .'" data-stroke-color="'. $settings[ 'stroke_color_mechanical_grass' ] .'"><canvas id="mechanical-grass"></canvas></div>';
				}

				// Gradient Animation
				if ( $settings['background_effects'] === 'gradient_animation' ) {
					$start_color1_gradient_animation = $this->get_hex2rgba2($settings[ 'start_color1_gradient_animation' ]); 
					$stop_color1_gradient_animation = $this->get_hex2rgba2($settings[ 'stop_color1_gradient_animation' ]); 
					$start_color2_gradient_animation = $this->get_hex2rgba2($settings[ 'start_color2_gradient_animation' ]); 
					$stop_color2_gradient_animation = $this->get_hex2rgba2($settings[ 'stop_color2_gradient_animation' ]); 
					$start_color3_gradient_animation = $this->get_hex2rgba2($settings[ 'start_color3_gradient_animation' ]); 
					$stop_color3_gradient_animation = $this->get_hex2rgba2($settings[ 'stop_color3_gradient_animation' ]); 
					echo '<div id="effect-box" data-speed="'. $settings[ 'speed_gradient_animation' ] .'" data-start-color1="'. $start_color1_gradient_animation .'" data-stop-color1="'. $stop_color1_gradient_animation .'" data-start-color2="'. $start_color2_gradient_animation .'" data-stop-color2="'. $stop_color2_gradient_animation .'" data-start-color3="'. $start_color3_gradient_animation .'" data-stop-color3="'. $stop_color3_gradient_animation .'"></div>';
				}

				// Funky Perlin
				if ( $settings['background_effects'] === 'funky_perlin' ) {
					echo '<div id="effect-box" data-color="'. $settings[ 'color1_funky_perlin' ] .'" data-color2="'. $settings[ 'color2_funky_perlin' ] .'" data-color3="'. $settings[ 'color3_funky_perlin' ] .'" data-speed="'. $settings[ 'speed_funky_perlin' ] .'" data-scale="'. $settings[ 'scale_funky_perlin' ] .'"></div>';
				}

				// Snowfall
				if ( $settings['background_effects'] === 'snowfall' ) {
					echo '<div id="effect-box" data-count="'. $settings[ 'count_snowfall' ] .'" data-size="'. $settings[ 'size_snowfall' ] .'" data-speed="'. $settings[ 'speed_snowfall' ] .'"></div>';
				}

				// Trails
				if ( $settings['background_effects'] === 'trails' ) {
					echo '<div id="effect-box" data-color="'. $settings[ 'color_trails' ] .'" data-particles="'. $settings[ 'particles_trails' ] .'" data-speed="'. $settings[ 'speed_trails' ] .'" data-circle="'. $settings[ 'circle_trails' ] .'"><canvas id="trails"></canvas></div>';
				}

				// Blood Flow
				if ( $settings['background_effects'] === 'blood_flow' ) {
					$object = plugin_dir_url(__DIR__) . 'assets/js/effects/blood/blood.obj'; 
					echo '<div id="effect-box" data-object="'. esc_url($object) .'" data-particles="'. $settings[ 'particles_blood' ] .'" data-speed="'. $settings[ 'speed_blood' ] .'"><canvas id="blood-flow"></canvas></div>';
				}

				// Night Sky
				if ( $settings['background_effects'] === 'night_sky' ) {
					echo '<div id="effect-box" data-sky-color="'. $settings[ 'sky_color_night_sky' ] .'" data-star-color="'. $settings[ 'star_color_night_sky' ] .'" data-falling-star-color="'. $settings[ 'falling_star_color_night_sky' ] .'" data-mountain-color1="'. $settings[ 'mountain_color1_night_sky' ] .'" data-mountain-color2="'. $settings[ 'mountain_color2_night_sky' ] .'" data-mountain-color3="'. $settings[ 'mountain_color3_night_sky' ] .'" data-displacement="'. $settings[ 'displacement_night_sky' ] .'" data-scroll="'. $settings[ 'scroll_delay_night_sky' ] .'"><div id="night-sky-bg"></div><canvas id="night-sky"></canvas></div>';
				}

				// Text Particles
				if ( $settings['background_effects'] === 'text_particles' ) {
					$text_particles_colors = array();
					if ( $settings['list_text_particles'] ) {
						foreach (  $settings['list_text_particles'] as $item ) {
							$text_particles_colors[] = $item['list_color_text_particles'];
						}
					}
					$text_particles_list_colors = implode(", ", $text_particles_colors);
					echo '<div id="effect-box" data-color="'. $text_particles_list_colors .'" data-distance="'. $settings[ 'distance_text_particles' ] .'" data-text="'. $settings[ 'text_text_particles' ] .'" data-text-size="'. $settings[ 'text_size_text_particles' ] .'" data-font="'. $settings[ 'font_text_particles' ] .'" data-width="'. $settings[ 'width_text_particles' ] .'" data-height="'. $settings[ 'height_text_particles' ] .'" data-particles="'. $settings[ 'particles_text_particles' ] .'"><canvas id="text-particles"></canvas></div>';
				}

				// Pixel Grid
				if ( $settings['background_effects'] === 'pixel_grid' ) {
					$pixel_grid_colors = array();
					if ( $settings['list_pixel_grid'] ) {
						foreach (  $settings['list_pixel_grid'] as $item ) {
							$pixel_grid_colors[] = $item['list_color_pixel_grid'];
						}
					}
					$pixel_grid_list_colors = implode(", ", $pixel_grid_colors);
					echo '<div id="effect-box" data-color="'. $pixel_grid_list_colors .'" data-bg-color="'. $settings[ 'background_grid_pixel_grid' ] .'"><canvas id="pixel-grid"></canvas></div>';
				}

				// Swarming Bugs
				if ( $settings['background_effects'] === 'swarming_bugs' ) {
					echo '<div id="effect-box" data-circle-color="'. $settings[ 'circle_color_swarming_bugs' ] .'" data-circle-border-color="'. $settings[ 'circle_border_color_swarming_bugs' ] .'" data-bugs-color="'. $settings[ 'bugs_color_swarming_bugs' ] .'"  data-spurt="'. $settings[ 'spurt_swarming_bugs' ] .'" data-radius1="'. $settings[ 'radius1_swarming_bugs' ] .'" data-radius2="'. $settings[ 'radius2_swarming_bugs' ] .'"><div id="swarming-bugs"></div></div>';
				}

				// Blobs
				if ( $settings['background_effects'] === 'blobs' ) {
					echo '<div id="effect-box" data-size-blobs1="'. $settings[ 'size_blobs1' ] .'" data-speed-blobs1="'. $settings[ 'speed_blobs1' ] .'"  data-color-blobs1="'. $settings[ 'color_blobs1' ] .'" data-frequency-blobs1="'. $settings[ 'frequency_blobs1' ] .'" data-density-blobs1="'. $settings[ 'density_blobs1' ] .'" data-size-blobs2="'. $settings[ 'size_blobs2' ] .'" data-speed-blobs2="'. $settings[ 'speed_blobs2' ] .'"  data-color-blobs2="'. $settings[ 'color_blobs2' ] .'" data-frequency-blobs2="'. $settings[ 'frequency_blobs2' ] .'" data-density-blobs2="'. $settings[ 'density_blobs2' ] .'" data-size-blobs3="'. $settings[ 'size_blobs3' ] .'" data-speed-blobs3="'. $settings[ 'speed_blobs3' ] .'"  data-color-blobs3="'. $settings[ 'color_blobs3' ] .'" data-frequency-blobs3="'. $settings[ 'frequency_blobs3' ] .'" data-density-blobs3="'. $settings[ 'density_blobs3' ] .'"><div id="blobs">';
					if ( $settings[ 'noise_blobs' ] == 'yes' ) {
						echo '<div class="blobs-noise"></div>';
					}
					echo '</div></div>';
				}

                ?>

		</div>

		<?php
	}
}
Plugin::instance()->widgets_manager->register( new Expedition_Content_Cover_Widget() );