<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Expedition Countdown Widget
 *
 * @author: Mountain-Themes
 * @version: 2.0.0
 */

class Expedition_Countdown_Widget extends Widget_Base {

	public function get_name() {
		return 'expedition-countdown';
	}

	public function get_title() {
		return esc_html__( 'Countdown', 'expedition-plugin' );
	}

	public function get_icon() {
		return 'eicon-countdown expedition-badge';
	}

	public function get_categories() {
		return [ 'expedition-category' ];
	}

	public function get_keywords() {
		return [ 'countdown', 'timer', 'date', 'clock' ];
	}

	public function get_script_depends() {
		return [ 'countdown-lib' ];

	}

	/**
	 * Register widget controls.
	 */

	protected function register_controls() {
		

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'expedition-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'due_time', [
				'label' => esc_html__( 'Due Date', 'expedition-plugin' ),
				'type' => Controls_Manager::DATE_TIME,
				'default' => date( 'Y/m/d', strtotime( '+ 1 day' ) ),
			]
		);

        $this->add_control(
			'countdown_text_days', [
				'label' => esc_html__( 'Countdown text days', 'expedition-plugin' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'days',
			]
		);

        $this->add_control(
			'countdown_text_hours', [
				'label' => esc_html__( 'Countdown text hours', 'expedition-plugin' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'hours',

			]
		);

        $this->add_control(
			'countdown_text_minutes', [
				'label' => esc_html__( 'Countdown text minutes', 'expedition-plugin' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'minutes',
			]
		);

        $this->add_control(
			'countdown_text_seconds', [
				'label' => esc_html__( 'Countdown text seconds', 'expedition-plugin' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'seconds',
			]
		);

        $this->end_controls_section();
        
		$this->start_controls_section(
			'title_styling',
			[
				'label' => esc_html__( 'Title Style', 'expedition-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'text_typography',
				'label' => esc_html__( 'Typography text', 'expedition-plugin' ),
				'selector' => '{{WRAPPER}} .countdown-box span',
				'fields_options' => [
					'typography' => [
						'default' => 'yes'
					],
					// Inner control name
					'font_weight' => [
						// Inner control settings
						'default' => '300',
					],
					'font_family' => [
						'default' => 'Aldrich',
					],
					'font_size'   => [
						'default' => [ 'unit' => 'px', 'size' => 15 ]
					],
					'text_transform' => [
						'default' => 'none',
					],
			
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'number_typography',
				'label' => esc_html__( 'Typography number', 'expedition-plugin' ),
				'selector' => '{{WRAPPER}} .countdown-box',
				'fields_options' => [
					'typography' => [
						'default' => 'yes'
					],
					// Inner control name
					'font_weight' => [
						// Inner control settings
						'default' => '300',
					],
					'font_family' => [
						'default' => 'Aldrich',
					],
					'font_size'   => [
						'default' => [ 'unit' => 'em', 'size' => 3 ]
					],
					'text_transform' => [
						'default' => 'uppercase',
					],
	
				],
			]
		);

		$this->add_control(
			'countdown_text_color',
			[
				'label' => esc_html__( 'Text color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'alpha'		=> true,
				'selectors' => [
					'{{WRAPPER}} .countdown-box' => 'color: {{VALUE}};',
					'{{WRAPPER}} .countdown-box div span' => 'color: {{VALUE}};',
				],
			]
		);
        

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {

		$settings = $this->get_settings_for_display();

        $get_due_date = esc_attr( $settings[ 'due_time' ] );
        $due_date = date( 'Y/m/d', strtotime( $get_due_date ) );

        $this->add_render_attribute( [
            'countdown' => [
                'class' => 'countdown-box',
                'data-date' => $due_date,
                'data-textdays' => $settings[ 'countdown_text_days' ],
                'data-texthours' => $settings[ 'countdown_text_hours' ],
                'data-textminutes' => $settings[ 'countdown_text_minutes' ],
                'data-textseconds' => $settings[ 'countdown_text_seconds' ],

            ]
        ] );

        echo '<div ' . $this->get_render_attribute_string( 'countdown' ) . '></div>';
	}

}

Plugin::instance()->widgets_manager->register( new Expedition_Countdown_Widget() );
