<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Expedition Services Widget
 *
 * @author: Mountain-Themes
 * @version: 2.0.0
 */

class Expedition_Services_Widget extends Widget_Base {

	public function get_name() {
		return 'expedition-services';
	}

	public function get_title() {
		return esc_html__( 'Services', 'expedition-plugin' );
	}

	public function get_icon() {
		return 'eicon-icon-box expedition-badge';
	}

	public function get_categories() {
		return [ 'expedition-category' ];
	}

	public function get_keywords() {
		return [ 'services', 'service', 'box', 'icon' ];
	}

	/**
	 * Register widget controls.
	 */

	protected function register_controls() {
		

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'expedition-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'services_icon',
			[
				'label' => esc_html__( 'Icon', 'expedition-plugin' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa-solid fa-rocket',
					'library' => 'faprosolid',
				],
			]
		);

        $this->add_control(
			'services_title', [
				'label' => esc_html__( 'Title', 'expedition-plugin' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Inovative Ideas' , 'expedition-plugin' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'services_text',
			array(
				'type'        => Controls_Manager::WYSIWYG,
				'label' => esc_html__( 'Text', 'expedition-plugin' ),
				'description' => sprintf(
					'%1s <strong>%2s</strong> %3s',
					esc_html__( 'Use class', 'expedition-plugin' ),
					'has-drop-cap',
					esc_html__( 'on an HTML element to set a dropcap.', 'expedition-plugin' )
				),
				'default' => '<p>We don\'t want to conquer the cosmos, we simply want to extend the boundaries of Earth to the frontiers of the cosmos.</p>',
			)
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'services_styling',
			[
				'label' => esc_html__( 'Services Style', 'expedition-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'title_typography',
				'label' => esc_html__( 'Typography title', 'expedition-plugin' ),
				'selector' => '{{WRAPPER}} .services-box h2',
				'fields_options' => [
					'typography' => [
						'default' => 'yes'
					],
					// Inner control name
					'font_weight' => [
						// Inner control settings
						'default' => '600',
					],
					'font_family' => [
						'default' => 'Aldrich',
					],
					'text_transform' => [
						'default' => 'uppercase',
					],
					'font_size'   => [
						'default' => [ 'unit' => 'px', 'size' => 14 ]
					],
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'text_typography',
				'label' => esc_html__( 'Typography text', 'expedition-plugin' ),
				'selector' => '{{WRAPPER}} .services-box p',
				'fields_options' => [
					'typography' => [
						'default' => 'yes'
					],
					// Inner control name
					'font_weight' => [
						// Inner control settings
						'default' => '400',
					],
					'font_family' => [
						'default' => 'Exo',
					],
					'text_transform' => [
						'default' => 'none',
					],
					'font_size'   => [
						'default' => [ 'unit' => 'px', 'size' => 13 ]
					],
				],
			]
		);

		$this->add_control(
			'services_icon_bg_color',
			[
				'label' => esc_html__( 'Icon background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
			]
		);

		$this->add_control(
			'services_icon_color',
			[
				'label' => esc_html__( 'Icon color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .services-box .icon i' => 'color: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'services_title_color',
			[
				'label' => esc_html__( 'Title color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'selectors' => [
					'{{WRAPPER}} .services-box h2' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'services_line_color',
			[
				'label' => esc_html__( 'Line color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'selectors' => [
					'{{WRAPPER}} .services-box .line:before' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .services-box .line:after' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'services_text_color',
			[
				'label' => esc_html__( 'Text color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'selectors' => [
					'{{WRAPPER}} .services-box p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'services', 'class', 'services-box' );

        echo '<div ' . $this->get_render_attribute_string( 'services' ) . '>';
        echo '<div class="icon">';
        Icons_Manager::render_icon( $settings['services_icon'], [ 'class' => 'flat-icon', 'aria-hidden' => 'true', 'data-color' => $settings['services_icon_bg_color'] ] );
        echo '</div>';
        echo '<h2>' . esc_html($settings['services_title']) . '</h2>';
		echo '<div class="line"><span></span></div>';
		echo  $settings['services_text'];
        echo '</div>';
	}

}

Plugin::instance()->widgets_manager->register( new Expedition_Services_Widget() );
