<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Expedition Subscribe Widget
 *
 * @author: Mountain-Themes
 * @version: 2.0.0
 */

class Expedition_Subscribe_Widget extends Widget_Base {

	public function get_name() {
		return 'expedition-subscribe';
	}

	public function get_title() {
		return esc_html__( 'Subscribe', 'expedition-plugin' );
	}

	public function get_icon() {
		return 'eicon-mail expedition-badge';
	}

	public function get_categories() {
		return [ 'expedition-category' ];
	}

	public function get_keywords() {
		return [ 'subscribe', 'mailchimp', 'shortcode', 'news' ];
	}

	/**
	 * Register widget controls.
	 */

	protected function register_controls() {
		

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Shortcode', 'expedition-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'shortcode',
			[
				'label' => esc_html__( 'Enter your shortcode mailchimp form', 'expedition-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => '[mc4wp_form id=2710]',
				'default' => '',
			]
		);


		$this->end_controls_section();


		$this->start_controls_section(
			'subscribe_styling',
			[
				'label' => esc_html__( 'Subscribe Style', 'expedition-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'alignment', [
				'label' => esc_html__( 'Alignment', 'expedition-plugin' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => esc_html__( 'Left', 'expedition-plugin' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'expedition-plugin' ),
						'icon' => 'eicon-text-align-center',
					],
					'flex-end' => [
						'title' => esc_html__( 'Right', 'expedition-plugin' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .subscribe-box' => 'justify-content: {{VALUE}};'
				],
			]
		);

        $this->add_control(
			'subscribe_color_text',
			[
				'label' => esc_html__( 'Subscribe text color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
                'selectors' => [
					'{{WRAPPER}} .subscribe-box input[type="email"]' => 'color: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'subscribe_bg_color',
			[
				'label' => esc_html__( 'Subscribe background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'transparent',
                'selectors' => [
					'{{WRAPPER}} .subscribe-box input[type="email"]' => 'background-color: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'subscribe_border_color',
			[
				'label' => esc_html__( 'Subscribe border color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
                'selectors' => [
					'{{WRAPPER}} .subscribe-box input[type="email"]' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .subscribe-box button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'subscribe_button_color',
			[
				'label' => esc_html__( 'Subscribe button color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
                'selectors' => [
					'{{WRAPPER}} .subscribe-box button' => 'background: {{VALUE}};',
					'{{WRAPPER}} .subscribe-box button' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'subscribe_button_hover_color',
			[
				'label' => esc_html__( 'Subscribe button hover color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => 'transparent',
                'selectors' => [
					'{{WRAPPER}} .subscribe-box button:hover' => 'background: {{VALUE}};',
				],
			]
		);
    

        $this->add_control(
			'subscribe_placeholder_color',
			[
				'label' => esc_html__( 'Subscribe placeholder color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
                'selectors' => [
					'{{WRAPPER}} .subscribe-box input[type="email"]::-webkit-input-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .subscribe-box input[type="email"]:-moz-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .subscribe-box input[type="email"]::-moz-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .subscribe-box input[type="email"]:-ms-input-placeholder' => 'color: {{VALUE}};',
                ],
			]
		);

        $this->add_control(
			'subscribe_mailchimp_response_color',
			[
				'label' => esc_html__( 'MailChimp response color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
                'selectors' => [
					'{{WRAPPER}} .mc4wp-response' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {

		$shortcode = $this->get_settings_for_display( 'shortcode' );

		$shortcode = do_shortcode( shortcode_unautop( $shortcode ) );

        echo $shortcode;
	}

}

Plugin::instance()->widgets_manager->register( new Expedition_Subscribe_Widget() );
