<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Expedition Title Widget
 *
 * @author: Mountain-Themes
 * @version: 2.0.0
 */

class Expedition_Title_Widget extends Widget_Base {

	public function get_name() {
		return 'expedition-title';
	}

	public function get_title() {
		return esc_html__( 'Title', 'expedition-plugin' );
	}

	public function get_icon() {
		return 'eicon-site-title expedition-badge';
	}

	public function get_categories() {
		return [ 'expedition-category' ];
	}

	public function get_keywords() {
		return [ 'heading', 'title', 'text', 'section' ];
	}

	/**
	 * Register widget controls.
	 */

	protected function register_controls() {
		

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'expedition-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'icon_enabled',
			array(
				'type'      => Controls_Manager::SWITCHER,
				'label'     => esc_html__( 'Show Icon', 'expedition-plugin' ),
				'separator' => 'before',
				'return_value' => 'yes',
				'default'   => 'yes',
			)
		);

		$this->add_control(
			'icon_animation',
			array(
				'type'      => Controls_Manager::SWITCHER,
				'label'     => esc_html__( 'Icon Animation', 'expedition-plugin' ),
				'return_value' => 'yes',
				'default'   => 'yes',
				'condition'  => array(
					'icon_enabled' => 'yes',
				),
			)
		);

		$this->add_control(
			'title_icon',
			[
				'label' => esc_html__( 'Icon', 'expedition-plugin' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa-regular fa-clock-four',
					'library' => 'faprosolid',
				],
				'condition'  => array(
					'icon_enabled' => 'yes',
				),
			]
		);

        $this->add_control(
			'title_text', [
				'label' => esc_html__( 'Title', 'expedition-plugin' ),
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your title', 'expedition-plugin' ),
				'default' => esc_html__( 'We are Coming Soon...' , 'expedition-plugin' ),
				'label_block' => true,
			]
		);


		$this->end_controls_section();


		$this->start_controls_section(
			'title_styling',
			[
				'label' => esc_html__( 'Title Style', 'expedition-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'title_typography',
				'label' => esc_html__( 'Typography title', 'expedition-plugin' ),
				'selector' => '{{WRAPPER}} .title-section h3',
				'fields_options' => [
					'typography' => [
						'default' => 'yes'
					],
					// Inner control name
					'font_weight' => [
						// Inner control settings
						'default' => '700',
					],
					'font_family' => [
						'default' => 'Aldrich',
					],
					'text_transform' => [
						'default' => 'uppercase',
					],
					'letter_spacing' => [
						'default' => [ 'unit' => 'px', 'size' => 0 ]
					],
					'font_size'   => [
						'default' => [ 'unit' => 'px', 'size' => 14 ]
					],
				],
			]
		);

		$this->add_control(
			'title_icon_size',
			[
				'label' => esc_html__( 'Icon size', 'expedition-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default'   => 22,
				'selectors' => [
					'{{WRAPPER}} .title-section i' => 'font-size: {{VALUE}}px',
				],
				'condition'  => array(
					'icon_enabled' => 'yes',
				),
			]
		);

		$this->add_control(
			'title_icon_color',
			[
				'label' => esc_html__( 'Title icon color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
                'selectors' => [
					'{{WRAPPER}} .title-section i' => 'color: {{VALUE}};',
				],
				'condition'  => array(
					'icon_enabled' => 'yes',
				),
			]
		);

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#3d4a6e',
				'selectors' => [
					'{{WRAPPER}} .title-section' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_bg_color',
			[
				'label' => esc_html__( 'Title background color', 'expedition-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .title-section' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_bg_image',
			array(
				'label'     => esc_html__( 'Title background color', 'expedition-plugin' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'media_types' => [ 'image' ],
                'selectors' => [
                '{{WRAPPER}} .title-section' => 'background-image: url( {{URL}} );',
                ],
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {

			$settings = $this->get_settings_for_display();

			$icon_animation = ( $settings[ 'icon_animation' ] == 'yes' ? 'true' : 'false' );

			$this->add_render_attribute( 'title', [
				'class' => 'title-section',
				'data-animation' => $icon_animation, 
			] );

			echo '<div ' . $this->get_render_attribute_string( 'title' ) . '>';
			if ( $settings['icon_enabled'] === 'yes') : 
				Icons_Manager::render_icon( $settings['title_icon'] );
			endif; 
			echo '<span>'. esc_html($settings['title_text']) . '</span>';
			echo '</div>';

	}

}

Plugin::instance()->widgets_manager->register( new Expedition_Title_Widget() );
