<?php
/**
 * Plugin Name: Expedition Helper Plugin
 * Plugin URI: https://mountainthemes.dev/
 * Description: Core Plugin for Expedition WordPress Theme.
 * Version: 2.0.0
 * Author: Mountain-Themes
 * Author URI: https://themeforest.net/user/mountain-themes
 * License: http://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: expedition-plugin
 */


// Exit if accessed directly

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


if ( !function_exists( 'ExpeditionHelperPlugin' ) ) {

	class ExpeditionHelperPlugin {

		/**
		 * The single class instance.
		 * @var $_instance
		 */
		private static $_instance = null;

		/**
		 * Main Instance
		 * Ensures only one instance of this class exists in memory at any one time.
		 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
				self::$_instance->init_option();
				self::$_instance->init_includes();
			}
			return self::$_instance;
		}

		/**
		 * Path to the plugin directory
		 * @var $plugin_path
		 */
		public $plugin_path;

		/**
		 * URL to the plugin directory
		 * @var $plugin_url
		 */
		public $plugin_url;

		
		public function __construct() {
			// We do nothing here!
		}


		/**
		 * Init options
		 */
		public function init_option() {
			$this->plugin_path = plugin_dir_path( __FILE__ );
			$this->plugin_url = plugin_dir_url( __FILE__ );

			load_plugin_textdomain( 'expedition-plugin', false, $this->plugin_path . 'languages/' );
		}

		/**
		 * Init includes
		 */
		public function init_includes() {
			require_once $this->plugin_path . 'includes/helper-functions.php';
			require_once $this->plugin_path . 'elementor/elementor.php';
		}

	}

	function expedition_helper_plugin() {
		return ExpeditionHelperPlugin::instance();
	}
	add_action( 'plugins_loaded', 'expedition_helper_plugin' );

}
