﻿/*
    Name: Expedition
    Description: Elementor Coming Soon WordPress Theme
    Version: 4.0.1
    Author: Mountain-Themes
    Author URL: https://themeforest.net/user/mountain-themes
    Expedition © 2025. Design & Coded by Mountain-Themes.

    TABLE OF CONTENTS
    ---------------------------
     1. Page Loader
     2. Mobile Menu
     3. Blog
     4. Wow
     5. Shop
     6. Fancybox
     7. Flex Slider
     8. Parallax
*/

jQuery.noConflict()(function($) {

  'use strict'; 

   var isMobile = {
      Android: function() {
        return navigator.userAgent.match(/Android/i);
      },
      BlackBerry: function() {
        return navigator.userAgent.match(/BlackBerry/i);
      },
      iPhone: function() {
        return navigator.userAgent.match(/iPhone/i);
      },
      iPad: function() {
        return navigator.userAgent.match(/iPad/i);
      },
      iPod: function() {
        return navigator.userAgent.match(/iPod/i);
      },
      iOS: function() {
        return navigator.userAgent.match(/iPhone|iPad|iPod/i);
      },
      Opera: function() {
        return navigator.userAgent.match(/Opera Mini/i);
      },
      Windows: function() {
        return navigator.userAgent.match(/IEMobile/i);
      },
      any: function() {
        return (isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Opera() || isMobile.Windows());
      }
    };
    
    mt_classic_loading();
    mt_image_loading();
    mt_mobile_menu();
    mt_blogGrid();
    mt_shop();
    mt_wow();
    mt_fancybox();
    mt_flexslider();
    mt_parallax();

/* ================================= */
/* :::::::: 1. Page Loader ::::::::: */
/* ================================= */

function mt_classic_loading() {
  $(".classic-loader-icon").delay(500).fadeOut();
  $(".classic-page-loader").delay(700).fadeOut("slow");

} 

function mt_image_loading() {
  $(".page-inner-loader").delay(500).fadeOut();
  $(".page-loader").delay(700).fadeOut("slow");
  
} 

/* ================================= */
/* ::::::: 2. Mobile Menu :::::::::: */
/* ================================= */

function mt_mobile_menu() {

    $("#expedition_menu").slicknav({
      prependTo: 'header .mobile-menu',
      allowParentLinks: false
    });

}     

/* ================================= */
/* ::::::::::: 3. Blog ::::::::::::: */
/* ================================= */

function mt_blogGrid() {

    // Blog Grid
    var element = $('.blogContainer');
    element.imagesLoaded().done(function() {
      element.isotope({
        itemSelector: 'article',
        masonry: {
          columnWidth: 'article',
          gutter: '.gutter-sizer'
        },
        percentPosition: true
      });
    });
    $(window).on('resize', function() {
      element.isotope();
    }).trigger('resize');

}

/* ================================= */
/* :::::::::::: 4. Wow ::::::::::::: */
/* ================================= */

function mt_wow() {
  new WOW().init();
}

/* ================================= */
/* ::::::::::: 5. Shop ::::::::::::: */
/* ================================= */

function mt_shop() {

  $('.icon-cart').on('click', function(){
     $('.cart-widget').toggleClass('widget-visible');
  });

  // Quantity
  $(document).on('click', '.shop-qty .plus, .shop-qty .minus', function(){

    var $this = $(this),
      $qty = $this.siblings('.qty'),
      current = parseInt($qty.val(), 10),
      min = parseInt($qty.attr('min'), 10),
      max = parseInt($qty.attr('max'), 10),
      step = parseInt($qty.attr('step'), 10);

    min = min ? min : 1;
    max = max ? max : current + step;

    if ($this.hasClass('minus') && current > min) {
      $qty.val(current - step);
      $qty.trigger('change');
    }

    if ($this.hasClass('plus') && current < max) {
      $qty.val(current + step);
      $qty.trigger('change');
    }

    return false;
  });

  
    // Shop Grid
    var element = $('.shopContainer');
    element.imagesLoaded().done(function() {
      element.isotope({
        itemSelector: 'article',
        masonry: {
          columnWidth: 'article',
          gutter: '.gutter-sizer'
        },
        percentPosition: true
      });
    });
    $(window).on('resize', function() {
      element.isotope();
    }).trigger('resize');

}

/* ================================= */
/* ::::::::: 6. Fancybox ::::::::::: */
/* ================================= */

function mt_fancybox() {

  Fancybox.bind('[data-fancybox="gallery"]', {
    Thumbs: {
      Carousel: {
        fill: false,
        center: true,
      },
    },
  });

 }

/* ================================= */
/* ::::::: 7. Flex Slider :::::::::: */
/* ================================= */

function mt_flexslider() {
  $('.flexslider').flexslider({
    controlNav: false,
    prevText: '<i class="fa fa-angle-left"></i>',
    nextText: '<i class="fa fa-angle-right"></i>',
    slideshowSpeed: '3000',
    pauseOnHover: true
  });
}

/* ================================= */
/* ::::::::: 8. Parallax ::::::::::: */
/* ================================= */

function mt_parallax() {

  $('.parallax').jarallax({
    speed: 0.5,
    noAndroid: true
  });

  $(function () {
      $('.info h2').textillate();
  });
}

});
