<?php

/* ======================= */
/* :::::: Comments ::::::: */
/* ======================= */

if ( post_password_required() ) {
  return;
}
?>

<div id="comments">


<?php if ( have_comments() ) : ?>

  <h3 class="comments-title">

  <?php
  printf( _nx( 'Comments (1)', 'Comments (%1$s)', get_comments_number(), 'comments title', 'expedition' ),
  number_format_i18n( get_comments_number() ), get_the_title() );
  ?>
    
  </h3>

 <ol class="comment-list">
      
      <?php 
        
        $args = array(
          'avatar_size' => 80,
          'style' => 'ul',
          'short_ping' => true,
          'callback' => 'expedition_comments_style',
        );
        
        wp_list_comments( $args );
      ?>
      
    </ol>

    <?php echo expedition_comment_pagination(); ?>

<?php if ( ! comments_open() && get_comments_number() ) : ?>
<p class="no-comments"><?php esc_html_e( 'Comments are closed.' , 'expedition' ); ?></p>
<?php endif; ?>

<?php else: // have_comments() ?>

   <h3 class="comments-title"><?php esc_html_e( 'No Comments', 'expedition' ); ?></h4>

<?php endif; // have_comments() ?>

<div class="form-comment">

<?php 
    
    $commenter = wp_get_current_commenter();

    $fields = array(
      
      'author' =>
        '<span class="required"></span> <input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" required="required" placeholder="'.esc_html__('Name', 'expedition').'" />',
        
      'email' =>
        '<span class="required"></span><input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" required="required" placeholder="'.esc_html__('Email', 'expedition').'" />',      
    );
    
    $args = array(
      'id_form'           => 'commentform',
      'id_submit'         => 'submit',
      'name_submit'       => 'submit',
      'title_reply'       => esc_html__( 'Leave a Reply', 'expedition' ),
      'title_reply_to'    => esc_html__( 'Leave a Reply', 'expedition' ),
      'cancel_reply_link' => esc_html__( 'Cancel Reply', 'expedition' ),
      'label_submit' => esc_html__( 'Submit Comment', 'expedition' ),
      'comment_field' => '<div class="form-group"><span class="required"></span><textarea id="comment" name="comment" rows="3" required="required" placeholder="'.esc_html__('Comment', 'expedition').'"></textarea></div>',
      'fields' => apply_filters( 'comment_form_default_fields', $fields ),
      'comment_notes_before' => '',
      'comment_notes_after' => '',
      'format' => 'html5',
      
    );
    
    comment_form( $args ); 
    
  ?>
</div>
</div><!-- #comments -->
