<?php

/* ============================ */
/* ::::::::::: Blog ::::::::::: */
/* ============================ */

$section  = 'blog';
$priority = 0;

// Hide/Show sidebar
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'blog_sidebar',
		'label'       => esc_html__( 'Hide/Show sidebar in single page', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

// Button color
new \Kirki\Field\Color(
	[
		'settings'    => 'blog_button_color',
		'label'       => esc_html__( 'Button color', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'   => '#3d4a6e',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.page-links a, .page-links > span, .post-button a, .pagination a, .pagination span, .post-navigation .prev-button a, .post-navigation .next-button a, #comments .comment .reply a, #comments .comment .reply a:hover, #comments input[type="submit"], .load-more a, .post-password-form input[type="submit"], .mt-widget .tagcloud a, footer .tagcloud a',
				'property' => 'border-color',
				'suffix'   => ' !important',
			),
			array(
				'element'  => '.post-page-numbers.current, .page-links a:hover, .post-button a, .pagination span.current, .pagination a:hover, .post-navigation .prev-button a, .post-navigation .next-button a, #comments .comment .reply a, #comments input[type="submit"], .load-more a, .format-gallery .flex-direction-nav a, .format-gallery .flex-direction-nav a:hover, .post-password-form input[type="submit"], .mt-widget .tagcloud a, footer .tagcloud a',
				'property' => 'background-color',
				'suffix'   => ' !important',
			),
			array(
				'element'  => '.post-button a:hover, .post-navigation .prev-button a:hover, .post-navigation .next-button a:hover, #comments .comment .reply a:hover, #comments input[type="submit"]:hover, .load-more a:hover, .load-more a.disabled, .load-more a.loaded, .load-more a.loaded .fa-spin, .post-password-form input[type="submit"]:hover, .mt-widget .tagcloud a:hover, footer .tagcloud a:hover',
				'property' => 'color',
				'suffix'   => ' !important',
			),
		),
	]
);

// Position button post
new \Kirki\Field\Typography(
	[
		'settings'    => 'position_button_post',
		'label'       => esc_html__( 'Button Position', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'transport'   => 'auto',
		'default'     => [
			'text-align' => 'left',
		],
		'output' => [
			[
				'element' => '.post-button',
			],
		],
	]
);

// Show post date
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'post_date',
		'label'       => esc_html__( 'Show post date', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

// Show post author
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'post_author',
		'label'       => esc_html__( 'Show post author', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

// Show post comments
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'post_comments',
		'label'       => esc_html__( 'Show post comments', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

// Show post categories
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'post_categories',
		'label'       => esc_html__( 'Show post categories', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

// Show post tags
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'post_tags',
		'label'       => esc_html__( 'Show post tags', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

// Show social icons post
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'post_social_icons',
		'label'       => esc_html__( 'Show social icons post', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);



