<?php

/* ============================ */
/* ::::::::::: Footer ::::::::: */
/* ============================ */

$section  = 'footer';
$priority = 0;

// Minimal or Widgets
new \Kirki\Field\Radio(
	[
		'settings'    => 'variants_footer',
		'label'       => esc_html__( 'Variants Footer', 'expedition' ),
		'description' => esc_html__('After activation "Widgets" in admin panel are will be accessed.', 'expedition'),
		'section'   => $section,
		'priority'  => $priority ++,
		'default'     => 'minimal',
		'choices'     => [
			'minimal'   => esc_html__( 'Minimal', 'expedition' ),
			'widgets' => esc_html__( 'Widgets', 'expedition' ),
		],
	]
);

// Column footer
new \Kirki\Field\Radio_Buttonset(
	[
		'settings'    => 'column_footer',
		'label'       => esc_html__( 'Columns', 'expedition' ),
		'section'   => $section,
		'priority'  => $priority ++,
		'default'     => 'col-md-flex-12 col-md-flex-4',
		'choices'     => [
			'col-md-flex-12'   => esc_html__( '1', 'expedition' ),
			'col-md-flex-12 col-md-flex-6'   => esc_html__( '2', 'expedition' ),
			'col-md-flex-12 col-md-flex-4' => esc_html__( '3', 'expedition' ),
			'col-md-flex-12 col-md-flex-3'  => esc_html__( '4', 'expedition' ),
		],
		'active_callback' => [
			[
				'setting'  => 'variants_footer',
				'operator' => '==',
				'value'    => 'widgets',
			]
		],
	]
);

// Footer background
new \Kirki\Field\Color(
	[
		'settings'    => 'footer_bg',
		'label'       => esc_html__( 'Footer background', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'   => '#fff',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.footer',
				'property' => 'background-color',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'variants_footer',
				'operator' => '==',
				'value'    => 'minimal',
			]
		],
	]
);


// Color social icon
new \Kirki\Field\Color(
	[
		'settings'   => 'footer_color_icons',
		'label'      => esc_html__( 'Color social icons', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'   => '#3d4a6e',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.footer .social-icons li i',
				'property' => 'color',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'variants_footer',
				'operator' => '==',
				'value'    => 'minimal',
			]
		],
	]
);

// Color hover social icon
new \Kirki\Field\Color(
	[
		'settings'   => 'footer_color_hover_icons',
		'label'     => esc_html__( 'Color hover social icons', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'   => '#fff',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.footer .social-icons li a:hover i',
				'property' => 'color',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'variants_footer',
				'operator' => '==',
				'value'    => 'minimal',
			]
		],
	]
);

// Color text footer
new \Kirki\Field\Color(
	[
		'settings'   => 'footer_color_text',
		'label'       => esc_html__( 'Color text footer', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'   => '#3d4a6e',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.footer .copyright',
				'property' => 'color',
			),
			array(
				'element'  => '.footer a',
				'property' => 'color',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'variants_footer',
				'operator' => '==',
				'value'    => 'minimal',
			]
		],
	]
);

// Color hover link footer
new \Kirki\Field\Color(
	[
		'settings'   => 'footer_color_link',
		'label'       => esc_html__( 'Color hover link footer', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'   => '#ababab',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.footer a:hover',
				'property' => 'color',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'variants_footer',
				'operator' => '==',
				'value'    => 'minimal',
			]
		],
	]
);

// Social Icons
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'footer_social_icons_check',
		'label'       => esc_html__( 'On/Off Social Icons', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
		'active_callback' => [
			[
				'setting'  => 'variants_footer',
				'operator' => '==',
				'value'    => 'minimal',
			]
		],
	]
);

new \Kirki\Field\Repeater(
	[
		'settings' => 'footer_social_icons',
		'label'    => esc_html__( 'Social icons', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'row_label'    => [
			'type'  => 'text',
			'value' => esc_html__( 'Social', 'expedition' ),
		],
		'fields'   => [
			'social_icon'   => [
				'type'        => 'select',
				'label'       => esc_html__( 'Social Icon', 'expedition' ),
				'choices' => expedition_get_social_icons()
			],
			'social_url'    => [
				'type'        => 'text',
				'label'       => esc_html__( 'Link URL', 'expedition' ),
			],
			'social_bg_color' => array(
                'type'        => 'color',
                'label'       => esc_html__( 'Color background color', 'expedition' ),
            ),
		],
		'default' => [
			[
				'social_icon'   => ( 'fa-brands fa-x-twitter' ),
				'social_url'    => '#',
				'social_bg_color' => '#46C0fb',
			],
			[
				'social_icon'   => ( 'fa-brands fa-facebook' ),
				'social_url'    => '#',
				'social_bg_color' => '#4863ae',
			],
			[
				'social_icon'   => ( 'fa-brands fa-dribbble' ),
				'social_url'    => '#',
				'social_bg_color' => '#dd4b39',
			],
			[
				'social_icon'   => ( 'fa-brands fa-youtube' ),
				'social_url'    => '#',
				'social_bg_color' => '#cc181e',
			],
			[
				'social_icon'   => ( 'fa-brands fa-instagram' ),
				'social_url'    => '#',
				'social_bg_color' => '#4d4f54',
			]
		],
		'active_callback' => [
			[
				'setting'  => 'footer_social_icons_check',
				'operator' => '==',
				'value'    => true,
			],
			[
				'setting'  => 'variants_footer',
				'operator' => '==',
				'value'    => 'minimal',
			]
		],
	]
);

// Copyright
new \Kirki\Field\Code(
	[
		'settings'    => 'editor_copyright',
		'label'    => esc_html__( 'Copyright', 'expedition' ),
		'description' => esc_html__( 'Enter your copyright', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'Expedition © 2024. Design & Coded by <a href="http://themeforest.net/user/Mountain-Themes" target="_blank"> Mountain-Themes</a>.',
		'choices'     => [
			'language' => 'html',
		],
		'active_callback' => [
			[
				'setting'  => 'variants_footer',
				'operator' => '==',
				'value'    => 'minimal',
			]
		],
	]
);

// Button Up
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'footer_button_up',
		'label'       => esc_html__( 'On/Off Button up', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

// Background color button up
new \Kirki\Field\Color(
	[
		'settings'   => 'footer_bg_color_button_up',
		'label'       => esc_html__( 'Background color', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'   => '#fff',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.footer .button-up-box',
				'property' => 'background',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'footer_button_up',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);


// Color icon button up
new \Kirki\Field\Color(
	[
		'settings'   => 'footer_icon_color_button_up',
		'label'       => esc_html__( 'Color icon', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'   => '#3d4a6e',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.footer .up-btn i',
				'property' => 'color',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'footer_button_up',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);
