<?php

/* ============================ */
/* :::::::::: General ::::::::: */
/* ============================ */


/* ::::::: Page Loader :::::: */

$section  = 'page_loader';
$priority = 0;


// On/off Page loader
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'page_loader',
		'label'       => esc_html__( 'On/Off', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

// Classic or Image Page loader
new \Kirki\Field\Radio_Buttonset(
	[
		'settings'    => 'choose_page_loader',
		'label'       => esc_html__( 'Choose page loader', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'classic',
		'choices'     => [
			'classic'   => esc_html__( 'Classic', 'expedition' ),
			'image' => esc_html__( 'Image', 'expedition' ),
		],
		'active_callback' => [
			[
				'setting'  => 'page_loader',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Loader
new \Kirki\Field\Image(
	[
		'settings'    => 'image_loader',
		'label'       => esc_html__( 'Loader', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => get_template_directory_uri() . '/assets/img/spinner.gif' ,
		'active_callback' => [
			[
				'setting'  => 'choose_page_loader',
				'operator' => '==',
				'value'    => 'image',
			],
			[
				'setting'  => 'page_loader',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Background color loader
new \Kirki\Field\Color(
	[
		'settings'    => 'bg_image_loader',
		'label'       => esc_html__( 'Background color loader', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#fff',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.page-loader',
				'property' => 'background',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'choose_page_loader',
				'operator' => '==',
				'value'    => 'image',
			],
			[
				'setting'  => 'page_loader',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Background color
new \Kirki\Field\Color(
	[
		'settings'    => 'bg_color_loader',
		'label'       => esc_html__( 'Background color loader', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#fff',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.classic-page-loader',
				'property' => 'background',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'choose_page_loader',
				'operator' => '==',
				'value'    => 'classic',
			],
			[
				'setting'  => 'page_loader',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);


// Background color loader icon
new \Kirki\Field\Color(
	[
		'settings'    => 'loader_icon_bg_color',
		'label'       => esc_html__( 'Background color loader icon', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#fff',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.classic-loader-icon',
				'property' => 'background',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'choose_page_loader',
				'operator' => '==',
				'value'    => 'classic',
			],
			[
				'setting'  => 'page_loader',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Progress border color
new \Kirki\Field\Color(
	[
		'settings'    => 'loader_icon_border_color',
		'label'       => esc_html__( 'Progress border color', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#3d4a6e',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.classic-loader-icon',
				'property' => 'border-right-color',
				'suffix'   => ' !important',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'choose_page_loader',
				'operator' => '==',
				'value'    => 'classic',
			],
			[
				'setting'  => 'page_loader',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

new \Kirki\Field\Color(
	[
		'settings'    => 'circle_icon_border_color',
		'label'       => esc_html__( 'Border color circle', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'rgba(19, 19, 19, 0.1)',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.classic-loader-icon',
				'property' => 'border-top-color',
				'suffix'   => ' !important',
			),
			array(
				'element'  => '.classic-loader-icon',
				'property' => 'border-left-color',
				'suffix'   => ' !important',
			),
			array(
				'element'  => '.classic-loader-icon',
				'property' => 'border-bottom-color',
				'suffix'   => ' !important',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'choose_page_loader',
				'operator' => '==',
				'value'    => 'classic',
			],
			[
				'setting'  => 'page_loader',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Width circle
new \Kirki\Field\Slider(
	[
		'settings'    => 'width_icon',
		'label'       => esc_html__( 'Width circle', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 50,
		'choices'     => [
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		],
		'output' => array(
			array(
				'element'  => '.classic-loader-icon',
				'property' => 'width',
				'units'    => 'px',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'choose_page_loader',
				'operator' => '==',
				'value'    => 'classic',
			],
			[
				'setting'  => 'page_loader',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Height circle
new \Kirki\Field\Slider(
	[
		'settings'    => 'height_icon',
		'label'       => esc_html__( 'Height circle', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 50,
		'choices'     => [
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		],
		'output' => array(
			array(
				'element'  => '.classic-loader-icon',
				'property' => 'height',
				'units'    => 'px',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'choose_page_loader',
				'operator' => '==',
				'value'    => 'classic',
			],
			[
				'setting'  => 'page_loader',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Border width circle
new \Kirki\Field\Slider(
	[
		'settings'    => 'border_width_circle',
		'label'       => esc_html__( 'Border width', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 5,
		'choices'     => [
			'min'  => 0,
			'max'  => 20,
			'step' => 1,
		],
		'output' => array(
			array(
				'element'  => '.classic-loader-icon',
				'property' => 'border-top-width',
				'units'    => 'px',
				'suffix'   => ' !important',
			),
			array(
				'element'  => '.classic-loader-icon',
				'property' => 'border-bottom-width',
				'units'    => 'px',
				'suffix'   => ' !important',
			),
			array(
				'element'  => '.classic-loader-icon',
				'property' => 'border-left-width',
				'units'    => 'px',
				'suffix'   => ' !important',
			),
			array(
				'element'  => '.classic-loader-icon',
				'property' => 'border-right-width',
				'units'    => 'px',
				'suffix'   => ' !important',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'choose_page_loader',
				'operator' => '==',
				'value'    => 'classic',
			],
			[
				'setting'  => 'page_loader',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

/* ::::::: Menu :::::: */

$section  = 'menu_style';
$priority = 10;


// Menu typography
new \Kirki\Field\Typography(
	[
		'settings'    => 'menu_typography',
		'label'       => esc_html__( 'Menu Typography', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'transport'   => 'auto',
		'default'     => [
			'font-family'    => 'Rajdhani',
			'variant'        => '500',
			'font-size'      => '14px',
			'letter-spacing' => '1px',
			'text-transform'  => 'uppercase',
			'color'          => '#000',
		],
		'output'      => [
			[
				'element' => '#expedition_menu > ul > li > a',
			],
		],
	]
);


// Color hover menu
new \Kirki\Field\Color(
	[
		'settings'    => 'menu_hover_color',
		'label'     => esc_html__( 'Color hover menu', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#bfbebe',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '#expedition_menu > ul > li > a:hover span',
				'property' => 'color',
			),
		),
	]
);

// Color active menu
new \Kirki\Field\Color(
	[
		'settings'    => 'menu_active_color',
		'label'     => esc_html__( 'Color active menu', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#bfbebe',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '#expedition_menu > ul > li.active > a',
				'property' => 'color',
			),
		),
	]
);

// Submenu typography
new \Kirki\Field\Typography(
	[
		'settings'    => 'submenu_typography',
		'label'       => esc_html__( 'SubMenu Typography', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'transport'   => 'auto',
		'default'     => [
			'font-family'     => 'Rajdhani',
			'variant'         => '500',
			'font-size'       => '14px',
			'color'           => '#fff',
			'letter-spacing'  => '1px',
			'text-transform'  => 'uppercase',
			'text-align'	  => 'left',
		],
		'output'      => [
			[
				'element' => '#expedition_menu > ul > li > ul > li a',
			],
		],
	]
);


// Color background submenu
new \Kirki\Field\Color(
	[
		'settings'    => 'background_submenu',
		'label'       => esc_html__( 'Color background submenu', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#050505',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '#expedition_menu ul li > ul',
				'property' => 'background',
			),
		),
	]
);

// Color text hover submenu
new \Kirki\Field\Color(
	[
		'settings'    => 'color_text_submenu',
		'label'       => esc_html__( 'Color text hover submenu', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#bfbebe',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '#expedition_menu > ul > li > ul > li a:hover',
				'property' => 'color',
			),
		),
	]
);

// MobileMenu typography
new \Kirki\Field\Typography(
	[
		'settings'    => 'mobile_typography',
		'label'       => esc_html__( 'Mobile Menu Typography', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'transport'   => 'auto',
		'default'     => [
			'font-family'     => 'Rajdhani',
			'variant'         => '500',
			'color'           => '#fff',
			'font-size'       => '14px',
			'letter-spacing'  => '1px',
			'text-transform'  => 'uppercase',
			'text-align'	  => 'left',
		],
		'output'      => [
			[
				'element' => '.slicknav_menu .slicknav_menutxt, .slicknav_nav ul, .slicknav_nav a, .slicknav_arrow, .slicknav_nav a:hover',
			],
		],
	]
);


// Color mobile background hover submenu
new \Kirki\Field\Color(
	[
		'settings'    => 'mobile_background_hover_submenu',
		'label'       => esc_html__( 'Color mobile background hover submenu', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'rgba(255,255,255,.1)',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.slicknav_nav a.slicknav_item:hover, .slicknav_nav ul > li.menu-item a:hover, .slicknav_nav ul > li > ul li.menu-item a:hover',
				'property' => 'background',
			),
		),
	]
);

// Color mobile border menu
new \Kirki\Field\Color(
	[
		'settings'    => 'menu_mobile_border',
		'label'       => esc_html__( 'Color mobile border menu', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#fff',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.slicknav_menu .slicknav_icon-bar',
				'property' => 'background',
			),
		),
	]
);

// Color mobile background submenu
new \Kirki\Field\Color(
	[
		'settings'    => 'mobile_background_submenu',
		'label'       => esc_html__( 'Color mobile background submenu', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#050505',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.slicknav_btn, .slicknav_nav ul',
				'property' => 'background',
			),
		),
	]
);

/* ::::::: Additional Settings :::::: */

$section  = 'additional';
$priority = 10;

new \Kirki\Field\Number(
	[
		'settings' => 'container_width',
		'label'    => esc_html__( 'Max Width of Container', 'expedition' ),
		'description' => esc_html__( 'Controls the overall container width. (in px)', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'  => 1140,
		'output' => array(
			array(
				'element' => '.container',
				'property' => 'max-width',
				'units'    => 'px'
			)
		)
	]
);

// API Key
new \Kirki\Field\Text(
	[
		'settings' => 'google_map_api_key',
		'label' => esc_html__( 'API Key', 'expedition' ),
		'description' => 'Get your API Key <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">here</a> or read <a href="http://bsf.io/google-map-api-key" target="_blank">this article</a> for more information.',
		'section'     => $section,
		'priority'    => $priority++,
		'transport' => 'auto',
		'default' => '',
		'active_callback' => [
			[
				'setting'  => 'show_google_map_key',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// On/off Google Map API Key
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'show_google_map_key',
		'label'       => esc_html__( 'On/Off Google Map API Key', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'off',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

// Logo typography
new \Kirki\Field\Typography(
	[
		'settings'    => 'logo_typography',
		'label'       => esc_html__( 'Logo Typography', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'transport'   => 'auto',
		'default'     => [
			'font-family'    => 'Aldrich',
			'variant'        => 'regular',
			'letter-spacing' => '0px',
			'text-transform' => 'none',
			'font-size' 	 => '24px',
			'color'			 => '#000',
		],
		'output' => [
			[
				'element' => 'header .logo h3',
			],
		],
	]
);

// On/off Logo header
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'logo_header',
		'label'       => esc_html__( 'On/Off Logo image', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'off',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

// Logo Site
new \Kirki\Field\Image(
	[
		'settings'    => 'image_site',
		'label'       => esc_html__( 'Logo Header', 'expedition' ),
		'description' => esc_html__( 'Choose a logo for the page of template', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => get_template_directory_uri() . '/assets/img/logo.png' ,
		'active_callback' => [
			[
				'setting'  => 'logo_header',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Logo Header ( Height )
new \Kirki\Field\Number(
	[
		'settings' => 'height_img_site',
		'label'    => esc_html__( 'Logo height', 'expedition' ),
		'description' => esc_html__( 'Enter logo height', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'  => 170,
		'active_callback' => [
			[
				'setting'  => 'logo_header',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Logo Header ( Width )
new \Kirki\Field\Number(
	[
		'settings' => 'width_img_site',
		'label'    => esc_html__( 'Logo width', 'expedition' ),
		'description' => esc_html__( 'Enter logo width', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'  => 287,
		'active_callback' => [
			[
				'setting'  => 'logo_header',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Authorization logo
new \Kirki\Field\Image(
	[
		'settings'    => 'image_admin',
		'label'       => esc_html__( 'Authorization logo', 'expedition' ),
		'description' => esc_html__( 'Choose a logo for the page of authorization', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => get_template_directory_uri() . '/assets/img/logo.png' ,
	]
);

// Authorization logo ( Height )
new \Kirki\Field\Number(
	[
		'settings' => 'height_img_admin',
		'label'    => esc_html__( 'Logo height', 'expedition' ),
		'description' => esc_html__( 'Enter logo height', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'  => 220,
	]
);

// Authorization logo ( Width )
new \Kirki\Field\Number(
	[
		'settings' => 'width_img_admin',
		'label'    => esc_html__( 'Logo width', 'expedition' ),
		'description' => esc_html__( 'Enter logo height', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'  => 255,
	]
);

// Show ACF in Admin Panel
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'acf_show_admin_panel',
		'label'       => esc_html__( 'Show ACF in Admin Panel', 'expedition' ),
		'description' => esc_html__( 'This field enable tab for ACF Professional in your dashboard.', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'off',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

/* ::::::: General typography :::::: */

$section  = 'general_typography';
$priority = 10;


// Body typography
new \Kirki\Field\Typography(
	[
		'settings'    => 'body_typography',
		'label'       => esc_html__( 'Body Typography', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'choices' => expedition_add_custom_choice(),
		'transport'   => 'auto',
		'default'     => [
			'font-family'    => 'Exo',
			'variant'        => 'regular',
			'letter-spacing' => '0px',
			'text-transform' => 'none',
			'font-size' 	 => '13px',
		],
		'output' => [
			[
				'element' => 'body',
			],
		],
	]
);

// Headings typography
new \Kirki\Field\Typography(
	[
		'settings'    => 'headings_typography',
		'label'       => esc_html__( 'Headings Typography', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'choices' => expedition_add_custom_choice(),
		'transport'   => 'auto',
		'default'     => [
			'font-family'    => 'Aldrich',
			'variant'        => 'regular',
			'letter-spacing' => '0px',
			'text-transform' => 'none',	
		],
		'output' => [
			[
				'element' => 'h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6',
			],
		],
	]
);


/* ::::::: Typekit Settings :::::: */

$section  = 'typekit_settings';
$priority = 10;


new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'enable_typekit',
		'label' => esc_html__('Enable Typekit', 'expedition') ,
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'off',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

new \Kirki\Field\Text(
	[
		'settings' => 'typekit_id',
		'label' => esc_html__('Typekit ID', 'expedition'),
		'description' => esc_html__( 'Enter the ID of your kit.', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'  	  => 'fyf1uam',
		'active_callback' => [
			[
				'setting'  => 'enable_typekit',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

new \Kirki\Field\Repeater(
	[
		'settings' => 'typekit_fonts',
		'label' => esc_html__( 'Typekit Fonts', 'expedition' ) ,
		'description' => esc_html__( 'Here you can add typekit fonts.', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'row_label'    => [
			'type'  => 'text',
			'value' => esc_html__( 'Typekit Font', 'expedition' ),
		],
		'fields'   => [
			'font_id'   => [
				'type'        => 'text',
				'label' => esc_html__( 'ID', 'expedition' ) ,
			],
			'font_text'    => [
				'type'        => 'text',
				'label' => esc_html__( 'Text', 'expedition' ) ,
			],
			'font_variants'    => [
				'type'        => 'select',
				'label' => esc_html__( 'Variants', 'expedition' ) ,
				'multiple'    => 2,
				'choices'     => [
					'100' => esc_html__( '100', 'expedition' ) ,
					'100italic' => esc_html__( '100italic', 'expedition' ) ,
					'200' => esc_html__( '200', 'expedition' ) ,
					'200italic' => esc_html__( '200italic', 'expedition' ) ,
					'300' => esc_html__( '300', 'expedition' ) ,
					'300italic' => esc_html__( '300italic', 'expedition' ) ,
					'regular' => esc_html__( 'regular', 'expedition' ) ,
					'italic' => esc_html__( 'italic', 'expedition' ) ,
					'500' => esc_html__( '500', 'expedition' ) ,
					'500italic' => esc_html__( '500italic', 'expedition' ) ,
					'600' => esc_html__( '600', 'expedition' ) ,
					'600italic' => esc_html__( '600italic', 'expedition' ) ,
					'700' => esc_html__( '700', 'expedition' ) ,
					'700italic' => esc_html__( '700italic', 'expedition' ) ,
					'800' => esc_html__( '800', 'expedition' ) ,
					'800italic' => esc_html__( '800italic', 'expedition' ) ,
					'900' => esc_html__( '900', 'expedition' ) ,
					'900italic' => esc_html__( '900italic', 'expedition' ) ,
				],
			],
		],
		'default' => '',
		'active_callback' => [
			[
				'setting'  => 'enable_typekit',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);