<?php


/* ============================ */
/* :::::::::::: Shop :::::::::: */
/* ============================ */

$section  = 'shop';
$priority = 0;

// Button color
new \Kirki\Field\Color(
	[
		'settings'    => 'shop_button_color',
		'label'       => esc_html__( 'Shop color', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#3d4a6e',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => '.woocommerce .shop_cart-button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce a.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce-message, .woocommerce-info, .woocommerce .load-more-shop a, .woocommerce .shop-qty button.plus, .woocommerce .shop-qty button.minus, .woocommerce .shop-qty .qty, .woocommerce nav.woocommerce-pagination ul li a, .woocommerce nav.woocommerce-pagination ul li span',
				'property' => 'border-color',
				'suffix'   => ' !important',
			),
			array(
				'element'  => '.woocommerce nav.woocommerce-pagination ul li span.current, .woocommerce .shop_cart-button, .woocommerce span.onsale, .woocommerce .load-more-shop a, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .widget .mini_cart_item a.remove:hover, .woocommerce .cart_item a.remove:hover, .woocommerce .shop-qty button.plus, .woocommerce .shop-qty button.minus, .woocommerce nav.woocommerce-pagination ul li a:hover',
				'property' => 'background-color',
			),
			array(
				'element'  => '.woocommerce .shop_cart-button:hover, .woocommerce .load-more-shop a:hover, .woocommerce .load-more-shop a.disabled, .woocommerce .load-more-shop a.loaded, .woocommerce .load-more-shop a.loaded .fa-spin, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce .star-rating:before, .woocommerce .star-rating span, .woocommerce p.stars a, .woocommerce .load-more-shop a.disabled, .woocommerce .woocommerce-message::before, .woocommerce-info::before, .woocommerce .shop-qty button.plus:hover, .woocommerce .shop-qty button.minus:hover',
				'property' => 'color',
				'suffix'   => ' !important',
			),
		),
	]
);

// Hide/Show Mini Cart
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'cart_shop',
		'label'       => esc_html__( 'Hide/Show Cart', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

// Color cart 
new \Kirki\Field\Color(
	[
		'settings'    => 'color_cart',
		'label'       => esc_html__( 'Color icon cart', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#000',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => 'header .icon-cart i',
				'property' => 'color',
			),
			array(
				'element'  => 'header .icon-cart span',
				'property' => 'background',
			),
			array(
				'element'  => 'header .cart-container .cart-widget',
				'property' => 'background',
				'suffix'   => '!important',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'cart_shop',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Color cart 
new \Kirki\Field\Color(
	[
		'settings'    => 'color_count_cart',
		'label'       => esc_html__( 'Color count cart', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '#fff',
		'choices'     => [
			'alpha' => true,
		],
		'output'    => array(
			array(
				'element'  => 'header .icon-cart span',
				'property' => 'color',
			),
		),
		'active_callback' => [
			[
				'setting'  => 'cart_shop',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);


// Hide/Show Parallax
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'parallax_shop',
		'label'       => esc_html__( 'Hide/Show Parallax', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'expedition' ),
			'off' => esc_html__( 'Disable', 'expedition' ),
		],
	]
);

// Parallax
new \Kirki\Field\Image(
	[
		'settings'    => 'parallax_image_shop',
		'label'       => esc_html__( 'Parallax Image Shop', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'parallax_shop',
				'operator' => '==',
				'value'    => true,
			]
		],
	
	]
);

// Title
new \Kirki\Field\Text(
	[
		'settings' => 'parallax_title',
		'label'    => esc_html__( 'Title parallax', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'  => esc_html__( 'expedition Shop', 'expedition' ),
		'active_callback' => [
			[
				'setting'  => 'parallax_shop',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Effect Text
new \Kirki\Field\Select(
	[
		'settings'    => 'parallax_effect_text',
		'label'       => esc_html__( 'Effect Text', 'expedition' ),
		'section'     => $section,
		'priority'    => $priority++,
		'default'     => 'none',
		'multiple'    => 1,
		'choices'     => [
		'none' => esc_html__( 'None', 'expedition' ),
		'wow bounce' => esc_html__( 'Bounce', 'expedition' ),
		'wow flash' => esc_html__( 'Flash', 'expedition' ),
		'wow pulse' => esc_html__( 'Pulse', 'expedition' ),
		'wow rubberBand' => esc_html__( 'RubberBand', 'expedition' ),
		'wow shake' => esc_html__( 'Shake', 'expedition' ),
		'wow swing' => esc_html__( 'Swing', 'expedition' ),
		'wow tada' => esc_html__( 'Tada', 'expedition' ),
		'wow wobble' => esc_html__( 'Wobble', 'expedition' ),
		'wow jello' => esc_html__( 'Jello', 'expedition' ),
		'wow bounceIn' => esc_html__( 'BounceIn', 'expedition' ),
		'wow bounceInDown' => esc_html__( 'BounceInDown', 'expedition' ),
		'wow bounceInLeft' => esc_html__( 'BounceInLeft', 'expedition' ),
		'wow bounceInRight' => esc_html__( 'BounceInRight', 'expedition' ),
		'wow bounceInUp' => esc_html__( 'BounceInUp', 'expedition' ),
		'wow fadeIn' => esc_html__( 'FadeIn', 'expedition' ),
		'wow fadeInDown' => esc_html__( 'FadeInDown', 'expedition' ),
		'wow fadeInDownBig' => esc_html__( 'FadeInDownBig', 'expedition' ),
		'wow fadeInLeft' => esc_html__( 'FadeInLeft', 'expedition' ),
		'wow fadeInLeftBig' => esc_html__( 'FadeInLeftBig', 'expedition' ),
		'wow fadeInRight' => esc_html__( 'FadeInRight', 'expedition' ),
		'wow fadeInRightBig' => esc_html__( 'FadeInRightBig', 'expedition' ),
		'wow fadeInUp' => esc_html__( 'FadeInUp', 'expedition' ),
		'wow fadeInUpBig' => esc_html__( 'FadeInUpBig', 'expedition' ),
		'wow flip' => esc_html__( 'Flip', 'expedition' ),
		'wow flipInX' => esc_html__( 'FlipInX', 'expedition' ),
		'wow flipInY' => esc_html__( 'FlipInY', 'expedition' ),
		'wow lightSpeedIn' => esc_html__( 'LightSpeedIn', 'expedition' ),
		'wow rotateIn' => esc_html__( 'RotateIn', 'expedition' ),
		'wow rotateInDownLeft' => esc_html__( 'RotateInDownLeft', 'expedition' ),
		'wow rotateInDownRight' => esc_html__( 'RotateInDownRight', 'expedition' ),
		'wow rotateInUpLeft' => esc_html__( 'RotateInUpLeft', 'expedition' ),
		'wow rotateInUpRight' => esc_html__( 'RotateInUpRight', 'expedition' ),
		'wow slideInUp' => esc_html__( 'SlideInUp', 'expedition' ),
		'wow slideInDown' => esc_html__( 'SlideInDown', 'expedition' ),
		'wow slideInLeft' => esc_html__( 'SlideInLeft', 'expedition' ),
		'wow slideInRight' => esc_html__( 'SlideInRight', 'expedition' ),
		'wow zoomIn' => esc_html__( 'ZoomIn', 'expedition' ),
		'wow zoomInDown' => esc_html__( 'ZoomInDown', 'expedition' ),
		'wow zoomInLeft' => esc_html__( 'ZoomInLeft', 'expedition' ),
		'wow zoomInRight' => esc_html__( 'ZoomInRight', 'expedition' ),
		'wow zoomInUp' => esc_html__( 'ZoomInUp', 'expedition' ),
		'wow hinge' => esc_html__( 'Hinge', 'expedition' ),
		'wow rollIn' => esc_html__( 'RollIn', 'expedition' ),
		],
		'active_callback' => [
			[
				'setting'  => 'parallax_shop',
				'operator' => '==',
				'value'    => true,
			]
		],
	]
);

// Sidebar Shop
new \Kirki\Field\Radio_Buttonset(
	[
		'settings'    => 'sidebar_shop',
		'label'       => esc_html__( 'Sidebar Shop', 'expedition' ),
		'section'   => $section,
		'priority'  => $priority ++,
		'default'     => 'right',
		'choices'     => [
			'left'   => esc_html__( 'Left', 'expedition' ),
			'hide' => esc_html__( 'Hide', 'expedition' ),
			'right'  => esc_html__( 'Right', 'expedition' ),
		],
	]
);

// Number of products displayed per page
new \Kirki\Field\Number(
	[
		'settings'    => 'number_products_shop',
		'label'       => esc_html__( 'Number of products displayed per page', 'expedition' ),
		'section'   => $section,
		'priority'  => $priority ++,
		'default'  => 15,
		'choices'  => [
			'min'  => 0,
			'step' => 1,
		],
	]
);

// Pagination
new \Kirki\Field\Radio_Buttonset(
	[
		'settings'    => 'pagination_shop',
		'label'       => esc_html__( 'Pagination', 'expedition' ),
		'section'   => $section,
		'priority'  => $priority ++,
		'default'     => 'classic',
		'choices'     => [
			'classic'   => esc_html__( 'Classic', 'expedition' ),
			'ajax' => esc_html__( 'Ajax', 'expedition' ),
			'hide'  => esc_html__( 'Hide', 'expedition' ),
		],
	]
);

