<?php

/* ====================== */
/* ::::::: FONTS :::::::: */
/* ====================== */

function expedition_fonts_url() {
    $fonts_url = '';
    $fonts = array();
    $subsets = 'latin,latin-ext';
    $fonts[] = 'Exo:300,400';
    $fonts[] = 'Aldrich:400';
    $fonts[] = 'Rajdhani:500';
    if ( $fonts ) {
        $fonts_url = add_query_arg(array(
            'family' => urlencode(implode('|', $fonts) ),
            'subset' => urlencode($subsets),
        ), '//fonts.googleapis.com/css');
    }
    return $fonts_url;
}

/* ====================== */
/* ::::::::: CSS :::::::: */
/* ====================== */

function expedition_load_styles() {

    // Bootstrap
    wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/plugins/bootstrap.min.css' );

    // Animate
    wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/plugins/animate.min.css' );

    // SlickNav
    wp_enqueue_style( 'slick-nav', get_template_directory_uri() . '/assets/css/plugins/slicknav.min.css' );

    // Font-Awesome
    wp_enqueue_style( 'font-awesome-6', get_template_directory_uri() . '/assets/fonts/css/all.min.css' );

    // Fancybox
    wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/assets/css/plugins/fancybox.min.css' );

    // Flexslider
    wp_enqueue_style( 'flex-slider', get_template_directory_uri() . '/assets/css/plugins/flexslider.min.css' );

    if ( !class_exists( 'Kirki' ) ) :

        wp_enqueue_style( 'expedition-fonts-url', expedition_fonts_url(), ' ', '1.0' );

    endif;

    // MediaElements
    wp_enqueue_style( 'wp-mediaelement' );

    // Main CSS
    wp_enqueue_style( 'expedition-general-style', get_template_directory_uri() . '/assets/css/main.css', ' ', '1.0' );
    
}
add_action( 'wp_enqueue_scripts', 'expedition_load_styles' );


/* ====================== */
/* ::::::::: JS ::::::::: */
/* ====================== */

function expedition_load_scripts() {

    // Images Loaded
    wp_enqueue_script( 'imagesloaded' );

    // MediaElements
    wp_enqueue_script( 'wp-mediaelement' );

    // Plugins minify
    wp_enqueue_script( 'expedition-plugins-minify', get_template_directory_uri() . '/assets/js/plugins.min.js', array('jquery'), '1.0', true );

    // Main JS
    wp_enqueue_script( 'expedition-main', get_template_directory_uri() . '/assets/js/main.js', array('jquery'), '1.0', true );
    
    // Google Map  API Key
    if ( true == get_theme_mod( 'show_google_map_key' ) ) {
        $api = 'https://maps.googleapis.com/maps/api/js';
        $map_key = get_theme_mod( 'google_map_api_key' );
        if ( false != $map_key ) {
            $arr_params = array(
                'key' => $map_key,
            );
            $api = esc_url( add_query_arg( $arr_params, $api ) );
        }
        wp_enqueue_script( 'google-map-api-key', $api, null, null, false );
    }

    // Comment reply
    if ( is_singular() && comments_open() ) {
        wp_enqueue_script( 'comment-reply' );
    }

}
add_action( 'wp_enqueue_scripts', 'expedition_load_scripts' );

function expedition_admin_styles() {

    wp_enqueue_style( 'expedition-admin-style', get_template_directory_uri() . '/assets/css/admin.css', ' ', '1.0' );
    
}
add_action( 'admin_enqueue_scripts', 'expedition_admin_styles' );

function expedition_admin_scripts() {

    wp_enqueue_script( 'expedition-admin-script', get_template_directory_uri() . '/assets/js/admin.js', array('jquery'), '1.0', true );
    
}
add_action( 'admin_enqueue_scripts', 'expedition_admin_scripts' );
  
