<?php
/**
 * expedition Plugins Activation
 *
 * @package expedition
 */

require get_template_directory() . '/lib/tgm/class-tgm-plugin-activation.php';


function expedition_register_required_plugins() {

	 $plugins = array(

		array(
			'name'      		 => esc_html__( 'Elementor', 'expedition' ),
			'slug'      		 => 'elementor',
			'force_activation'	 => false,
			'required'  		 => true,
		),

		array(
			'name'               => esc_html__( 'Expedition Helper Plugin', 'expedition' ), 
			'slug'               => 'expedition_helper_plugin', 
			'source'             => esc_url( 'https://wordpress.mountainthemes.dev/plugins/helper/expedition_helper_plugin.zip' ), 
			'force_activation'	 => false,
			'required'           => true, 
		),	

		
		array(
			'name' 				 => esc_html__( 'WooCommerce', 'expedition' ),
			'slug' 				 => 'woocommerce',
			'required'			 => false,
		),

		array(
			'name'               => esc_html__( 'Advanced Custom Fields PRO', 'expedition' ), 
			'slug'               => 'acf_pro', 
			'source'             => esc_url( 'https://wordpress.mountainthemes.dev/plugins/advanced-custom-fields-pro.zip' ),
			'force_activation'	 => false,
			'required'           => true, 
		),

		array(
			'name'               => esc_html__( 'Contact Form 7', 'expedition' ),
			'slug'               => 'contact-form-7', 
			'force_activation'	 => false,
			'required'           => true, 
		),

		array(
			'name'               => esc_html__( 'MailChimp for WordPress', 'expedition' ),
			'slug'               => 'mailchimp-for-wp', 
			'force_activate'	 => false,
			'force_deactivation' => false,
			'required'           => true, 
			'version'            => '', 
			'external_url'		 => ''
		),

		array(
			'name'               => esc_html__( 'Classic Widgets', 'expedition' ),
			'slug'               => 'classic-widgets', 
			'force_activate'	 => false,
			'force_deactivation' => false,
			'required'           => true, 
			'version'            => '', 
			'external_url'		 => ''
		),

		array(
			'name'               => esc_html__( 'Envato Market', 'expedition' ),
			'slug'               => 'envato-market',
			'source'             => esc_url( 'https://wordpress.mountainthemes.dev/plugins/envato-market.zip' ),  
			'force_activation'	 => false,
			'required'           => false, 
		),

		array(
			'name' 				 => esc_html__( 'One Click Demo Import', 'expedition' ),
			'slug' 				 => 'one-click-demo-import',
			'required' 			 => false,
		),

		array(
			'name'               => esc_html__( 'Kirki', 'expedition' ), 
			'slug'               => 'kirki', 
			'required'           => true, 
		),

	);

    tgmpa( $plugins );
}


add_action( 'tgmpa_register', 'expedition_register_required_plugins' );

 
 /**
 * Print notice if helper plugin is not installed
 */
if ( ! function_exists( 'expedition_helper_plugin_notice' ) ) {
	function expedition_helper_plugin_notice() {
		if ( class_exists( 'ExpeditionHelperPlugin' ) ) {
			return;
		}
		echo '<div class="notice notice-info is-dismissible"><p>' . sprintf( __( 'Please activate <strong>%s</strong> before your work with this theme.', 'expedition' ), 'Expedition Helper Plugin' ) . '</p></div>';
	}
}
add_action( 'admin_notices', 'expedition_helper_plugin_notice' );
