<?php

/**
 * Template Name: Elementor Coming Soon Page
 */

?>

<?php if ( class_exists('acf') ) : 

	// vars ( ACF )

	// page settings
	$menu = get_field('menu');

endif; ?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
		  <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	  <?php endif; ?>
    <?php wp_head(); ?>

</head>

	 <body <?php body_class(); ?>>

	 <?php 
	 
	 wp_body_open(); 
	 
	 get_template_part( 'template-parts/preloader' );
	 
	 ?>

	<?php if ( $menu == 'show' ) : ?>

		<!-- HEADER -->
			<header class="custom-header" id="top">

			<div class="container">
				<div class="row">
					<div class="col-md-12">

						<div class="header-container">


						<div class="header-inner-box">

								<!-- NAVIGATION -->
								<nav>

								<?php

									wp_nav_menu(
									array (
										'theme_location' => 'primary-menu',
										'class' => '',
										'container_id' => 'expedition_menu',
										'depth' => 3,
										'fallback_cb' => 'expedition_fallback_menu',
										'walker' => new expedition_Menu_Walker()
									)
								);

								?>

								</nav>
								<!-- END NAVIGATION -->

							<?php if ( class_exists( 'WooCommerce' ) ) : ?>

								<?php if ( true == get_theme_mod( 'cart_shop', true ) ) : ?>

									<!-- WOOCOMMERCE CART -->
									<div class="cart-container">
									<div class="icon-cart">
										<i class="fa-solid fa-bag-shopping"></i>
										<span class="cart-count"><?php echo sprintf (_n( '%d', '%d', WC()->cart->get_cart_contents_count(), 'expedition' ), WC()->cart->get_cart_contents_count() ); ?></span> 
									</div>
									<div class="cart-widget">
										<?php woocommerce_mini_cart(); ?>
									</div>
									</div>
									<!-- END WOOCOMMERCE CART -->

								<?php endif; ?>

							<?php endif; ?>

							<!-- MOBILE MENU -->
								<div class="mobile-menu"></div>
							<!-- END MOBILE MENU -->

						</div>
						</div>
					</div>
					</div>
				</div>

		</header>
		<!-- END HEADER -->

	<?php endif; ?>

	<!-- WRAPPER -->    
	<div id="wrapper" class="custom-wrapper">

	<?php 


		while ( have_posts() ) : the_post();

			if ( post_password_required( get_the_ID() ) ) {

				get_template_part( 'template-parts/content/content', 'protected' );

			} else {

				get_template_part( 'template-parts/content/content', 'custom-page' );

			}

		endwhile;
			
	?>	

<?php get_footer(); ?>