<?php

/* ============================ */
/* ::: Gallery Post Format :::: */
/* ============================ */

if ( class_exists('acf') ) :

  $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );

  // vars ( ACF )
  $gallery_type = get_field('gallery_type');
  $type_gallery_images = get_field('type_gallery_images');

  // blog settings
  $grids = $args['grids'] ?? null;
  $animation = $args['animation'] ?? null;

  $classes = array(
    $grids,
    $animation,
    'post'
  );

  ?>

  <article id="post-<?php the_ID(); ?>" <?php post_class($classes); ?>>


         <?php if ($gallery_type == 'slider') : ?>


          <div class="entry-header">


          	  <?php if ( $type_gallery_images ) : ?> 

                  <div class="flexslider">
                   <ul class="slides">

                    <?php foreach ( $type_gallery_images as $images ) : ?>

                        <?php 

                            $image = $images['url'];

                        ?>

                        <li>
                           <div style="background-image:url(<?php echo esc_url($image) ?>)"></div>

                           <?php if ( $images['title'] ) : ?> 

                             <p class="flex-caption"><?php echo esc_html($images['title']); ?></p>

                            <?php endif; ?>

                        </li>
                    <?php endforeach; ?>

                  </ul>
                </div>

              <?php endif; ?>
            

    		 <?php endif; ?>

         <?php if ($gallery_type == 'tiled') : ?>

          <div class="entry-header">

          <div class="gallery-box">

              <?php if ( $type_gallery_images ) : ?> 

                    <ul class="post-gallery">

                      <?php foreach ( $type_gallery_images as $images ) : ?>

                        <?php 

                            $original_image = $images['url'];

                            $image = $original_image; //resize & crop the image 

                        ?>
                        
                        <li>
                            <div class="overlay-box">
                              <a href="<?php echo esc_url($image); ?>" data-fancybox="gallery" data-caption="<?php echo esc_attr($images['title']); ?>">
                              <div class="overlay-wrap">
                                <div class="overlay">
                                  <i class="fa-solid fa-magnifying-glass"></i>
                                 </div>
                               </div>  
                               <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_html($images['alt']); ?>">
                              </a>
                            </div>
                         </li> 
                        
                      <?php endforeach; ?>

                    </ul>

              <?php endif; ?>

          </div>

         <?php endif; ?>

       

        <h3 class="entry-title">

          <?php if ( is_sticky() ) : ?>

            <i class="fa fa-paperclip"></i>

          <?php endif; ?>

          <?php the_title( sprintf( '<a href="%s" rel="bookmark">', get_permalink() ), '</a>' ); ?>

        </h3>
    		
    		<div class="post-details">
                <?php if ( true == get_theme_mod( 'post_date', true ) ) : ?>
                <div class="post-date">
                <i class="fa-solid fa-calendar-days"></i><a href="<?php the_permalink(); ?>"><time datetime="<?php the_time( 'F j, Y' ); ?>"><?php echo get_the_date(); ?></time></a>
                </div>
                <?php endif; ?>

                <?php if ( true == get_theme_mod( 'post_author', true ) ) : ?>
                <div class="post-author">
                    <i class="fa-solid fa-user"></i><?php esc_html_e( 'by', 'expedition' ); ?> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php echo get_the_author(); ?></a>
                </div>
                <?php endif; ?>

                <?php if ( true == get_theme_mod( 'post_comments', true ) ) : ?>
                <div class="post-comment">
                  <i class="fa-regular fa-comment"></i><a href="<?php comments_link(); ?>"><?php comments_number( esc_html__( '0 Comments', 'expedition'), esc_html__( '1 Comment', 'expedition' ), esc_html__( '% Comments', 'expedition' ) ); ?></a>
                </div> 
                <?php endif; ?>
        </div>

        <div class="post-info">
          
          <?php is_singular('post') ? the_content() : the_excerpt() ?>

           <?php
                    wp_link_pages( array(
                        'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'expedition' ),
                        'after'  => '</div>',
                        'link_before' => '<span>',
                        'link_after'  => '</span>',
                    ) );
           ?>

          <?php if (is_singular('post')) : ?>

             <div class="footer-single">

              <?php if ( true == get_theme_mod( 'post_categories', true ) ) : ?>

                    <div class="post-categories single"> 
                        <?php esc_html_e( 'Categories: ', 'expedition' ); ?><span class="cat-links"><?php echo get_the_category_list( esc_html__( ', ', 'expedition' ) ) ?></span>
                    </div>

              <?php endif; ?>

                <?php if ( true == get_theme_mod( 'post_tags', true ) ) : ?>

                      <?php if(has_tag()) : ?>

                        <div class="post-tags">
                            <?php the_tags(esc_html__( 'Tags: ', 'expedition'), ', ', ' '); ?>
                        </div>

                      <?php endif; ?>

                <?php endif; ?>

                <?php if ( true == get_theme_mod( 'post_social_icons', true ) ) : ?>

                  <?php if ( function_exists( 'expedition_get_post_share_buttons' ) ) : ?>

                    <?php echo expedition_get_post_share_buttons( get_the_ID() ); ?>

                  <?php endif; ?>

                <?php endif; ?>

            </div>

          <?php endif; ?>

    		</div>
  		
  	  </div>

  </article>


<?php endif; ?>

