<?php

/* ============================ */
/* ::: Standard Post Format ::: */
/* ============================ */

  // blog settings
  $animation = $args['animation'] ?? null;
  $grids = $args['grids'] ?? null;

  $classes = array(
    $animation,
	  $grids,
    'post'
  );



?>

<article id="post-<?php the_ID(); ?>" <?php post_class($classes); ?>>

	
	<div class="entry-header">

  		
      <h3 class="entry-title">

        <?php if ( is_sticky() ) : ?>

          <i class="fa fa-paperclip"></i>

        <?php endif; ?>

        <?php the_title( sprintf( '<a href="%s" rel="bookmark">', get_permalink() ), '</a>' ); ?>

      </h3>
  		
      <div class="post-details">
                <?php if ( true == get_theme_mod( 'post_date', true ) ) : ?>
                <div class="post-date">
                  <i class="fa-solid fa-calendar-days"></i><a href="<?php the_permalink(); ?>"><time datetime="<?php the_time( 'F j, Y' ); ?>"><?php echo get_the_date(); ?></time></a>
                </div>
                <?php endif; ?>

                <?php if ( true == get_theme_mod( 'post_author', true ) ) : ?>
                <div class="post-author">
                    <i class="fa-solid fa-user"></i><?php esc_html_e( 'by', 'expedition' ); ?> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php echo get_the_author(); ?></a>
                </div>
                <?php endif; ?>

                <?php if ( true == get_theme_mod( 'post_comments', true ) ) : ?>
                <div class="post-comment">
                  <i class="fa-regular fa-comment"></i><a href="<?php comments_link(); ?>"><?php comments_number( esc_html__( '0 Comments', 'expedition'), esc_html__( '1 Comment', 'expedition' ), esc_html__( '% Comments', 'expedition' ) ); ?></a>
                </div> 
                <?php endif; ?>
        </div>

        <div class="post-info">
          
           <?php is_singular('post') ? the_content() : the_excerpt() ?>

           <?php
                    wp_link_pages( array(
                        'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'expedition' ),
                        'after'  => '</div>',
                        'link_before' => '<span>',
                        'link_after'  => '</span>',
                    ) );
           ?>

          <?php if (is_singular('post')) : ?>

            <div class="footer-single">

              <?php if ( true == get_theme_mod( 'post_categories', true ) ) : ?>

                    <div class="post-categories"> 
                        <?php esc_html_e( 'Categories: ', 'expedition' ); ?><span class="cat-links"><?php echo get_the_category_list( esc_html__( ', ', 'expedition' ) ) ?></span>
                    </div>

              <?php endif; ?>

              <?php if ( true == get_theme_mod( 'post_tags', true ) ) : ?>

                        <?php if(has_tag()) : ?>

                        <div class="post-tags">
                            <?php the_tags(esc_html__( 'Tags: ', 'expedition'), ', ', ' '); ?>
                        </div>

                        <?php endif; ?>

              <?php endif; ?>

              <?php if ( true == get_theme_mod( 'post_social_icons', true ) ) : ?>

                <?php if ( function_exists( 'expedition_get_post_share_buttons' ) ) : ?>

                  <?php echo expedition_get_post_share_buttons( get_the_ID() ); ?>

                <?php endif; ?>

              <?php endif; ?>

              </div>

          <?php endif; ?>

  		</div>
	
</article>


