<?php

/* ============================ */
/* ::::::: Creative Blog :::::: */
/* ============================ */

  $thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
  
  // blog settings
  $animation = $args['animation'] ?? null;
  $grids = $args['grids'] ?? null;

  $classes = array(
    $animation,
	  $grids,
    "blog-creative",
    'post'
  );

?>

  <article id="post-<?php the_ID(); ?>" <?php post_class($classes); ?>>

        <div class="entry-header">

          <a href="<?php the_permalink(); ?>">

            <?php if ($thumbnail) : ?>                         

               <div style="background-image:url('<?php echo esc_url($thumbnail[0]); ?>')" class="work-box"></div>

            <?php endif; ?>
      
            <div class="blog-creative-item">

              <div class="item-info">

                  <span><?php echo get_the_title(); ?></span>

                  <em>

                  <div class="post-date">
                    <?php the_time( 'F j, Y' ); ?>
                  </div>

                  <div class="post-author">
                        <?php esc_html_e('by', 'expedition'); ?> <?php the_author(); ?>
                  </div>

                  </em>

              </div>

            </div>

          </a>
   
     </div>

   </article>



