<?php

/* ============================ */
/* ::::::: Minimal Blog ::::::: */
/* ============================ */

  $thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
  
  // blog settings
  $animation = $args['animation'] ?? null;
  $grids = $args['grids'] ?? null;

  $classes = array(
    $animation,
	$grids,
    "blog-minimal",
	'post'
  );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class($classes); ?>>

<div class="entry-header">

<div class="col-md-5">

		<?php if ($thumbnail) : ?>            

			<div class="post-intro">
                    <a href="<?php the_permalink(); ?>">
                      <div class="image-box" style="background-image:url(<?php echo esc_url($thumbnail[0]); ?>)"></div>
                    </a>
            </div>

		<?php endif; ?>

	</div>

		<div class="col-md-7">

				<h3 class="entry-title">

						<?php if ( is_sticky() ) : ?>

							<i class="fa fa-paperclip"></i>

						<?php endif; ?>

						<?php the_title( sprintf( '<a href="%s" rel="bookmark">', get_permalink() ), '</a>' ); ?>

				</h3>

				<div class="post-details">

						<div class="post-date">

									<?php the_time( 'F j, Y' ); ?>

						</div>

						<div class="post-author">
							<?php esc_html_e('by', 'expedition'); ?> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php the_author(); ?></a>
						</div>

				</div>

				<div class="post-info">

					<?php is_singular('post') ? the_content() : the_excerpt() ?>

				</div>
		</div>

</div>

</article>
