<!-- HEADER -->
<header id="top">

  <div class="container">
    <div class="row">
     <div class="col-md-12">

        <div class="header-container">

              <?php if ( true == get_theme_mod( 'logo_header' ) ) : ?>

                  <?php 
                
                    $image_site = get_theme_mod( 'image_site' );
                    $width_img_site = get_theme_mod( 'width_img_site' );
                    $height_img_site = get_theme_mod( 'height_img_site' );

                  ?>

                    <!-- LOGO -->
                    <div class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img width="<?php echo esc_attr($width_img_site); ?>" height="<?php echo esc_attr($height_img_site); ?>" src="<?php echo esc_url($image_site); ?>"></a></div>
                    <!-- END LOGO -->

              <?php endif; ?>

              <?php if ( false == get_theme_mod( 'logo_header', false ) ) : ?>

                <!-- LOGO -->
                <div class="logo"><h3><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_attr( get_bloginfo("name") ); ?></a></h3></div>
                <!-- END LOGO -->

              <?php endif; ?>

              <div class="header-inner-box">


                    <!-- NAVIGATION -->
                    <nav>

                    <?php

                        wp_nav_menu(
                        array (
                            'theme_location' => 'primary-menu',
                            'class' => '',
                            'container_id' => 'expedition_menu',
                            'depth' => 3,
                            'fallback_cb' => 'expedition_fallback_menu',
                            'walker' => new Expedition_Menu_Walker()
                        )
                    );

                    ?>

                    </nav>
                    <!-- END NAVIGATION -->


                  <?php if ( class_exists( 'WooCommerce' ) ) : ?>

                    <?php if ( true == get_theme_mod( 'cart_shop', true ) ) : ?>

                      <!-- WOOCOMMERCE CART -->
                      <div class="cart-container">
                      <div class="icon-cart">
                        <i class="fa-solid fa-bag-shopping"></i>
                        <span class="cart-count"><?php echo sprintf (_n( '%d', '%d', WC()->cart->get_cart_contents_count(), 'expedition' ), WC()->cart->get_cart_contents_count() ); ?></span> 
                      </div>
                      <div class="cart-widget">
                        <?php woocommerce_mini_cart(); ?>
                      </div>
                      </div>
                      <!-- END WOOCOMMERCE CART -->

                    <?php endif; ?>

                  <?php endif; ?>

                <!-- MOBILE MENU -->
                <div class="mobile-menu"></div>
                <!-- END MOBILE MENU -->

              </div>

          </div>

        </div>
    </div>
</div>

</header>
<!-- END HEADER -->