<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Check if the product is a valid WooCommerce product and ensure its visibility before proceeding.
if ( ! is_a( $product, WC_Product::class ) || ! $product->is_visible() ) {
	return;
}
?>

<article id="product-<?php the_ID(); ?>" <?php post_class(); ?>>



        <div class="product-images">
            <a href="<?php the_permalink(); ?>" class="link-product-images"></a>
            <?php $attachment_ids = $product->get_gallery_image_ids(); ?>
            <?php if ($attachment_ids){?>
                <div class="woo_first_image">
                    <?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>
                </div>
                <div class="woo_second_image">
                    <?php echo wp_get_attachment_image($attachment_ids[0], 'shop_catalog');?>
                </div>
            <?php }else{?>
                <div class="woo_first_image woo_single_image">
                    <?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>
                </div>
            <?php };?>
        </div>


            <div class="shop_product-details">

                <h4 class="woo_product-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>

             
                <?php do_action( 'woocommerce_after_shop_loop_item_title' ); ?>

                <?php do_action( 'woocommerce_template_loop_price_output' ); ?>
      
               <?php
                echo apply_filters( 'woocommerce_loop_add_to_cart_link',
                    sprintf( '<a rel="nofollow" href="%s" data-quantity="%s" data-product_id="%s" data-product_sku="%s" class="%s">%s</a>',
                        esc_url( $product->add_to_cart_url() ),
                        esc_attr( isset( $quantity ) ? $quantity : 1 ),
                        esc_attr( $product->get_id() ),
                        esc_attr( $product->get_sku() ),
                        implode( ' ', array_filter( array(
                            '',
                            $product->is_purchasable() && $product->is_in_stock() ? 'shop_cart-button add_to_cart_button' : '',
                            $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : ''
                        ) ) ),
                        ''
                    ),
                $product );
            ?>
 
            </div>

    
</article>