<?php
defined('ABSPATH') || exit('You do not have access to this page!');

/**
 * Template for displaying a search form.
 *
 * @package Fabula
 * @since   1.3
 */
?>

<form role="search"
      method="get"
      class="sf-form"
      action="<?php echo esc_url(home_url('/')); ?>"
      aria-label="<?php esc_attr_e('Sitewide search form', 'fabula'); ?>">
	
	<label for="sf-search-field" class="screen-reader-text">
		<?php esc_html_e('Search for:', 'fabula'); ?>
	</label>
	
	<input type="search"
	       id="sf-search-field"
	       class="search-field"
	       name="s"
	       value="<?php echo esc_attr(get_search_query()); ?>"
	       placeholder="<?php esc_attr_e('Enter some keywords...', 'fabula'); ?>"
	       title="<?php esc_attr_e('Search input field', 'fabula'); ?>"
	       aria-label="<?php esc_attr_e('Search input', 'fabula'); ?>"
	       required />
	
	<button
	 type="submit"
	 class="search-submit"
	 aria-label="<?php esc_attr_e('Submit search', 'fabula'); ?>"
	 title="<?php esc_attr_e('Submit search', 'fabula'); ?>">
		<svg
		 xmlns="http://www.w3.org/2000/svg"
		 viewBox="0 0 24 24"
		 fill="none"
		 stroke="currentColor"
		 stroke-width="2"
		 stroke-linecap="round"
		 stroke-linejoin="round"
		 class="lucide lucide-search"
		 aria-hidden="true"
		 focusable="false">
			<circle cx="11" cy="11" r="8" />
			<path d="m21 21-4.3-4.3" />
		</svg>
	</button>

</form>