<?php
defined('ABSPATH') || exit('You do not have access to this page!');

if (is_front_page()) return;

$post = get_post();

function fabula_breadcrumb_separator()
{
	
	echo '<svg xmlns="http://www.w3.org/2000/svg" class="divider" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true" focusable="false"><path d="M5 12h14"/><path d="m12 5 7 7-7 7"/></svg>';
}

echo '<nav class="jkd-breadcrumbs mt-7 d-f ai-c f-wrp jc-c" aria-label="' . esc_attr__('Breadcrumb', 'fabula') . '">';
echo '<a href="' . esc_url(home_url()) . '">' . esc_html__('Home', 'fabula') . '</a>';
fabula_breadcrumb_separator();

if (is_category()) :
	echo '<span aria-current="page">' . esc_html(single_cat_title('', false)) . '</span>';

elseif (is_single()) :
	$category = get_the_category();
	if (!empty($category)) :
		echo '<a href="' . esc_url(get_category_link($category[0]->term_id)) . '">' . esc_html($category[0]->name) . '</a>';
		fabula_breadcrumb_separator();
	endif;
	echo '<span aria-current="page">' . esc_html(get_the_title()) . '</span>';

elseif (is_page()) :
	if ($post->post_parent) :
		$breadcrumbs = [];
		$parent_id = $post->post_parent;
		while ($parent_id) :
			$page = get_post($parent_id);
			$breadcrumbs[] = '<a href="' . esc_url(get_permalink($page->ID)) . '">' . esc_html(get_the_title($page->ID)) . '</a>';
			$parent_id = $page->post_parent;
		endwhile;
		$breadcrumbs = array_reverse($breadcrumbs);
		foreach ($breadcrumbs as $crumb) :
			echo $crumb;
			fabula_breadcrumb_separator();
		endforeach;
	endif;
	echo '<span aria-current="page">' . esc_html(get_the_title()) . '</span>';

elseif (is_tag()) :
	echo '<span aria-current="page">' . esc_html__('Tag: ', 'fabula') . single_tag_title('', false) . '</span>';

elseif (is_day()) :
	echo '<span aria-current="page">' . esc_html__('Archive for ', 'fabula') . esc_html(get_the_time('F jS, Y')) . '</span>';

elseif (is_month()) :
	echo '<span aria-current="page">' . esc_html__('Archive for ', 'fabula') . esc_html(get_the_time('F, Y')) . '</span>';

elseif (is_year()) :
	echo '<span aria-current="page">' . esc_html__('Archive for ', 'fabula') . esc_html(get_the_time('Y')) . '</span>';

elseif (is_author()) :
	echo '<span aria-current="page">' . esc_html__('Author Archive', 'fabula') . '</span>';

elseif (is_search()) :
	echo '<span aria-current="page">' . esc_html__('Search Results for: ', 'fabula') . '<strong class="ml-5">"' . esc_html(get_search_query()) . '"</strong></span>';

endif;

echo '</nav>';