<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\finbuzz\Customizer\Settings;

use radiustheme\finbuzz\Customizer\FinbuzzTheme_Customizer;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Switch_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Heading_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Separator_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Image_Radio_Control;
use WP_Customize_Media_Control;
use WP_Customize_Color_Control;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class FinbuzzTheme_Gallery_Post_Settings extends FinbuzzTheme_Customizer {

	public function __construct() {
	    parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_gallery_post_controls' ) );
	}

    /**
     * Gallery Post Controls
     */
    public function register_gallery_post_controls( $wp_customize ) {
		
		$wp_customize->add_setting( 'gallery_archive_style',
            array(
                'default' => $this->defaults['gallery_archive_style'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_radio_sanitization'
            )
        );
        $wp_customize->add_control( new Customizer_Image_Radio_Control( $wp_customize, 'gallery_archive_style',
            array(
                'label' => __( 'Gallery Archive Layout', 'finbuzz' ),
                'description' => esc_html__( 'Select the gallery layout for gallery page', 'finbuzz' ),
                'section' => 'rttheme_gallery_settings',
                'choices' => array(
                    'style1' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/post-style-1.png',
                        'name' => __( 'Layout 1', 'finbuzz' )
                    ),
                    'style2' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/post-style-3.png',
                        'name' => __( 'Layout 2', 'finbuzz' )
                    ),
                )
            )
        ) );

        // Gallery option
        $wp_customize->add_setting( 'gallery_arexcerpt_limit',
            array(
                'default' => $this->defaults['gallery_arexcerpt_limit'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'gallery_arexcerpt_limit',
            array(
                'label' => __( 'Gallery Content Limit', 'finbuzz' ),
                'section' => 'rttheme_gallery_settings',
                'type' => 'number',
            )
        );
		
		$wp_customize->add_setting( 'gallery_ar_category',
            array(
                'default' => $this->defaults['gallery_ar_category'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'gallery_ar_category',
            array(
                'label' => __( 'Show Category', 'finbuzz' ),
                'section' => 'rttheme_gallery_settings',
            )
        ));
		
		$wp_customize->add_setting( 'gallery_ar_excerpt',
            array(
                'default' => $this->defaults['gallery_ar_excerpt'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'gallery_ar_excerpt',
            array(
                'label' => __( 'Show Excerpt', 'finbuzz' ),
                'section' => 'rttheme_gallery_settings',
            )
        ));
		
		$wp_customize->add_setting( 'gallery_ar_view',
            array(
                'default' => $this->defaults['gallery_ar_view'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'gallery_ar_view',
            array(
                'label' => __( 'Show View', 'finbuzz' ),
                'section' => 'rttheme_gallery_settings',
            )
        ));
		
		$wp_customize->add_setting( 'gallery_ar_link',
            array(
                'default' => $this->defaults['gallery_ar_link'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'gallery_ar_link',
            array(
                'label' => __( 'Show Link', 'finbuzz' ),
                'section' => 'rttheme_gallery_settings',
            )
        ));
		
		// Single Gallery Post
		$wp_customize->add_setting('galler_single_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'galler_single_heading', array(
            'label' => __( 'Single Gallery Settings', 'finbuzz' ),
            'section' => 'rttheme_gallery_settings',
        )));
		
		
		
		// Related Gallery Post
		$wp_customize->add_setting('galler_related_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'galler_related_heading', array(
            'label' => __( 'Related Gallery Settings', 'finbuzz' ),
            'section' => 'rttheme_gallery_settings',
        )));
		
		$wp_customize->add_setting( 'gallery_show_related_port',
            array(
                'default' => $this->defaults['gallery_show_related_port'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'gallery_show_related_port',
            array(
                'label' => __( 'Show Related Gallery', 'finbuzz' ),
                'section' => 'rttheme_gallery_settings',
            )
        ));
		
		$wp_customize->add_setting( 'gallery_show_related_port_content',
            array(
                'default' => $this->defaults['gallery_show_related_port_content'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'gallery_show_related_port_content',
            array(
                'label' => __( 'Show Related Content', 'finbuzz' ),
                'section' => 'rttheme_gallery_settings',
				'active_callback'   => 'rttheme_is_related_gallery_enabled',
            )
        ));
		
		$wp_customize->add_setting( 'gallery_related_port_cat',
            array(
                'default' => $this->defaults['gallery_related_port_cat'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'gallery_related_port_cat',
            array(
                'label' => __( 'Related Gallery Category', 'finbuzz' ),
                'section' => 'rttheme_gallery_settings',
				'active_callback'   => 'rttheme_is_related_gallery_enabled',
            )
        ));
		
		$wp_customize->add_setting( 'gallery_port_related_title',
            array(
                'default' => $this->defaults['gallery_port_related_title'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'gallery_port_related_title',
            array(
                'label' => __( 'Related Title', 'finbuzz' ),
                'section' => 'rttheme_gallery_settings',
                'type' => 'text',
				'active_callback'   => 'rttheme_is_related_gallery_enabled',
            )
        );
		
		$wp_customize->add_setting( 'gallery_related_port_number',
            array(
                'default' => $this->defaults['gallery_related_port_number'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'gallery_related_port_number',
            array(
                'label' => __( 'Related Gallery Post', 'finbuzz' ),
                'section' => 'rttheme_gallery_settings',
                'type' => 'number',
				'active_callback'   => 'rttheme_is_related_gallery_enabled',
            )
        );
		
		$wp_customize->add_setting( 'gallery_related_port_title_limit',
            array(
                'default' => $this->defaults['gallery_related_port_title_limit'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'gallery_related_port_title_limit',
            array(
                'label' => __( 'Related Title Limit', 'finbuzz' ),
                'section' => 'rttheme_gallery_settings',
                'type' => 'number',
				'active_callback'   => 'rttheme_is_related_gallery_enabled',
            )
        );

    }

}

/**
 * Initialise our Customizer settings only when they're required
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new FinbuzzTheme_Gallery_Post_Settings();
}
