<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\finbuzz\Customizer\Settings;

use radiustheme\finbuzz\Customizer\FinbuzzTheme_Customizer;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Switch_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Heading_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Separator_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Image_Radio_Control;
use WP_Customize_Media_Control;
use WP_Customize_Color_Control;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class FinbuzzTheme_Portfolio_Post_Settings extends FinbuzzTheme_Customizer {

	public function __construct() {
	    parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_portfolio_post_controls' ) );
	}

    /**
     * Portfolio Post Controls
     */
    public function register_portfolio_post_controls( $wp_customize ) {
		
		$wp_customize->add_setting( 'portfolio_archive_style',
            array(
                'default' => $this->defaults['portfolio_archive_style'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_radio_sanitization'
            )
        );
        $wp_customize->add_control( new Customizer_Image_Radio_Control( $wp_customize, 'portfolio_archive_style',
            array(
                'label' => __( 'Portfolio Archive Layout', 'finbuzz' ),
                'description' => esc_html__( 'Select the portfolio layout for portfolio page', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
                'choices' => array(
                    'style1' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/post-style-1.png',
                        'name' => __( 'Layout 1', 'finbuzz' )
                    ),
                    'style2' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/post-style-3.png',
                        'name' => __( 'Layout 2', 'finbuzz' )
                    ),
                )
            )
        ) );

        // Portfolio option
        $wp_customize->add_setting( 'portfolio_arexcerpt_limit',
            array(
                'default' => $this->defaults['portfolio_arexcerpt_limit'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'portfolio_arexcerpt_limit',
            array(
                'label' => __( 'Portfolio Content Limit', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
                'type' => 'number',
            )
        );
		
		$wp_customize->add_setting( 'portfolio_ar_category',
            array(
                'default' => $this->defaults['portfolio_ar_category'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'portfolio_ar_category',
            array(
                'label' => __( 'Show Category', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
            )
        ));
		
		$wp_customize->add_setting( 'portfolio_ar_excerpt',
            array(
                'default' => $this->defaults['portfolio_ar_excerpt'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'portfolio_ar_excerpt',
            array(
                'label' => __( 'Show Excerpt', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
            )
        ));
		
		$wp_customize->add_setting( 'portfolio_ar_link',
            array(
                'default' => $this->defaults['portfolio_ar_link'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'portfolio_ar_link',
            array(
                'label' => __( 'Show Link', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
            )
        ));
        $wp_customize->add_setting( 'portfolio_ar_number',
            array(
                'default' => $this->defaults['portfolio_ar_number'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'portfolio_ar_number',
            array(
                'label' => __( 'Portfolio Serial Number', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
            )
        ));
		
		// Single Portfolio Post
		$wp_customize->add_setting('portfolio_single_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'portfolio_single_heading', array(
            'label' => __( 'Single Portfolio Settings', 'finbuzz' ),
            'section' => 'rttheme_portfolio_settings',
        )));

        $wp_customize->add_setting( 'portfolio_client',
            array(
                'default' => $this->defaults['portfolio_client'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'portfolio_client',
            array(
                'label' => __( 'Client', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
            )
        ));

        $wp_customize->add_setting( 'portfolio_start_date',
            array(
                'default' => $this->defaults['portfolio_start_date'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'portfolio_start_date',
            array(
                'label' => __( 'Start Date', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
            )
        ));


        $wp_customize->add_setting( 'portfolio_end_date',
            array(
                'default' => $this->defaults['portfolio_end_date'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'portfolio_end_date',
            array(
                'label' => __( 'End Date', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
            )
        ));


        $wp_customize->add_setting( 'portfolio_website',
            array(
                'default' => $this->defaults['portfolio_website'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'portfolio_website',
            array(
                'label' => __( 'Website', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
            )
        ));

        $wp_customize->add_setting( 'portfolio_category',
            array(
                'default' => $this->defaults['portfolio_category'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'portfolio_category',
            array(
                'label' => __( 'Category', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
            )
        ));

        // Next/Previous Post


        $wp_customize->add_setting( 'portfolio_post_links',
            array(
                'default' => $this->defaults['portfolio_post_links'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'portfolio_post_links',
            array(
                'label' => __( 'Show Next / Previous post', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
            )
        ));
    
		
		// Related Portfolio Post
		$wp_customize->add_setting('portfolio_related_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'portfolio_related_heading', array(
            'label' => __( 'Related Portfolio Settings', 'finbuzz' ),
            'section' => 'rttheme_portfolio_settings',
        )));
		
		$wp_customize->add_setting( 'show_related_port',
            array(
                'default' => $this->defaults['show_related_port'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'show_related_port',
            array(
                'label' => __( 'Show Related Portfolio', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
            )
        ));
		
		$wp_customize->add_setting( 'show_related_port_content',
            array(
                'default' => $this->defaults['show_related_port_content'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'show_related_port_content',
            array(
                'label' => __( 'Show Related Content', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
				'active_callback'   => 'rttheme_is_related_portfolio_enabled',
            )
        ));
		

		$wp_customize->add_setting( 'related_port_cat',
            array(
                'default' => $this->defaults['related_port_cat'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'related_port_cat',
            array(
                'label' => __( 'Related Portfolio Category', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
				'active_callback'   => 'rttheme_is_related_portfolio_enabled',
            )
        ));
		
		$wp_customize->add_setting( 'port_related_title',
            array(
                'default' => $this->defaults['port_related_title'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'port_related_title',
            array(
                'label' => __( 'Related Title', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
                'type' => 'text',
				'active_callback'   => 'rttheme_is_related_portfolio_enabled',
            )
        );
		
		$wp_customize->add_setting( 'related_port_number',
            array(
                'default' => $this->defaults['related_port_number'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'related_port_number',
            array(
                'label' => __( 'Related Portfolio Post', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
                'type' => 'number',
				'active_callback'   => 'rttheme_is_related_portfolio_enabled',
            )
        );
		
		$wp_customize->add_setting( 'related_port_title_limit',
            array(
                'default' => $this->defaults['related_port_title_limit'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'related_port_title_limit',
            array(
                'label' => __( 'Related Title Limit', 'finbuzz' ),
                'section' => 'rttheme_portfolio_settings',
                'type' => 'number',
				'active_callback'   => 'rttheme_is_related_portfolio_enabled',
            )
        );

    }

}

/**
 * Initialise our Customizer settings only when they're required
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new FinbuzzTheme_Portfolio_Post_Settings();
}
