<?php

// Initialize Widgets
add_action( 'widgets_init', 'finbuzz_widgets_register' );
if ( !function_exists( 'finbuzz_widgets_register' ) ) {
	function finbuzz_widgets_register() {
		
		$footer_widget_titles1 = array(
			'1' => esc_html__( 'Footer (Style 1) 1', 'finbuzz' ),
			'2' => esc_html__( 'Footer (Style 1) 2', 'finbuzz' ),
			'3' => esc_html__( 'Footer (Style 1) 3', 'finbuzz' ),
			'4' => esc_html__( 'Footer (Style 1) 4', 'finbuzz' ),
		);	
		
		$footer_widget_titles2 = array(
			'1' => esc_html__( 'Footer (Style 2) 1', 'finbuzz' ),
			'2' => esc_html__( 'Footer (Style 2) 2', 'finbuzz' ),
			'3' => esc_html__( 'Footer (Style 2) 3', 'finbuzz' ),
			'4' => esc_html__( 'Footer (Style 2) 4', 'finbuzz' ),
		);

		$footer_widget_titles6 = array(
			'1' => esc_html__( 'Footer (Style 6) 1', 'finbuzz' ),
			'2' => esc_html__( 'Footer (Style 6) 2', 'finbuzz' ),
			'3' => esc_html__( 'Footer (Style 6) 3', 'finbuzz' ),
			'4' => esc_html__( 'Footer (Style 6) 4', 'finbuzz' ),
		);

		$footer_widget_titles7 = array(
			'1' => esc_html__( 'Footer (Style 7) 1', 'finbuzz' ),
			'2' => esc_html__( 'Footer (Style 7) 2', 'finbuzz' ),
			'3' => esc_html__( 'Footer (Style 7) 3', 'finbuzz' ),
			'4' => esc_html__( 'Footer (Style 7) 4', 'finbuzz' ),
		);

		$footer_widget_titles8 = array(
			'1' => esc_html__( 'Footer (Style 8) 1', 'finbuzz' ),
			'2' => esc_html__( 'Footer (Style 8) 2', 'finbuzz' ),
			'3' => esc_html__( 'Footer (Style 8) 3', 'finbuzz' ),
			'4' => esc_html__( 'Footer (Style 8) 4', 'finbuzz' ),
		);
		
		// Register Widget Areas ( Common )
		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar', 'finbuzz' ),
			'id'            => 'sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="rt-widget-title-holder"><h3 class="widgettitle">',
			'after_title'   => '<span class="titleinner"></span></h3></div>',
			) );
		if ( class_exists( 'WooCommerce' ) ) {
			register_sidebar( array(
				'name'          => 'Shop Sidebar',
				'id'            => 'shop-sidebar-1',
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="rt-widget-title-holder"><h3 class="widgettitle">',
				'after_title'   => '<span class="titleinner"></span></h3></div>',
			) );
		}	
		
		if ( class_exists( 'Finbuzz_Core' ) ) {
			register_sidebar( array(
				'name'          => 'Service Sidebar',
				'id'            => 'service-sidebar',
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="rt-widget-title-holder"><h3 class="widgettitle">',
				'after_title'   => '<span class="titleinner"></span></h3></div>',
			) );			
		}
		register_sidebar( array(
			'name'          => esc_html__( 'Offcanvas Info', 'finbuzz' ),
			'id'            => 'offcanvas',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="hidden">',
			'after_title'   => '</h3>',
		) );
		
		if ( !empty(FinbuzzTheme::$options['footer_column_1']) ){
			$item_widget = FinbuzzTheme::$options['footer_column_1'];
		} else {
			$item_widget = 3;
		}		
		for ( $i = 1; $i <= $item_widget; $i++ ) {
			register_sidebar( array(
				'name'          => $footer_widget_titles1[$i],
				'id'            => 'footer-style-1-'. $i,
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widgettitle '. FinbuzzTheme::$footer_style .'">',
				'after_title'   => '</h3>',
			) );
		}
		

		if ( !empty(FinbuzzTheme::$options['footer_column_2']) ){
			$item_widget = FinbuzzTheme::$options['footer_column_2'];
		} else {
			$item_widget = 3;
		}		
		for ( $i = 1; $i <= $item_widget; $i++ ) {
			register_sidebar( array(
				'name'          => $footer_widget_titles2[$i],
				'id'            => 'footer-style-2-'. $i,
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widgettitle '. FinbuzzTheme::$footer_style .'">',
				'after_title'   => '</h3>',
			) );
		}

		if ( !empty(FinbuzzTheme::$options['footer_column_3']) ){
			$item_widget = FinbuzzTheme::$options['footer_column_3'];
		} else {
			$item_widget = 4;
		}

		$footer_widget_titles=__('Footer (Style','finbuzz');
		for($i=3;$i<=5;$i++){
			for ( $j = 1; $j <= $item_widget; $j++ ) {
				register_sidebar( array(
					'name'          => $footer_widget_titles.' '.$i.' ) '.$j,
					'id'            => 'footer-style-'. $i.'-'.$j,
					'before_widget' => '<div id="%1$s" class="widget %2$s">',
					'after_widget'  => '</div>',
					'before_title'  => '<h3 class="widgettitle '. FinbuzzTheme::$footer_style .'">',
					'after_title'   => '</h3>',
				) );
			}
		}
		//footer style 6 register widget
		if ( !empty(FinbuzzTheme::$options['footer_column_1']) ){
			$item_widget = FinbuzzTheme::$options['footer_column_1'];
		} else {
			$item_widget = 3;
		}
		for ( $i = 1; $i <= $item_widget; $i++ ) {
			register_sidebar( array(
				'name'          => $footer_widget_titles6[$i],
				'id'            => 'footer-style-6-'. $i,
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widgettitle '. FinbuzzTheme::$footer_style .'">',
				'after_title'   => '</h3>',
			) );
		}

		// Footer Style 7
		if ( !empty(FinbuzzTheme::$options['footer_column_3']) ){
			$item_widget = FinbuzzTheme::$options['footer_column_3'];
		} else {
			$item_widget = 4;
		}
		for ( $i = 1; $i <= $item_widget; $i++ ) {
			register_sidebar( array(
				'name'          => $footer_widget_titles7[$i],
				'id'            => 'footer-style-7-'. $i,
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widgettitle '. FinbuzzTheme::$footer_style .'">',
				'after_title'   => '</h3>',
			) );
		}

		// Footer Style 8
		if ( !empty(FinbuzzTheme::$options['footer_column_3']) ){
			$item_widget = FinbuzzTheme::$options['footer_column_3'];
		} else {
			$item_widget = 4;
		}
		for ( $i = 1; $i <= $item_widget; $i++ ) {
			register_sidebar( array(
				'name'          => $footer_widget_titles8[$i],
				'id'            => 'footer-style-8-'. $i,
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widgettitle '. FinbuzzTheme::$footer_style .'">',
				'after_title'   => '</h3>',
			) );
		}
		
		
	}
}

function finbuzz_footer_layout(){
	return array(
		'1' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/footer-1.jpg',
			'name' => __( 'Layout 1', 'finbuzz' )
		),                  
		'2' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/footer-2.jpg',
			'name' => __( 'Layout 2', 'finbuzz' )
		),
		'3' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/footer-3.jpg',
			'name' => __( 'Layout 3', 'finbuzz' )
		),
		'4' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/footer-4.jpg',
			'name' => __( 'Layout 4', 'finbuzz' )
		),
		'5' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/footer-5.jpg',
			'name' => __( 'Layout 5', 'finbuzz' )
		),
		'6' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/footer-6.jpg',
			'name' => __( 'Layout 6', 'finbuzz' )
		),
		'7' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/footer-7.jpg',
			'name' => __( 'Layout 7', 'finbuzz' )
		),
		'8' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/footer-8.jpg',
			'name' => __( 'Layout 8', 'finbuzz' )
		),
	);
}